      program shift_test

      parameter (n=100)

      real a(n), b(n)

      call cmf_random (b)

      call test (a,b,n, 1)
      call test (a,b,n, -1)
      call test (a,b,n, 49)
      call test (a,b,n, 51)
      call test (a,b,n, -51)
      call test (a,b,n, 13)

      call test1 (a,b,n, 1)
      call test1 (a,b,n, -1)
      call test1 (a,b,n, 49)
      call test1 (a,b,n, 51)
      call test1 (a,b,n, -51)
      call test1 (a,b,n, 13)

      end

      subroutine test1 (a, b, n, pos)
      integer n
      real a(n), b(n)
      logical equal (n)
      integer pos
      integer errors

      a = b
      do i = 1, n
         a = cshift (a, 1, pos)
      end do

      equal = (b .eq. a)
      errors = count (equal)
      errors = n - errors

      print *, errors, ' Errors for shifting in dim 1 with pos = ', pos
      end


      subroutine test (a, b, n, pos)
      integer n
      real a(n), b(n)
      logical equal (n)
      integer pos
      integer errors

      a = b

      b = cshift (b, 1, pos)

      if (pos .gt. 0) then
         do i = 1, pos
            a = cshift (a, 1, 1) 
         end do
      end if

      if (pos .lt. 0) then
         do i = 1, -pos
            a = cshift (a, 1, -1) 
         end do
      end if

      equal = (b .eq. a)
      errors = count (equal)
      errors = n - errors

      print *, errors, ' Errors for shifting in dim 1 with pos = ', pos
      end

