/* addr_to_row[(addr & 0x1FFF) / 8] contains  */
/* the screen row for a given hires address. */

const unsigned char addr_to_row[] = {
     0,   0,   0,   0,   0,  64,  64,  64,        /* 0x2000 - 0x203F */
    64,  64, 128, 128, 128, 128, 128,   0,        /* 0x2040 - 0x207F */
     8,   8,   8,   8,   8,  72,  72,  72,        /* 0x2080 - 0x20BF */
    72,  72, 136, 136, 136, 136, 136,   0,        /* 0x20C0 - 0x20FF */
    16,  16,  16,  16,  16,  80,  80,  80,        /* 0x2100 - 0x213F */
    80,  80, 144, 144, 144, 144, 144,   0,        /* 0x2140 - 0x217F */
    24,  24,  24,  24,  24,  88,  88,  88,        /* 0x2180 - 0x21BF */
    88,  88, 152, 152, 152, 152, 152,   0,        /* 0x21C0 - 0x21FF */
    32,  32,  32,  32,  32,  96,  96,  96,        /* 0x2200 - 0x223F */
    96,  96, 160, 160, 160, 160, 160,   0,        /* 0x2240 - 0x227F */
    40,  40,  40,  40,  40, 104, 104, 104,        /* 0x2280 - 0x22BF */
   104, 104, 168, 168, 168, 168, 168,   0,        /* 0x22C0 - 0x22FF */
    48,  48,  48,  48,  48, 112, 112, 112,        /* 0x2300 - 0x233F */
   112, 112, 176, 176, 176, 176, 176,   0,        /* 0x2340 - 0x237F */
    56,  56,  56,  56,  56, 120, 120, 120,        /* 0x2380 - 0x23BF */
   120, 120, 184, 184, 184, 184, 184,   0,        /* 0x23C0 - 0x23FF */
     1,   1,   1,   1,   1,  65,  65,  65,        /* 0x2400 - 0x243F */
    65,  65, 129, 129, 129, 129, 129,   0,        /* 0x2440 - 0x247F */
     9,   9,   9,   9,   9,  73,  73,  73,        /* 0x2480 - 0x24BF */
    73,  73, 137, 137, 137, 137, 137,   0,        /* 0x24C0 - 0x24FF */
    17,  17,  17,  17,  17,  81,  81,  81,        /* 0x2500 - 0x253F */
    81,  81, 145, 145, 145, 145, 145,   0,        /* 0x2540 - 0x257F */
    25,  25,  25,  25,  25,  89,  89,  89,        /* 0x2580 - 0x25BF */
    89,  89, 153, 153, 153, 153, 153,   0,        /* 0x25C0 - 0x25FF */
    33,  33,  33,  33,  33,  97,  97,  97,        /* 0x2600 - 0x263F */
    97,  97, 161, 161, 161, 161, 161,   0,        /* 0x2640 - 0x267F */
    41,  41,  41,  41,  41, 105, 105, 105,        /* 0x2680 - 0x26BF */
   105, 105, 169, 169, 169, 169, 169,   0,        /* 0x26C0 - 0x26FF */
    49,  49,  49,  49,  49, 113, 113, 113,        /* 0x2700 - 0x273F */
   113, 113, 177, 177, 177, 177, 177,   0,        /* 0x2740 - 0x277F */
    57,  57,  57,  57,  57, 121, 121, 121,        /* 0x2780 - 0x27BF */
   121, 121, 185, 185, 185, 185, 185,   0,        /* 0x27C0 - 0x27FF */
     2,   2,   2,   2,   2,  66,  66,  66,        /* 0x2800 - 0x283F */
    66,  66, 130, 130, 130, 130, 130,   0,        /* 0x2840 - 0x287F */
    10,  10,  10,  10,  10,  74,  74,  74,        /* 0x2880 - 0x28BF */
    74,  74, 138, 138, 138, 138, 138,   0,        /* 0x28C0 - 0x28FF */
    18,  18,  18,  18,  18,  82,  82,  82,        /* 0x2900 - 0x293F */
    82,  82, 146, 146, 146, 146, 146,   0,        /* 0x2940 - 0x297F */
    26,  26,  26,  26,  26,  90,  90,  90,        /* 0x2980 - 0x29BF */
    90,  90, 154, 154, 154, 154, 154,   0,        /* 0x29C0 - 0x29FF */
    34,  34,  34,  34,  34,  98,  98,  98,        /* 0x2A00 - 0x2A3F */
    98,  98, 162, 162, 162, 162, 162,   0,        /* 0x2A40 - 0x2A7F */
    42,  42,  42,  42,  42, 106, 106, 106,        /* 0x2A80 - 0x2ABF */
   106, 106, 170, 170, 170, 170, 170,   0,        /* 0x2AC0 - 0x2AFF */
    50,  50,  50,  50,  50, 114, 114, 114,        /* 0x2B00 - 0x2B3F */
   114, 114, 178, 178, 178, 178, 178,   0,        /* 0x2B40 - 0x2B7F */
    58,  58,  58,  58,  58, 122, 122, 122,        /* 0x2B80 - 0x2BBF */
   122, 122, 186, 186, 186, 186, 186,   0,        /* 0x2BC0 - 0x2BFF */
     3,   3,   3,   3,   3,  67,  67,  67,        /* 0x2C00 - 0x2C3F */
    67,  67, 131, 131, 131, 131, 131,   0,        /* 0x2C40 - 0x2C7F */
    11,  11,  11,  11,  11,  75,  75,  75,        /* 0x2C80 - 0x2CBF */
    75,  75, 139, 139, 139, 139, 139,   0,        /* 0x2CC0 - 0x2CFF */
    19,  19,  19,  19,  19,  83,  83,  83,        /* 0x2D00 - 0x2D3F */
    83,  83, 147, 147, 147, 147, 147,   0,        /* 0x2D40 - 0x2D7F */
    27,  27,  27,  27,  27,  91,  91,  91,        /* 0x2D80 - 0x2DBF */
    91,  91, 155, 155, 155, 155, 155,   0,        /* 0x2DC0 - 0x2DFF */
    35,  35,  35,  35,  35,  99,  99,  99,        /* 0x2E00 - 0x2E3F */
    99,  99, 163, 163, 163, 163, 163,   0,        /* 0x2E40 - 0x2E7F */
    43,  43,  43,  43,  43, 107, 107, 107,        /* 0x2E80 - 0x2EBF */
   107, 107, 171, 171, 171, 171, 171,   0,        /* 0x2EC0 - 0x2EFF */
    51,  51,  51,  51,  51, 115, 115, 115,        /* 0x2F00 - 0x2F3F */
   115, 115, 179, 179, 179, 179, 179,   0,        /* 0x2F40 - 0x2F7F */
    59,  59,  59,  59,  59, 123, 123, 123,        /* 0x2F80 - 0x2FBF */
   123, 123, 187, 187, 187, 187, 187,   0,        /* 0x2FC0 - 0x2FFF */
     4,   4,   4,   4,   4,  68,  68,  68,        /* 0x3000 - 0x303F */
    68,  68, 132, 132, 132, 132, 132,   0,        /* 0x3040 - 0x307F */
    12,  12,  12,  12,  12,  76,  76,  76,        /* 0x3080 - 0x30BF */
    76,  76, 140, 140, 140, 140, 140,   0,        /* 0x30C0 - 0x30FF */
    20,  20,  20,  20,  20,  84,  84,  84,        /* 0x3100 - 0x313F */
    84,  84, 148, 148, 148, 148, 148,   0,        /* 0x3140 - 0x317F */
    28,  28,  28,  28,  28,  92,  92,  92,        /* 0x3180 - 0x31BF */
    92,  92, 156, 156, 156, 156, 156,   0,        /* 0x31C0 - 0x31FF */
    36,  36,  36,  36,  36, 100, 100, 100,        /* 0x3200 - 0x323F */
   100, 100, 164, 164, 164, 164, 164,   0,        /* 0x3240 - 0x327F */
    44,  44,  44,  44,  44, 108, 108, 108,        /* 0x3280 - 0x32BF */
   108, 108, 172, 172, 172, 172, 172,   0,        /* 0x32C0 - 0x32FF */
    52,  52,  52,  52,  52, 116, 116, 116,        /* 0x3300 - 0x333F */
   116, 116, 180, 180, 180, 180, 180,   0,        /* 0x3340 - 0x337F */
    60,  60,  60,  60,  60, 124, 124, 124,        /* 0x3380 - 0x33BF */
   124, 124, 188, 188, 188, 188, 188,   0,        /* 0x33C0 - 0x33FF */
     5,   5,   5,   5,   5,  69,  69,  69,        /* 0x3400 - 0x343F */
    69,  69, 133, 133, 133, 133, 133,   0,        /* 0x3440 - 0x347F */
    13,  13,  13,  13,  13,  77,  77,  77,        /* 0x3480 - 0x34BF */
    77,  77, 141, 141, 141, 141, 141,   0,        /* 0x34C0 - 0x34FF */
    21,  21,  21,  21,  21,  85,  85,  85,        /* 0x3500 - 0x353F */
    85,  85, 149, 149, 149, 149, 149,   0,        /* 0x3540 - 0x357F */
    29,  29,  29,  29,  29,  93,  93,  93,        /* 0x3580 - 0x35BF */
    93,  93, 157, 157, 157, 157, 157,   0,        /* 0x35C0 - 0x35FF */
    37,  37,  37,  37,  37, 101, 101, 101,        /* 0x3600 - 0x363F */
   101, 101, 165, 165, 165, 165, 165,   0,        /* 0x3640 - 0x367F */
    45,  45,  45,  45,  45, 109, 109, 109,        /* 0x3680 - 0x36BF */
   109, 109, 173, 173, 173, 173, 173,   0,        /* 0x36C0 - 0x36FF */
    53,  53,  53,  53,  53, 117, 117, 117,        /* 0x3700 - 0x373F */
   117, 117, 181, 181, 181, 181, 181,   0,        /* 0x3740 - 0x377F */
    61,  61,  61,  61,  61, 125, 125, 125,        /* 0x3780 - 0x37BF */
   125, 125, 189, 189, 189, 189, 189,   0,        /* 0x37C0 - 0x37FF */
     6,   6,   6,   6,   6,  70,  70,  70,        /* 0x3800 - 0x383F */
    70,  70, 134, 134, 134, 134, 134,   0,        /* 0x3840 - 0x387F */
    14,  14,  14,  14,  14,  78,  78,  78,        /* 0x3880 - 0x38BF */
    78,  78, 142, 142, 142, 142, 142,   0,        /* 0x38C0 - 0x38FF */
    22,  22,  22,  22,  22,  86,  86,  86,        /* 0x3900 - 0x393F */
    86,  86, 150, 150, 150, 150, 150,   0,        /* 0x3940 - 0x397F */
    30,  30,  30,  30,  30,  94,  94,  94,        /* 0x3980 - 0x39BF */
    94,  94, 158, 158, 158, 158, 158,   0,        /* 0x39C0 - 0x39FF */
    38,  38,  38,  38,  38, 102, 102, 102,        /* 0x3A00 - 0x3A3F */
   102, 102, 166, 166, 166, 166, 166,   0,        /* 0x3A40 - 0x3A7F */
    46,  46,  46,  46,  46, 110, 110, 110,        /* 0x3A80 - 0x3ABF */
   110, 110, 174, 174, 174, 174, 174,   0,        /* 0x3AC0 - 0x3AFF */
    54,  54,  54,  54,  54, 118, 118, 118,        /* 0x3B00 - 0x3B3F */
   118, 118, 182, 182, 182, 182, 182,   0,        /* 0x3B40 - 0x3B7F */
    62,  62,  62,  62,  62, 126, 126, 126,        /* 0x3B80 - 0x3BBF */
   126, 126, 190, 190, 190, 190, 190,   0,        /* 0x3BC0 - 0x3BFF */
     7,   7,   7,   7,   7,  71,  71,  71,        /* 0x3C00 - 0x3C3F */
    71,  71, 135, 135, 135, 135, 135,   0,        /* 0x3C40 - 0x3C7F */
    15,  15,  15,  15,  15,  79,  79,  79,        /* 0x3C80 - 0x3CBF */
    79,  79, 143, 143, 143, 143, 143,   0,        /* 0x3CC0 - 0x3CFF */
    23,  23,  23,  23,  23,  87,  87,  87,        /* 0x3D00 - 0x3D3F */
    87,  87, 151, 151, 151, 151, 151,   0,        /* 0x3D40 - 0x3D7F */
    31,  31,  31,  31,  31,  95,  95,  95,        /* 0x3D80 - 0x3DBF */
    95,  95, 159, 159, 159, 159, 159,   0,        /* 0x3DC0 - 0x3DFF */
    39,  39,  39,  39,  39, 103, 103, 103,        /* 0x3E00 - 0x3E3F */
   103, 103, 167, 167, 167, 167, 167,   0,        /* 0x3E40 - 0x3E7F */
    47,  47,  47,  47,  47, 111, 111, 111,        /* 0x3E80 - 0x3EBF */
   111, 111, 175, 175, 175, 175, 175,   0,        /* 0x3EC0 - 0x3EFF */
    55,  55,  55,  55,  55, 119, 119, 119,        /* 0x3F00 - 0x3F3F */
   119, 119, 183, 183, 183, 183, 183,   0,        /* 0x3F40 - 0x3F7F */
    63,  63,  63,  63,  63, 127, 127, 127,        /* 0x3F80 - 0x3FBF */
   127, 127, 191, 191, 191, 191, 191,   0         /* 0x3FC0 - 0x3FFF */
};


/* row_to_addr[row] contains the base address for a given row. */

const unsigned int row_to_addr[] = {
   0x0000, 0x0400, 0x0800, 0x0C00, 0x1000, 0x1400, 0x1800, 0x1C00, 
   0x0080, 0x0480, 0x0880, 0x0C80, 0x1080, 0x1480, 0x1880, 0x1C80, 
   0x0100, 0x0500, 0x0900, 0x0D00, 0x1100, 0x1500, 0x1900, 0x1D00, 
   0x0180, 0x0580, 0x0980, 0x0D80, 0x1180, 0x1580, 0x1980, 0x1D80, 
   0x0200, 0x0600, 0x0A00, 0x0E00, 0x1200, 0x1600, 0x1A00, 0x1E00, 
   0x0280, 0x0680, 0x0A80, 0x0E80, 0x1280, 0x1680, 0x1A80, 0x1E80, 
   0x0300, 0x0700, 0x0B00, 0x0F00, 0x1300, 0x1700, 0x1B00, 0x1F00, 
   0x0380, 0x0780, 0x0B80, 0x0F80, 0x1380, 0x1780, 0x1B80, 0x1F80, 
   0x0028, 0x0428, 0x0828, 0x0C28, 0x1028, 0x1428, 0x1828, 0x1C28, 
   0x00A8, 0x04A8, 0x08A8, 0x0CA8, 0x10A8, 0x14A8, 0x18A8, 0x1CA8, 
   0x0128, 0x0528, 0x0928, 0x0D28, 0x1128, 0x1528, 0x1928, 0x1D28, 
   0x01A8, 0x05A8, 0x09A8, 0x0DA8, 0x11A8, 0x15A8, 0x19A8, 0x1DA8, 
   0x0228, 0x0628, 0x0A28, 0x0E28, 0x1228, 0x1628, 0x1A28, 0x1E28, 
   0x02A8, 0x06A8, 0x0AA8, 0x0EA8, 0x12A8, 0x16A8, 0x1AA8, 0x1EA8, 
   0x0328, 0x0728, 0x0B28, 0x0F28, 0x1328, 0x1728, 0x1B28, 0x1F28, 
   0x03A8, 0x07A8, 0x0BA8, 0x0FA8, 0x13A8, 0x17A8, 0x1BA8, 0x1FA8, 
   0x0050, 0x0450, 0x0850, 0x0C50, 0x1050, 0x1450, 0x1850, 0x1C50, 
   0x00D0, 0x04D0, 0x08D0, 0x0CD0, 0x10D0, 0x14D0, 0x18D0, 0x1CD0, 
   0x0150, 0x0550, 0x0950, 0x0D50, 0x1150, 0x1550, 0x1950, 0x1D50, 
   0x01D0, 0x05D0, 0x09D0, 0x0DD0, 0x11D0, 0x15D0, 0x19D0, 0x1DD0, 
   0x0250, 0x0650, 0x0A50, 0x0E50, 0x1250, 0x1650, 0x1A50, 0x1E50, 
   0x02D0, 0x06D0, 0x0AD0, 0x0ED0, 0x12D0, 0x16D0, 0x1AD0, 0x1ED0, 
   0x0350, 0x0750, 0x0B50, 0x0F50, 0x1350, 0x1750, 0x1B50, 0x1F50, 
   0x03D0, 0x07D0, 0x0BD0, 0x0FD0, 0x13D0, 0x17D0, 0x1BD0, 0x1FD0 
};


#if !USE_GREYSCALE
/* one_to_two_bpp[byte] maps one bit per pixel to two for the */
/* low 7 bits, reversing the order.                           */

const unsigned long one_to_two_bpp[] = {
   0x0000, 0x3000, 0x0C00, 0x3C00, 0x0300, 0x3300, 0x0F00, 0x3F00, 
   0x00C0, 0x30C0, 0x0CC0, 0x3CC0, 0x03C0, 0x33C0, 0x0FC0, 0x3FC0, 
   0x0030, 0x3030, 0x0C30, 0x3C30, 0x0330, 0x3330, 0x0F30, 0x3F30, 
   0x00F0, 0x30F0, 0x0CF0, 0x3CF0, 0x03F0, 0x33F0, 0x0FF0, 0x3FF0, 
   0x000C, 0x300C, 0x0C0C, 0x3C0C, 0x030C, 0x330C, 0x0F0C, 0x3F0C, 
   0x00CC, 0x30CC, 0x0CCC, 0x3CCC, 0x03CC, 0x33CC, 0x0FCC, 0x3FCC, 
   0x003C, 0x303C, 0x0C3C, 0x3C3C, 0x033C, 0x333C, 0x0F3C, 0x3F3C, 
   0x00FC, 0x30FC, 0x0CFC, 0x3CFC, 0x03FC, 0x33FC, 0x0FFC, 0x3FFC, 
   0x0003, 0x3003, 0x0C03, 0x3C03, 0x0303, 0x3303, 0x0F03, 0x3F03, 
   0x00C3, 0x30C3, 0x0CC3, 0x3CC3, 0x03C3, 0x33C3, 0x0FC3, 0x3FC3, 
   0x0033, 0x3033, 0x0C33, 0x3C33, 0x0333, 0x3333, 0x0F33, 0x3F33, 
   0x00F3, 0x30F3, 0x0CF3, 0x3CF3, 0x03F3, 0x33F3, 0x0FF3, 0x3FF3, 
   0x000F, 0x300F, 0x0C0F, 0x3C0F, 0x030F, 0x330F, 0x0F0F, 0x3F0F, 
   0x00CF, 0x30CF, 0x0CCF, 0x3CCF, 0x03CF, 0x33CF, 0x0FCF, 0x3FCF, 
   0x003F, 0x303F, 0x0C3F, 0x3C3F, 0x033F, 0x333F, 0x0F3F, 0x3F3F, 
   0x00FF, 0x30FF, 0x0CFF, 0x3CFF, 0x03FF, 0x33FF, 0x0FFF, 0x3FFF, 
   0x0000, 0x3000, 0x0C00, 0x3C00, 0x0300, 0x3300, 0x0F00, 0x3F00, 
   0x00C0, 0x30C0, 0x0CC0, 0x3CC0, 0x03C0, 0x33C0, 0x0FC0, 0x3FC0, 
   0x0030, 0x3030, 0x0C30, 0x3C30, 0x0330, 0x3330, 0x0F30, 0x3F30, 
   0x00F0, 0x30F0, 0x0CF0, 0x3CF0, 0x03F0, 0x33F0, 0x0FF0, 0x3FF0, 
   0x000C, 0x300C, 0x0C0C, 0x3C0C, 0x030C, 0x330C, 0x0F0C, 0x3F0C, 
   0x00CC, 0x30CC, 0x0CCC, 0x3CCC, 0x03CC, 0x33CC, 0x0FCC, 0x3FCC, 
   0x003C, 0x303C, 0x0C3C, 0x3C3C, 0x033C, 0x333C, 0x0F3C, 0x3F3C, 
   0x00FC, 0x30FC, 0x0CFC, 0x3CFC, 0x03FC, 0x33FC, 0x0FFC, 0x3FFC, 
   0x0003, 0x3003, 0x0C03, 0x3C03, 0x0303, 0x3303, 0x0F03, 0x3F03, 
   0x00C3, 0x30C3, 0x0CC3, 0x3CC3, 0x03C3, 0x33C3, 0x0FC3, 0x3FC3, 
   0x0033, 0x3033, 0x0C33, 0x3C33, 0x0333, 0x3333, 0x0F33, 0x3F33, 
   0x00F3, 0x30F3, 0x0CF3, 0x3CF3, 0x03F3, 0x33F3, 0x0FF3, 0x3FF3, 
   0x000F, 0x300F, 0x0C0F, 0x3C0F, 0x030F, 0x330F, 0x0F0F, 0x3F0F, 
   0x00CF, 0x30CF, 0x0CCF, 0x3CCF, 0x03CF, 0x33CF, 0x0FCF, 0x3FCF, 
   0x003F, 0x303F, 0x0C3F, 0x3C3F, 0x033F, 0x333F, 0x0F3F, 0x3F3F, 
   0x00FF, 0x30FF, 0x0CFF, 0x3CFF, 0x03FF, 0x33FF, 0x0FFF, 0x3FFF 
};

#else
/* color_one_to_two_bpp[13 bits] is like one_to_two_bpp, except */
/* that it maps a set of pixels to a 2-bit color version of     */
/* those pixels.  The 13 pixels are the five to the left of a   */
/* given screen byte and the screen byte itself.  The output    */
/* represents the rightmost two pixels of the byte to the left  */
/* and the leftmost 5 pixels of the current byte.               */
/* Note that not all pixels are converted; two on each edge are */
/* only there to  convey information about how to color the     */
/* interior pixels.  The color bit of the byte is ignored.      */

const unsigned short color_one_to_two_bpp_even[] = {
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x000C, 0x02AA, 0x003C, 0x00FC, 
   0x0003, 0x00C3, 0x0055, 0x00F5, 0x000F, 0x02AF, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x002A, 0x02AA, 0x003E, 0x00FE, 
   0x0003, 0x00C3, 0x0057, 0x00F3, 0x000F, 0x02AF, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x000C, 0x02AA, 0x003C, 0x00FC, 
   0x0005, 0x00C5, 0x0055, 0x00F5, 0x000F, 0x02AF, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x002A, 0x02AA, 0x003C, 0x00FC, 
   0x0003, 0x00C3, 0x0057, 0x00F3, 0x000F, 0x02AF, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x000C, 0x02AA, 0x003C, 0x00FC, 
   0x0003, 0x00C3, 0x0055, 0x00F5, 0x000F, 0x02AF, 0x003F, 0x00FF, 
   0x0002, 0x00C2, 0x0032, 0x00F2, 0x002A, 0x02AA, 0x003E, 0x00FE, 
   0x0003, 0x00C3, 0x0057, 0x00F3, 0x000F, 0x02AF, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x000C, 0x02AA, 0x003C, 0x00FC, 
   0x0005, 0x00C5, 0x0055, 0x00F5, 0x000F, 0x02AF, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x002A, 0x02AA, 0x003C, 0x00FC, 
   0x0003, 0x00C3, 0x0057, 0x00F3, 0x000F, 0x02AF, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x000C, 0x02AA, 0x003C, 0x00FC, 
   0x0003, 0x00C3, 0x0055, 0x00F5, 0x000F, 0x02AF, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x002A, 0x02AA, 0x003E, 0x00FE, 
   0x0003, 0x00C3, 0x0057, 0x00F3, 0x000F, 0x02AF, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x000C, 0x02AA, 0x003C, 0x00FC, 
   0x0005, 0x00C5, 0x0055, 0x00F5, 0x000F, 0x02AF, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x002A, 0x02AA, 0x003C, 0x00FC, 
   0x0003, 0x00C3, 0x0057, 0x00F3, 0x000F, 0x02AF, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x000C, 0x02AA, 0x003C, 0x00FC, 
   0x0003, 0x00C3, 0x0055, 0x00F5, 0x000F, 0x02AF, 0x003F, 0x00FF, 
   0x0002, 0x00C2, 0x0032, 0x00F2, 0x002A, 0x02AA, 0x003E, 0x00FE, 
   0x0003, 0x00C3, 0x0057, 0x00F3, 0x000F, 0x02AF, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x000C, 0x02AA, 0x003C, 0x00FC, 
   0x0005, 0x00C5, 0x0055, 0x00F5, 0x000F, 0x02AF, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x002A, 0x02AA, 0x003C, 0x00FC, 
   0x0003, 0x00C3, 0x0057, 0x00F3, 0x000F, 0x02AF, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x000C, 0x02AA, 0x003C, 0x00FC, 
   0x0003, 0x00C3, 0x0055, 0x00F5, 0x000F, 0x02AF, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x002A, 0x02AA, 0x003E, 0x00FE, 
   0x0003, 0x00C3, 0x0057, 0x00F3, 0x000F, 0x02AF, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x000C, 0x02AA, 0x003C, 0x00FC, 
   0x0005, 0x00C5, 0x0055, 0x00F5, 0x000F, 0x02AF, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x002A, 0x02AA, 0x003C, 0x00FC, 
   0x0003, 0x00C3, 0x0057, 0x00F3, 0x000F, 0x02AF, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x000C, 0x02AA, 0x003C, 0x00FC, 
   0x0003, 0x00C3, 0x0055, 0x00F5, 0x000F, 0x02AF, 0x003F, 0x00FF, 
   0x0002, 0x00C2, 0x0032, 0x00F2, 0x002A, 0x02AA, 0x003E, 0x00FE, 
   0x0003, 0x00C3, 0x0057, 0x00F3, 0x000F, 0x02AF, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x000C, 0x02AA, 0x003C, 0x00FC, 
   0x0005, 0x00C5, 0x0055, 0x00F5, 0x000F, 0x02AF, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x002A, 0x02AA, 0x003C, 0x00FC, 
   0x0003, 0x00C3, 0x0057, 0x00F3, 0x000F, 0x02AF, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x000C, 0x02AA, 0x003C, 0x00FC, 
   0x0003, 0x00C3, 0x0055, 0x00F5, 0x000F, 0x02AF, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x002A, 0x02AA, 0x003E, 0x00FE, 
   0x0003, 0x00C3, 0x0057, 0x00F3, 0x000F, 0x02AF, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x000C, 0x02AA, 0x003C, 0x00FC, 
   0x0005, 0x00C5, 0x0055, 0x00F5, 0x000F, 0x02AF, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x002A, 0x02AA, 0x003C, 0x00FC, 
   0x0003, 0x00C3, 0x0057, 0x00F3, 0x000F, 0x02AF, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x000C, 0x02AA, 0x003C, 0x00FC, 
   0x0003, 0x00C3, 0x0055, 0x00F5, 0x000F, 0x02AF, 0x003F, 0x00FF, 
   0x0002, 0x00C2, 0x0032, 0x00F2, 0x002A, 0x02AA, 0x003E, 0x00FE, 
   0x0003, 0x00C3, 0x0057, 0x00F3, 0x000F, 0x02AF, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x000C, 0x02AA, 0x003C, 0x00FC, 
   0x0005, 0x00C5, 0x0055, 0x00F5, 0x000F, 0x02AF, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x002A, 0x02AA, 0x003C, 0x00FC, 
   0x0003, 0x00C3, 0x0057, 0x00F3, 0x000F, 0x02AF, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x000C, 0x02AA, 0x003C, 0x00FC, 
   0x0003, 0x00C3, 0x0055, 0x00F5, 0x000F, 0x02AF, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x002A, 0x02AA, 0x003E, 0x00FE, 
   0x0003, 0x00C3, 0x0057, 0x00F3, 0x000F, 0x02AF, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x000C, 0x02AA, 0x003C, 0x00FC, 
   0x0005, 0x00C5, 0x0055, 0x00F5, 0x000F, 0x02AF, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x002A, 0x02AA, 0x003C, 0x00FC, 
   0x0003, 0x00C3, 0x0057, 0x00F3, 0x000F, 0x02AF, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x000C, 0x02AA, 0x003C, 0x00FC, 
   0x0003, 0x00C3, 0x0055, 0x00F5, 0x000F, 0x02AF, 0x003F, 0x00FF, 
   0x0002, 0x00C2, 0x0032, 0x00F2, 0x002A, 0x02AA, 0x003E, 0x00FE, 
   0x0003, 0x00C3, 0x0057, 0x00F3, 0x000F, 0x02AF, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x000C, 0x02AA, 0x003C, 0x00FC, 
   0x0005, 0x00C5, 0x0055, 0x00F5, 0x000F, 0x02AF, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x002A, 0x02AA, 0x003C, 0x00FC, 
   0x0003, 0x00C3, 0x0057, 0x00F3, 0x000F, 0x02AF, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x000C, 0x02AA, 0x003C, 0x00FC, 
   0x0003, 0x00C3, 0x0055, 0x00F5, 0x000F, 0x02AF, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x002A, 0x02AA, 0x003E, 0x00FE, 
   0x0003, 0x00C3, 0x0057, 0x00F3, 0x000F, 0x02AF, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x000C, 0x02AA, 0x003C, 0x00FC, 
   0x0005, 0x00C5, 0x0055, 0x00F5, 0x000F, 0x02AF, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x002A, 0x02AA, 0x003C, 0x00FC, 
   0x0003, 0x00C3, 0x0057, 0x00F3, 0x000F, 0x02AF, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x000C, 0x02AA, 0x003C, 0x00FC, 
   0x0003, 0x00C3, 0x0055, 0x00F5, 0x000F, 0x02AF, 0x003F, 0x00FF, 
   0x0002, 0x00C2, 0x0032, 0x00F2, 0x002A, 0x02AA, 0x003E, 0x00FE, 
   0x0003, 0x00C3, 0x0057, 0x00F3, 0x000F, 0x02AF, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x000C, 0x02AA, 0x003C, 0x00FC, 
   0x0005, 0x00C5, 0x0055, 0x00F5, 0x000F, 0x02AF, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x002A, 0x02AA, 0x003C, 0x00FC, 
   0x0003, 0x00C3, 0x0057, 0x00F3, 0x000F, 0x02AF, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x000C, 0x02AA, 0x003C, 0x00FC, 
   0x0003, 0x00C3, 0x0055, 0x00F5, 0x000F, 0x02AF, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x002A, 0x02AA, 0x003E, 0x00FE, 
   0x0003, 0x00C3, 0x0057, 0x00F3, 0x000F, 0x02AF, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x000C, 0x02AA, 0x003C, 0x00FC, 
   0x0005, 0x00C5, 0x0055, 0x00F5, 0x000F, 0x02AF, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x002A, 0x02AA, 0x003C, 0x00FC, 
   0x0003, 0x00C3, 0x0057, 0x00F3, 0x000F, 0x02AF, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x000C, 0x02AA, 0x003C, 0x00FC, 
   0x0003, 0x00C3, 0x0055, 0x00F5, 0x000F, 0x02AF, 0x003F, 0x00FF, 
   0x0002, 0x00C2, 0x0032, 0x00F2, 0x002A, 0x02AA, 0x003E, 0x00FE, 
   0x0003, 0x00C3, 0x0057, 0x00F3, 0x000F, 0x02AF, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x000C, 0x02AA, 0x003C, 0x00FC, 
   0x0005, 0x00C5, 0x0055, 0x00F5, 0x000F, 0x02AF, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x002A, 0x02AA, 0x003C, 0x00FC, 
   0x0003, 0x00C3, 0x0057, 0x00F3, 0x000F, 0x02AF, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x000C, 0x02AA, 0x003C, 0x00FC, 
   0x0003, 0x00C3, 0x0055, 0x00F5, 0x000F, 0x02AF, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x002A, 0x02AA, 0x003E, 0x00FE, 
   0x0003, 0x00C3, 0x0057, 0x00F3, 0x000F, 0x02AF, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x000C, 0x02AA, 0x003C, 0x00FC, 
   0x0005, 0x00C5, 0x0055, 0x00F5, 0x000F, 0x02AF, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x002A, 0x02AA, 0x003C, 0x00FC, 
   0x0003, 0x00C3, 0x0057, 0x00F3, 0x000F, 0x02AF, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x000C, 0x02AA, 0x003C, 0x00FC, 
   0x0003, 0x00C3, 0x0055, 0x00F5, 0x000F, 0x02AF, 0x003F, 0x00FF, 
   0x0002, 0x00C2, 0x0032, 0x00F2, 0x002A, 0x02AA, 0x003E, 0x00FE, 
   0x0003, 0x00C3, 0x0057, 0x00F3, 0x000F, 0x02AF, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x000C, 0x02AA, 0x003C, 0x00FC, 
   0x0005, 0x00C5, 0x0055, 0x00F5, 0x000F, 0x02AF, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x002A, 0x02AA, 0x003C, 0x00FC, 
   0x0003, 0x00C3, 0x0057, 0x00F3, 0x000F, 0x02AF, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x000C, 0x02AA, 0x003C, 0x00FC, 
   0x0003, 0x00C3, 0x0055, 0x00F5, 0x000F, 0x02AF, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x002A, 0x02AA, 0x003E, 0x00FE, 
   0x0003, 0x00C3, 0x0057, 0x00F3, 0x000F, 0x02AF, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x000C, 0x02AA, 0x003C, 0x00FC, 
   0x0005, 0x00C5, 0x0055, 0x00F5, 0x000F, 0x02AF, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x002A, 0x02AA, 0x003C, 0x00FC, 
   0x0003, 0x00C3, 0x0057, 0x00F3, 0x000F, 0x02AF, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x000C, 0x02AA, 0x003C, 0x00FC, 
   0x0003, 0x00C3, 0x0055, 0x00F5, 0x000F, 0x02AF, 0x003F, 0x00FF, 
   0x0002, 0x00C2, 0x0032, 0x00F2, 0x002A, 0x02AA, 0x003E, 0x00FE, 
   0x0003, 0x00C3, 0x0057, 0x00F3, 0x000F, 0x02AF, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x000C, 0x02AA, 0x003C, 0x00FC, 
   0x0005, 0x00C5, 0x0055, 0x00F5, 0x000F, 0x02AF, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x002A, 0x02AA, 0x003C, 0x00FC, 
   0x0003, 0x00C3, 0x0057, 0x00F3, 0x000F, 0x02AF, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x000C, 0x02AA, 0x003C, 0x00FC, 
   0x0003, 0x00C3, 0x0055, 0x00F5, 0x000F, 0x02AF, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x002A, 0x02AA, 0x003E, 0x00FE, 
   0x0003, 0x00C3, 0x0057, 0x00F3, 0x000F, 0x02AF, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x000C, 0x02AA, 0x003C, 0x00FC, 
   0x0005, 0x00C5, 0x0055, 0x00F5, 0x000F, 0x02AF, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x002A, 0x02AA, 0x003C, 0x00FC, 
   0x0003, 0x00C3, 0x0057, 0x00F3, 0x000F, 0x02AF, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x000C, 0x02AA, 0x003C, 0x00FC, 
   0x0003, 0x00C3, 0x0055, 0x00F5, 0x000F, 0x02AF, 0x003F, 0x00FF, 
   0x0002, 0x00C2, 0x0032, 0x00F2, 0x002A, 0x02AA, 0x003E, 0x00FE, 
   0x0003, 0x00C3, 0x0057, 0x00F3, 0x000F, 0x02AF, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x000C, 0x02AA, 0x003C, 0x00FC, 
   0x0005, 0x00C5, 0x0055, 0x00F5, 0x000F, 0x02AF, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x002A, 0x02AA, 0x003C, 0x00FC, 
   0x0003, 0x00C3, 0x0057, 0x00F3, 0x000F, 0x02AF, 0x003F, 0x00FF, 
   0x2000, 0x20C0, 0x2030, 0x20F0, 0x200C, 0x22AA, 0x203C, 0x20FC, 
   0x2003, 0x20C3, 0x2055, 0x20F5, 0x200F, 0x22AF, 0x203F, 0x20FF, 
   0x2000, 0x20C0, 0x2030, 0x20F0, 0x202A, 0x22AA, 0x203E, 0x20FE, 
   0x2003, 0x20C3, 0x2057, 0x20F3, 0x200F, 0x22AF, 0x203F, 0x20FF, 
   0x2000, 0x20C0, 0x2030, 0x20F0, 0x200C, 0x22AA, 0x203C, 0x20FC, 
   0x2005, 0x20C5, 0x2055, 0x20F5, 0x200F, 0x22AF, 0x203F, 0x20FF, 
   0x2000, 0x20C0, 0x2030, 0x20F0, 0x202A, 0x22AA, 0x203C, 0x20FC, 
   0x2003, 0x20C3, 0x2057, 0x20F3, 0x200F, 0x22AF, 0x203F, 0x20FF, 
   0x2000, 0x20C0, 0x2030, 0x20F0, 0x200C, 0x22AA, 0x203C, 0x20FC, 
   0x2003, 0x20C3, 0x2055, 0x20F5, 0x200F, 0x22AF, 0x203F, 0x20FF, 
   0x2002, 0x20C2, 0x2032, 0x20F2, 0x202A, 0x22AA, 0x203E, 0x20FE, 
   0x2003, 0x20C3, 0x2057, 0x20F3, 0x200F, 0x22AF, 0x203F, 0x20FF, 
   0x2000, 0x20C0, 0x2030, 0x20F0, 0x200C, 0x22AA, 0x203C, 0x20FC, 
   0x2005, 0x20C5, 0x2055, 0x20F5, 0x200F, 0x22AF, 0x203F, 0x20FF, 
   0x2000, 0x20C0, 0x2030, 0x20F0, 0x202A, 0x22AA, 0x203C, 0x20FC, 
   0x2003, 0x20C3, 0x2057, 0x20F3, 0x200F, 0x22AF, 0x203F, 0x20FF, 
   0x2000, 0x20C0, 0x2030, 0x20F0, 0x200C, 0x22AA, 0x203C, 0x20FC, 
   0x2003, 0x20C3, 0x2055, 0x20F5, 0x200F, 0x22AF, 0x203F, 0x20FF, 
   0x2000, 0x20C0, 0x2030, 0x20F0, 0x202A, 0x22AA, 0x203E, 0x20FE, 
   0x2003, 0x20C3, 0x2057, 0x20F3, 0x200F, 0x22AF, 0x203F, 0x20FF, 
   0x2000, 0x20C0, 0x2030, 0x20F0, 0x200C, 0x22AA, 0x203C, 0x20FC, 
   0x2005, 0x20C5, 0x2055, 0x20F5, 0x200F, 0x22AF, 0x203F, 0x20FF, 
   0x2000, 0x20C0, 0x2030, 0x20F0, 0x202A, 0x22AA, 0x203C, 0x20FC, 
   0x2003, 0x20C3, 0x2057, 0x20F3, 0x200F, 0x22AF, 0x203F, 0x20FF, 
   0x2000, 0x20C0, 0x2030, 0x20F0, 0x200C, 0x22AA, 0x203C, 0x20FC, 
   0x2003, 0x20C3, 0x2055, 0x20F5, 0x200F, 0x22AF, 0x203F, 0x20FF, 
   0x2002, 0x20C2, 0x2032, 0x20F2, 0x202A, 0x22AA, 0x203E, 0x20FE, 
   0x2003, 0x20C3, 0x2057, 0x20F3, 0x200F, 0x22AF, 0x203F, 0x20FF, 
   0x2000, 0x20C0, 0x2030, 0x20F0, 0x200C, 0x22AA, 0x203C, 0x20FC, 
   0x2005, 0x20C5, 0x2055, 0x20F5, 0x200F, 0x22AF, 0x203F, 0x20FF, 
   0x2000, 0x20C0, 0x2030, 0x20F0, 0x202A, 0x22AA, 0x203C, 0x20FC, 
   0x2003, 0x20C3, 0x2057, 0x20F3, 0x200F, 0x22AF, 0x203F, 0x20FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x000C, 0x02AA, 0x003C, 0x00FC, 
   0x0003, 0x00C3, 0x0055, 0x00F5, 0x000F, 0x02AF, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x002A, 0x02AA, 0x003E, 0x00FE, 
   0x0003, 0x00C3, 0x0057, 0x00F3, 0x000F, 0x02AF, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x000C, 0x02AA, 0x003C, 0x00FC, 
   0x0005, 0x00C5, 0x0055, 0x00F5, 0x000F, 0x02AF, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x002A, 0x02AA, 0x003C, 0x00FC, 
   0x0003, 0x00C3, 0x0057, 0x00F3, 0x000F, 0x02AF, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x000C, 0x02AA, 0x003C, 0x00FC, 
   0x0003, 0x00C3, 0x0055, 0x00F5, 0x000F, 0x02AF, 0x003F, 0x00FF, 
   0x0002, 0x00C2, 0x0032, 0x00F2, 0x002A, 0x02AA, 0x003E, 0x00FE, 
   0x0003, 0x00C3, 0x0057, 0x00F3, 0x000F, 0x02AF, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x000C, 0x02AA, 0x003C, 0x00FC, 
   0x0005, 0x00C5, 0x0055, 0x00F5, 0x000F, 0x02AF, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x002A, 0x02AA, 0x003C, 0x00FC, 
   0x0003, 0x00C3, 0x0057, 0x00F3, 0x000F, 0x02AF, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x000C, 0x02AA, 0x003C, 0x00FC, 
   0x0003, 0x00C3, 0x0055, 0x00F5, 0x000F, 0x02AF, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x002A, 0x02AA, 0x003E, 0x00FE, 
   0x0003, 0x00C3, 0x0057, 0x00F3, 0x000F, 0x02AF, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x000C, 0x02AA, 0x003C, 0x00FC, 
   0x0005, 0x00C5, 0x0055, 0x00F5, 0x000F, 0x02AF, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x002A, 0x02AA, 0x003C, 0x00FC, 
   0x0003, 0x00C3, 0x0057, 0x00F3, 0x000F, 0x02AF, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x000C, 0x02AA, 0x003C, 0x00FC, 
   0x0003, 0x00C3, 0x0055, 0x00F5, 0x000F, 0x02AF, 0x003F, 0x00FF, 
   0x0002, 0x00C2, 0x0032, 0x00F2, 0x002A, 0x02AA, 0x003E, 0x00FE, 
   0x0003, 0x00C3, 0x0057, 0x00F3, 0x000F, 0x02AF, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x000C, 0x02AA, 0x003C, 0x00FC, 
   0x0005, 0x00C5, 0x0055, 0x00F5, 0x000F, 0x02AF, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x002A, 0x02AA, 0x003C, 0x00FC, 
   0x0003, 0x00C3, 0x0057, 0x00F3, 0x000F, 0x02AF, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x000C, 0x02AA, 0x003C, 0x00FC, 
   0x0003, 0x00C3, 0x0055, 0x00F5, 0x000F, 0x02AF, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x002A, 0x02AA, 0x003E, 0x00FE, 
   0x0003, 0x00C3, 0x0057, 0x00F3, 0x000F, 0x02AF, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x000C, 0x02AA, 0x003C, 0x00FC, 
   0x0005, 0x00C5, 0x0055, 0x00F5, 0x000F, 0x02AF, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x002A, 0x02AA, 0x003C, 0x00FC, 
   0x0003, 0x00C3, 0x0057, 0x00F3, 0x000F, 0x02AF, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x000C, 0x02AA, 0x003C, 0x00FC, 
   0x0003, 0x00C3, 0x0055, 0x00F5, 0x000F, 0x02AF, 0x003F, 0x00FF, 
   0x0002, 0x00C2, 0x0032, 0x00F2, 0x002A, 0x02AA, 0x003E, 0x00FE, 
   0x0003, 0x00C3, 0x0057, 0x00F3, 0x000F, 0x02AF, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x000C, 0x02AA, 0x003C, 0x00FC, 
   0x0005, 0x00C5, 0x0055, 0x00F5, 0x000F, 0x02AF, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x002A, 0x02AA, 0x003C, 0x00FC, 
   0x0003, 0x00C3, 0x0057, 0x00F3, 0x000F, 0x02AF, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x000C, 0x02AA, 0x003C, 0x00FC, 
   0x0003, 0x00C3, 0x0055, 0x00F5, 0x000F, 0x02AF, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x002A, 0x02AA, 0x003E, 0x00FE, 
   0x0003, 0x00C3, 0x0057, 0x00F3, 0x000F, 0x02AF, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x000C, 0x02AA, 0x003C, 0x00FC, 
   0x0005, 0x00C5, 0x0055, 0x00F5, 0x000F, 0x02AF, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x002A, 0x02AA, 0x003C, 0x00FC, 
   0x0003, 0x00C3, 0x0057, 0x00F3, 0x000F, 0x02AF, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x000C, 0x02AA, 0x003C, 0x00FC, 
   0x0003, 0x00C3, 0x0055, 0x00F5, 0x000F, 0x02AF, 0x003F, 0x00FF, 
   0x0002, 0x00C2, 0x0032, 0x00F2, 0x002A, 0x02AA, 0x003E, 0x00FE, 
   0x0003, 0x00C3, 0x0057, 0x00F3, 0x000F, 0x02AF, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x000C, 0x02AA, 0x003C, 0x00FC, 
   0x0005, 0x00C5, 0x0055, 0x00F5, 0x000F, 0x02AF, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x002A, 0x02AA, 0x003C, 0x00FC, 
   0x0003, 0x00C3, 0x0057, 0x00F3, 0x000F, 0x02AF, 0x003F, 0x00FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x300C, 0x32AA, 0x303C, 0x30FC, 
   0x3003, 0x30C3, 0x3055, 0x30F5, 0x300F, 0x32AF, 0x303F, 0x30FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x302A, 0x32AA, 0x303E, 0x30FE, 
   0x3003, 0x30C3, 0x3057, 0x30F3, 0x300F, 0x32AF, 0x303F, 0x30FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x300C, 0x32AA, 0x303C, 0x30FC, 
   0x3005, 0x30C5, 0x3055, 0x30F5, 0x300F, 0x32AF, 0x303F, 0x30FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x302A, 0x32AA, 0x303C, 0x30FC, 
   0x3003, 0x30C3, 0x3057, 0x30F3, 0x300F, 0x32AF, 0x303F, 0x30FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x300C, 0x32AA, 0x303C, 0x30FC, 
   0x3003, 0x30C3, 0x3055, 0x30F5, 0x300F, 0x32AF, 0x303F, 0x30FF, 
   0x3002, 0x30C2, 0x3032, 0x30F2, 0x302A, 0x32AA, 0x303E, 0x30FE, 
   0x3003, 0x30C3, 0x3057, 0x30F3, 0x300F, 0x32AF, 0x303F, 0x30FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x300C, 0x32AA, 0x303C, 0x30FC, 
   0x3005, 0x30C5, 0x3055, 0x30F5, 0x300F, 0x32AF, 0x303F, 0x30FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x302A, 0x32AA, 0x303C, 0x30FC, 
   0x3003, 0x30C3, 0x3057, 0x30F3, 0x300F, 0x32AF, 0x303F, 0x30FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x300C, 0x32AA, 0x303C, 0x30FC, 
   0x3003, 0x30C3, 0x3055, 0x30F5, 0x300F, 0x32AF, 0x303F, 0x30FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x302A, 0x32AA, 0x303E, 0x30FE, 
   0x3003, 0x30C3, 0x3057, 0x30F3, 0x300F, 0x32AF, 0x303F, 0x30FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x300C, 0x32AA, 0x303C, 0x30FC, 
   0x3005, 0x30C5, 0x3055, 0x30F5, 0x300F, 0x32AF, 0x303F, 0x30FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x302A, 0x32AA, 0x303C, 0x30FC, 
   0x3003, 0x30C3, 0x3057, 0x30F3, 0x300F, 0x32AF, 0x303F, 0x30FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x300C, 0x32AA, 0x303C, 0x30FC, 
   0x3003, 0x30C3, 0x3055, 0x30F5, 0x300F, 0x32AF, 0x303F, 0x30FF, 
   0x3002, 0x30C2, 0x3032, 0x30F2, 0x302A, 0x32AA, 0x303E, 0x30FE, 
   0x3003, 0x30C3, 0x3057, 0x30F3, 0x300F, 0x32AF, 0x303F, 0x30FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x300C, 0x32AA, 0x303C, 0x30FC, 
   0x3005, 0x30C5, 0x3055, 0x30F5, 0x300F, 0x32AF, 0x303F, 0x30FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x302A, 0x32AA, 0x303C, 0x30FC, 
   0x3003, 0x30C3, 0x3057, 0x30F3, 0x300F, 0x32AF, 0x303F, 0x30FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x300C, 0x32AA, 0x303C, 0x30FC, 
   0x3003, 0x30C3, 0x3055, 0x30F5, 0x300F, 0x32AF, 0x303F, 0x30FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x302A, 0x32AA, 0x303E, 0x30FE, 
   0x3003, 0x30C3, 0x3057, 0x30F3, 0x300F, 0x32AF, 0x303F, 0x30FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x300C, 0x32AA, 0x303C, 0x30FC, 
   0x3005, 0x30C5, 0x3055, 0x30F5, 0x300F, 0x32AF, 0x303F, 0x30FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x302A, 0x32AA, 0x303C, 0x30FC, 
   0x3003, 0x30C3, 0x3057, 0x30F3, 0x300F, 0x32AF, 0x303F, 0x30FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x300C, 0x32AA, 0x303C, 0x30FC, 
   0x3003, 0x30C3, 0x3055, 0x30F5, 0x300F, 0x32AF, 0x303F, 0x30FF, 
   0x3002, 0x30C2, 0x3032, 0x30F2, 0x302A, 0x32AA, 0x303E, 0x30FE, 
   0x3003, 0x30C3, 0x3057, 0x30F3, 0x300F, 0x32AF, 0x303F, 0x30FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x300C, 0x32AA, 0x303C, 0x30FC, 
   0x3005, 0x30C5, 0x3055, 0x30F5, 0x300F, 0x32AF, 0x303F, 0x30FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x302A, 0x32AA, 0x303C, 0x30FC, 
   0x3003, 0x30C3, 0x3057, 0x30F3, 0x300F, 0x32AF, 0x303F, 0x30FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x300C, 0x32AA, 0x303C, 0x30FC, 
   0x3003, 0x30C3, 0x3055, 0x30F5, 0x300F, 0x32AF, 0x303F, 0x30FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x302A, 0x32AA, 0x303E, 0x30FE, 
   0x3003, 0x30C3, 0x3057, 0x30F3, 0x300F, 0x32AF, 0x303F, 0x30FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x300C, 0x32AA, 0x303C, 0x30FC, 
   0x3005, 0x30C5, 0x3055, 0x30F5, 0x300F, 0x32AF, 0x303F, 0x30FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x302A, 0x32AA, 0x303C, 0x30FC, 
   0x3003, 0x30C3, 0x3057, 0x30F3, 0x300F, 0x32AF, 0x303F, 0x30FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x300C, 0x32AA, 0x303C, 0x30FC, 
   0x3003, 0x30C3, 0x3055, 0x30F5, 0x300F, 0x32AF, 0x303F, 0x30FF, 
   0x3002, 0x30C2, 0x3032, 0x30F2, 0x302A, 0x32AA, 0x303E, 0x30FE, 
   0x3003, 0x30C3, 0x3057, 0x30F3, 0x300F, 0x32AF, 0x303F, 0x30FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x300C, 0x32AA, 0x303C, 0x30FC, 
   0x3005, 0x30C5, 0x3055, 0x30F5, 0x300F, 0x32AF, 0x303F, 0x30FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x302A, 0x32AA, 0x303C, 0x30FC, 
   0x3003, 0x30C3, 0x3057, 0x30F3, 0x300F, 0x32AF, 0x303F, 0x30FF, 
   0x1400, 0x14C0, 0x1430, 0x14F0, 0x140C, 0x16AA, 0x143C, 0x14FC, 
   0x1403, 0x14C3, 0x1455, 0x14F5, 0x140F, 0x16AF, 0x143F, 0x14FF, 
   0x1400, 0x14C0, 0x1430, 0x14F0, 0x142A, 0x16AA, 0x143E, 0x14FE, 
   0x1403, 0x14C3, 0x1457, 0x14F3, 0x140F, 0x16AF, 0x143F, 0x14FF, 
   0x1400, 0x14C0, 0x1430, 0x14F0, 0x140C, 0x16AA, 0x143C, 0x14FC, 
   0x1405, 0x14C5, 0x1455, 0x14F5, 0x140F, 0x16AF, 0x143F, 0x14FF, 
   0x1400, 0x14C0, 0x1430, 0x14F0, 0x142A, 0x16AA, 0x143C, 0x14FC, 
   0x1403, 0x14C3, 0x1457, 0x14F3, 0x140F, 0x16AF, 0x143F, 0x14FF, 
   0x1400, 0x14C0, 0x1430, 0x14F0, 0x140C, 0x16AA, 0x143C, 0x14FC, 
   0x1403, 0x14C3, 0x1455, 0x14F5, 0x140F, 0x16AF, 0x143F, 0x14FF, 
   0x1402, 0x14C2, 0x1432, 0x14F2, 0x142A, 0x16AA, 0x143E, 0x14FE, 
   0x1403, 0x14C3, 0x1457, 0x14F3, 0x140F, 0x16AF, 0x143F, 0x14FF, 
   0x1400, 0x14C0, 0x1430, 0x14F0, 0x140C, 0x16AA, 0x143C, 0x14FC, 
   0x1405, 0x14C5, 0x1455, 0x14F5, 0x140F, 0x16AF, 0x143F, 0x14FF, 
   0x1400, 0x14C0, 0x1430, 0x14F0, 0x142A, 0x16AA, 0x143C, 0x14FC, 
   0x1403, 0x14C3, 0x1457, 0x14F3, 0x140F, 0x16AF, 0x143F, 0x14FF, 
   0x1400, 0x14C0, 0x1430, 0x14F0, 0x140C, 0x16AA, 0x143C, 0x14FC, 
   0x1403, 0x14C3, 0x1455, 0x14F5, 0x140F, 0x16AF, 0x143F, 0x14FF, 
   0x1400, 0x14C0, 0x1430, 0x14F0, 0x142A, 0x16AA, 0x143E, 0x14FE, 
   0x1403, 0x14C3, 0x1457, 0x14F3, 0x140F, 0x16AF, 0x143F, 0x14FF, 
   0x1400, 0x14C0, 0x1430, 0x14F0, 0x140C, 0x16AA, 0x143C, 0x14FC, 
   0x1405, 0x14C5, 0x1455, 0x14F5, 0x140F, 0x16AF, 0x143F, 0x14FF, 
   0x1400, 0x14C0, 0x1430, 0x14F0, 0x142A, 0x16AA, 0x143C, 0x14FC, 
   0x1403, 0x14C3, 0x1457, 0x14F3, 0x140F, 0x16AF, 0x143F, 0x14FF, 
   0x1400, 0x14C0, 0x1430, 0x14F0, 0x140C, 0x16AA, 0x143C, 0x14FC, 
   0x1403, 0x14C3, 0x1455, 0x14F5, 0x140F, 0x16AF, 0x143F, 0x14FF, 
   0x1402, 0x14C2, 0x1432, 0x14F2, 0x142A, 0x16AA, 0x143E, 0x14FE, 
   0x1403, 0x14C3, 0x1457, 0x14F3, 0x140F, 0x16AF, 0x143F, 0x14FF, 
   0x1400, 0x14C0, 0x1430, 0x14F0, 0x140C, 0x16AA, 0x143C, 0x14FC, 
   0x1405, 0x14C5, 0x1455, 0x14F5, 0x140F, 0x16AF, 0x143F, 0x14FF, 
   0x1400, 0x14C0, 0x1430, 0x14F0, 0x142A, 0x16AA, 0x143C, 0x14FC, 
   0x1403, 0x14C3, 0x1457, 0x14F3, 0x140F, 0x16AF, 0x143F, 0x14FF, 
   0x1400, 0x14C0, 0x1430, 0x14F0, 0x140C, 0x16AA, 0x143C, 0x14FC, 
   0x1403, 0x14C3, 0x1455, 0x14F5, 0x140F, 0x16AF, 0x143F, 0x14FF, 
   0x1400, 0x14C0, 0x1430, 0x14F0, 0x142A, 0x16AA, 0x143E, 0x14FE, 
   0x1403, 0x14C3, 0x1457, 0x14F3, 0x140F, 0x16AF, 0x143F, 0x14FF, 
   0x1400, 0x14C0, 0x1430, 0x14F0, 0x140C, 0x16AA, 0x143C, 0x14FC, 
   0x1405, 0x14C5, 0x1455, 0x14F5, 0x140F, 0x16AF, 0x143F, 0x14FF, 
   0x1400, 0x14C0, 0x1430, 0x14F0, 0x142A, 0x16AA, 0x143C, 0x14FC, 
   0x1403, 0x14C3, 0x1457, 0x14F3, 0x140F, 0x16AF, 0x143F, 0x14FF, 
   0x1400, 0x14C0, 0x1430, 0x14F0, 0x140C, 0x16AA, 0x143C, 0x14FC, 
   0x1403, 0x14C3, 0x1455, 0x14F5, 0x140F, 0x16AF, 0x143F, 0x14FF, 
   0x1402, 0x14C2, 0x1432, 0x14F2, 0x142A, 0x16AA, 0x143E, 0x14FE, 
   0x1403, 0x14C3, 0x1457, 0x14F3, 0x140F, 0x16AF, 0x143F, 0x14FF, 
   0x1400, 0x14C0, 0x1430, 0x14F0, 0x140C, 0x16AA, 0x143C, 0x14FC, 
   0x1405, 0x14C5, 0x1455, 0x14F5, 0x140F, 0x16AF, 0x143F, 0x14FF, 
   0x1400, 0x14C0, 0x1430, 0x14F0, 0x142A, 0x16AA, 0x143C, 0x14FC, 
   0x1403, 0x14C3, 0x1457, 0x14F3, 0x140F, 0x16AF, 0x143F, 0x14FF, 
   0x1400, 0x14C0, 0x1430, 0x14F0, 0x140C, 0x16AA, 0x143C, 0x14FC, 
   0x1403, 0x14C3, 0x1455, 0x14F5, 0x140F, 0x16AF, 0x143F, 0x14FF, 
   0x1400, 0x14C0, 0x1430, 0x14F0, 0x142A, 0x16AA, 0x143E, 0x14FE, 
   0x1403, 0x14C3, 0x1457, 0x14F3, 0x140F, 0x16AF, 0x143F, 0x14FF, 
   0x1400, 0x14C0, 0x1430, 0x14F0, 0x140C, 0x16AA, 0x143C, 0x14FC, 
   0x1405, 0x14C5, 0x1455, 0x14F5, 0x140F, 0x16AF, 0x143F, 0x14FF, 
   0x1400, 0x14C0, 0x1430, 0x14F0, 0x142A, 0x16AA, 0x143C, 0x14FC, 
   0x1403, 0x14C3, 0x1457, 0x14F3, 0x140F, 0x16AF, 0x143F, 0x14FF, 
   0x1400, 0x14C0, 0x1430, 0x14F0, 0x140C, 0x16AA, 0x143C, 0x14FC, 
   0x1403, 0x14C3, 0x1455, 0x14F5, 0x140F, 0x16AF, 0x143F, 0x14FF, 
   0x1402, 0x14C2, 0x1432, 0x14F2, 0x142A, 0x16AA, 0x143E, 0x14FE, 
   0x1403, 0x14C3, 0x1457, 0x14F3, 0x140F, 0x16AF, 0x143F, 0x14FF, 
   0x1400, 0x14C0, 0x1430, 0x14F0, 0x140C, 0x16AA, 0x143C, 0x14FC, 
   0x1405, 0x14C5, 0x1455, 0x14F5, 0x140F, 0x16AF, 0x143F, 0x14FF, 
   0x1400, 0x14C0, 0x1430, 0x14F0, 0x142A, 0x16AA, 0x143C, 0x14FC, 
   0x1403, 0x14C3, 0x1457, 0x14F3, 0x140F, 0x16AF, 0x143F, 0x14FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x300C, 0x32AA, 0x303C, 0x30FC, 
   0x3003, 0x30C3, 0x3055, 0x30F5, 0x300F, 0x32AF, 0x303F, 0x30FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x302A, 0x32AA, 0x303E, 0x30FE, 
   0x3003, 0x30C3, 0x3057, 0x30F3, 0x300F, 0x32AF, 0x303F, 0x30FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x300C, 0x32AA, 0x303C, 0x30FC, 
   0x3005, 0x30C5, 0x3055, 0x30F5, 0x300F, 0x32AF, 0x303F, 0x30FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x302A, 0x32AA, 0x303C, 0x30FC, 
   0x3003, 0x30C3, 0x3057, 0x30F3, 0x300F, 0x32AF, 0x303F, 0x30FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x300C, 0x32AA, 0x303C, 0x30FC, 
   0x3003, 0x30C3, 0x3055, 0x30F5, 0x300F, 0x32AF, 0x303F, 0x30FF, 
   0x3002, 0x30C2, 0x3032, 0x30F2, 0x302A, 0x32AA, 0x303E, 0x30FE, 
   0x3003, 0x30C3, 0x3057, 0x30F3, 0x300F, 0x32AF, 0x303F, 0x30FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x300C, 0x32AA, 0x303C, 0x30FC, 
   0x3005, 0x30C5, 0x3055, 0x30F5, 0x300F, 0x32AF, 0x303F, 0x30FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x302A, 0x32AA, 0x303C, 0x30FC, 
   0x3003, 0x30C3, 0x3057, 0x30F3, 0x300F, 0x32AF, 0x303F, 0x30FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x300C, 0x32AA, 0x303C, 0x30FC, 
   0x3003, 0x30C3, 0x3055, 0x30F5, 0x300F, 0x32AF, 0x303F, 0x30FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x302A, 0x32AA, 0x303E, 0x30FE, 
   0x3003, 0x30C3, 0x3057, 0x30F3, 0x300F, 0x32AF, 0x303F, 0x30FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x300C, 0x32AA, 0x303C, 0x30FC, 
   0x3005, 0x30C5, 0x3055, 0x30F5, 0x300F, 0x32AF, 0x303F, 0x30FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x302A, 0x32AA, 0x303C, 0x30FC, 
   0x3003, 0x30C3, 0x3057, 0x30F3, 0x300F, 0x32AF, 0x303F, 0x30FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x300C, 0x32AA, 0x303C, 0x30FC, 
   0x3003, 0x30C3, 0x3055, 0x30F5, 0x300F, 0x32AF, 0x303F, 0x30FF, 
   0x3002, 0x30C2, 0x3032, 0x30F2, 0x302A, 0x32AA, 0x303E, 0x30FE, 
   0x3003, 0x30C3, 0x3057, 0x30F3, 0x300F, 0x32AF, 0x303F, 0x30FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x300C, 0x32AA, 0x303C, 0x30FC, 
   0x3005, 0x30C5, 0x3055, 0x30F5, 0x300F, 0x32AF, 0x303F, 0x30FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x302A, 0x32AA, 0x303C, 0x30FC, 
   0x3003, 0x30C3, 0x3057, 0x30F3, 0x300F, 0x32AF, 0x303F, 0x30FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x300C, 0x32AA, 0x303C, 0x30FC, 
   0x3003, 0x30C3, 0x3055, 0x30F5, 0x300F, 0x32AF, 0x303F, 0x30FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x302A, 0x32AA, 0x303E, 0x30FE, 
   0x3003, 0x30C3, 0x3057, 0x30F3, 0x300F, 0x32AF, 0x303F, 0x30FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x300C, 0x32AA, 0x303C, 0x30FC, 
   0x3005, 0x30C5, 0x3055, 0x30F5, 0x300F, 0x32AF, 0x303F, 0x30FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x302A, 0x32AA, 0x303C, 0x30FC, 
   0x3003, 0x30C3, 0x3057, 0x30F3, 0x300F, 0x32AF, 0x303F, 0x30FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x300C, 0x32AA, 0x303C, 0x30FC, 
   0x3003, 0x30C3, 0x3055, 0x30F5, 0x300F, 0x32AF, 0x303F, 0x30FF, 
   0x3002, 0x30C2, 0x3032, 0x30F2, 0x302A, 0x32AA, 0x303E, 0x30FE, 
   0x3003, 0x30C3, 0x3057, 0x30F3, 0x300F, 0x32AF, 0x303F, 0x30FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x300C, 0x32AA, 0x303C, 0x30FC, 
   0x3005, 0x30C5, 0x3055, 0x30F5, 0x300F, 0x32AF, 0x303F, 0x30FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x302A, 0x32AA, 0x303C, 0x30FC, 
   0x3003, 0x30C3, 0x3057, 0x30F3, 0x300F, 0x32AF, 0x303F, 0x30FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x300C, 0x32AA, 0x303C, 0x30FC, 
   0x3003, 0x30C3, 0x3055, 0x30F5, 0x300F, 0x32AF, 0x303F, 0x30FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x302A, 0x32AA, 0x303E, 0x30FE, 
   0x3003, 0x30C3, 0x3057, 0x30F3, 0x300F, 0x32AF, 0x303F, 0x30FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x300C, 0x32AA, 0x303C, 0x30FC, 
   0x3005, 0x30C5, 0x3055, 0x30F5, 0x300F, 0x32AF, 0x303F, 0x30FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x302A, 0x32AA, 0x303C, 0x30FC, 
   0x3003, 0x30C3, 0x3057, 0x30F3, 0x300F, 0x32AF, 0x303F, 0x30FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x300C, 0x32AA, 0x303C, 0x30FC, 
   0x3003, 0x30C3, 0x3055, 0x30F5, 0x300F, 0x32AF, 0x303F, 0x30FF, 
   0x3002, 0x30C2, 0x3032, 0x30F2, 0x302A, 0x32AA, 0x303E, 0x30FE, 
   0x3003, 0x30C3, 0x3057, 0x30F3, 0x300F, 0x32AF, 0x303F, 0x30FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x300C, 0x32AA, 0x303C, 0x30FC, 
   0x3005, 0x30C5, 0x3055, 0x30F5, 0x300F, 0x32AF, 0x303F, 0x30FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x302A, 0x32AA, 0x303C, 0x30FC, 
   0x3003, 0x30C3, 0x3057, 0x30F3, 0x300F, 0x32AF, 0x303F, 0x30FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x300C, 0x32AA, 0x303C, 0x30FC, 
   0x3003, 0x30C3, 0x3055, 0x30F5, 0x300F, 0x32AF, 0x303F, 0x30FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x302A, 0x32AA, 0x303E, 0x30FE, 
   0x3003, 0x30C3, 0x3057, 0x30F3, 0x300F, 0x32AF, 0x303F, 0x30FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x300C, 0x32AA, 0x303C, 0x30FC, 
   0x3005, 0x30C5, 0x3055, 0x30F5, 0x300F, 0x32AF, 0x303F, 0x30FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x302A, 0x32AA, 0x303C, 0x30FC, 
   0x3003, 0x30C3, 0x3057, 0x30F3, 0x300F, 0x32AF, 0x303F, 0x30FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x300C, 0x32AA, 0x303C, 0x30FC, 
   0x3003, 0x30C3, 0x3055, 0x30F5, 0x300F, 0x32AF, 0x303F, 0x30FF, 
   0x3002, 0x30C2, 0x3032, 0x30F2, 0x302A, 0x32AA, 0x303E, 0x30FE, 
   0x3003, 0x30C3, 0x3057, 0x30F3, 0x300F, 0x32AF, 0x303F, 0x30FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x300C, 0x32AA, 0x303C, 0x30FC, 
   0x3005, 0x30C5, 0x3055, 0x30F5, 0x300F, 0x32AF, 0x303F, 0x30FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x302A, 0x32AA, 0x303C, 0x30FC, 
   0x3003, 0x30C3, 0x3057, 0x30F3, 0x300F, 0x32AF, 0x303F, 0x30FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x300C, 0x32AA, 0x303C, 0x30FC, 
   0x3003, 0x30C3, 0x3055, 0x30F5, 0x300F, 0x32AF, 0x303F, 0x30FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x302A, 0x32AA, 0x303E, 0x30FE, 
   0x3003, 0x30C3, 0x3057, 0x30F3, 0x300F, 0x32AF, 0x303F, 0x30FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x300C, 0x32AA, 0x303C, 0x30FC, 
   0x3005, 0x30C5, 0x3055, 0x30F5, 0x300F, 0x32AF, 0x303F, 0x30FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x302A, 0x32AA, 0x303C, 0x30FC, 
   0x3003, 0x30C3, 0x3057, 0x30F3, 0x300F, 0x32AF, 0x303F, 0x30FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x300C, 0x32AA, 0x303C, 0x30FC, 
   0x3003, 0x30C3, 0x3055, 0x30F5, 0x300F, 0x32AF, 0x303F, 0x30FF, 
   0x3002, 0x30C2, 0x3032, 0x30F2, 0x302A, 0x32AA, 0x303E, 0x30FE, 
   0x3003, 0x30C3, 0x3057, 0x30F3, 0x300F, 0x32AF, 0x303F, 0x30FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x300C, 0x32AA, 0x303C, 0x30FC, 
   0x3005, 0x30C5, 0x3055, 0x30F5, 0x300F, 0x32AF, 0x303F, 0x30FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x302A, 0x32AA, 0x303C, 0x30FC, 
   0x3003, 0x30C3, 0x3057, 0x30F3, 0x300F, 0x32AF, 0x303F, 0x30FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x300C, 0x32AA, 0x303C, 0x30FC, 
   0x3003, 0x30C3, 0x3055, 0x30F5, 0x300F, 0x32AF, 0x303F, 0x30FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x302A, 0x32AA, 0x303E, 0x30FE, 
   0x3003, 0x30C3, 0x3057, 0x30F3, 0x300F, 0x32AF, 0x303F, 0x30FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x300C, 0x32AA, 0x303C, 0x30FC, 
   0x3005, 0x30C5, 0x3055, 0x30F5, 0x300F, 0x32AF, 0x303F, 0x30FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x302A, 0x32AA, 0x303C, 0x30FC, 
   0x3003, 0x30C3, 0x3057, 0x30F3, 0x300F, 0x32AF, 0x303F, 0x30FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x300C, 0x32AA, 0x303C, 0x30FC, 
   0x3003, 0x30C3, 0x3055, 0x30F5, 0x300F, 0x32AF, 0x303F, 0x30FF, 
   0x3002, 0x30C2, 0x3032, 0x30F2, 0x302A, 0x32AA, 0x303E, 0x30FE, 
   0x3003, 0x30C3, 0x3057, 0x30F3, 0x300F, 0x32AF, 0x303F, 0x30FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x300C, 0x32AA, 0x303C, 0x30FC, 
   0x3005, 0x30C5, 0x3055, 0x30F5, 0x300F, 0x32AF, 0x303F, 0x30FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x302A, 0x32AA, 0x303C, 0x30FC, 
   0x3003, 0x30C3, 0x3057, 0x30F3, 0x300F, 0x32AF, 0x303F, 0x30FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x300C, 0x32AA, 0x303C, 0x30FC, 
   0x3003, 0x30C3, 0x3055, 0x30F5, 0x300F, 0x32AF, 0x303F, 0x30FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x302A, 0x32AA, 0x303E, 0x30FE, 
   0x3003, 0x30C3, 0x3057, 0x30F3, 0x300F, 0x32AF, 0x303F, 0x30FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x300C, 0x32AA, 0x303C, 0x30FC, 
   0x3005, 0x30C5, 0x3055, 0x30F5, 0x300F, 0x32AF, 0x303F, 0x30FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x302A, 0x32AA, 0x303C, 0x30FC, 
   0x3003, 0x30C3, 0x3057, 0x30F3, 0x300F, 0x32AF, 0x303F, 0x30FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x300C, 0x32AA, 0x303C, 0x30FC, 
   0x3003, 0x30C3, 0x3055, 0x30F5, 0x300F, 0x32AF, 0x303F, 0x30FF, 
   0x3002, 0x30C2, 0x3032, 0x30F2, 0x302A, 0x32AA, 0x303E, 0x30FE, 
   0x3003, 0x30C3, 0x3057, 0x30F3, 0x300F, 0x32AF, 0x303F, 0x30FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x300C, 0x32AA, 0x303C, 0x30FC, 
   0x3005, 0x30C5, 0x3055, 0x30F5, 0x300F, 0x32AF, 0x303F, 0x30FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x302A, 0x32AA, 0x303C, 0x30FC, 
   0x3003, 0x30C3, 0x3057, 0x30F3, 0x300F, 0x32AF, 0x303F, 0x30FF, 
   0x0C00, 0x2AA0, 0x0C30, 0x2AF0, 0x0C0C, 0x2AAA, 0x0C3C, 0x2AFC, 
   0x0C03, 0x2AA3, 0x0C55, 0x2AF5, 0x0C0F, 0x2AAF, 0x0C3F, 0x2AFF, 
   0x0C00, 0x2AA0, 0x0C30, 0x2AF0, 0x0C2A, 0x2AAA, 0x0C3E, 0x2AFE, 
   0x0C03, 0x2AA3, 0x0C57, 0x2AF3, 0x0C0F, 0x2AAF, 0x0C3F, 0x2AFF, 
   0x0C00, 0x2AA0, 0x0C30, 0x2AF0, 0x0C0C, 0x2AAA, 0x0C3C, 0x2AFC, 
   0x0C05, 0x2AA5, 0x0C55, 0x2AF5, 0x0C0F, 0x2AAF, 0x0C3F, 0x2AFF, 
   0x0C00, 0x2AA0, 0x0C30, 0x2AF0, 0x0C2A, 0x2AAA, 0x0C3C, 0x2AFC, 
   0x0C03, 0x2AA3, 0x0C57, 0x2AF3, 0x0C0F, 0x2AAF, 0x0C3F, 0x2AFF, 
   0x0C00, 0x2AA0, 0x0C30, 0x2AF0, 0x0C0C, 0x2AAA, 0x0C3C, 0x2AFC, 
   0x0C03, 0x2AA3, 0x0C55, 0x2AF5, 0x0C0F, 0x2AAF, 0x0C3F, 0x2AFF, 
   0x0C02, 0x2AA2, 0x0C32, 0x2AF2, 0x0C2A, 0x2AAA, 0x0C3E, 0x2AFE, 
   0x0C03, 0x2AA3, 0x0C57, 0x2AF3, 0x0C0F, 0x2AAF, 0x0C3F, 0x2AFF, 
   0x0C00, 0x2AA0, 0x0C30, 0x2AF0, 0x0C0C, 0x2AAA, 0x0C3C, 0x2AFC, 
   0x0C05, 0x2AA5, 0x0C55, 0x2AF5, 0x0C0F, 0x2AAF, 0x0C3F, 0x2AFF, 
   0x0C00, 0x2AA0, 0x0C30, 0x2AF0, 0x0C2A, 0x2AAA, 0x0C3C, 0x2AFC, 
   0x0C03, 0x2AA3, 0x0C57, 0x2AF3, 0x0C0F, 0x2AAF, 0x0C3F, 0x2AFF, 
   0x0C00, 0x2AA0, 0x0C30, 0x2AF0, 0x0C0C, 0x2AAA, 0x0C3C, 0x2AFC, 
   0x0C03, 0x2AA3, 0x0C55, 0x2AF5, 0x0C0F, 0x2AAF, 0x0C3F, 0x2AFF, 
   0x0C00, 0x2AA0, 0x0C30, 0x2AF0, 0x0C2A, 0x2AAA, 0x0C3E, 0x2AFE, 
   0x0C03, 0x2AA3, 0x0C57, 0x2AF3, 0x0C0F, 0x2AAF, 0x0C3F, 0x2AFF, 
   0x0C00, 0x2AA0, 0x0C30, 0x2AF0, 0x0C0C, 0x2AAA, 0x0C3C, 0x2AFC, 
   0x0C05, 0x2AA5, 0x0C55, 0x2AF5, 0x0C0F, 0x2AAF, 0x0C3F, 0x2AFF, 
   0x0C00, 0x2AA0, 0x0C30, 0x2AF0, 0x0C2A, 0x2AAA, 0x0C3C, 0x2AFC, 
   0x0C03, 0x2AA3, 0x0C57, 0x2AF3, 0x0C0F, 0x2AAF, 0x0C3F, 0x2AFF, 
   0x0C00, 0x2AA0, 0x0C30, 0x2AF0, 0x0C0C, 0x2AAA, 0x0C3C, 0x2AFC, 
   0x0C03, 0x2AA3, 0x0C55, 0x2AF5, 0x0C0F, 0x2AAF, 0x0C3F, 0x2AFF, 
   0x0C02, 0x2AA2, 0x0C32, 0x2AF2, 0x0C2A, 0x2AAA, 0x0C3E, 0x2AFE, 
   0x0C03, 0x2AA3, 0x0C57, 0x2AF3, 0x0C0F, 0x2AAF, 0x0C3F, 0x2AFF, 
   0x0C00, 0x2AA0, 0x0C30, 0x2AF0, 0x0C0C, 0x2AAA, 0x0C3C, 0x2AFC, 
   0x0C05, 0x2AA5, 0x0C55, 0x2AF5, 0x0C0F, 0x2AAF, 0x0C3F, 0x2AFF, 
   0x0C00, 0x2AA0, 0x0C30, 0x2AF0, 0x0C2A, 0x2AAA, 0x0C3C, 0x2AFC, 
   0x0C03, 0x2AA3, 0x0C57, 0x2AF3, 0x0C0F, 0x2AAF, 0x0C3F, 0x2AFF, 
   0x0C00, 0x2AA0, 0x0C30, 0x2AF0, 0x0C0C, 0x2AAA, 0x0C3C, 0x2AFC, 
   0x0C03, 0x2AA3, 0x0C55, 0x2AF5, 0x0C0F, 0x2AAF, 0x0C3F, 0x2AFF, 
   0x0C00, 0x2AA0, 0x0C30, 0x2AF0, 0x0C2A, 0x2AAA, 0x0C3E, 0x2AFE, 
   0x0C03, 0x2AA3, 0x0C57, 0x2AF3, 0x0C0F, 0x2AAF, 0x0C3F, 0x2AFF, 
   0x0C00, 0x2AA0, 0x0C30, 0x2AF0, 0x0C0C, 0x2AAA, 0x0C3C, 0x2AFC, 
   0x0C05, 0x2AA5, 0x0C55, 0x2AF5, 0x0C0F, 0x2AAF, 0x0C3F, 0x2AFF, 
   0x0C00, 0x2AA0, 0x0C30, 0x2AF0, 0x0C2A, 0x2AAA, 0x0C3C, 0x2AFC, 
   0x0C03, 0x2AA3, 0x0C57, 0x2AF3, 0x0C0F, 0x2AAF, 0x0C3F, 0x2AFF, 
   0x0C00, 0x2AA0, 0x0C30, 0x2AF0, 0x0C0C, 0x2AAA, 0x0C3C, 0x2AFC, 
   0x0C03, 0x2AA3, 0x0C55, 0x2AF5, 0x0C0F, 0x2AAF, 0x0C3F, 0x2AFF, 
   0x0C02, 0x2AA2, 0x0C32, 0x2AF2, 0x0C2A, 0x2AAA, 0x0C3E, 0x2AFE, 
   0x0C03, 0x2AA3, 0x0C57, 0x2AF3, 0x0C0F, 0x2AAF, 0x0C3F, 0x2AFF, 
   0x0C00, 0x2AA0, 0x0C30, 0x2AF0, 0x0C0C, 0x2AAA, 0x0C3C, 0x2AFC, 
   0x0C05, 0x2AA5, 0x0C55, 0x2AF5, 0x0C0F, 0x2AAF, 0x0C3F, 0x2AFF, 
   0x0C00, 0x2AA0, 0x0C30, 0x2AF0, 0x0C2A, 0x2AAA, 0x0C3C, 0x2AFC, 
   0x0C03, 0x2AA3, 0x0C57, 0x2AF3, 0x0C0F, 0x2AAF, 0x0C3F, 0x2AFF, 
   0x0C00, 0x2AA0, 0x0C30, 0x2AF0, 0x0C0C, 0x2AAA, 0x0C3C, 0x2AFC, 
   0x0C03, 0x2AA3, 0x0C55, 0x2AF5, 0x0C0F, 0x2AAF, 0x0C3F, 0x2AFF, 
   0x0C00, 0x2AA0, 0x0C30, 0x2AF0, 0x0C2A, 0x2AAA, 0x0C3E, 0x2AFE, 
   0x0C03, 0x2AA3, 0x0C57, 0x2AF3, 0x0C0F, 0x2AAF, 0x0C3F, 0x2AFF, 
   0x0C00, 0x2AA0, 0x0C30, 0x2AF0, 0x0C0C, 0x2AAA, 0x0C3C, 0x2AFC, 
   0x0C05, 0x2AA5, 0x0C55, 0x2AF5, 0x0C0F, 0x2AAF, 0x0C3F, 0x2AFF, 
   0x0C00, 0x2AA0, 0x0C30, 0x2AF0, 0x0C2A, 0x2AAA, 0x0C3C, 0x2AFC, 
   0x0C03, 0x2AA3, 0x0C57, 0x2AF3, 0x0C0F, 0x2AAF, 0x0C3F, 0x2AFF, 
   0x0C00, 0x2AA0, 0x0C30, 0x2AF0, 0x0C0C, 0x2AAA, 0x0C3C, 0x2AFC, 
   0x0C03, 0x2AA3, 0x0C55, 0x2AF5, 0x0C0F, 0x2AAF, 0x0C3F, 0x2AFF, 
   0x0C02, 0x2AA2, 0x0C32, 0x2AF2, 0x0C2A, 0x2AAA, 0x0C3E, 0x2AFE, 
   0x0C03, 0x2AA3, 0x0C57, 0x2AF3, 0x0C0F, 0x2AAF, 0x0C3F, 0x2AFF, 
   0x0C00, 0x2AA0, 0x0C30, 0x2AF0, 0x0C0C, 0x2AAA, 0x0C3C, 0x2AFC, 
   0x0C05, 0x2AA5, 0x0C55, 0x2AF5, 0x0C0F, 0x2AAF, 0x0C3F, 0x2AFF, 
   0x0C00, 0x2AA0, 0x0C30, 0x2AF0, 0x0C2A, 0x2AAA, 0x0C3C, 0x2AFC, 
   0x0C03, 0x2AA3, 0x0C57, 0x2AF3, 0x0C0F, 0x2AAF, 0x0C3F, 0x2AFF, 
   0x0C00, 0x2AA0, 0x0C30, 0x2AF0, 0x0C0C, 0x2AAA, 0x0C3C, 0x2AFC, 
   0x0C03, 0x2AA3, 0x0C55, 0x2AF5, 0x0C0F, 0x2AAF, 0x0C3F, 0x2AFF, 
   0x0C00, 0x2AA0, 0x0C30, 0x2AF0, 0x0C2A, 0x2AAA, 0x0C3E, 0x2AFE, 
   0x0C03, 0x2AA3, 0x0C57, 0x2AF3, 0x0C0F, 0x2AAF, 0x0C3F, 0x2AFF, 
   0x0C00, 0x2AA0, 0x0C30, 0x2AF0, 0x0C0C, 0x2AAA, 0x0C3C, 0x2AFC, 
   0x0C05, 0x2AA5, 0x0C55, 0x2AF5, 0x0C0F, 0x2AAF, 0x0C3F, 0x2AFF, 
   0x0C00, 0x2AA0, 0x0C30, 0x2AF0, 0x0C2A, 0x2AAA, 0x0C3C, 0x2AFC, 
   0x0C03, 0x2AA3, 0x0C57, 0x2AF3, 0x0C0F, 0x2AAF, 0x0C3F, 0x2AFF, 
   0x0C00, 0x2AA0, 0x0C30, 0x2AF0, 0x0C0C, 0x2AAA, 0x0C3C, 0x2AFC, 
   0x0C03, 0x2AA3, 0x0C55, 0x2AF5, 0x0C0F, 0x2AAF, 0x0C3F, 0x2AFF, 
   0x0C02, 0x2AA2, 0x0C32, 0x2AF2, 0x0C2A, 0x2AAA, 0x0C3E, 0x2AFE, 
   0x0C03, 0x2AA3, 0x0C57, 0x2AF3, 0x0C0F, 0x2AAF, 0x0C3F, 0x2AFF, 
   0x0C00, 0x2AA0, 0x0C30, 0x2AF0, 0x0C0C, 0x2AAA, 0x0C3C, 0x2AFC, 
   0x0C05, 0x2AA5, 0x0C55, 0x2AF5, 0x0C0F, 0x2AAF, 0x0C3F, 0x2AFF, 
   0x0C00, 0x2AA0, 0x0C30, 0x2AF0, 0x0C2A, 0x2AAA, 0x0C3C, 0x2AFC, 
   0x0C03, 0x2AA3, 0x0C57, 0x2AF3, 0x0C0F, 0x2AAF, 0x0C3F, 0x2AFF, 
   0x0C00, 0x2AA0, 0x0C30, 0x2AF0, 0x0C0C, 0x2AAA, 0x0C3C, 0x2AFC, 
   0x0C03, 0x2AA3, 0x0C55, 0x2AF5, 0x0C0F, 0x2AAF, 0x0C3F, 0x2AFF, 
   0x0C00, 0x2AA0, 0x0C30, 0x2AF0, 0x0C2A, 0x2AAA, 0x0C3E, 0x2AFE, 
   0x0C03, 0x2AA3, 0x0C57, 0x2AF3, 0x0C0F, 0x2AAF, 0x0C3F, 0x2AFF, 
   0x0C00, 0x2AA0, 0x0C30, 0x2AF0, 0x0C0C, 0x2AAA, 0x0C3C, 0x2AFC, 
   0x0C05, 0x2AA5, 0x0C55, 0x2AF5, 0x0C0F, 0x2AAF, 0x0C3F, 0x2AFF, 
   0x0C00, 0x2AA0, 0x0C30, 0x2AF0, 0x0C2A, 0x2AAA, 0x0C3C, 0x2AFC, 
   0x0C03, 0x2AA3, 0x0C57, 0x2AF3, 0x0C0F, 0x2AAF, 0x0C3F, 0x2AFF, 
   0x0C00, 0x2AA0, 0x0C30, 0x2AF0, 0x0C0C, 0x2AAA, 0x0C3C, 0x2AFC, 
   0x0C03, 0x2AA3, 0x0C55, 0x2AF5, 0x0C0F, 0x2AAF, 0x0C3F, 0x2AFF, 
   0x0C02, 0x2AA2, 0x0C32, 0x2AF2, 0x0C2A, 0x2AAA, 0x0C3E, 0x2AFE, 
   0x0C03, 0x2AA3, 0x0C57, 0x2AF3, 0x0C0F, 0x2AAF, 0x0C3F, 0x2AFF, 
   0x0C00, 0x2AA0, 0x0C30, 0x2AF0, 0x0C0C, 0x2AAA, 0x0C3C, 0x2AFC, 
   0x0C05, 0x2AA5, 0x0C55, 0x2AF5, 0x0C0F, 0x2AAF, 0x0C3F, 0x2AFF, 
   0x0C00, 0x2AA0, 0x0C30, 0x2AF0, 0x0C2A, 0x2AAA, 0x0C3C, 0x2AFC, 
   0x0C03, 0x2AA3, 0x0C57, 0x2AF3, 0x0C0F, 0x2AAF, 0x0C3F, 0x2AFF, 
   0x0C00, 0x2AA0, 0x0C30, 0x2AF0, 0x0C0C, 0x2AAA, 0x0C3C, 0x2AFC, 
   0x0C03, 0x2AA3, 0x0C55, 0x2AF5, 0x0C0F, 0x2AAF, 0x0C3F, 0x2AFF, 
   0x0C00, 0x2AA0, 0x0C30, 0x2AF0, 0x0C2A, 0x2AAA, 0x0C3E, 0x2AFE, 
   0x0C03, 0x2AA3, 0x0C57, 0x2AF3, 0x0C0F, 0x2AAF, 0x0C3F, 0x2AFF, 
   0x0C00, 0x2AA0, 0x0C30, 0x2AF0, 0x0C0C, 0x2AAA, 0x0C3C, 0x2AFC, 
   0x0C05, 0x2AA5, 0x0C55, 0x2AF5, 0x0C0F, 0x2AAF, 0x0C3F, 0x2AFF, 
   0x0C00, 0x2AA0, 0x0C30, 0x2AF0, 0x0C2A, 0x2AAA, 0x0C3C, 0x2AFC, 
   0x0C03, 0x2AA3, 0x0C57, 0x2AF3, 0x0C0F, 0x2AAF, 0x0C3F, 0x2AFF, 
   0x0C00, 0x2AA0, 0x0C30, 0x2AF0, 0x0C0C, 0x2AAA, 0x0C3C, 0x2AFC, 
   0x0C03, 0x2AA3, 0x0C55, 0x2AF5, 0x0C0F, 0x2AAF, 0x0C3F, 0x2AFF, 
   0x0C02, 0x2AA2, 0x0C32, 0x2AF2, 0x0C2A, 0x2AAA, 0x0C3E, 0x2AFE, 
   0x0C03, 0x2AA3, 0x0C57, 0x2AF3, 0x0C0F, 0x2AAF, 0x0C3F, 0x2AFF, 
   0x0C00, 0x2AA0, 0x0C30, 0x2AF0, 0x0C0C, 0x2AAA, 0x0C3C, 0x2AFC, 
   0x0C05, 0x2AA5, 0x0C55, 0x2AF5, 0x0C0F, 0x2AAF, 0x0C3F, 0x2AFF, 
   0x0C00, 0x2AA0, 0x0C30, 0x2AF0, 0x0C2A, 0x2AAA, 0x0C3C, 0x2AFC, 
   0x0C03, 0x2AA3, 0x0C57, 0x2AF3, 0x0C0F, 0x2AAF, 0x0C3F, 0x2AFF, 
   0x0C00, 0x2AA0, 0x0C30, 0x2AF0, 0x0C0C, 0x2AAA, 0x0C3C, 0x2AFC, 
   0x0C03, 0x2AA3, 0x0C55, 0x2AF5, 0x0C0F, 0x2AAF, 0x0C3F, 0x2AFF, 
   0x0C00, 0x2AA0, 0x0C30, 0x2AF0, 0x0C2A, 0x2AAA, 0x0C3E, 0x2AFE, 
   0x0C03, 0x2AA3, 0x0C57, 0x2AF3, 0x0C0F, 0x2AAF, 0x0C3F, 0x2AFF, 
   0x0C00, 0x2AA0, 0x0C30, 0x2AF0, 0x0C0C, 0x2AAA, 0x0C3C, 0x2AFC, 
   0x0C05, 0x2AA5, 0x0C55, 0x2AF5, 0x0C0F, 0x2AAF, 0x0C3F, 0x2AFF, 
   0x0C00, 0x2AA0, 0x0C30, 0x2AF0, 0x0C2A, 0x2AAA, 0x0C3C, 0x2AFC, 
   0x0C03, 0x2AA3, 0x0C57, 0x2AF3, 0x0C0F, 0x2AAF, 0x0C3F, 0x2AFF, 
   0x0C00, 0x2AA0, 0x0C30, 0x2AF0, 0x0C0C, 0x2AAA, 0x0C3C, 0x2AFC, 
   0x0C03, 0x2AA3, 0x0C55, 0x2AF5, 0x0C0F, 0x2AAF, 0x0C3F, 0x2AFF, 
   0x0C02, 0x2AA2, 0x0C32, 0x2AF2, 0x0C2A, 0x2AAA, 0x0C3E, 0x2AFE, 
   0x0C03, 0x2AA3, 0x0C57, 0x2AF3, 0x0C0F, 0x2AAF, 0x0C3F, 0x2AFF, 
   0x0C00, 0x2AA0, 0x0C30, 0x2AF0, 0x0C0C, 0x2AAA, 0x0C3C, 0x2AFC, 
   0x0C05, 0x2AA5, 0x0C55, 0x2AF5, 0x0C0F, 0x2AAF, 0x0C3F, 0x2AFF, 
   0x0C00, 0x2AA0, 0x0C30, 0x2AF0, 0x0C2A, 0x2AAA, 0x0C3C, 0x2AFC, 
   0x0C03, 0x2AA3, 0x0C57, 0x2AF3, 0x0C0F, 0x2AAF, 0x0C3F, 0x2AFF, 
   0x2A00, 0x2AA0, 0x2A30, 0x2AF0, 0x2A0C, 0x2AAA, 0x2A3C, 0x2AFC, 
   0x2A03, 0x2AA3, 0x2A55, 0x2AF5, 0x2A0F, 0x2AAF, 0x2A3F, 0x2AFF, 
   0x2A00, 0x2AA0, 0x2A30, 0x2AF0, 0x2A2A, 0x2AAA, 0x2A3E, 0x2AFE, 
   0x2A03, 0x2AA3, 0x2A57, 0x2AF3, 0x2A0F, 0x2AAF, 0x2A3F, 0x2AFF, 
   0x2A00, 0x2AA0, 0x2A30, 0x2AF0, 0x2A0C, 0x2AAA, 0x2A3C, 0x2AFC, 
   0x2A05, 0x2AA5, 0x2A55, 0x2AF5, 0x2A0F, 0x2AAF, 0x2A3F, 0x2AFF, 
   0x2A00, 0x2AA0, 0x2A30, 0x2AF0, 0x2A2A, 0x2AAA, 0x2A3C, 0x2AFC, 
   0x2A03, 0x2AA3, 0x2A57, 0x2AF3, 0x2A0F, 0x2AAF, 0x2A3F, 0x2AFF, 
   0x2A00, 0x2AA0, 0x2A30, 0x2AF0, 0x2A0C, 0x2AAA, 0x2A3C, 0x2AFC, 
   0x2A03, 0x2AA3, 0x2A55, 0x2AF5, 0x2A0F, 0x2AAF, 0x2A3F, 0x2AFF, 
   0x2A02, 0x2AA2, 0x2A32, 0x2AF2, 0x2A2A, 0x2AAA, 0x2A3E, 0x2AFE, 
   0x2A03, 0x2AA3, 0x2A57, 0x2AF3, 0x2A0F, 0x2AAF, 0x2A3F, 0x2AFF, 
   0x2A00, 0x2AA0, 0x2A30, 0x2AF0, 0x2A0C, 0x2AAA, 0x2A3C, 0x2AFC, 
   0x2A05, 0x2AA5, 0x2A55, 0x2AF5, 0x2A0F, 0x2AAF, 0x2A3F, 0x2AFF, 
   0x2A00, 0x2AA0, 0x2A30, 0x2AF0, 0x2A2A, 0x2AAA, 0x2A3C, 0x2AFC, 
   0x2A03, 0x2AA3, 0x2A57, 0x2AF3, 0x2A0F, 0x2AAF, 0x2A3F, 0x2AFF, 
   0x2A00, 0x2AA0, 0x2A30, 0x2AF0, 0x2A0C, 0x2AAA, 0x2A3C, 0x2AFC, 
   0x2A03, 0x2AA3, 0x2A55, 0x2AF5, 0x2A0F, 0x2AAF, 0x2A3F, 0x2AFF, 
   0x2A00, 0x2AA0, 0x2A30, 0x2AF0, 0x2A2A, 0x2AAA, 0x2A3E, 0x2AFE, 
   0x2A03, 0x2AA3, 0x2A57, 0x2AF3, 0x2A0F, 0x2AAF, 0x2A3F, 0x2AFF, 
   0x2A00, 0x2AA0, 0x2A30, 0x2AF0, 0x2A0C, 0x2AAA, 0x2A3C, 0x2AFC, 
   0x2A05, 0x2AA5, 0x2A55, 0x2AF5, 0x2A0F, 0x2AAF, 0x2A3F, 0x2AFF, 
   0x2A00, 0x2AA0, 0x2A30, 0x2AF0, 0x2A2A, 0x2AAA, 0x2A3C, 0x2AFC, 
   0x2A03, 0x2AA3, 0x2A57, 0x2AF3, 0x2A0F, 0x2AAF, 0x2A3F, 0x2AFF, 
   0x2A00, 0x2AA0, 0x2A30, 0x2AF0, 0x2A0C, 0x2AAA, 0x2A3C, 0x2AFC, 
   0x2A03, 0x2AA3, 0x2A55, 0x2AF5, 0x2A0F, 0x2AAF, 0x2A3F, 0x2AFF, 
   0x2A02, 0x2AA2, 0x2A32, 0x2AF2, 0x2A2A, 0x2AAA, 0x2A3E, 0x2AFE, 
   0x2A03, 0x2AA3, 0x2A57, 0x2AF3, 0x2A0F, 0x2AAF, 0x2A3F, 0x2AFF, 
   0x2A00, 0x2AA0, 0x2A30, 0x2AF0, 0x2A0C, 0x2AAA, 0x2A3C, 0x2AFC, 
   0x2A05, 0x2AA5, 0x2A55, 0x2AF5, 0x2A0F, 0x2AAF, 0x2A3F, 0x2AFF, 
   0x2A00, 0x2AA0, 0x2A30, 0x2AF0, 0x2A2A, 0x2AAA, 0x2A3C, 0x2AFC, 
   0x2A03, 0x2AA3, 0x2A57, 0x2AF3, 0x2A0F, 0x2AAF, 0x2A3F, 0x2AFF, 
   0x2A00, 0x2AA0, 0x2A30, 0x2AF0, 0x2A0C, 0x2AAA, 0x2A3C, 0x2AFC, 
   0x2A03, 0x2AA3, 0x2A55, 0x2AF5, 0x2A0F, 0x2AAF, 0x2A3F, 0x2AFF, 
   0x2A00, 0x2AA0, 0x2A30, 0x2AF0, 0x2A2A, 0x2AAA, 0x2A3E, 0x2AFE, 
   0x2A03, 0x2AA3, 0x2A57, 0x2AF3, 0x2A0F, 0x2AAF, 0x2A3F, 0x2AFF, 
   0x2A00, 0x2AA0, 0x2A30, 0x2AF0, 0x2A0C, 0x2AAA, 0x2A3C, 0x2AFC, 
   0x2A05, 0x2AA5, 0x2A55, 0x2AF5, 0x2A0F, 0x2AAF, 0x2A3F, 0x2AFF, 
   0x2A00, 0x2AA0, 0x2A30, 0x2AF0, 0x2A2A, 0x2AAA, 0x2A3C, 0x2AFC, 
   0x2A03, 0x2AA3, 0x2A57, 0x2AF3, 0x2A0F, 0x2AAF, 0x2A3F, 0x2AFF, 
   0x2A00, 0x2AA0, 0x2A30, 0x2AF0, 0x2A0C, 0x2AAA, 0x2A3C, 0x2AFC, 
   0x2A03, 0x2AA3, 0x2A55, 0x2AF5, 0x2A0F, 0x2AAF, 0x2A3F, 0x2AFF, 
   0x2A02, 0x2AA2, 0x2A32, 0x2AF2, 0x2A2A, 0x2AAA, 0x2A3E, 0x2AFE, 
   0x2A03, 0x2AA3, 0x2A57, 0x2AF3, 0x2A0F, 0x2AAF, 0x2A3F, 0x2AFF, 
   0x2A00, 0x2AA0, 0x2A30, 0x2AF0, 0x2A0C, 0x2AAA, 0x2A3C, 0x2AFC, 
   0x2A05, 0x2AA5, 0x2A55, 0x2AF5, 0x2A0F, 0x2AAF, 0x2A3F, 0x2AFF, 
   0x2A00, 0x2AA0, 0x2A30, 0x2AF0, 0x2A2A, 0x2AAA, 0x2A3C, 0x2AFC, 
   0x2A03, 0x2AA3, 0x2A57, 0x2AF3, 0x2A0F, 0x2AAF, 0x2A3F, 0x2AFF, 
   0x2A00, 0x2AA0, 0x2A30, 0x2AF0, 0x2A0C, 0x2AAA, 0x2A3C, 0x2AFC, 
   0x2A03, 0x2AA3, 0x2A55, 0x2AF5, 0x2A0F, 0x2AAF, 0x2A3F, 0x2AFF, 
   0x2A00, 0x2AA0, 0x2A30, 0x2AF0, 0x2A2A, 0x2AAA, 0x2A3E, 0x2AFE, 
   0x2A03, 0x2AA3, 0x2A57, 0x2AF3, 0x2A0F, 0x2AAF, 0x2A3F, 0x2AFF, 
   0x2A00, 0x2AA0, 0x2A30, 0x2AF0, 0x2A0C, 0x2AAA, 0x2A3C, 0x2AFC, 
   0x2A05, 0x2AA5, 0x2A55, 0x2AF5, 0x2A0F, 0x2AAF, 0x2A3F, 0x2AFF, 
   0x2A00, 0x2AA0, 0x2A30, 0x2AF0, 0x2A2A, 0x2AAA, 0x2A3C, 0x2AFC, 
   0x2A03, 0x2AA3, 0x2A57, 0x2AF3, 0x2A0F, 0x2AAF, 0x2A3F, 0x2AFF, 
   0x2A00, 0x2AA0, 0x2A30, 0x2AF0, 0x2A0C, 0x2AAA, 0x2A3C, 0x2AFC, 
   0x2A03, 0x2AA3, 0x2A55, 0x2AF5, 0x2A0F, 0x2AAF, 0x2A3F, 0x2AFF, 
   0x2A02, 0x2AA2, 0x2A32, 0x2AF2, 0x2A2A, 0x2AAA, 0x2A3E, 0x2AFE, 
   0x2A03, 0x2AA3, 0x2A57, 0x2AF3, 0x2A0F, 0x2AAF, 0x2A3F, 0x2AFF, 
   0x2A00, 0x2AA0, 0x2A30, 0x2AF0, 0x2A0C, 0x2AAA, 0x2A3C, 0x2AFC, 
   0x2A05, 0x2AA5, 0x2A55, 0x2AF5, 0x2A0F, 0x2AAF, 0x2A3F, 0x2AFF, 
   0x2A00, 0x2AA0, 0x2A30, 0x2AF0, 0x2A2A, 0x2AAA, 0x2A3C, 0x2AFC, 
   0x2A03, 0x2AA3, 0x2A57, 0x2AF3, 0x2A0F, 0x2AAF, 0x2A3F, 0x2AFF, 
   0x2A00, 0x2AA0, 0x2A30, 0x2AF0, 0x2A0C, 0x2AAA, 0x2A3C, 0x2AFC, 
   0x2A03, 0x2AA3, 0x2A55, 0x2AF5, 0x2A0F, 0x2AAF, 0x2A3F, 0x2AFF, 
   0x2A00, 0x2AA0, 0x2A30, 0x2AF0, 0x2A2A, 0x2AAA, 0x2A3E, 0x2AFE, 
   0x2A03, 0x2AA3, 0x2A57, 0x2AF3, 0x2A0F, 0x2AAF, 0x2A3F, 0x2AFF, 
   0x2A00, 0x2AA0, 0x2A30, 0x2AF0, 0x2A0C, 0x2AAA, 0x2A3C, 0x2AFC, 
   0x2A05, 0x2AA5, 0x2A55, 0x2AF5, 0x2A0F, 0x2AAF, 0x2A3F, 0x2AFF, 
   0x2A00, 0x2AA0, 0x2A30, 0x2AF0, 0x2A2A, 0x2AAA, 0x2A3C, 0x2AFC, 
   0x2A03, 0x2AA3, 0x2A57, 0x2AF3, 0x2A0F, 0x2AAF, 0x2A3F, 0x2AFF, 
   0x2A00, 0x2AA0, 0x2A30, 0x2AF0, 0x2A0C, 0x2AAA, 0x2A3C, 0x2AFC, 
   0x2A03, 0x2AA3, 0x2A55, 0x2AF5, 0x2A0F, 0x2AAF, 0x2A3F, 0x2AFF, 
   0x2A02, 0x2AA2, 0x2A32, 0x2AF2, 0x2A2A, 0x2AAA, 0x2A3E, 0x2AFE, 
   0x2A03, 0x2AA3, 0x2A57, 0x2AF3, 0x2A0F, 0x2AAF, 0x2A3F, 0x2AFF, 
   0x2A00, 0x2AA0, 0x2A30, 0x2AF0, 0x2A0C, 0x2AAA, 0x2A3C, 0x2AFC, 
   0x2A05, 0x2AA5, 0x2A55, 0x2AF5, 0x2A0F, 0x2AAF, 0x2A3F, 0x2AFF, 
   0x2A00, 0x2AA0, 0x2A30, 0x2AF0, 0x2A2A, 0x2AAA, 0x2A3C, 0x2AFC, 
   0x2A03, 0x2AA3, 0x2A57, 0x2AF3, 0x2A0F, 0x2AAF, 0x2A3F, 0x2AFF, 
   0x2A00, 0x2AA0, 0x2A30, 0x2AF0, 0x2A0C, 0x2AAA, 0x2A3C, 0x2AFC, 
   0x2A03, 0x2AA3, 0x2A55, 0x2AF5, 0x2A0F, 0x2AAF, 0x2A3F, 0x2AFF, 
   0x2A00, 0x2AA0, 0x2A30, 0x2AF0, 0x2A2A, 0x2AAA, 0x2A3E, 0x2AFE, 
   0x2A03, 0x2AA3, 0x2A57, 0x2AF3, 0x2A0F, 0x2AAF, 0x2A3F, 0x2AFF, 
   0x2A00, 0x2AA0, 0x2A30, 0x2AF0, 0x2A0C, 0x2AAA, 0x2A3C, 0x2AFC, 
   0x2A05, 0x2AA5, 0x2A55, 0x2AF5, 0x2A0F, 0x2AAF, 0x2A3F, 0x2AFF, 
   0x2A00, 0x2AA0, 0x2A30, 0x2AF0, 0x2A2A, 0x2AAA, 0x2A3C, 0x2AFC, 
   0x2A03, 0x2AA3, 0x2A57, 0x2AF3, 0x2A0F, 0x2AAF, 0x2A3F, 0x2AFF, 
   0x2A00, 0x2AA0, 0x2A30, 0x2AF0, 0x2A0C, 0x2AAA, 0x2A3C, 0x2AFC, 
   0x2A03, 0x2AA3, 0x2A55, 0x2AF5, 0x2A0F, 0x2AAF, 0x2A3F, 0x2AFF, 
   0x2A02, 0x2AA2, 0x2A32, 0x2AF2, 0x2A2A, 0x2AAA, 0x2A3E, 0x2AFE, 
   0x2A03, 0x2AA3, 0x2A57, 0x2AF3, 0x2A0F, 0x2AAF, 0x2A3F, 0x2AFF, 
   0x2A00, 0x2AA0, 0x2A30, 0x2AF0, 0x2A0C, 0x2AAA, 0x2A3C, 0x2AFC, 
   0x2A05, 0x2AA5, 0x2A55, 0x2AF5, 0x2A0F, 0x2AAF, 0x2A3F, 0x2AFF, 
   0x2A00, 0x2AA0, 0x2A30, 0x2AF0, 0x2A2A, 0x2AAA, 0x2A3C, 0x2AFC, 
   0x2A03, 0x2AA3, 0x2A57, 0x2AF3, 0x2A0F, 0x2AAF, 0x2A3F, 0x2AFF, 
   0x2A00, 0x2AA0, 0x2A30, 0x2AF0, 0x2A0C, 0x2AAA, 0x2A3C, 0x2AFC, 
   0x2A03, 0x2AA3, 0x2A55, 0x2AF5, 0x2A0F, 0x2AAF, 0x2A3F, 0x2AFF, 
   0x2A00, 0x2AA0, 0x2A30, 0x2AF0, 0x2A2A, 0x2AAA, 0x2A3E, 0x2AFE, 
   0x2A03, 0x2AA3, 0x2A57, 0x2AF3, 0x2A0F, 0x2AAF, 0x2A3F, 0x2AFF, 
   0x2A00, 0x2AA0, 0x2A30, 0x2AF0, 0x2A0C, 0x2AAA, 0x2A3C, 0x2AFC, 
   0x2A05, 0x2AA5, 0x2A55, 0x2AF5, 0x2A0F, 0x2AAF, 0x2A3F, 0x2AFF, 
   0x2A00, 0x2AA0, 0x2A30, 0x2AF0, 0x2A2A, 0x2AAA, 0x2A3C, 0x2AFC, 
   0x2A03, 0x2AA3, 0x2A57, 0x2AF3, 0x2A0F, 0x2AAF, 0x2A3F, 0x2AFF, 
   0x2A00, 0x2AA0, 0x2A30, 0x2AF0, 0x2A0C, 0x2AAA, 0x2A3C, 0x2AFC, 
   0x2A03, 0x2AA3, 0x2A55, 0x2AF5, 0x2A0F, 0x2AAF, 0x2A3F, 0x2AFF, 
   0x2A02, 0x2AA2, 0x2A32, 0x2AF2, 0x2A2A, 0x2AAA, 0x2A3E, 0x2AFE, 
   0x2A03, 0x2AA3, 0x2A57, 0x2AF3, 0x2A0F, 0x2AAF, 0x2A3F, 0x2AFF, 
   0x2A00, 0x2AA0, 0x2A30, 0x2AF0, 0x2A0C, 0x2AAA, 0x2A3C, 0x2AFC, 
   0x2A05, 0x2AA5, 0x2A55, 0x2AF5, 0x2A0F, 0x2AAF, 0x2A3F, 0x2AFF, 
   0x2A00, 0x2AA0, 0x2A30, 0x2AF0, 0x2A2A, 0x2AAA, 0x2A3C, 0x2AFC, 
   0x2A03, 0x2AA3, 0x2A57, 0x2AF3, 0x2A0F, 0x2AAF, 0x2A3F, 0x2AFF, 
   0x2A00, 0x2AA0, 0x2A30, 0x2AF0, 0x2A0C, 0x2AAA, 0x2A3C, 0x2AFC, 
   0x2A03, 0x2AA3, 0x2A55, 0x2AF5, 0x2A0F, 0x2AAF, 0x2A3F, 0x2AFF, 
   0x2A00, 0x2AA0, 0x2A30, 0x2AF0, 0x2A2A, 0x2AAA, 0x2A3E, 0x2AFE, 
   0x2A03, 0x2AA3, 0x2A57, 0x2AF3, 0x2A0F, 0x2AAF, 0x2A3F, 0x2AFF, 
   0x2A00, 0x2AA0, 0x2A30, 0x2AF0, 0x2A0C, 0x2AAA, 0x2A3C, 0x2AFC, 
   0x2A05, 0x2AA5, 0x2A55, 0x2AF5, 0x2A0F, 0x2AAF, 0x2A3F, 0x2AFF, 
   0x2A00, 0x2AA0, 0x2A30, 0x2AF0, 0x2A2A, 0x2AAA, 0x2A3C, 0x2AFC, 
   0x2A03, 0x2AA3, 0x2A57, 0x2AF3, 0x2A0F, 0x2AAF, 0x2A3F, 0x2AFF, 
   0x2A00, 0x2AA0, 0x2A30, 0x2AF0, 0x2A0C, 0x2AAA, 0x2A3C, 0x2AFC, 
   0x2A03, 0x2AA3, 0x2A55, 0x2AF5, 0x2A0F, 0x2AAF, 0x2A3F, 0x2AFF, 
   0x2A02, 0x2AA2, 0x2A32, 0x2AF2, 0x2A2A, 0x2AAA, 0x2A3E, 0x2AFE, 
   0x2A03, 0x2AA3, 0x2A57, 0x2AF3, 0x2A0F, 0x2AAF, 0x2A3F, 0x2AFF, 
   0x2A00, 0x2AA0, 0x2A30, 0x2AF0, 0x2A0C, 0x2AAA, 0x2A3C, 0x2AFC, 
   0x2A05, 0x2AA5, 0x2A55, 0x2AF5, 0x2A0F, 0x2AAF, 0x2A3F, 0x2AFF, 
   0x2A00, 0x2AA0, 0x2A30, 0x2AF0, 0x2A2A, 0x2AAA, 0x2A3C, 0x2AFC, 
   0x2A03, 0x2AA3, 0x2A57, 0x2AF3, 0x2A0F, 0x2AAF, 0x2A3F, 0x2AFF, 
   0x3C00, 0x3EA0, 0x3C30, 0x3CF0, 0x3C0C, 0x3EAA, 0x3C3C, 0x3CFC, 
   0x3C03, 0x3EA3, 0x3C55, 0x3CF5, 0x3C0F, 0x3EAF, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3EA0, 0x3C30, 0x3CF0, 0x3C2A, 0x3EAA, 0x3C3E, 0x3CFE, 
   0x3C03, 0x3EA3, 0x3C57, 0x3CF3, 0x3C0F, 0x3EAF, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3EA0, 0x3C30, 0x3CF0, 0x3C0C, 0x3EAA, 0x3C3C, 0x3CFC, 
   0x3C05, 0x3EA5, 0x3C55, 0x3CF5, 0x3C0F, 0x3EAF, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3EA0, 0x3C30, 0x3CF0, 0x3C2A, 0x3EAA, 0x3C3C, 0x3CFC, 
   0x3C03, 0x3EA3, 0x3C57, 0x3CF3, 0x3C0F, 0x3EAF, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3EA0, 0x3C30, 0x3CF0, 0x3C0C, 0x3EAA, 0x3C3C, 0x3CFC, 
   0x3C03, 0x3EA3, 0x3C55, 0x3CF5, 0x3C0F, 0x3EAF, 0x3C3F, 0x3CFF, 
   0x3C02, 0x3EA2, 0x3C32, 0x3CF2, 0x3C2A, 0x3EAA, 0x3C3E, 0x3CFE, 
   0x3C03, 0x3EA3, 0x3C57, 0x3CF3, 0x3C0F, 0x3EAF, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3EA0, 0x3C30, 0x3CF0, 0x3C0C, 0x3EAA, 0x3C3C, 0x3CFC, 
   0x3C05, 0x3EA5, 0x3C55, 0x3CF5, 0x3C0F, 0x3EAF, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3EA0, 0x3C30, 0x3CF0, 0x3C2A, 0x3EAA, 0x3C3C, 0x3CFC, 
   0x3C03, 0x3EA3, 0x3C57, 0x3CF3, 0x3C0F, 0x3EAF, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3EA0, 0x3C30, 0x3CF0, 0x3C0C, 0x3EAA, 0x3C3C, 0x3CFC, 
   0x3C03, 0x3EA3, 0x3C55, 0x3CF5, 0x3C0F, 0x3EAF, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3EA0, 0x3C30, 0x3CF0, 0x3C2A, 0x3EAA, 0x3C3E, 0x3CFE, 
   0x3C03, 0x3EA3, 0x3C57, 0x3CF3, 0x3C0F, 0x3EAF, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3EA0, 0x3C30, 0x3CF0, 0x3C0C, 0x3EAA, 0x3C3C, 0x3CFC, 
   0x3C05, 0x3EA5, 0x3C55, 0x3CF5, 0x3C0F, 0x3EAF, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3EA0, 0x3C30, 0x3CF0, 0x3C2A, 0x3EAA, 0x3C3C, 0x3CFC, 
   0x3C03, 0x3EA3, 0x3C57, 0x3CF3, 0x3C0F, 0x3EAF, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3EA0, 0x3C30, 0x3CF0, 0x3C0C, 0x3EAA, 0x3C3C, 0x3CFC, 
   0x3C03, 0x3EA3, 0x3C55, 0x3CF5, 0x3C0F, 0x3EAF, 0x3C3F, 0x3CFF, 
   0x3C02, 0x3EA2, 0x3C32, 0x3CF2, 0x3C2A, 0x3EAA, 0x3C3E, 0x3CFE, 
   0x3C03, 0x3EA3, 0x3C57, 0x3CF3, 0x3C0F, 0x3EAF, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3EA0, 0x3C30, 0x3CF0, 0x3C0C, 0x3EAA, 0x3C3C, 0x3CFC, 
   0x3C05, 0x3EA5, 0x3C55, 0x3CF5, 0x3C0F, 0x3EAF, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3EA0, 0x3C30, 0x3CF0, 0x3C2A, 0x3EAA, 0x3C3C, 0x3CFC, 
   0x3C03, 0x3EA3, 0x3C57, 0x3CF3, 0x3C0F, 0x3EAF, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3EA0, 0x3C30, 0x3CF0, 0x3C0C, 0x3EAA, 0x3C3C, 0x3CFC, 
   0x3C03, 0x3EA3, 0x3C55, 0x3CF5, 0x3C0F, 0x3EAF, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3EA0, 0x3C30, 0x3CF0, 0x3C2A, 0x3EAA, 0x3C3E, 0x3CFE, 
   0x3C03, 0x3EA3, 0x3C57, 0x3CF3, 0x3C0F, 0x3EAF, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3EA0, 0x3C30, 0x3CF0, 0x3C0C, 0x3EAA, 0x3C3C, 0x3CFC, 
   0x3C05, 0x3EA5, 0x3C55, 0x3CF5, 0x3C0F, 0x3EAF, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3EA0, 0x3C30, 0x3CF0, 0x3C2A, 0x3EAA, 0x3C3C, 0x3CFC, 
   0x3C03, 0x3EA3, 0x3C57, 0x3CF3, 0x3C0F, 0x3EAF, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3EA0, 0x3C30, 0x3CF0, 0x3C0C, 0x3EAA, 0x3C3C, 0x3CFC, 
   0x3C03, 0x3EA3, 0x3C55, 0x3CF5, 0x3C0F, 0x3EAF, 0x3C3F, 0x3CFF, 
   0x3C02, 0x3EA2, 0x3C32, 0x3CF2, 0x3C2A, 0x3EAA, 0x3C3E, 0x3CFE, 
   0x3C03, 0x3EA3, 0x3C57, 0x3CF3, 0x3C0F, 0x3EAF, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3EA0, 0x3C30, 0x3CF0, 0x3C0C, 0x3EAA, 0x3C3C, 0x3CFC, 
   0x3C05, 0x3EA5, 0x3C55, 0x3CF5, 0x3C0F, 0x3EAF, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3EA0, 0x3C30, 0x3CF0, 0x3C2A, 0x3EAA, 0x3C3C, 0x3CFC, 
   0x3C03, 0x3EA3, 0x3C57, 0x3CF3, 0x3C0F, 0x3EAF, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3EA0, 0x3C30, 0x3CF0, 0x3C0C, 0x3EAA, 0x3C3C, 0x3CFC, 
   0x3C03, 0x3EA3, 0x3C55, 0x3CF5, 0x3C0F, 0x3EAF, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3EA0, 0x3C30, 0x3CF0, 0x3C2A, 0x3EAA, 0x3C3E, 0x3CFE, 
   0x3C03, 0x3EA3, 0x3C57, 0x3CF3, 0x3C0F, 0x3EAF, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3EA0, 0x3C30, 0x3CF0, 0x3C0C, 0x3EAA, 0x3C3C, 0x3CFC, 
   0x3C05, 0x3EA5, 0x3C55, 0x3CF5, 0x3C0F, 0x3EAF, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3EA0, 0x3C30, 0x3CF0, 0x3C2A, 0x3EAA, 0x3C3C, 0x3CFC, 
   0x3C03, 0x3EA3, 0x3C57, 0x3CF3, 0x3C0F, 0x3EAF, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3EA0, 0x3C30, 0x3CF0, 0x3C0C, 0x3EAA, 0x3C3C, 0x3CFC, 
   0x3C03, 0x3EA3, 0x3C55, 0x3CF5, 0x3C0F, 0x3EAF, 0x3C3F, 0x3CFF, 
   0x3C02, 0x3EA2, 0x3C32, 0x3CF2, 0x3C2A, 0x3EAA, 0x3C3E, 0x3CFE, 
   0x3C03, 0x3EA3, 0x3C57, 0x3CF3, 0x3C0F, 0x3EAF, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3EA0, 0x3C30, 0x3CF0, 0x3C0C, 0x3EAA, 0x3C3C, 0x3CFC, 
   0x3C05, 0x3EA5, 0x3C55, 0x3CF5, 0x3C0F, 0x3EAF, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3EA0, 0x3C30, 0x3CF0, 0x3C2A, 0x3EAA, 0x3C3C, 0x3CFC, 
   0x3C03, 0x3EA3, 0x3C57, 0x3CF3, 0x3C0F, 0x3EAF, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3EA0, 0x3C30, 0x3CF0, 0x3C0C, 0x3EAA, 0x3C3C, 0x3CFC, 
   0x3C03, 0x3EA3, 0x3C55, 0x3CF5, 0x3C0F, 0x3EAF, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3EA0, 0x3C30, 0x3CF0, 0x3C2A, 0x3EAA, 0x3C3E, 0x3CFE, 
   0x3C03, 0x3EA3, 0x3C57, 0x3CF3, 0x3C0F, 0x3EAF, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3EA0, 0x3C30, 0x3CF0, 0x3C0C, 0x3EAA, 0x3C3C, 0x3CFC, 
   0x3C05, 0x3EA5, 0x3C55, 0x3CF5, 0x3C0F, 0x3EAF, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3EA0, 0x3C30, 0x3CF0, 0x3C2A, 0x3EAA, 0x3C3C, 0x3CFC, 
   0x3C03, 0x3EA3, 0x3C57, 0x3CF3, 0x3C0F, 0x3EAF, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3EA0, 0x3C30, 0x3CF0, 0x3C0C, 0x3EAA, 0x3C3C, 0x3CFC, 
   0x3C03, 0x3EA3, 0x3C55, 0x3CF5, 0x3C0F, 0x3EAF, 0x3C3F, 0x3CFF, 
   0x3C02, 0x3EA2, 0x3C32, 0x3CF2, 0x3C2A, 0x3EAA, 0x3C3E, 0x3CFE, 
   0x3C03, 0x3EA3, 0x3C57, 0x3CF3, 0x3C0F, 0x3EAF, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3EA0, 0x3C30, 0x3CF0, 0x3C0C, 0x3EAA, 0x3C3C, 0x3CFC, 
   0x3C05, 0x3EA5, 0x3C55, 0x3CF5, 0x3C0F, 0x3EAF, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3EA0, 0x3C30, 0x3CF0, 0x3C2A, 0x3EAA, 0x3C3C, 0x3CFC, 
   0x3C03, 0x3EA3, 0x3C57, 0x3CF3, 0x3C0F, 0x3EAF, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3EA0, 0x3C30, 0x3CF0, 0x3C0C, 0x3EAA, 0x3C3C, 0x3CFC, 
   0x3C03, 0x3EA3, 0x3C55, 0x3CF5, 0x3C0F, 0x3EAF, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3EA0, 0x3C30, 0x3CF0, 0x3C2A, 0x3EAA, 0x3C3E, 0x3CFE, 
   0x3C03, 0x3EA3, 0x3C57, 0x3CF3, 0x3C0F, 0x3EAF, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3EA0, 0x3C30, 0x3CF0, 0x3C0C, 0x3EAA, 0x3C3C, 0x3CFC, 
   0x3C05, 0x3EA5, 0x3C55, 0x3CF5, 0x3C0F, 0x3EAF, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3EA0, 0x3C30, 0x3CF0, 0x3C2A, 0x3EAA, 0x3C3C, 0x3CFC, 
   0x3C03, 0x3EA3, 0x3C57, 0x3CF3, 0x3C0F, 0x3EAF, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3EA0, 0x3C30, 0x3CF0, 0x3C0C, 0x3EAA, 0x3C3C, 0x3CFC, 
   0x3C03, 0x3EA3, 0x3C55, 0x3CF5, 0x3C0F, 0x3EAF, 0x3C3F, 0x3CFF, 
   0x3C02, 0x3EA2, 0x3C32, 0x3CF2, 0x3C2A, 0x3EAA, 0x3C3E, 0x3CFE, 
   0x3C03, 0x3EA3, 0x3C57, 0x3CF3, 0x3C0F, 0x3EAF, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3EA0, 0x3C30, 0x3CF0, 0x3C0C, 0x3EAA, 0x3C3C, 0x3CFC, 
   0x3C05, 0x3EA5, 0x3C55, 0x3CF5, 0x3C0F, 0x3EAF, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3EA0, 0x3C30, 0x3CF0, 0x3C2A, 0x3EAA, 0x3C3C, 0x3CFC, 
   0x3C03, 0x3EA3, 0x3C57, 0x3CF3, 0x3C0F, 0x3EAF, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3EA0, 0x3C30, 0x3CF0, 0x3C0C, 0x3EAA, 0x3C3C, 0x3CFC, 
   0x3C03, 0x3EA3, 0x3C55, 0x3CF5, 0x3C0F, 0x3EAF, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3EA0, 0x3C30, 0x3CF0, 0x3C2A, 0x3EAA, 0x3C3E, 0x3CFE, 
   0x3C03, 0x3EA3, 0x3C57, 0x3CF3, 0x3C0F, 0x3EAF, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3EA0, 0x3C30, 0x3CF0, 0x3C0C, 0x3EAA, 0x3C3C, 0x3CFC, 
   0x3C05, 0x3EA5, 0x3C55, 0x3CF5, 0x3C0F, 0x3EAF, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3EA0, 0x3C30, 0x3CF0, 0x3C2A, 0x3EAA, 0x3C3C, 0x3CFC, 
   0x3C03, 0x3EA3, 0x3C57, 0x3CF3, 0x3C0F, 0x3EAF, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3EA0, 0x3C30, 0x3CF0, 0x3C0C, 0x3EAA, 0x3C3C, 0x3CFC, 
   0x3C03, 0x3EA3, 0x3C55, 0x3CF5, 0x3C0F, 0x3EAF, 0x3C3F, 0x3CFF, 
   0x3C02, 0x3EA2, 0x3C32, 0x3CF2, 0x3C2A, 0x3EAA, 0x3C3E, 0x3CFE, 
   0x3C03, 0x3EA3, 0x3C57, 0x3CF3, 0x3C0F, 0x3EAF, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3EA0, 0x3C30, 0x3CF0, 0x3C0C, 0x3EAA, 0x3C3C, 0x3CFC, 
   0x3C05, 0x3EA5, 0x3C55, 0x3CF5, 0x3C0F, 0x3EAF, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3EA0, 0x3C30, 0x3CF0, 0x3C2A, 0x3EAA, 0x3C3C, 0x3CFC, 
   0x3C03, 0x3EA3, 0x3C57, 0x3CF3, 0x3C0F, 0x3EAF, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3EA0, 0x3C30, 0x3CF0, 0x3C0C, 0x3EAA, 0x3C3C, 0x3CFC, 
   0x3C03, 0x3EA3, 0x3C55, 0x3CF5, 0x3C0F, 0x3EAF, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3EA0, 0x3C30, 0x3CF0, 0x3C2A, 0x3EAA, 0x3C3E, 0x3CFE, 
   0x3C03, 0x3EA3, 0x3C57, 0x3CF3, 0x3C0F, 0x3EAF, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3EA0, 0x3C30, 0x3CF0, 0x3C0C, 0x3EAA, 0x3C3C, 0x3CFC, 
   0x3C05, 0x3EA5, 0x3C55, 0x3CF5, 0x3C0F, 0x3EAF, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3EA0, 0x3C30, 0x3CF0, 0x3C2A, 0x3EAA, 0x3C3C, 0x3CFC, 
   0x3C03, 0x3EA3, 0x3C57, 0x3CF3, 0x3C0F, 0x3EAF, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3EA0, 0x3C30, 0x3CF0, 0x3C0C, 0x3EAA, 0x3C3C, 0x3CFC, 
   0x3C03, 0x3EA3, 0x3C55, 0x3CF5, 0x3C0F, 0x3EAF, 0x3C3F, 0x3CFF, 
   0x3C02, 0x3EA2, 0x3C32, 0x3CF2, 0x3C2A, 0x3EAA, 0x3C3E, 0x3CFE, 
   0x3C03, 0x3EA3, 0x3C57, 0x3CF3, 0x3C0F, 0x3EAF, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3EA0, 0x3C30, 0x3CF0, 0x3C0C, 0x3EAA, 0x3C3C, 0x3CFC, 
   0x3C05, 0x3EA5, 0x3C55, 0x3CF5, 0x3C0F, 0x3EAF, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3EA0, 0x3C30, 0x3CF0, 0x3C2A, 0x3EAA, 0x3C3C, 0x3CFC, 
   0x3C03, 0x3EA3, 0x3C57, 0x3CF3, 0x3C0F, 0x3EAF, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3EA0, 0x3C30, 0x3CF0, 0x3C0C, 0x3EAA, 0x3C3C, 0x3CFC, 
   0x3C03, 0x3EA3, 0x3C55, 0x3CF5, 0x3C0F, 0x3EAF, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3EA0, 0x3C30, 0x3CF0, 0x3C2A, 0x3EAA, 0x3C3E, 0x3CFE, 
   0x3C03, 0x3EA3, 0x3C57, 0x3CF3, 0x3C0F, 0x3EAF, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3EA0, 0x3C30, 0x3CF0, 0x3C0C, 0x3EAA, 0x3C3C, 0x3CFC, 
   0x3C05, 0x3EA5, 0x3C55, 0x3CF5, 0x3C0F, 0x3EAF, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3EA0, 0x3C30, 0x3CF0, 0x3C2A, 0x3EAA, 0x3C3C, 0x3CFC, 
   0x3C03, 0x3EA3, 0x3C57, 0x3CF3, 0x3C0F, 0x3EAF, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3EA0, 0x3C30, 0x3CF0, 0x3C0C, 0x3EAA, 0x3C3C, 0x3CFC, 
   0x3C03, 0x3EA3, 0x3C55, 0x3CF5, 0x3C0F, 0x3EAF, 0x3C3F, 0x3CFF, 
   0x3C02, 0x3EA2, 0x3C32, 0x3CF2, 0x3C2A, 0x3EAA, 0x3C3E, 0x3CFE, 
   0x3C03, 0x3EA3, 0x3C57, 0x3CF3, 0x3C0F, 0x3EAF, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3EA0, 0x3C30, 0x3CF0, 0x3C0C, 0x3EAA, 0x3C3C, 0x3CFC, 
   0x3C05, 0x3EA5, 0x3C55, 0x3CF5, 0x3C0F, 0x3EAF, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3EA0, 0x3C30, 0x3CF0, 0x3C2A, 0x3EAA, 0x3C3C, 0x3CFC, 
   0x3C03, 0x3EA3, 0x3C57, 0x3CF3, 0x3C0F, 0x3EAF, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3EA0, 0x3C30, 0x3CF0, 0x3C0C, 0x3EAA, 0x3C3C, 0x3CFC, 
   0x3C03, 0x3EA3, 0x3C55, 0x3CF5, 0x3C0F, 0x3EAF, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3EA0, 0x3C30, 0x3CF0, 0x3C2A, 0x3EAA, 0x3C3E, 0x3CFE, 
   0x3C03, 0x3EA3, 0x3C57, 0x3CF3, 0x3C0F, 0x3EAF, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3EA0, 0x3C30, 0x3CF0, 0x3C0C, 0x3EAA, 0x3C3C, 0x3CFC, 
   0x3C05, 0x3EA5, 0x3C55, 0x3CF5, 0x3C0F, 0x3EAF, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3EA0, 0x3C30, 0x3CF0, 0x3C2A, 0x3EAA, 0x3C3C, 0x3CFC, 
   0x3C03, 0x3EA3, 0x3C57, 0x3CF3, 0x3C0F, 0x3EAF, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3EA0, 0x3C30, 0x3CF0, 0x3C0C, 0x3EAA, 0x3C3C, 0x3CFC, 
   0x3C03, 0x3EA3, 0x3C55, 0x3CF5, 0x3C0F, 0x3EAF, 0x3C3F, 0x3CFF, 
   0x3C02, 0x3EA2, 0x3C32, 0x3CF2, 0x3C2A, 0x3EAA, 0x3C3E, 0x3CFE, 
   0x3C03, 0x3EA3, 0x3C57, 0x3CF3, 0x3C0F, 0x3EAF, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3EA0, 0x3C30, 0x3CF0, 0x3C0C, 0x3EAA, 0x3C3C, 0x3CFC, 
   0x3C05, 0x3EA5, 0x3C55, 0x3CF5, 0x3C0F, 0x3EAF, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3EA0, 0x3C30, 0x3CF0, 0x3C2A, 0x3EAA, 0x3C3C, 0x3CFC, 
   0x3C03, 0x3EA3, 0x3C57, 0x3CF3, 0x3C0F, 0x3EAF, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3EA0, 0x3C30, 0x3CF0, 0x3C0C, 0x3EAA, 0x3C3C, 0x3CFC, 
   0x3C03, 0x3EA3, 0x3C55, 0x3CF5, 0x3C0F, 0x3EAF, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3EA0, 0x3C30, 0x3CF0, 0x3C2A, 0x3EAA, 0x3C3E, 0x3CFE, 
   0x3C03, 0x3EA3, 0x3C57, 0x3CF3, 0x3C0F, 0x3EAF, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3EA0, 0x3C30, 0x3CF0, 0x3C0C, 0x3EAA, 0x3C3C, 0x3CFC, 
   0x3C05, 0x3EA5, 0x3C55, 0x3CF5, 0x3C0F, 0x3EAF, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3EA0, 0x3C30, 0x3CF0, 0x3C2A, 0x3EAA, 0x3C3C, 0x3CFC, 
   0x3C03, 0x3EA3, 0x3C57, 0x3CF3, 0x3C0F, 0x3EAF, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3EA0, 0x3C30, 0x3CF0, 0x3C0C, 0x3EAA, 0x3C3C, 0x3CFC, 
   0x3C03, 0x3EA3, 0x3C55, 0x3CF5, 0x3C0F, 0x3EAF, 0x3C3F, 0x3CFF, 
   0x3C02, 0x3EA2, 0x3C32, 0x3CF2, 0x3C2A, 0x3EAA, 0x3C3E, 0x3CFE, 
   0x3C03, 0x3EA3, 0x3C57, 0x3CF3, 0x3C0F, 0x3EAF, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3EA0, 0x3C30, 0x3CF0, 0x3C0C, 0x3EAA, 0x3C3C, 0x3CFC, 
   0x3C05, 0x3EA5, 0x3C55, 0x3CF5, 0x3C0F, 0x3EAF, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3EA0, 0x3C30, 0x3CF0, 0x3C2A, 0x3EAA, 0x3C3C, 0x3CFC, 
   0x3C03, 0x3EA3, 0x3C57, 0x3CF3, 0x3C0F, 0x3EAF, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3EA0, 0x3C30, 0x3CF0, 0x3C0C, 0x3EAA, 0x3C3C, 0x3CFC, 
   0x3C03, 0x3EA3, 0x3C55, 0x3CF5, 0x3C0F, 0x3EAF, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3EA0, 0x3C30, 0x3CF0, 0x3C2A, 0x3EAA, 0x3C3E, 0x3CFE, 
   0x3C03, 0x3EA3, 0x3C57, 0x3CF3, 0x3C0F, 0x3EAF, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3EA0, 0x3C30, 0x3CF0, 0x3C0C, 0x3EAA, 0x3C3C, 0x3CFC, 
   0x3C05, 0x3EA5, 0x3C55, 0x3CF5, 0x3C0F, 0x3EAF, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3EA0, 0x3C30, 0x3CF0, 0x3C2A, 0x3EAA, 0x3C3C, 0x3CFC, 
   0x3C03, 0x3EA3, 0x3C57, 0x3CF3, 0x3C0F, 0x3EAF, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3EA0, 0x3C30, 0x3CF0, 0x3C0C, 0x3EAA, 0x3C3C, 0x3CFC, 
   0x3C03, 0x3EA3, 0x3C55, 0x3CF5, 0x3C0F, 0x3EAF, 0x3C3F, 0x3CFF, 
   0x3C02, 0x3EA2, 0x3C32, 0x3CF2, 0x3C2A, 0x3EAA, 0x3C3E, 0x3CFE, 
   0x3C03, 0x3EA3, 0x3C57, 0x3CF3, 0x3C0F, 0x3EAF, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3EA0, 0x3C30, 0x3CF0, 0x3C0C, 0x3EAA, 0x3C3C, 0x3CFC, 
   0x3C05, 0x3EA5, 0x3C55, 0x3CF5, 0x3C0F, 0x3EAF, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3EA0, 0x3C30, 0x3CF0, 0x3C2A, 0x3EAA, 0x3C3C, 0x3CFC, 
   0x3C03, 0x3EA3, 0x3C57, 0x3CF3, 0x3C0F, 0x3EAF, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3EA0, 0x3C30, 0x3CF0, 0x3C0C, 0x3EAA, 0x3C3C, 0x3CFC, 
   0x3C03, 0x3EA3, 0x3C55, 0x3CF5, 0x3C0F, 0x3EAF, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3EA0, 0x3C30, 0x3CF0, 0x3C2A, 0x3EAA, 0x3C3E, 0x3CFE, 
   0x3C03, 0x3EA3, 0x3C57, 0x3CF3, 0x3C0F, 0x3EAF, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3EA0, 0x3C30, 0x3CF0, 0x3C0C, 0x3EAA, 0x3C3C, 0x3CFC, 
   0x3C05, 0x3EA5, 0x3C55, 0x3CF5, 0x3C0F, 0x3EAF, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3EA0, 0x3C30, 0x3CF0, 0x3C2A, 0x3EAA, 0x3C3C, 0x3CFC, 
   0x3C03, 0x3EA3, 0x3C57, 0x3CF3, 0x3C0F, 0x3EAF, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3EA0, 0x3C30, 0x3CF0, 0x3C0C, 0x3EAA, 0x3C3C, 0x3CFC, 
   0x3C03, 0x3EA3, 0x3C55, 0x3CF5, 0x3C0F, 0x3EAF, 0x3C3F, 0x3CFF, 
   0x3C02, 0x3EA2, 0x3C32, 0x3CF2, 0x3C2A, 0x3EAA, 0x3C3E, 0x3CFE, 
   0x3C03, 0x3EA3, 0x3C57, 0x3CF3, 0x3C0F, 0x3EAF, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3EA0, 0x3C30, 0x3CF0, 0x3C0C, 0x3EAA, 0x3C3C, 0x3CFC, 
   0x3C05, 0x3EA5, 0x3C55, 0x3CF5, 0x3C0F, 0x3EAF, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3EA0, 0x3C30, 0x3CF0, 0x3C2A, 0x3EAA, 0x3C3C, 0x3CFC, 
   0x3C03, 0x3EA3, 0x3C57, 0x3CF3, 0x3C0F, 0x3EAF, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3EA0, 0x3C30, 0x3CF0, 0x3C0C, 0x3EAA, 0x3C3C, 0x3CFC, 
   0x3C03, 0x3EA3, 0x3C55, 0x3CF5, 0x3C0F, 0x3EAF, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3EA0, 0x3C30, 0x3CF0, 0x3C2A, 0x3EAA, 0x3C3E, 0x3CFE, 
   0x3C03, 0x3EA3, 0x3C57, 0x3CF3, 0x3C0F, 0x3EAF, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3EA0, 0x3C30, 0x3CF0, 0x3C0C, 0x3EAA, 0x3C3C, 0x3CFC, 
   0x3C05, 0x3EA5, 0x3C55, 0x3CF5, 0x3C0F, 0x3EAF, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3EA0, 0x3C30, 0x3CF0, 0x3C2A, 0x3EAA, 0x3C3C, 0x3CFC, 
   0x3C03, 0x3EA3, 0x3C57, 0x3CF3, 0x3C0F, 0x3EAF, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3EA0, 0x3C30, 0x3CF0, 0x3C0C, 0x3EAA, 0x3C3C, 0x3CFC, 
   0x3C03, 0x3EA3, 0x3C55, 0x3CF5, 0x3C0F, 0x3EAF, 0x3C3F, 0x3CFF, 
   0x3C02, 0x3EA2, 0x3C32, 0x3CF2, 0x3C2A, 0x3EAA, 0x3C3E, 0x3CFE, 
   0x3C03, 0x3EA3, 0x3C57, 0x3CF3, 0x3C0F, 0x3EAF, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3EA0, 0x3C30, 0x3CF0, 0x3C0C, 0x3EAA, 0x3C3C, 0x3CFC, 
   0x3C05, 0x3EA5, 0x3C55, 0x3CF5, 0x3C0F, 0x3EAF, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3EA0, 0x3C30, 0x3CF0, 0x3C2A, 0x3EAA, 0x3C3C, 0x3CFC, 
   0x3C03, 0x3EA3, 0x3C57, 0x3CF3, 0x3C0F, 0x3EAF, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3EA0, 0x3C30, 0x3CF0, 0x3C0C, 0x3EAA, 0x3C3C, 0x3CFC, 
   0x3C03, 0x3EA3, 0x3C55, 0x3CF5, 0x3C0F, 0x3EAF, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3EA0, 0x3C30, 0x3CF0, 0x3C2A, 0x3EAA, 0x3C3E, 0x3CFE, 
   0x3C03, 0x3EA3, 0x3C57, 0x3CF3, 0x3C0F, 0x3EAF, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3EA0, 0x3C30, 0x3CF0, 0x3C0C, 0x3EAA, 0x3C3C, 0x3CFC, 
   0x3C05, 0x3EA5, 0x3C55, 0x3CF5, 0x3C0F, 0x3EAF, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3EA0, 0x3C30, 0x3CF0, 0x3C2A, 0x3EAA, 0x3C3C, 0x3CFC, 
   0x3C03, 0x3EA3, 0x3C57, 0x3CF3, 0x3C0F, 0x3EAF, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3EA0, 0x3C30, 0x3CF0, 0x3C0C, 0x3EAA, 0x3C3C, 0x3CFC, 
   0x3C03, 0x3EA3, 0x3C55, 0x3CF5, 0x3C0F, 0x3EAF, 0x3C3F, 0x3CFF, 
   0x3C02, 0x3EA2, 0x3C32, 0x3CF2, 0x3C2A, 0x3EAA, 0x3C3E, 0x3CFE, 
   0x3C03, 0x3EA3, 0x3C57, 0x3CF3, 0x3C0F, 0x3EAF, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3EA0, 0x3C30, 0x3CF0, 0x3C0C, 0x3EAA, 0x3C3C, 0x3CFC, 
   0x3C05, 0x3EA5, 0x3C55, 0x3CF5, 0x3C0F, 0x3EAF, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3EA0, 0x3C30, 0x3CF0, 0x3C2A, 0x3EAA, 0x3C3C, 0x3CFC, 
   0x3C03, 0x3EA3, 0x3C57, 0x3CF3, 0x3C0F, 0x3EAF, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3EA0, 0x3C30, 0x3CF0, 0x3C0C, 0x3EAA, 0x3C3C, 0x3CFC, 
   0x3C03, 0x3EA3, 0x3C55, 0x3CF5, 0x3C0F, 0x3EAF, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3EA0, 0x3C30, 0x3CF0, 0x3C2A, 0x3EAA, 0x3C3E, 0x3CFE, 
   0x3C03, 0x3EA3, 0x3C57, 0x3CF3, 0x3C0F, 0x3EAF, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3EA0, 0x3C30, 0x3CF0, 0x3C0C, 0x3EAA, 0x3C3C, 0x3CFC, 
   0x3C05, 0x3EA5, 0x3C55, 0x3CF5, 0x3C0F, 0x3EAF, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3EA0, 0x3C30, 0x3CF0, 0x3C2A, 0x3EAA, 0x3C3C, 0x3CFC, 
   0x3C03, 0x3EA3, 0x3C57, 0x3CF3, 0x3C0F, 0x3EAF, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3EA0, 0x3C30, 0x3CF0, 0x3C0C, 0x3EAA, 0x3C3C, 0x3CFC, 
   0x3C03, 0x3EA3, 0x3C55, 0x3CF5, 0x3C0F, 0x3EAF, 0x3C3F, 0x3CFF, 
   0x3C02, 0x3EA2, 0x3C32, 0x3CF2, 0x3C2A, 0x3EAA, 0x3C3E, 0x3CFE, 
   0x3C03, 0x3EA3, 0x3C57, 0x3CF3, 0x3C0F, 0x3EAF, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3EA0, 0x3C30, 0x3CF0, 0x3C0C, 0x3EAA, 0x3C3C, 0x3CFC, 
   0x3C05, 0x3EA5, 0x3C55, 0x3CF5, 0x3C0F, 0x3EAF, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3EA0, 0x3C30, 0x3CF0, 0x3C2A, 0x3EAA, 0x3C3C, 0x3CFC, 
   0x3C03, 0x3EA3, 0x3C57, 0x3CF3, 0x3C0F, 0x3EAF, 0x3C3F, 0x3CFF, 
   0x0300, 0x03C0, 0x0554, 0x03F0, 0x030C, 0x03EA, 0x057C, 0x03FC, 
   0x0303, 0x03C3, 0x0555, 0x03F5, 0x030F, 0x03CF, 0x057F, 0x03FF, 
   0x0300, 0x03C0, 0x0554, 0x03F0, 0x032A, 0x03EA, 0x057E, 0x03FE, 
   0x0303, 0x03C3, 0x0557, 0x03F3, 0x030F, 0x03CF, 0x057F, 0x03FF, 
   0x0300, 0x03C0, 0x0554, 0x03F0, 0x030C, 0x03EA, 0x057C, 0x03FC, 
   0x0305, 0x03C5, 0x0555, 0x03F5, 0x030F, 0x03CF, 0x057F, 0x03FF, 
   0x0300, 0x03C0, 0x0554, 0x03F0, 0x032A, 0x03EA, 0x057C, 0x03FC, 
   0x0303, 0x03C3, 0x0557, 0x03F3, 0x030F, 0x03CF, 0x057F, 0x03FF, 
   0x0300, 0x03C0, 0x0554, 0x03F0, 0x030C, 0x03EA, 0x057C, 0x03FC, 
   0x0303, 0x03C3, 0x0555, 0x03F5, 0x030F, 0x03CF, 0x057F, 0x03FF, 
   0x0302, 0x03C2, 0x0556, 0x03F2, 0x032A, 0x03EA, 0x057E, 0x03FE, 
   0x0303, 0x03C3, 0x0557, 0x03F3, 0x030F, 0x03CF, 0x057F, 0x03FF, 
   0x0300, 0x03C0, 0x0554, 0x03F0, 0x030C, 0x03EA, 0x057C, 0x03FC, 
   0x0305, 0x03C5, 0x0555, 0x03F5, 0x030F, 0x03CF, 0x057F, 0x03FF, 
   0x0300, 0x03C0, 0x0554, 0x03F0, 0x032A, 0x03EA, 0x057C, 0x03FC, 
   0x0303, 0x03C3, 0x0557, 0x03F3, 0x030F, 0x03CF, 0x057F, 0x03FF, 
   0x0300, 0x03C0, 0x0554, 0x03F0, 0x030C, 0x03EA, 0x057C, 0x03FC, 
   0x0303, 0x03C3, 0x0555, 0x03F5, 0x030F, 0x03CF, 0x057F, 0x03FF, 
   0x0300, 0x03C0, 0x0554, 0x03F0, 0x032A, 0x03EA, 0x057E, 0x03FE, 
   0x0303, 0x03C3, 0x0557, 0x03F3, 0x030F, 0x03CF, 0x057F, 0x03FF, 
   0x0300, 0x03C0, 0x0554, 0x03F0, 0x030C, 0x03EA, 0x057C, 0x03FC, 
   0x0305, 0x03C5, 0x0555, 0x03F5, 0x030F, 0x03CF, 0x057F, 0x03FF, 
   0x0300, 0x03C0, 0x0554, 0x03F0, 0x032A, 0x03EA, 0x057C, 0x03FC, 
   0x0303, 0x03C3, 0x0557, 0x03F3, 0x030F, 0x03CF, 0x057F, 0x03FF, 
   0x0300, 0x03C0, 0x0554, 0x03F0, 0x030C, 0x03EA, 0x057C, 0x03FC, 
   0x0303, 0x03C3, 0x0555, 0x03F5, 0x030F, 0x03CF, 0x057F, 0x03FF, 
   0x0302, 0x03C2, 0x0556, 0x03F2, 0x032A, 0x03EA, 0x057E, 0x03FE, 
   0x0303, 0x03C3, 0x0557, 0x03F3, 0x030F, 0x03CF, 0x057F, 0x03FF, 
   0x0300, 0x03C0, 0x0554, 0x03F0, 0x030C, 0x03EA, 0x057C, 0x03FC, 
   0x0305, 0x03C5, 0x0555, 0x03F5, 0x030F, 0x03CF, 0x057F, 0x03FF, 
   0x0300, 0x03C0, 0x0554, 0x03F0, 0x032A, 0x03EA, 0x057C, 0x03FC, 
   0x0303, 0x03C3, 0x0557, 0x03F3, 0x030F, 0x03CF, 0x057F, 0x03FF, 
   0x0300, 0x03C0, 0x0554, 0x03F0, 0x030C, 0x03EA, 0x057C, 0x03FC, 
   0x0303, 0x03C3, 0x0555, 0x03F5, 0x030F, 0x03CF, 0x057F, 0x03FF, 
   0x0300, 0x03C0, 0x0554, 0x03F0, 0x032A, 0x03EA, 0x057E, 0x03FE, 
   0x0303, 0x03C3, 0x0557, 0x03F3, 0x030F, 0x03CF, 0x057F, 0x03FF, 
   0x0300, 0x03C0, 0x0554, 0x03F0, 0x030C, 0x03EA, 0x057C, 0x03FC, 
   0x0305, 0x03C5, 0x0555, 0x03F5, 0x030F, 0x03CF, 0x057F, 0x03FF, 
   0x0300, 0x03C0, 0x0554, 0x03F0, 0x032A, 0x03EA, 0x057C, 0x03FC, 
   0x0303, 0x03C3, 0x0557, 0x03F3, 0x030F, 0x03CF, 0x057F, 0x03FF, 
   0x0300, 0x03C0, 0x0554, 0x03F0, 0x030C, 0x03EA, 0x057C, 0x03FC, 
   0x0303, 0x03C3, 0x0555, 0x03F5, 0x030F, 0x03CF, 0x057F, 0x03FF, 
   0x0302, 0x03C2, 0x0556, 0x03F2, 0x032A, 0x03EA, 0x057E, 0x03FE, 
   0x0303, 0x03C3, 0x0557, 0x03F3, 0x030F, 0x03CF, 0x057F, 0x03FF, 
   0x0300, 0x03C0, 0x0554, 0x03F0, 0x030C, 0x03EA, 0x057C, 0x03FC, 
   0x0305, 0x03C5, 0x0555, 0x03F5, 0x030F, 0x03CF, 0x057F, 0x03FF, 
   0x0300, 0x03C0, 0x0554, 0x03F0, 0x032A, 0x03EA, 0x057C, 0x03FC, 
   0x0303, 0x03C3, 0x0557, 0x03F3, 0x030F, 0x03CF, 0x057F, 0x03FF, 
   0x0300, 0x03C0, 0x0554, 0x03F0, 0x030C, 0x03EA, 0x057C, 0x03FC, 
   0x0303, 0x03C3, 0x0555, 0x03F5, 0x030F, 0x03CF, 0x057F, 0x03FF, 
   0x0300, 0x03C0, 0x0554, 0x03F0, 0x032A, 0x03EA, 0x057E, 0x03FE, 
   0x0303, 0x03C3, 0x0557, 0x03F3, 0x030F, 0x03CF, 0x057F, 0x03FF, 
   0x0300, 0x03C0, 0x0554, 0x03F0, 0x030C, 0x03EA, 0x057C, 0x03FC, 
   0x0305, 0x03C5, 0x0555, 0x03F5, 0x030F, 0x03CF, 0x057F, 0x03FF, 
   0x0300, 0x03C0, 0x0554, 0x03F0, 0x032A, 0x03EA, 0x057C, 0x03FC, 
   0x0303, 0x03C3, 0x0557, 0x03F3, 0x030F, 0x03CF, 0x057F, 0x03FF, 
   0x0300, 0x03C0, 0x0554, 0x03F0, 0x030C, 0x03EA, 0x057C, 0x03FC, 
   0x0303, 0x03C3, 0x0555, 0x03F5, 0x030F, 0x03CF, 0x057F, 0x03FF, 
   0x0302, 0x03C2, 0x0556, 0x03F2, 0x032A, 0x03EA, 0x057E, 0x03FE, 
   0x0303, 0x03C3, 0x0557, 0x03F3, 0x030F, 0x03CF, 0x057F, 0x03FF, 
   0x0300, 0x03C0, 0x0554, 0x03F0, 0x030C, 0x03EA, 0x057C, 0x03FC, 
   0x0305, 0x03C5, 0x0555, 0x03F5, 0x030F, 0x03CF, 0x057F, 0x03FF, 
   0x0300, 0x03C0, 0x0554, 0x03F0, 0x032A, 0x03EA, 0x057C, 0x03FC, 
   0x0303, 0x03C3, 0x0557, 0x03F3, 0x030F, 0x03CF, 0x057F, 0x03FF, 
   0x0300, 0x03C0, 0x0554, 0x03F0, 0x030C, 0x03EA, 0x057C, 0x03FC, 
   0x0303, 0x03C3, 0x0555, 0x03F5, 0x030F, 0x03CF, 0x057F, 0x03FF, 
   0x0300, 0x03C0, 0x0554, 0x03F0, 0x032A, 0x03EA, 0x057E, 0x03FE, 
   0x0303, 0x03C3, 0x0557, 0x03F3, 0x030F, 0x03CF, 0x057F, 0x03FF, 
   0x0300, 0x03C0, 0x0554, 0x03F0, 0x030C, 0x03EA, 0x057C, 0x03FC, 
   0x0305, 0x03C5, 0x0555, 0x03F5, 0x030F, 0x03CF, 0x057F, 0x03FF, 
   0x0300, 0x03C0, 0x0554, 0x03F0, 0x032A, 0x03EA, 0x057C, 0x03FC, 
   0x0303, 0x03C3, 0x0557, 0x03F3, 0x030F, 0x03CF, 0x057F, 0x03FF, 
   0x0300, 0x03C0, 0x0554, 0x03F0, 0x030C, 0x03EA, 0x057C, 0x03FC, 
   0x0303, 0x03C3, 0x0555, 0x03F5, 0x030F, 0x03CF, 0x057F, 0x03FF, 
   0x0302, 0x03C2, 0x0556, 0x03F2, 0x032A, 0x03EA, 0x057E, 0x03FE, 
   0x0303, 0x03C3, 0x0557, 0x03F3, 0x030F, 0x03CF, 0x057F, 0x03FF, 
   0x0300, 0x03C0, 0x0554, 0x03F0, 0x030C, 0x03EA, 0x057C, 0x03FC, 
   0x0305, 0x03C5, 0x0555, 0x03F5, 0x030F, 0x03CF, 0x057F, 0x03FF, 
   0x0300, 0x03C0, 0x0554, 0x03F0, 0x032A, 0x03EA, 0x057C, 0x03FC, 
   0x0303, 0x03C3, 0x0557, 0x03F3, 0x030F, 0x03CF, 0x057F, 0x03FF, 
   0x0300, 0x03C0, 0x0554, 0x03F0, 0x030C, 0x03EA, 0x057C, 0x03FC, 
   0x0303, 0x03C3, 0x0555, 0x03F5, 0x030F, 0x03CF, 0x057F, 0x03FF, 
   0x0300, 0x03C0, 0x0554, 0x03F0, 0x032A, 0x03EA, 0x057E, 0x03FE, 
   0x0303, 0x03C3, 0x0557, 0x03F3, 0x030F, 0x03CF, 0x057F, 0x03FF, 
   0x0300, 0x03C0, 0x0554, 0x03F0, 0x030C, 0x03EA, 0x057C, 0x03FC, 
   0x0305, 0x03C5, 0x0555, 0x03F5, 0x030F, 0x03CF, 0x057F, 0x03FF, 
   0x0300, 0x03C0, 0x0554, 0x03F0, 0x032A, 0x03EA, 0x057C, 0x03FC, 
   0x0303, 0x03C3, 0x0557, 0x03F3, 0x030F, 0x03CF, 0x057F, 0x03FF, 
   0x0300, 0x03C0, 0x0554, 0x03F0, 0x030C, 0x03EA, 0x057C, 0x03FC, 
   0x0303, 0x03C3, 0x0555, 0x03F5, 0x030F, 0x03CF, 0x057F, 0x03FF, 
   0x0302, 0x03C2, 0x0556, 0x03F2, 0x032A, 0x03EA, 0x057E, 0x03FE, 
   0x0303, 0x03C3, 0x0557, 0x03F3, 0x030F, 0x03CF, 0x057F, 0x03FF, 
   0x0300, 0x03C0, 0x0554, 0x03F0, 0x030C, 0x03EA, 0x057C, 0x03FC, 
   0x0305, 0x03C5, 0x0555, 0x03F5, 0x030F, 0x03CF, 0x057F, 0x03FF, 
   0x0300, 0x03C0, 0x0554, 0x03F0, 0x032A, 0x03EA, 0x057C, 0x03FC, 
   0x0303, 0x03C3, 0x0557, 0x03F3, 0x030F, 0x03CF, 0x057F, 0x03FF, 
   0x0300, 0x03C0, 0x0554, 0x03F0, 0x030C, 0x03EA, 0x057C, 0x03FC, 
   0x0303, 0x03C3, 0x0555, 0x03F5, 0x030F, 0x03CF, 0x057F, 0x03FF, 
   0x0300, 0x03C0, 0x0554, 0x03F0, 0x032A, 0x03EA, 0x057E, 0x03FE, 
   0x0303, 0x03C3, 0x0557, 0x03F3, 0x030F, 0x03CF, 0x057F, 0x03FF, 
   0x0300, 0x03C0, 0x0554, 0x03F0, 0x030C, 0x03EA, 0x057C, 0x03FC, 
   0x0305, 0x03C5, 0x0555, 0x03F5, 0x030F, 0x03CF, 0x057F, 0x03FF, 
   0x0300, 0x03C0, 0x0554, 0x03F0, 0x032A, 0x03EA, 0x057C, 0x03FC, 
   0x0303, 0x03C3, 0x0557, 0x03F3, 0x030F, 0x03CF, 0x057F, 0x03FF, 
   0x0300, 0x03C0, 0x0554, 0x03F0, 0x030C, 0x03EA, 0x057C, 0x03FC, 
   0x0303, 0x03C3, 0x0555, 0x03F5, 0x030F, 0x03CF, 0x057F, 0x03FF, 
   0x0302, 0x03C2, 0x0556, 0x03F2, 0x032A, 0x03EA, 0x057E, 0x03FE, 
   0x0303, 0x03C3, 0x0557, 0x03F3, 0x030F, 0x03CF, 0x057F, 0x03FF, 
   0x0300, 0x03C0, 0x0554, 0x03F0, 0x030C, 0x03EA, 0x057C, 0x03FC, 
   0x0305, 0x03C5, 0x0555, 0x03F5, 0x030F, 0x03CF, 0x057F, 0x03FF, 
   0x0300, 0x03C0, 0x0554, 0x03F0, 0x032A, 0x03EA, 0x057C, 0x03FC, 
   0x0303, 0x03C3, 0x0557, 0x03F3, 0x030F, 0x03CF, 0x057F, 0x03FF, 
   0x0300, 0x03C0, 0x0554, 0x03F0, 0x030C, 0x03EA, 0x057C, 0x03FC, 
   0x0303, 0x03C3, 0x0555, 0x03F5, 0x030F, 0x03CF, 0x057F, 0x03FF, 
   0x0300, 0x03C0, 0x0554, 0x03F0, 0x032A, 0x03EA, 0x057E, 0x03FE, 
   0x0303, 0x03C3, 0x0557, 0x03F3, 0x030F, 0x03CF, 0x057F, 0x03FF, 
   0x0300, 0x03C0, 0x0554, 0x03F0, 0x030C, 0x03EA, 0x057C, 0x03FC, 
   0x0305, 0x03C5, 0x0555, 0x03F5, 0x030F, 0x03CF, 0x057F, 0x03FF, 
   0x0300, 0x03C0, 0x0554, 0x03F0, 0x032A, 0x03EA, 0x057C, 0x03FC, 
   0x0303, 0x03C3, 0x0557, 0x03F3, 0x030F, 0x03CF, 0x057F, 0x03FF, 
   0x0300, 0x03C0, 0x0554, 0x03F0, 0x030C, 0x03EA, 0x057C, 0x03FC, 
   0x0303, 0x03C3, 0x0555, 0x03F5, 0x030F, 0x03CF, 0x057F, 0x03FF, 
   0x0302, 0x03C2, 0x0556, 0x03F2, 0x032A, 0x03EA, 0x057E, 0x03FE, 
   0x0303, 0x03C3, 0x0557, 0x03F3, 0x030F, 0x03CF, 0x057F, 0x03FF, 
   0x0300, 0x03C0, 0x0554, 0x03F0, 0x030C, 0x03EA, 0x057C, 0x03FC, 
   0x0305, 0x03C5, 0x0555, 0x03F5, 0x030F, 0x03CF, 0x057F, 0x03FF, 
   0x0300, 0x03C0, 0x0554, 0x03F0, 0x032A, 0x03EA, 0x057C, 0x03FC, 
   0x0303, 0x03C3, 0x0557, 0x03F3, 0x030F, 0x03CF, 0x057F, 0x03FF, 
   0x0300, 0x03C0, 0x0554, 0x03F0, 0x030C, 0x03EA, 0x057C, 0x03FC, 
   0x0303, 0x03C3, 0x0555, 0x03F5, 0x030F, 0x03CF, 0x057F, 0x03FF, 
   0x0300, 0x03C0, 0x0554, 0x03F0, 0x032A, 0x03EA, 0x057E, 0x03FE, 
   0x0303, 0x03C3, 0x0557, 0x03F3, 0x030F, 0x03CF, 0x057F, 0x03FF, 
   0x0300, 0x03C0, 0x0554, 0x03F0, 0x030C, 0x03EA, 0x057C, 0x03FC, 
   0x0305, 0x03C5, 0x0555, 0x03F5, 0x030F, 0x03CF, 0x057F, 0x03FF, 
   0x0300, 0x03C0, 0x0554, 0x03F0, 0x032A, 0x03EA, 0x057C, 0x03FC, 
   0x0303, 0x03C3, 0x0557, 0x03F3, 0x030F, 0x03CF, 0x057F, 0x03FF, 
   0x0300, 0x03C0, 0x0554, 0x03F0, 0x030C, 0x03EA, 0x057C, 0x03FC, 
   0x0303, 0x03C3, 0x0555, 0x03F5, 0x030F, 0x03CF, 0x057F, 0x03FF, 
   0x0302, 0x03C2, 0x0556, 0x03F2, 0x032A, 0x03EA, 0x057E, 0x03FE, 
   0x0303, 0x03C3, 0x0557, 0x03F3, 0x030F, 0x03CF, 0x057F, 0x03FF, 
   0x0300, 0x03C0, 0x0554, 0x03F0, 0x030C, 0x03EA, 0x057C, 0x03FC, 
   0x0305, 0x03C5, 0x0555, 0x03F5, 0x030F, 0x03CF, 0x057F, 0x03FF, 
   0x0300, 0x03C0, 0x0554, 0x03F0, 0x032A, 0x03EA, 0x057C, 0x03FC, 
   0x0303, 0x03C3, 0x0557, 0x03F3, 0x030F, 0x03CF, 0x057F, 0x03FF, 
   0x0300, 0x03C0, 0x0554, 0x03F0, 0x030C, 0x03EA, 0x057C, 0x03FC, 
   0x0303, 0x03C3, 0x0555, 0x03F5, 0x030F, 0x03CF, 0x057F, 0x03FF, 
   0x0300, 0x03C0, 0x0554, 0x03F0, 0x032A, 0x03EA, 0x057E, 0x03FE, 
   0x0303, 0x03C3, 0x0557, 0x03F3, 0x030F, 0x03CF, 0x057F, 0x03FF, 
   0x0300, 0x03C0, 0x0554, 0x03F0, 0x030C, 0x03EA, 0x057C, 0x03FC, 
   0x0305, 0x03C5, 0x0555, 0x03F5, 0x030F, 0x03CF, 0x057F, 0x03FF, 
   0x0300, 0x03C0, 0x0554, 0x03F0, 0x032A, 0x03EA, 0x057C, 0x03FC, 
   0x0303, 0x03C3, 0x0557, 0x03F3, 0x030F, 0x03CF, 0x057F, 0x03FF, 
   0x0300, 0x03C0, 0x0554, 0x03F0, 0x030C, 0x03EA, 0x057C, 0x03FC, 
   0x0303, 0x03C3, 0x0555, 0x03F5, 0x030F, 0x03CF, 0x057F, 0x03FF, 
   0x0302, 0x03C2, 0x0556, 0x03F2, 0x032A, 0x03EA, 0x057E, 0x03FE, 
   0x0303, 0x03C3, 0x0557, 0x03F3, 0x030F, 0x03CF, 0x057F, 0x03FF, 
   0x0300, 0x03C0, 0x0554, 0x03F0, 0x030C, 0x03EA, 0x057C, 0x03FC, 
   0x0305, 0x03C5, 0x0555, 0x03F5, 0x030F, 0x03CF, 0x057F, 0x03FF, 
   0x0300, 0x03C0, 0x0554, 0x03F0, 0x032A, 0x03EA, 0x057C, 0x03FC, 
   0x0303, 0x03C3, 0x0557, 0x03F3, 0x030F, 0x03CF, 0x057F, 0x03FF, 
   0x2300, 0x23C0, 0x2554, 0x23F0, 0x230C, 0x23EA, 0x257C, 0x23FC, 
   0x2303, 0x23C3, 0x2555, 0x23F5, 0x230F, 0x23CF, 0x257F, 0x23FF, 
   0x2300, 0x23C0, 0x2554, 0x23F0, 0x232A, 0x23EA, 0x257E, 0x23FE, 
   0x2303, 0x23C3, 0x2557, 0x23F3, 0x230F, 0x23CF, 0x257F, 0x23FF, 
   0x2300, 0x23C0, 0x2554, 0x23F0, 0x230C, 0x23EA, 0x257C, 0x23FC, 
   0x2305, 0x23C5, 0x2555, 0x23F5, 0x230F, 0x23CF, 0x257F, 0x23FF, 
   0x2300, 0x23C0, 0x2554, 0x23F0, 0x232A, 0x23EA, 0x257C, 0x23FC, 
   0x2303, 0x23C3, 0x2557, 0x23F3, 0x230F, 0x23CF, 0x257F, 0x23FF, 
   0x2300, 0x23C0, 0x2554, 0x23F0, 0x230C, 0x23EA, 0x257C, 0x23FC, 
   0x2303, 0x23C3, 0x2555, 0x23F5, 0x230F, 0x23CF, 0x257F, 0x23FF, 
   0x2302, 0x23C2, 0x2556, 0x23F2, 0x232A, 0x23EA, 0x257E, 0x23FE, 
   0x2303, 0x23C3, 0x2557, 0x23F3, 0x230F, 0x23CF, 0x257F, 0x23FF, 
   0x2300, 0x23C0, 0x2554, 0x23F0, 0x230C, 0x23EA, 0x257C, 0x23FC, 
   0x2305, 0x23C5, 0x2555, 0x23F5, 0x230F, 0x23CF, 0x257F, 0x23FF, 
   0x2300, 0x23C0, 0x2554, 0x23F0, 0x232A, 0x23EA, 0x257C, 0x23FC, 
   0x2303, 0x23C3, 0x2557, 0x23F3, 0x230F, 0x23CF, 0x257F, 0x23FF, 
   0x2300, 0x23C0, 0x2554, 0x23F0, 0x230C, 0x23EA, 0x257C, 0x23FC, 
   0x2303, 0x23C3, 0x2555, 0x23F5, 0x230F, 0x23CF, 0x257F, 0x23FF, 
   0x2300, 0x23C0, 0x2554, 0x23F0, 0x232A, 0x23EA, 0x257E, 0x23FE, 
   0x2303, 0x23C3, 0x2557, 0x23F3, 0x230F, 0x23CF, 0x257F, 0x23FF, 
   0x2300, 0x23C0, 0x2554, 0x23F0, 0x230C, 0x23EA, 0x257C, 0x23FC, 
   0x2305, 0x23C5, 0x2555, 0x23F5, 0x230F, 0x23CF, 0x257F, 0x23FF, 
   0x2300, 0x23C0, 0x2554, 0x23F0, 0x232A, 0x23EA, 0x257C, 0x23FC, 
   0x2303, 0x23C3, 0x2557, 0x23F3, 0x230F, 0x23CF, 0x257F, 0x23FF, 
   0x2300, 0x23C0, 0x2554, 0x23F0, 0x230C, 0x23EA, 0x257C, 0x23FC, 
   0x2303, 0x23C3, 0x2555, 0x23F5, 0x230F, 0x23CF, 0x257F, 0x23FF, 
   0x2302, 0x23C2, 0x2556, 0x23F2, 0x232A, 0x23EA, 0x257E, 0x23FE, 
   0x2303, 0x23C3, 0x2557, 0x23F3, 0x230F, 0x23CF, 0x257F, 0x23FF, 
   0x2300, 0x23C0, 0x2554, 0x23F0, 0x230C, 0x23EA, 0x257C, 0x23FC, 
   0x2305, 0x23C5, 0x2555, 0x23F5, 0x230F, 0x23CF, 0x257F, 0x23FF, 
   0x2300, 0x23C0, 0x2554, 0x23F0, 0x232A, 0x23EA, 0x257C, 0x23FC, 
   0x2303, 0x23C3, 0x2557, 0x23F3, 0x230F, 0x23CF, 0x257F, 0x23FF, 
   0x0300, 0x03C0, 0x0554, 0x03F0, 0x030C, 0x03EA, 0x057C, 0x03FC, 
   0x0303, 0x03C3, 0x0555, 0x03F5, 0x030F, 0x03CF, 0x057F, 0x03FF, 
   0x0300, 0x03C0, 0x0554, 0x03F0, 0x032A, 0x03EA, 0x057E, 0x03FE, 
   0x0303, 0x03C3, 0x0557, 0x03F3, 0x030F, 0x03CF, 0x057F, 0x03FF, 
   0x0300, 0x03C0, 0x0554, 0x03F0, 0x030C, 0x03EA, 0x057C, 0x03FC, 
   0x0305, 0x03C5, 0x0555, 0x03F5, 0x030F, 0x03CF, 0x057F, 0x03FF, 
   0x0300, 0x03C0, 0x0554, 0x03F0, 0x032A, 0x03EA, 0x057C, 0x03FC, 
   0x0303, 0x03C3, 0x0557, 0x03F3, 0x030F, 0x03CF, 0x057F, 0x03FF, 
   0x0300, 0x03C0, 0x0554, 0x03F0, 0x030C, 0x03EA, 0x057C, 0x03FC, 
   0x0303, 0x03C3, 0x0555, 0x03F5, 0x030F, 0x03CF, 0x057F, 0x03FF, 
   0x0302, 0x03C2, 0x0556, 0x03F2, 0x032A, 0x03EA, 0x057E, 0x03FE, 
   0x0303, 0x03C3, 0x0557, 0x03F3, 0x030F, 0x03CF, 0x057F, 0x03FF, 
   0x0300, 0x03C0, 0x0554, 0x03F0, 0x030C, 0x03EA, 0x057C, 0x03FC, 
   0x0305, 0x03C5, 0x0555, 0x03F5, 0x030F, 0x03CF, 0x057F, 0x03FF, 
   0x0300, 0x03C0, 0x0554, 0x03F0, 0x032A, 0x03EA, 0x057C, 0x03FC, 
   0x0303, 0x03C3, 0x0557, 0x03F3, 0x030F, 0x03CF, 0x057F, 0x03FF, 
   0x0300, 0x03C0, 0x0554, 0x03F0, 0x030C, 0x03EA, 0x057C, 0x03FC, 
   0x0303, 0x03C3, 0x0555, 0x03F5, 0x030F, 0x03CF, 0x057F, 0x03FF, 
   0x0300, 0x03C0, 0x0554, 0x03F0, 0x032A, 0x03EA, 0x057E, 0x03FE, 
   0x0303, 0x03C3, 0x0557, 0x03F3, 0x030F, 0x03CF, 0x057F, 0x03FF, 
   0x0300, 0x03C0, 0x0554, 0x03F0, 0x030C, 0x03EA, 0x057C, 0x03FC, 
   0x0305, 0x03C5, 0x0555, 0x03F5, 0x030F, 0x03CF, 0x057F, 0x03FF, 
   0x0300, 0x03C0, 0x0554, 0x03F0, 0x032A, 0x03EA, 0x057C, 0x03FC, 
   0x0303, 0x03C3, 0x0557, 0x03F3, 0x030F, 0x03CF, 0x057F, 0x03FF, 
   0x0300, 0x03C0, 0x0554, 0x03F0, 0x030C, 0x03EA, 0x057C, 0x03FC, 
   0x0303, 0x03C3, 0x0555, 0x03F5, 0x030F, 0x03CF, 0x057F, 0x03FF, 
   0x0302, 0x03C2, 0x0556, 0x03F2, 0x032A, 0x03EA, 0x057E, 0x03FE, 
   0x0303, 0x03C3, 0x0557, 0x03F3, 0x030F, 0x03CF, 0x057F, 0x03FF, 
   0x0300, 0x03C0, 0x0554, 0x03F0, 0x030C, 0x03EA, 0x057C, 0x03FC, 
   0x0305, 0x03C5, 0x0555, 0x03F5, 0x030F, 0x03CF, 0x057F, 0x03FF, 
   0x0300, 0x03C0, 0x0554, 0x03F0, 0x032A, 0x03EA, 0x057C, 0x03FC, 
   0x0303, 0x03C3, 0x0557, 0x03F3, 0x030F, 0x03CF, 0x057F, 0x03FF, 
   0x0300, 0x03C0, 0x0554, 0x03F0, 0x030C, 0x03EA, 0x057C, 0x03FC, 
   0x0303, 0x03C3, 0x0555, 0x03F5, 0x030F, 0x03CF, 0x057F, 0x03FF, 
   0x0300, 0x03C0, 0x0554, 0x03F0, 0x032A, 0x03EA, 0x057E, 0x03FE, 
   0x0303, 0x03C3, 0x0557, 0x03F3, 0x030F, 0x03CF, 0x057F, 0x03FF, 
   0x0300, 0x03C0, 0x0554, 0x03F0, 0x030C, 0x03EA, 0x057C, 0x03FC, 
   0x0305, 0x03C5, 0x0555, 0x03F5, 0x030F, 0x03CF, 0x057F, 0x03FF, 
   0x0300, 0x03C0, 0x0554, 0x03F0, 0x032A, 0x03EA, 0x057C, 0x03FC, 
   0x0303, 0x03C3, 0x0557, 0x03F3, 0x030F, 0x03CF, 0x057F, 0x03FF, 
   0x0300, 0x03C0, 0x0554, 0x03F0, 0x030C, 0x03EA, 0x057C, 0x03FC, 
   0x0303, 0x03C3, 0x0555, 0x03F5, 0x030F, 0x03CF, 0x057F, 0x03FF, 
   0x0302, 0x03C2, 0x0556, 0x03F2, 0x032A, 0x03EA, 0x057E, 0x03FE, 
   0x0303, 0x03C3, 0x0557, 0x03F3, 0x030F, 0x03CF, 0x057F, 0x03FF, 
   0x0300, 0x03C0, 0x0554, 0x03F0, 0x030C, 0x03EA, 0x057C, 0x03FC, 
   0x0305, 0x03C5, 0x0555, 0x03F5, 0x030F, 0x03CF, 0x057F, 0x03FF, 
   0x0300, 0x03C0, 0x0554, 0x03F0, 0x032A, 0x03EA, 0x057C, 0x03FC, 
   0x0303, 0x03C3, 0x0557, 0x03F3, 0x030F, 0x03CF, 0x057F, 0x03FF, 
   0x0300, 0x03C0, 0x0554, 0x03F0, 0x030C, 0x03EA, 0x057C, 0x03FC, 
   0x0303, 0x03C3, 0x0555, 0x03F5, 0x030F, 0x03CF, 0x057F, 0x03FF, 
   0x0300, 0x03C0, 0x0554, 0x03F0, 0x032A, 0x03EA, 0x057E, 0x03FE, 
   0x0303, 0x03C3, 0x0557, 0x03F3, 0x030F, 0x03CF, 0x057F, 0x03FF, 
   0x0300, 0x03C0, 0x0554, 0x03F0, 0x030C, 0x03EA, 0x057C, 0x03FC, 
   0x0305, 0x03C5, 0x0555, 0x03F5, 0x030F, 0x03CF, 0x057F, 0x03FF, 
   0x0300, 0x03C0, 0x0554, 0x03F0, 0x032A, 0x03EA, 0x057C, 0x03FC, 
   0x0303, 0x03C3, 0x0557, 0x03F3, 0x030F, 0x03CF, 0x057F, 0x03FF, 
   0x0300, 0x03C0, 0x0554, 0x03F0, 0x030C, 0x03EA, 0x057C, 0x03FC, 
   0x0303, 0x03C3, 0x0555, 0x03F5, 0x030F, 0x03CF, 0x057F, 0x03FF, 
   0x0302, 0x03C2, 0x0556, 0x03F2, 0x032A, 0x03EA, 0x057E, 0x03FE, 
   0x0303, 0x03C3, 0x0557, 0x03F3, 0x030F, 0x03CF, 0x057F, 0x03FF, 
   0x0300, 0x03C0, 0x0554, 0x03F0, 0x030C, 0x03EA, 0x057C, 0x03FC, 
   0x0305, 0x03C5, 0x0555, 0x03F5, 0x030F, 0x03CF, 0x057F, 0x03FF, 
   0x0300, 0x03C0, 0x0554, 0x03F0, 0x032A, 0x03EA, 0x057C, 0x03FC, 
   0x0303, 0x03C3, 0x0557, 0x03F3, 0x030F, 0x03CF, 0x057F, 0x03FF, 
   0x1540, 0x17C0, 0x1554, 0x17F0, 0x154C, 0x17EA, 0x157C, 0x17FC, 
   0x1543, 0x17C3, 0x1555, 0x17F5, 0x154F, 0x17CF, 0x157F, 0x17FF, 
   0x1540, 0x17C0, 0x1554, 0x17F0, 0x156A, 0x17EA, 0x157E, 0x17FE, 
   0x1543, 0x17C3, 0x1557, 0x17F3, 0x154F, 0x17CF, 0x157F, 0x17FF, 
   0x1540, 0x17C0, 0x1554, 0x17F0, 0x154C, 0x17EA, 0x157C, 0x17FC, 
   0x1545, 0x17C5, 0x1555, 0x17F5, 0x154F, 0x17CF, 0x157F, 0x17FF, 
   0x1540, 0x17C0, 0x1554, 0x17F0, 0x156A, 0x17EA, 0x157C, 0x17FC, 
   0x1543, 0x17C3, 0x1557, 0x17F3, 0x154F, 0x17CF, 0x157F, 0x17FF, 
   0x1540, 0x17C0, 0x1554, 0x17F0, 0x154C, 0x17EA, 0x157C, 0x17FC, 
   0x1543, 0x17C3, 0x1555, 0x17F5, 0x154F, 0x17CF, 0x157F, 0x17FF, 
   0x1542, 0x17C2, 0x1556, 0x17F2, 0x156A, 0x17EA, 0x157E, 0x17FE, 
   0x1543, 0x17C3, 0x1557, 0x17F3, 0x154F, 0x17CF, 0x157F, 0x17FF, 
   0x1540, 0x17C0, 0x1554, 0x17F0, 0x154C, 0x17EA, 0x157C, 0x17FC, 
   0x1545, 0x17C5, 0x1555, 0x17F5, 0x154F, 0x17CF, 0x157F, 0x17FF, 
   0x1540, 0x17C0, 0x1554, 0x17F0, 0x156A, 0x17EA, 0x157C, 0x17FC, 
   0x1543, 0x17C3, 0x1557, 0x17F3, 0x154F, 0x17CF, 0x157F, 0x17FF, 
   0x1540, 0x17C0, 0x1554, 0x17F0, 0x154C, 0x17EA, 0x157C, 0x17FC, 
   0x1543, 0x17C3, 0x1555, 0x17F5, 0x154F, 0x17CF, 0x157F, 0x17FF, 
   0x1540, 0x17C0, 0x1554, 0x17F0, 0x156A, 0x17EA, 0x157E, 0x17FE, 
   0x1543, 0x17C3, 0x1557, 0x17F3, 0x154F, 0x17CF, 0x157F, 0x17FF, 
   0x1540, 0x17C0, 0x1554, 0x17F0, 0x154C, 0x17EA, 0x157C, 0x17FC, 
   0x1545, 0x17C5, 0x1555, 0x17F5, 0x154F, 0x17CF, 0x157F, 0x17FF, 
   0x1540, 0x17C0, 0x1554, 0x17F0, 0x156A, 0x17EA, 0x157C, 0x17FC, 
   0x1543, 0x17C3, 0x1557, 0x17F3, 0x154F, 0x17CF, 0x157F, 0x17FF, 
   0x1540, 0x17C0, 0x1554, 0x17F0, 0x154C, 0x17EA, 0x157C, 0x17FC, 
   0x1543, 0x17C3, 0x1555, 0x17F5, 0x154F, 0x17CF, 0x157F, 0x17FF, 
   0x1542, 0x17C2, 0x1556, 0x17F2, 0x156A, 0x17EA, 0x157E, 0x17FE, 
   0x1543, 0x17C3, 0x1557, 0x17F3, 0x154F, 0x17CF, 0x157F, 0x17FF, 
   0x1540, 0x17C0, 0x1554, 0x17F0, 0x154C, 0x17EA, 0x157C, 0x17FC, 
   0x1545, 0x17C5, 0x1555, 0x17F5, 0x154F, 0x17CF, 0x157F, 0x17FF, 
   0x1540, 0x17C0, 0x1554, 0x17F0, 0x156A, 0x17EA, 0x157C, 0x17FC, 
   0x1543, 0x17C3, 0x1557, 0x17F3, 0x154F, 0x17CF, 0x157F, 0x17FF, 
   0x1540, 0x17C0, 0x1554, 0x17F0, 0x154C, 0x17EA, 0x157C, 0x17FC, 
   0x1543, 0x17C3, 0x1555, 0x17F5, 0x154F, 0x17CF, 0x157F, 0x17FF, 
   0x1540, 0x17C0, 0x1554, 0x17F0, 0x156A, 0x17EA, 0x157E, 0x17FE, 
   0x1543, 0x17C3, 0x1557, 0x17F3, 0x154F, 0x17CF, 0x157F, 0x17FF, 
   0x1540, 0x17C0, 0x1554, 0x17F0, 0x154C, 0x17EA, 0x157C, 0x17FC, 
   0x1545, 0x17C5, 0x1555, 0x17F5, 0x154F, 0x17CF, 0x157F, 0x17FF, 
   0x1540, 0x17C0, 0x1554, 0x17F0, 0x156A, 0x17EA, 0x157C, 0x17FC, 
   0x1543, 0x17C3, 0x1557, 0x17F3, 0x154F, 0x17CF, 0x157F, 0x17FF, 
   0x1540, 0x17C0, 0x1554, 0x17F0, 0x154C, 0x17EA, 0x157C, 0x17FC, 
   0x1543, 0x17C3, 0x1555, 0x17F5, 0x154F, 0x17CF, 0x157F, 0x17FF, 
   0x1542, 0x17C2, 0x1556, 0x17F2, 0x156A, 0x17EA, 0x157E, 0x17FE, 
   0x1543, 0x17C3, 0x1557, 0x17F3, 0x154F, 0x17CF, 0x157F, 0x17FF, 
   0x1540, 0x17C0, 0x1554, 0x17F0, 0x154C, 0x17EA, 0x157C, 0x17FC, 
   0x1545, 0x17C5, 0x1555, 0x17F5, 0x154F, 0x17CF, 0x157F, 0x17FF, 
   0x1540, 0x17C0, 0x1554, 0x17F0, 0x156A, 0x17EA, 0x157C, 0x17FC, 
   0x1543, 0x17C3, 0x1557, 0x17F3, 0x154F, 0x17CF, 0x157F, 0x17FF, 
   0x1540, 0x17C0, 0x1554, 0x17F0, 0x154C, 0x17EA, 0x157C, 0x17FC, 
   0x1543, 0x17C3, 0x1555, 0x17F5, 0x154F, 0x17CF, 0x157F, 0x17FF, 
   0x1540, 0x17C0, 0x1554, 0x17F0, 0x156A, 0x17EA, 0x157E, 0x17FE, 
   0x1543, 0x17C3, 0x1557, 0x17F3, 0x154F, 0x17CF, 0x157F, 0x17FF, 
   0x1540, 0x17C0, 0x1554, 0x17F0, 0x154C, 0x17EA, 0x157C, 0x17FC, 
   0x1545, 0x17C5, 0x1555, 0x17F5, 0x154F, 0x17CF, 0x157F, 0x17FF, 
   0x1540, 0x17C0, 0x1554, 0x17F0, 0x156A, 0x17EA, 0x157C, 0x17FC, 
   0x1543, 0x17C3, 0x1557, 0x17F3, 0x154F, 0x17CF, 0x157F, 0x17FF, 
   0x1540, 0x17C0, 0x1554, 0x17F0, 0x154C, 0x17EA, 0x157C, 0x17FC, 
   0x1543, 0x17C3, 0x1555, 0x17F5, 0x154F, 0x17CF, 0x157F, 0x17FF, 
   0x1542, 0x17C2, 0x1556, 0x17F2, 0x156A, 0x17EA, 0x157E, 0x17FE, 
   0x1543, 0x17C3, 0x1557, 0x17F3, 0x154F, 0x17CF, 0x157F, 0x17FF, 
   0x1540, 0x17C0, 0x1554, 0x17F0, 0x154C, 0x17EA, 0x157C, 0x17FC, 
   0x1545, 0x17C5, 0x1555, 0x17F5, 0x154F, 0x17CF, 0x157F, 0x17FF, 
   0x1540, 0x17C0, 0x1554, 0x17F0, 0x156A, 0x17EA, 0x157C, 0x17FC, 
   0x1543, 0x17C3, 0x1557, 0x17F3, 0x154F, 0x17CF, 0x157F, 0x17FF, 
   0x1540, 0x17C0, 0x1554, 0x17F0, 0x154C, 0x17EA, 0x157C, 0x17FC, 
   0x1543, 0x17C3, 0x1555, 0x17F5, 0x154F, 0x17CF, 0x157F, 0x17FF, 
   0x1540, 0x17C0, 0x1554, 0x17F0, 0x156A, 0x17EA, 0x157E, 0x17FE, 
   0x1543, 0x17C3, 0x1557, 0x17F3, 0x154F, 0x17CF, 0x157F, 0x17FF, 
   0x1540, 0x17C0, 0x1554, 0x17F0, 0x154C, 0x17EA, 0x157C, 0x17FC, 
   0x1545, 0x17C5, 0x1555, 0x17F5, 0x154F, 0x17CF, 0x157F, 0x17FF, 
   0x1540, 0x17C0, 0x1554, 0x17F0, 0x156A, 0x17EA, 0x157C, 0x17FC, 
   0x1543, 0x17C3, 0x1557, 0x17F3, 0x154F, 0x17CF, 0x157F, 0x17FF, 
   0x1540, 0x17C0, 0x1554, 0x17F0, 0x154C, 0x17EA, 0x157C, 0x17FC, 
   0x1543, 0x17C3, 0x1555, 0x17F5, 0x154F, 0x17CF, 0x157F, 0x17FF, 
   0x1542, 0x17C2, 0x1556, 0x17F2, 0x156A, 0x17EA, 0x157E, 0x17FE, 
   0x1543, 0x17C3, 0x1557, 0x17F3, 0x154F, 0x17CF, 0x157F, 0x17FF, 
   0x1540, 0x17C0, 0x1554, 0x17F0, 0x154C, 0x17EA, 0x157C, 0x17FC, 
   0x1545, 0x17C5, 0x1555, 0x17F5, 0x154F, 0x17CF, 0x157F, 0x17FF, 
   0x1540, 0x17C0, 0x1554, 0x17F0, 0x156A, 0x17EA, 0x157C, 0x17FC, 
   0x1543, 0x17C3, 0x1557, 0x17F3, 0x154F, 0x17CF, 0x157F, 0x17FF, 
   0x1540, 0x17C0, 0x1554, 0x17F0, 0x154C, 0x17EA, 0x157C, 0x17FC, 
   0x1543, 0x17C3, 0x1555, 0x17F5, 0x154F, 0x17CF, 0x157F, 0x17FF, 
   0x1540, 0x17C0, 0x1554, 0x17F0, 0x156A, 0x17EA, 0x157E, 0x17FE, 
   0x1543, 0x17C3, 0x1557, 0x17F3, 0x154F, 0x17CF, 0x157F, 0x17FF, 
   0x1540, 0x17C0, 0x1554, 0x17F0, 0x154C, 0x17EA, 0x157C, 0x17FC, 
   0x1545, 0x17C5, 0x1555, 0x17F5, 0x154F, 0x17CF, 0x157F, 0x17FF, 
   0x1540, 0x17C0, 0x1554, 0x17F0, 0x156A, 0x17EA, 0x157C, 0x17FC, 
   0x1543, 0x17C3, 0x1557, 0x17F3, 0x154F, 0x17CF, 0x157F, 0x17FF, 
   0x1540, 0x17C0, 0x1554, 0x17F0, 0x154C, 0x17EA, 0x157C, 0x17FC, 
   0x1543, 0x17C3, 0x1555, 0x17F5, 0x154F, 0x17CF, 0x157F, 0x17FF, 
   0x1542, 0x17C2, 0x1556, 0x17F2, 0x156A, 0x17EA, 0x157E, 0x17FE, 
   0x1543, 0x17C3, 0x1557, 0x17F3, 0x154F, 0x17CF, 0x157F, 0x17FF, 
   0x1540, 0x17C0, 0x1554, 0x17F0, 0x154C, 0x17EA, 0x157C, 0x17FC, 
   0x1545, 0x17C5, 0x1555, 0x17F5, 0x154F, 0x17CF, 0x157F, 0x17FF, 
   0x1540, 0x17C0, 0x1554, 0x17F0, 0x156A, 0x17EA, 0x157C, 0x17FC, 
   0x1543, 0x17C3, 0x1557, 0x17F3, 0x154F, 0x17CF, 0x157F, 0x17FF, 
   0x1540, 0x17C0, 0x1554, 0x17F0, 0x154C, 0x17EA, 0x157C, 0x17FC, 
   0x1543, 0x17C3, 0x1555, 0x17F5, 0x154F, 0x17CF, 0x157F, 0x17FF, 
   0x1540, 0x17C0, 0x1554, 0x17F0, 0x156A, 0x17EA, 0x157E, 0x17FE, 
   0x1543, 0x17C3, 0x1557, 0x17F3, 0x154F, 0x17CF, 0x157F, 0x17FF, 
   0x1540, 0x17C0, 0x1554, 0x17F0, 0x154C, 0x17EA, 0x157C, 0x17FC, 
   0x1545, 0x17C5, 0x1555, 0x17F5, 0x154F, 0x17CF, 0x157F, 0x17FF, 
   0x1540, 0x17C0, 0x1554, 0x17F0, 0x156A, 0x17EA, 0x157C, 0x17FC, 
   0x1543, 0x17C3, 0x1557, 0x17F3, 0x154F, 0x17CF, 0x157F, 0x17FF, 
   0x1540, 0x17C0, 0x1554, 0x17F0, 0x154C, 0x17EA, 0x157C, 0x17FC, 
   0x1543, 0x17C3, 0x1555, 0x17F5, 0x154F, 0x17CF, 0x157F, 0x17FF, 
   0x1542, 0x17C2, 0x1556, 0x17F2, 0x156A, 0x17EA, 0x157E, 0x17FE, 
   0x1543, 0x17C3, 0x1557, 0x17F3, 0x154F, 0x17CF, 0x157F, 0x17FF, 
   0x1540, 0x17C0, 0x1554, 0x17F0, 0x154C, 0x17EA, 0x157C, 0x17FC, 
   0x1545, 0x17C5, 0x1555, 0x17F5, 0x154F, 0x17CF, 0x157F, 0x17FF, 
   0x1540, 0x17C0, 0x1554, 0x17F0, 0x156A, 0x17EA, 0x157C, 0x17FC, 
   0x1543, 0x17C3, 0x1557, 0x17F3, 0x154F, 0x17CF, 0x157F, 0x17FF, 
   0x1540, 0x17C0, 0x1554, 0x17F0, 0x154C, 0x17EA, 0x157C, 0x17FC, 
   0x1543, 0x17C3, 0x1555, 0x17F5, 0x154F, 0x17CF, 0x157F, 0x17FF, 
   0x1540, 0x17C0, 0x1554, 0x17F0, 0x156A, 0x17EA, 0x157E, 0x17FE, 
   0x1543, 0x17C3, 0x1557, 0x17F3, 0x154F, 0x17CF, 0x157F, 0x17FF, 
   0x1540, 0x17C0, 0x1554, 0x17F0, 0x154C, 0x17EA, 0x157C, 0x17FC, 
   0x1545, 0x17C5, 0x1555, 0x17F5, 0x154F, 0x17CF, 0x157F, 0x17FF, 
   0x1540, 0x17C0, 0x1554, 0x17F0, 0x156A, 0x17EA, 0x157C, 0x17FC, 
   0x1543, 0x17C3, 0x1557, 0x17F3, 0x154F, 0x17CF, 0x157F, 0x17FF, 
   0x1540, 0x17C0, 0x1554, 0x17F0, 0x154C, 0x17EA, 0x157C, 0x17FC, 
   0x1543, 0x17C3, 0x1555, 0x17F5, 0x154F, 0x17CF, 0x157F, 0x17FF, 
   0x1542, 0x17C2, 0x1556, 0x17F2, 0x156A, 0x17EA, 0x157E, 0x17FE, 
   0x1543, 0x17C3, 0x1557, 0x17F3, 0x154F, 0x17CF, 0x157F, 0x17FF, 
   0x1540, 0x17C0, 0x1554, 0x17F0, 0x154C, 0x17EA, 0x157C, 0x17FC, 
   0x1545, 0x17C5, 0x1555, 0x17F5, 0x154F, 0x17CF, 0x157F, 0x17FF, 
   0x1540, 0x17C0, 0x1554, 0x17F0, 0x156A, 0x17EA, 0x157C, 0x17FC, 
   0x1543, 0x17C3, 0x1557, 0x17F3, 0x154F, 0x17CF, 0x157F, 0x17FF, 
   0x3540, 0x33C0, 0x3554, 0x33F0, 0x354C, 0x33EA, 0x357C, 0x33FC, 
   0x3543, 0x33C3, 0x3555, 0x33F5, 0x354F, 0x33CF, 0x357F, 0x33FF, 
   0x3540, 0x33C0, 0x3554, 0x33F0, 0x356A, 0x33EA, 0x357E, 0x33FE, 
   0x3543, 0x33C3, 0x3557, 0x33F3, 0x354F, 0x33CF, 0x357F, 0x33FF, 
   0x3540, 0x33C0, 0x3554, 0x33F0, 0x354C, 0x33EA, 0x357C, 0x33FC, 
   0x3545, 0x33C5, 0x3555, 0x33F5, 0x354F, 0x33CF, 0x357F, 0x33FF, 
   0x3540, 0x33C0, 0x3554, 0x33F0, 0x356A, 0x33EA, 0x357C, 0x33FC, 
   0x3543, 0x33C3, 0x3557, 0x33F3, 0x354F, 0x33CF, 0x357F, 0x33FF, 
   0x3540, 0x33C0, 0x3554, 0x33F0, 0x354C, 0x33EA, 0x357C, 0x33FC, 
   0x3543, 0x33C3, 0x3555, 0x33F5, 0x354F, 0x33CF, 0x357F, 0x33FF, 
   0x3542, 0x33C2, 0x3556, 0x33F2, 0x356A, 0x33EA, 0x357E, 0x33FE, 
   0x3543, 0x33C3, 0x3557, 0x33F3, 0x354F, 0x33CF, 0x357F, 0x33FF, 
   0x3540, 0x33C0, 0x3554, 0x33F0, 0x354C, 0x33EA, 0x357C, 0x33FC, 
   0x3545, 0x33C5, 0x3555, 0x33F5, 0x354F, 0x33CF, 0x357F, 0x33FF, 
   0x3540, 0x33C0, 0x3554, 0x33F0, 0x356A, 0x33EA, 0x357C, 0x33FC, 
   0x3543, 0x33C3, 0x3557, 0x33F3, 0x354F, 0x33CF, 0x357F, 0x33FF, 
   0x3540, 0x33C0, 0x3554, 0x33F0, 0x354C, 0x33EA, 0x357C, 0x33FC, 
   0x3543, 0x33C3, 0x3555, 0x33F5, 0x354F, 0x33CF, 0x357F, 0x33FF, 
   0x3540, 0x33C0, 0x3554, 0x33F0, 0x356A, 0x33EA, 0x357E, 0x33FE, 
   0x3543, 0x33C3, 0x3557, 0x33F3, 0x354F, 0x33CF, 0x357F, 0x33FF, 
   0x3540, 0x33C0, 0x3554, 0x33F0, 0x354C, 0x33EA, 0x357C, 0x33FC, 
   0x3545, 0x33C5, 0x3555, 0x33F5, 0x354F, 0x33CF, 0x357F, 0x33FF, 
   0x3540, 0x33C0, 0x3554, 0x33F0, 0x356A, 0x33EA, 0x357C, 0x33FC, 
   0x3543, 0x33C3, 0x3557, 0x33F3, 0x354F, 0x33CF, 0x357F, 0x33FF, 
   0x3540, 0x33C0, 0x3554, 0x33F0, 0x354C, 0x33EA, 0x357C, 0x33FC, 
   0x3543, 0x33C3, 0x3555, 0x33F5, 0x354F, 0x33CF, 0x357F, 0x33FF, 
   0x3542, 0x33C2, 0x3556, 0x33F2, 0x356A, 0x33EA, 0x357E, 0x33FE, 
   0x3543, 0x33C3, 0x3557, 0x33F3, 0x354F, 0x33CF, 0x357F, 0x33FF, 
   0x3540, 0x33C0, 0x3554, 0x33F0, 0x354C, 0x33EA, 0x357C, 0x33FC, 
   0x3545, 0x33C5, 0x3555, 0x33F5, 0x354F, 0x33CF, 0x357F, 0x33FF, 
   0x3540, 0x33C0, 0x3554, 0x33F0, 0x356A, 0x33EA, 0x357C, 0x33FC, 
   0x3543, 0x33C3, 0x3557, 0x33F3, 0x354F, 0x33CF, 0x357F, 0x33FF, 
   0x3540, 0x33C0, 0x3554, 0x33F0, 0x354C, 0x33EA, 0x357C, 0x33FC, 
   0x3543, 0x33C3, 0x3555, 0x33F5, 0x354F, 0x33CF, 0x357F, 0x33FF, 
   0x3540, 0x33C0, 0x3554, 0x33F0, 0x356A, 0x33EA, 0x357E, 0x33FE, 
   0x3543, 0x33C3, 0x3557, 0x33F3, 0x354F, 0x33CF, 0x357F, 0x33FF, 
   0x3540, 0x33C0, 0x3554, 0x33F0, 0x354C, 0x33EA, 0x357C, 0x33FC, 
   0x3545, 0x33C5, 0x3555, 0x33F5, 0x354F, 0x33CF, 0x357F, 0x33FF, 
   0x3540, 0x33C0, 0x3554, 0x33F0, 0x356A, 0x33EA, 0x357C, 0x33FC, 
   0x3543, 0x33C3, 0x3557, 0x33F3, 0x354F, 0x33CF, 0x357F, 0x33FF, 
   0x3540, 0x33C0, 0x3554, 0x33F0, 0x354C, 0x33EA, 0x357C, 0x33FC, 
   0x3543, 0x33C3, 0x3555, 0x33F5, 0x354F, 0x33CF, 0x357F, 0x33FF, 
   0x3542, 0x33C2, 0x3556, 0x33F2, 0x356A, 0x33EA, 0x357E, 0x33FE, 
   0x3543, 0x33C3, 0x3557, 0x33F3, 0x354F, 0x33CF, 0x357F, 0x33FF, 
   0x3540, 0x33C0, 0x3554, 0x33F0, 0x354C, 0x33EA, 0x357C, 0x33FC, 
   0x3545, 0x33C5, 0x3555, 0x33F5, 0x354F, 0x33CF, 0x357F, 0x33FF, 
   0x3540, 0x33C0, 0x3554, 0x33F0, 0x356A, 0x33EA, 0x357C, 0x33FC, 
   0x3543, 0x33C3, 0x3557, 0x33F3, 0x354F, 0x33CF, 0x357F, 0x33FF, 
   0x3540, 0x33C0, 0x3554, 0x33F0, 0x354C, 0x33EA, 0x357C, 0x33FC, 
   0x3543, 0x33C3, 0x3555, 0x33F5, 0x354F, 0x33CF, 0x357F, 0x33FF, 
   0x3540, 0x33C0, 0x3554, 0x33F0, 0x356A, 0x33EA, 0x357E, 0x33FE, 
   0x3543, 0x33C3, 0x3557, 0x33F3, 0x354F, 0x33CF, 0x357F, 0x33FF, 
   0x3540, 0x33C0, 0x3554, 0x33F0, 0x354C, 0x33EA, 0x357C, 0x33FC, 
   0x3545, 0x33C5, 0x3555, 0x33F5, 0x354F, 0x33CF, 0x357F, 0x33FF, 
   0x3540, 0x33C0, 0x3554, 0x33F0, 0x356A, 0x33EA, 0x357C, 0x33FC, 
   0x3543, 0x33C3, 0x3557, 0x33F3, 0x354F, 0x33CF, 0x357F, 0x33FF, 
   0x3540, 0x33C0, 0x3554, 0x33F0, 0x354C, 0x33EA, 0x357C, 0x33FC, 
   0x3543, 0x33C3, 0x3555, 0x33F5, 0x354F, 0x33CF, 0x357F, 0x33FF, 
   0x3542, 0x33C2, 0x3556, 0x33F2, 0x356A, 0x33EA, 0x357E, 0x33FE, 
   0x3543, 0x33C3, 0x3557, 0x33F3, 0x354F, 0x33CF, 0x357F, 0x33FF, 
   0x3540, 0x33C0, 0x3554, 0x33F0, 0x354C, 0x33EA, 0x357C, 0x33FC, 
   0x3545, 0x33C5, 0x3555, 0x33F5, 0x354F, 0x33CF, 0x357F, 0x33FF, 
   0x3540, 0x33C0, 0x3554, 0x33F0, 0x356A, 0x33EA, 0x357C, 0x33FC, 
   0x3543, 0x33C3, 0x3557, 0x33F3, 0x354F, 0x33CF, 0x357F, 0x33FF, 
   0x3540, 0x33C0, 0x3554, 0x33F0, 0x354C, 0x33EA, 0x357C, 0x33FC, 
   0x3543, 0x33C3, 0x3555, 0x33F5, 0x354F, 0x33CF, 0x357F, 0x33FF, 
   0x3540, 0x33C0, 0x3554, 0x33F0, 0x356A, 0x33EA, 0x357E, 0x33FE, 
   0x3543, 0x33C3, 0x3557, 0x33F3, 0x354F, 0x33CF, 0x357F, 0x33FF, 
   0x3540, 0x33C0, 0x3554, 0x33F0, 0x354C, 0x33EA, 0x357C, 0x33FC, 
   0x3545, 0x33C5, 0x3555, 0x33F5, 0x354F, 0x33CF, 0x357F, 0x33FF, 
   0x3540, 0x33C0, 0x3554, 0x33F0, 0x356A, 0x33EA, 0x357C, 0x33FC, 
   0x3543, 0x33C3, 0x3557, 0x33F3, 0x354F, 0x33CF, 0x357F, 0x33FF, 
   0x3540, 0x33C0, 0x3554, 0x33F0, 0x354C, 0x33EA, 0x357C, 0x33FC, 
   0x3543, 0x33C3, 0x3555, 0x33F5, 0x354F, 0x33CF, 0x357F, 0x33FF, 
   0x3542, 0x33C2, 0x3556, 0x33F2, 0x356A, 0x33EA, 0x357E, 0x33FE, 
   0x3543, 0x33C3, 0x3557, 0x33F3, 0x354F, 0x33CF, 0x357F, 0x33FF, 
   0x3540, 0x33C0, 0x3554, 0x33F0, 0x354C, 0x33EA, 0x357C, 0x33FC, 
   0x3545, 0x33C5, 0x3555, 0x33F5, 0x354F, 0x33CF, 0x357F, 0x33FF, 
   0x3540, 0x33C0, 0x3554, 0x33F0, 0x356A, 0x33EA, 0x357C, 0x33FC, 
   0x3543, 0x33C3, 0x3557, 0x33F3, 0x354F, 0x33CF, 0x357F, 0x33FF, 
   0x3540, 0x33C0, 0x3554, 0x33F0, 0x354C, 0x33EA, 0x357C, 0x33FC, 
   0x3543, 0x33C3, 0x3555, 0x33F5, 0x354F, 0x33CF, 0x357F, 0x33FF, 
   0x3540, 0x33C0, 0x3554, 0x33F0, 0x356A, 0x33EA, 0x357E, 0x33FE, 
   0x3543, 0x33C3, 0x3557, 0x33F3, 0x354F, 0x33CF, 0x357F, 0x33FF, 
   0x3540, 0x33C0, 0x3554, 0x33F0, 0x354C, 0x33EA, 0x357C, 0x33FC, 
   0x3545, 0x33C5, 0x3555, 0x33F5, 0x354F, 0x33CF, 0x357F, 0x33FF, 
   0x3540, 0x33C0, 0x3554, 0x33F0, 0x356A, 0x33EA, 0x357C, 0x33FC, 
   0x3543, 0x33C3, 0x3557, 0x33F3, 0x354F, 0x33CF, 0x357F, 0x33FF, 
   0x3540, 0x33C0, 0x3554, 0x33F0, 0x354C, 0x33EA, 0x357C, 0x33FC, 
   0x3543, 0x33C3, 0x3555, 0x33F5, 0x354F, 0x33CF, 0x357F, 0x33FF, 
   0x3542, 0x33C2, 0x3556, 0x33F2, 0x356A, 0x33EA, 0x357E, 0x33FE, 
   0x3543, 0x33C3, 0x3557, 0x33F3, 0x354F, 0x33CF, 0x357F, 0x33FF, 
   0x3540, 0x33C0, 0x3554, 0x33F0, 0x354C, 0x33EA, 0x357C, 0x33FC, 
   0x3545, 0x33C5, 0x3555, 0x33F5, 0x354F, 0x33CF, 0x357F, 0x33FF, 
   0x3540, 0x33C0, 0x3554, 0x33F0, 0x356A, 0x33EA, 0x357C, 0x33FC, 
   0x3543, 0x33C3, 0x3557, 0x33F3, 0x354F, 0x33CF, 0x357F, 0x33FF, 
   0x3540, 0x33C0, 0x3554, 0x33F0, 0x354C, 0x33EA, 0x357C, 0x33FC, 
   0x3543, 0x33C3, 0x3555, 0x33F5, 0x354F, 0x33CF, 0x357F, 0x33FF, 
   0x3540, 0x33C0, 0x3554, 0x33F0, 0x356A, 0x33EA, 0x357E, 0x33FE, 
   0x3543, 0x33C3, 0x3557, 0x33F3, 0x354F, 0x33CF, 0x357F, 0x33FF, 
   0x3540, 0x33C0, 0x3554, 0x33F0, 0x354C, 0x33EA, 0x357C, 0x33FC, 
   0x3545, 0x33C5, 0x3555, 0x33F5, 0x354F, 0x33CF, 0x357F, 0x33FF, 
   0x3540, 0x33C0, 0x3554, 0x33F0, 0x356A, 0x33EA, 0x357C, 0x33FC, 
   0x3543, 0x33C3, 0x3557, 0x33F3, 0x354F, 0x33CF, 0x357F, 0x33FF, 
   0x3540, 0x33C0, 0x3554, 0x33F0, 0x354C, 0x33EA, 0x357C, 0x33FC, 
   0x3543, 0x33C3, 0x3555, 0x33F5, 0x354F, 0x33CF, 0x357F, 0x33FF, 
   0x3542, 0x33C2, 0x3556, 0x33F2, 0x356A, 0x33EA, 0x357E, 0x33FE, 
   0x3543, 0x33C3, 0x3557, 0x33F3, 0x354F, 0x33CF, 0x357F, 0x33FF, 
   0x3540, 0x33C0, 0x3554, 0x33F0, 0x354C, 0x33EA, 0x357C, 0x33FC, 
   0x3545, 0x33C5, 0x3555, 0x33F5, 0x354F, 0x33CF, 0x357F, 0x33FF, 
   0x3540, 0x33C0, 0x3554, 0x33F0, 0x356A, 0x33EA, 0x357C, 0x33FC, 
   0x3543, 0x33C3, 0x3557, 0x33F3, 0x354F, 0x33CF, 0x357F, 0x33FF, 
   0x3540, 0x33C0, 0x3554, 0x33F0, 0x354C, 0x33EA, 0x357C, 0x33FC, 
   0x3543, 0x33C3, 0x3555, 0x33F5, 0x354F, 0x33CF, 0x357F, 0x33FF, 
   0x3540, 0x33C0, 0x3554, 0x33F0, 0x356A, 0x33EA, 0x357E, 0x33FE, 
   0x3543, 0x33C3, 0x3557, 0x33F3, 0x354F, 0x33CF, 0x357F, 0x33FF, 
   0x3540, 0x33C0, 0x3554, 0x33F0, 0x354C, 0x33EA, 0x357C, 0x33FC, 
   0x3545, 0x33C5, 0x3555, 0x33F5, 0x354F, 0x33CF, 0x357F, 0x33FF, 
   0x3540, 0x33C0, 0x3554, 0x33F0, 0x356A, 0x33EA, 0x357C, 0x33FC, 
   0x3543, 0x33C3, 0x3557, 0x33F3, 0x354F, 0x33CF, 0x357F, 0x33FF, 
   0x3540, 0x33C0, 0x3554, 0x33F0, 0x354C, 0x33EA, 0x357C, 0x33FC, 
   0x3543, 0x33C3, 0x3555, 0x33F5, 0x354F, 0x33CF, 0x357F, 0x33FF, 
   0x3542, 0x33C2, 0x3556, 0x33F2, 0x356A, 0x33EA, 0x357E, 0x33FE, 
   0x3543, 0x33C3, 0x3557, 0x33F3, 0x354F, 0x33CF, 0x357F, 0x33FF, 
   0x3540, 0x33C0, 0x3554, 0x33F0, 0x354C, 0x33EA, 0x357C, 0x33FC, 
   0x3545, 0x33C5, 0x3555, 0x33F5, 0x354F, 0x33CF, 0x357F, 0x33FF, 
   0x3540, 0x33C0, 0x3554, 0x33F0, 0x356A, 0x33EA, 0x357C, 0x33FC, 
   0x3543, 0x33C3, 0x3557, 0x33F3, 0x354F, 0x33CF, 0x357F, 0x33FF, 
   0x0F00, 0x0FC0, 0x0F54, 0x0FF0, 0x0F0C, 0x0FEA, 0x0F3C, 0x0FFC, 
   0x0F03, 0x0FC3, 0x0F55, 0x0FF5, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F00, 0x0FC0, 0x0F54, 0x0FF0, 0x0F2A, 0x0FEA, 0x0F3E, 0x0FFE, 
   0x0F03, 0x0FC3, 0x0F57, 0x0FF3, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F00, 0x0FC0, 0x0F54, 0x0FF0, 0x0F0C, 0x0FEA, 0x0F3C, 0x0FFC, 
   0x0F05, 0x0FC5, 0x0F55, 0x0FF5, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F00, 0x0FC0, 0x0F54, 0x0FF0, 0x0F2A, 0x0FEA, 0x0F3C, 0x0FFC, 
   0x0F03, 0x0FC3, 0x0F57, 0x0FF3, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F00, 0x0FC0, 0x0F54, 0x0FF0, 0x0F0C, 0x0FEA, 0x0F3C, 0x0FFC, 
   0x0F03, 0x0FC3, 0x0F55, 0x0FF5, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F02, 0x0FC2, 0x0F56, 0x0FF2, 0x0F2A, 0x0FEA, 0x0F3E, 0x0FFE, 
   0x0F03, 0x0FC3, 0x0F57, 0x0FF3, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F00, 0x0FC0, 0x0F54, 0x0FF0, 0x0F0C, 0x0FEA, 0x0F3C, 0x0FFC, 
   0x0F05, 0x0FC5, 0x0F55, 0x0FF5, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F00, 0x0FC0, 0x0F54, 0x0FF0, 0x0F2A, 0x0FEA, 0x0F3C, 0x0FFC, 
   0x0F03, 0x0FC3, 0x0F57, 0x0FF3, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F00, 0x0FC0, 0x0F54, 0x0FF0, 0x0F0C, 0x0FEA, 0x0F3C, 0x0FFC, 
   0x0F03, 0x0FC3, 0x0F55, 0x0FF5, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F00, 0x0FC0, 0x0F54, 0x0FF0, 0x0F2A, 0x0FEA, 0x0F3E, 0x0FFE, 
   0x0F03, 0x0FC3, 0x0F57, 0x0FF3, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F00, 0x0FC0, 0x0F54, 0x0FF0, 0x0F0C, 0x0FEA, 0x0F3C, 0x0FFC, 
   0x0F05, 0x0FC5, 0x0F55, 0x0FF5, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F00, 0x0FC0, 0x0F54, 0x0FF0, 0x0F2A, 0x0FEA, 0x0F3C, 0x0FFC, 
   0x0F03, 0x0FC3, 0x0F57, 0x0FF3, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F00, 0x0FC0, 0x0F54, 0x0FF0, 0x0F0C, 0x0FEA, 0x0F3C, 0x0FFC, 
   0x0F03, 0x0FC3, 0x0F55, 0x0FF5, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F02, 0x0FC2, 0x0F56, 0x0FF2, 0x0F2A, 0x0FEA, 0x0F3E, 0x0FFE, 
   0x0F03, 0x0FC3, 0x0F57, 0x0FF3, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F00, 0x0FC0, 0x0F54, 0x0FF0, 0x0F0C, 0x0FEA, 0x0F3C, 0x0FFC, 
   0x0F05, 0x0FC5, 0x0F55, 0x0FF5, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F00, 0x0FC0, 0x0F54, 0x0FF0, 0x0F2A, 0x0FEA, 0x0F3C, 0x0FFC, 
   0x0F03, 0x0FC3, 0x0F57, 0x0FF3, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F00, 0x0FC0, 0x0F54, 0x0FF0, 0x0F0C, 0x0FEA, 0x0F3C, 0x0FFC, 
   0x0F03, 0x0FC3, 0x0F55, 0x0FF5, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F00, 0x0FC0, 0x0F54, 0x0FF0, 0x0F2A, 0x0FEA, 0x0F3E, 0x0FFE, 
   0x0F03, 0x0FC3, 0x0F57, 0x0FF3, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F00, 0x0FC0, 0x0F54, 0x0FF0, 0x0F0C, 0x0FEA, 0x0F3C, 0x0FFC, 
   0x0F05, 0x0FC5, 0x0F55, 0x0FF5, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F00, 0x0FC0, 0x0F54, 0x0FF0, 0x0F2A, 0x0FEA, 0x0F3C, 0x0FFC, 
   0x0F03, 0x0FC3, 0x0F57, 0x0FF3, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F00, 0x0FC0, 0x0F54, 0x0FF0, 0x0F0C, 0x0FEA, 0x0F3C, 0x0FFC, 
   0x0F03, 0x0FC3, 0x0F55, 0x0FF5, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F02, 0x0FC2, 0x0F56, 0x0FF2, 0x0F2A, 0x0FEA, 0x0F3E, 0x0FFE, 
   0x0F03, 0x0FC3, 0x0F57, 0x0FF3, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F00, 0x0FC0, 0x0F54, 0x0FF0, 0x0F0C, 0x0FEA, 0x0F3C, 0x0FFC, 
   0x0F05, 0x0FC5, 0x0F55, 0x0FF5, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F00, 0x0FC0, 0x0F54, 0x0FF0, 0x0F2A, 0x0FEA, 0x0F3C, 0x0FFC, 
   0x0F03, 0x0FC3, 0x0F57, 0x0FF3, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F00, 0x0FC0, 0x0F54, 0x0FF0, 0x0F0C, 0x0FEA, 0x0F3C, 0x0FFC, 
   0x0F03, 0x0FC3, 0x0F55, 0x0FF5, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F00, 0x0FC0, 0x0F54, 0x0FF0, 0x0F2A, 0x0FEA, 0x0F3E, 0x0FFE, 
   0x0F03, 0x0FC3, 0x0F57, 0x0FF3, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F00, 0x0FC0, 0x0F54, 0x0FF0, 0x0F0C, 0x0FEA, 0x0F3C, 0x0FFC, 
   0x0F05, 0x0FC5, 0x0F55, 0x0FF5, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F00, 0x0FC0, 0x0F54, 0x0FF0, 0x0F2A, 0x0FEA, 0x0F3C, 0x0FFC, 
   0x0F03, 0x0FC3, 0x0F57, 0x0FF3, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F00, 0x0FC0, 0x0F54, 0x0FF0, 0x0F0C, 0x0FEA, 0x0F3C, 0x0FFC, 
   0x0F03, 0x0FC3, 0x0F55, 0x0FF5, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F02, 0x0FC2, 0x0F56, 0x0FF2, 0x0F2A, 0x0FEA, 0x0F3E, 0x0FFE, 
   0x0F03, 0x0FC3, 0x0F57, 0x0FF3, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F00, 0x0FC0, 0x0F54, 0x0FF0, 0x0F0C, 0x0FEA, 0x0F3C, 0x0FFC, 
   0x0F05, 0x0FC5, 0x0F55, 0x0FF5, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F00, 0x0FC0, 0x0F54, 0x0FF0, 0x0F2A, 0x0FEA, 0x0F3C, 0x0FFC, 
   0x0F03, 0x0FC3, 0x0F57, 0x0FF3, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F00, 0x0FC0, 0x0F54, 0x0FF0, 0x0F0C, 0x0FEA, 0x0F3C, 0x0FFC, 
   0x0F03, 0x0FC3, 0x0F55, 0x0FF5, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F00, 0x0FC0, 0x0F54, 0x0FF0, 0x0F2A, 0x0FEA, 0x0F3E, 0x0FFE, 
   0x0F03, 0x0FC3, 0x0F57, 0x0FF3, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F00, 0x0FC0, 0x0F54, 0x0FF0, 0x0F0C, 0x0FEA, 0x0F3C, 0x0FFC, 
   0x0F05, 0x0FC5, 0x0F55, 0x0FF5, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F00, 0x0FC0, 0x0F54, 0x0FF0, 0x0F2A, 0x0FEA, 0x0F3C, 0x0FFC, 
   0x0F03, 0x0FC3, 0x0F57, 0x0FF3, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F00, 0x0FC0, 0x0F54, 0x0FF0, 0x0F0C, 0x0FEA, 0x0F3C, 0x0FFC, 
   0x0F03, 0x0FC3, 0x0F55, 0x0FF5, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F02, 0x0FC2, 0x0F56, 0x0FF2, 0x0F2A, 0x0FEA, 0x0F3E, 0x0FFE, 
   0x0F03, 0x0FC3, 0x0F57, 0x0FF3, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F00, 0x0FC0, 0x0F54, 0x0FF0, 0x0F0C, 0x0FEA, 0x0F3C, 0x0FFC, 
   0x0F05, 0x0FC5, 0x0F55, 0x0FF5, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F00, 0x0FC0, 0x0F54, 0x0FF0, 0x0F2A, 0x0FEA, 0x0F3C, 0x0FFC, 
   0x0F03, 0x0FC3, 0x0F57, 0x0FF3, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F00, 0x0FC0, 0x0F54, 0x0FF0, 0x0F0C, 0x0FEA, 0x0F3C, 0x0FFC, 
   0x0F03, 0x0FC3, 0x0F55, 0x0FF5, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F00, 0x0FC0, 0x0F54, 0x0FF0, 0x0F2A, 0x0FEA, 0x0F3E, 0x0FFE, 
   0x0F03, 0x0FC3, 0x0F57, 0x0FF3, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F00, 0x0FC0, 0x0F54, 0x0FF0, 0x0F0C, 0x0FEA, 0x0F3C, 0x0FFC, 
   0x0F05, 0x0FC5, 0x0F55, 0x0FF5, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F00, 0x0FC0, 0x0F54, 0x0FF0, 0x0F2A, 0x0FEA, 0x0F3C, 0x0FFC, 
   0x0F03, 0x0FC3, 0x0F57, 0x0FF3, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F00, 0x0FC0, 0x0F54, 0x0FF0, 0x0F0C, 0x0FEA, 0x0F3C, 0x0FFC, 
   0x0F03, 0x0FC3, 0x0F55, 0x0FF5, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F02, 0x0FC2, 0x0F56, 0x0FF2, 0x0F2A, 0x0FEA, 0x0F3E, 0x0FFE, 
   0x0F03, 0x0FC3, 0x0F57, 0x0FF3, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F00, 0x0FC0, 0x0F54, 0x0FF0, 0x0F0C, 0x0FEA, 0x0F3C, 0x0FFC, 
   0x0F05, 0x0FC5, 0x0F55, 0x0FF5, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F00, 0x0FC0, 0x0F54, 0x0FF0, 0x0F2A, 0x0FEA, 0x0F3C, 0x0FFC, 
   0x0F03, 0x0FC3, 0x0F57, 0x0FF3, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F00, 0x0FC0, 0x0F54, 0x0FF0, 0x0F0C, 0x0FEA, 0x0F3C, 0x0FFC, 
   0x0F03, 0x0FC3, 0x0F55, 0x0FF5, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F00, 0x0FC0, 0x0F54, 0x0FF0, 0x0F2A, 0x0FEA, 0x0F3E, 0x0FFE, 
   0x0F03, 0x0FC3, 0x0F57, 0x0FF3, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F00, 0x0FC0, 0x0F54, 0x0FF0, 0x0F0C, 0x0FEA, 0x0F3C, 0x0FFC, 
   0x0F05, 0x0FC5, 0x0F55, 0x0FF5, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F00, 0x0FC0, 0x0F54, 0x0FF0, 0x0F2A, 0x0FEA, 0x0F3C, 0x0FFC, 
   0x0F03, 0x0FC3, 0x0F57, 0x0FF3, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F00, 0x0FC0, 0x0F54, 0x0FF0, 0x0F0C, 0x0FEA, 0x0F3C, 0x0FFC, 
   0x0F03, 0x0FC3, 0x0F55, 0x0FF5, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F02, 0x0FC2, 0x0F56, 0x0FF2, 0x0F2A, 0x0FEA, 0x0F3E, 0x0FFE, 
   0x0F03, 0x0FC3, 0x0F57, 0x0FF3, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F00, 0x0FC0, 0x0F54, 0x0FF0, 0x0F0C, 0x0FEA, 0x0F3C, 0x0FFC, 
   0x0F05, 0x0FC5, 0x0F55, 0x0FF5, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F00, 0x0FC0, 0x0F54, 0x0FF0, 0x0F2A, 0x0FEA, 0x0F3C, 0x0FFC, 
   0x0F03, 0x0FC3, 0x0F57, 0x0FF3, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F00, 0x0FC0, 0x0F54, 0x0FF0, 0x0F0C, 0x0FEA, 0x0F3C, 0x0FFC, 
   0x0F03, 0x0FC3, 0x0F55, 0x0FF5, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F00, 0x0FC0, 0x0F54, 0x0FF0, 0x0F2A, 0x0FEA, 0x0F3E, 0x0FFE, 
   0x0F03, 0x0FC3, 0x0F57, 0x0FF3, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F00, 0x0FC0, 0x0F54, 0x0FF0, 0x0F0C, 0x0FEA, 0x0F3C, 0x0FFC, 
   0x0F05, 0x0FC5, 0x0F55, 0x0FF5, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F00, 0x0FC0, 0x0F54, 0x0FF0, 0x0F2A, 0x0FEA, 0x0F3C, 0x0FFC, 
   0x0F03, 0x0FC3, 0x0F57, 0x0FF3, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F00, 0x0FC0, 0x0F54, 0x0FF0, 0x0F0C, 0x0FEA, 0x0F3C, 0x0FFC, 
   0x0F03, 0x0FC3, 0x0F55, 0x0FF5, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F02, 0x0FC2, 0x0F56, 0x0FF2, 0x0F2A, 0x0FEA, 0x0F3E, 0x0FFE, 
   0x0F03, 0x0FC3, 0x0F57, 0x0FF3, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F00, 0x0FC0, 0x0F54, 0x0FF0, 0x0F0C, 0x0FEA, 0x0F3C, 0x0FFC, 
   0x0F05, 0x0FC5, 0x0F55, 0x0FF5, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F00, 0x0FC0, 0x0F54, 0x0FF0, 0x0F2A, 0x0FEA, 0x0F3C, 0x0FFC, 
   0x0F03, 0x0FC3, 0x0F57, 0x0FF3, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x2F00, 0x2FC0, 0x2F54, 0x2FF0, 0x2F0C, 0x2FEA, 0x2F3C, 0x2FFC, 
   0x2F03, 0x2FC3, 0x2F55, 0x2FF5, 0x2F0F, 0x2FCF, 0x2F3F, 0x2FFF, 
   0x2F00, 0x2FC0, 0x2F54, 0x2FF0, 0x2F2A, 0x2FEA, 0x2F3E, 0x2FFE, 
   0x2F03, 0x2FC3, 0x2F57, 0x2FF3, 0x2F0F, 0x2FCF, 0x2F3F, 0x2FFF, 
   0x2F00, 0x2FC0, 0x2F54, 0x2FF0, 0x2F0C, 0x2FEA, 0x2F3C, 0x2FFC, 
   0x2F05, 0x2FC5, 0x2F55, 0x2FF5, 0x2F0F, 0x2FCF, 0x2F3F, 0x2FFF, 
   0x2F00, 0x2FC0, 0x2F54, 0x2FF0, 0x2F2A, 0x2FEA, 0x2F3C, 0x2FFC, 
   0x2F03, 0x2FC3, 0x2F57, 0x2FF3, 0x2F0F, 0x2FCF, 0x2F3F, 0x2FFF, 
   0x2F00, 0x2FC0, 0x2F54, 0x2FF0, 0x2F0C, 0x2FEA, 0x2F3C, 0x2FFC, 
   0x2F03, 0x2FC3, 0x2F55, 0x2FF5, 0x2F0F, 0x2FCF, 0x2F3F, 0x2FFF, 
   0x2F02, 0x2FC2, 0x2F56, 0x2FF2, 0x2F2A, 0x2FEA, 0x2F3E, 0x2FFE, 
   0x2F03, 0x2FC3, 0x2F57, 0x2FF3, 0x2F0F, 0x2FCF, 0x2F3F, 0x2FFF, 
   0x2F00, 0x2FC0, 0x2F54, 0x2FF0, 0x2F0C, 0x2FEA, 0x2F3C, 0x2FFC, 
   0x2F05, 0x2FC5, 0x2F55, 0x2FF5, 0x2F0F, 0x2FCF, 0x2F3F, 0x2FFF, 
   0x2F00, 0x2FC0, 0x2F54, 0x2FF0, 0x2F2A, 0x2FEA, 0x2F3C, 0x2FFC, 
   0x2F03, 0x2FC3, 0x2F57, 0x2FF3, 0x2F0F, 0x2FCF, 0x2F3F, 0x2FFF, 
   0x2F00, 0x2FC0, 0x2F54, 0x2FF0, 0x2F0C, 0x2FEA, 0x2F3C, 0x2FFC, 
   0x2F03, 0x2FC3, 0x2F55, 0x2FF5, 0x2F0F, 0x2FCF, 0x2F3F, 0x2FFF, 
   0x2F00, 0x2FC0, 0x2F54, 0x2FF0, 0x2F2A, 0x2FEA, 0x2F3E, 0x2FFE, 
   0x2F03, 0x2FC3, 0x2F57, 0x2FF3, 0x2F0F, 0x2FCF, 0x2F3F, 0x2FFF, 
   0x2F00, 0x2FC0, 0x2F54, 0x2FF0, 0x2F0C, 0x2FEA, 0x2F3C, 0x2FFC, 
   0x2F05, 0x2FC5, 0x2F55, 0x2FF5, 0x2F0F, 0x2FCF, 0x2F3F, 0x2FFF, 
   0x2F00, 0x2FC0, 0x2F54, 0x2FF0, 0x2F2A, 0x2FEA, 0x2F3C, 0x2FFC, 
   0x2F03, 0x2FC3, 0x2F57, 0x2FF3, 0x2F0F, 0x2FCF, 0x2F3F, 0x2FFF, 
   0x2F00, 0x2FC0, 0x2F54, 0x2FF0, 0x2F0C, 0x2FEA, 0x2F3C, 0x2FFC, 
   0x2F03, 0x2FC3, 0x2F55, 0x2FF5, 0x2F0F, 0x2FCF, 0x2F3F, 0x2FFF, 
   0x2F02, 0x2FC2, 0x2F56, 0x2FF2, 0x2F2A, 0x2FEA, 0x2F3E, 0x2FFE, 
   0x2F03, 0x2FC3, 0x2F57, 0x2FF3, 0x2F0F, 0x2FCF, 0x2F3F, 0x2FFF, 
   0x2F00, 0x2FC0, 0x2F54, 0x2FF0, 0x2F0C, 0x2FEA, 0x2F3C, 0x2FFC, 
   0x2F05, 0x2FC5, 0x2F55, 0x2FF5, 0x2F0F, 0x2FCF, 0x2F3F, 0x2FFF, 
   0x2F00, 0x2FC0, 0x2F54, 0x2FF0, 0x2F2A, 0x2FEA, 0x2F3C, 0x2FFC, 
   0x2F03, 0x2FC3, 0x2F57, 0x2FF3, 0x2F0F, 0x2FCF, 0x2F3F, 0x2FFF, 
   0x2F00, 0x2FC0, 0x2F54, 0x2FF0, 0x2F0C, 0x2FEA, 0x2F3C, 0x2FFC, 
   0x2F03, 0x2FC3, 0x2F55, 0x2FF5, 0x2F0F, 0x2FCF, 0x2F3F, 0x2FFF, 
   0x2F00, 0x2FC0, 0x2F54, 0x2FF0, 0x2F2A, 0x2FEA, 0x2F3E, 0x2FFE, 
   0x2F03, 0x2FC3, 0x2F57, 0x2FF3, 0x2F0F, 0x2FCF, 0x2F3F, 0x2FFF, 
   0x2F00, 0x2FC0, 0x2F54, 0x2FF0, 0x2F0C, 0x2FEA, 0x2F3C, 0x2FFC, 
   0x2F05, 0x2FC5, 0x2F55, 0x2FF5, 0x2F0F, 0x2FCF, 0x2F3F, 0x2FFF, 
   0x2F00, 0x2FC0, 0x2F54, 0x2FF0, 0x2F2A, 0x2FEA, 0x2F3C, 0x2FFC, 
   0x2F03, 0x2FC3, 0x2F57, 0x2FF3, 0x2F0F, 0x2FCF, 0x2F3F, 0x2FFF, 
   0x2F00, 0x2FC0, 0x2F54, 0x2FF0, 0x2F0C, 0x2FEA, 0x2F3C, 0x2FFC, 
   0x2F03, 0x2FC3, 0x2F55, 0x2FF5, 0x2F0F, 0x2FCF, 0x2F3F, 0x2FFF, 
   0x2F02, 0x2FC2, 0x2F56, 0x2FF2, 0x2F2A, 0x2FEA, 0x2F3E, 0x2FFE, 
   0x2F03, 0x2FC3, 0x2F57, 0x2FF3, 0x2F0F, 0x2FCF, 0x2F3F, 0x2FFF, 
   0x2F00, 0x2FC0, 0x2F54, 0x2FF0, 0x2F0C, 0x2FEA, 0x2F3C, 0x2FFC, 
   0x2F05, 0x2FC5, 0x2F55, 0x2FF5, 0x2F0F, 0x2FCF, 0x2F3F, 0x2FFF, 
   0x2F00, 0x2FC0, 0x2F54, 0x2FF0, 0x2F2A, 0x2FEA, 0x2F3C, 0x2FFC, 
   0x2F03, 0x2FC3, 0x2F57, 0x2FF3, 0x2F0F, 0x2FCF, 0x2F3F, 0x2FFF, 
   0x2F00, 0x2FC0, 0x2F54, 0x2FF0, 0x2F0C, 0x2FEA, 0x2F3C, 0x2FFC, 
   0x2F03, 0x2FC3, 0x2F55, 0x2FF5, 0x2F0F, 0x2FCF, 0x2F3F, 0x2FFF, 
   0x2F00, 0x2FC0, 0x2F54, 0x2FF0, 0x2F2A, 0x2FEA, 0x2F3E, 0x2FFE, 
   0x2F03, 0x2FC3, 0x2F57, 0x2FF3, 0x2F0F, 0x2FCF, 0x2F3F, 0x2FFF, 
   0x2F00, 0x2FC0, 0x2F54, 0x2FF0, 0x2F0C, 0x2FEA, 0x2F3C, 0x2FFC, 
   0x2F05, 0x2FC5, 0x2F55, 0x2FF5, 0x2F0F, 0x2FCF, 0x2F3F, 0x2FFF, 
   0x2F00, 0x2FC0, 0x2F54, 0x2FF0, 0x2F2A, 0x2FEA, 0x2F3C, 0x2FFC, 
   0x2F03, 0x2FC3, 0x2F57, 0x2FF3, 0x2F0F, 0x2FCF, 0x2F3F, 0x2FFF, 
   0x2F00, 0x2FC0, 0x2F54, 0x2FF0, 0x2F0C, 0x2FEA, 0x2F3C, 0x2FFC, 
   0x2F03, 0x2FC3, 0x2F55, 0x2FF5, 0x2F0F, 0x2FCF, 0x2F3F, 0x2FFF, 
   0x2F02, 0x2FC2, 0x2F56, 0x2FF2, 0x2F2A, 0x2FEA, 0x2F3E, 0x2FFE, 
   0x2F03, 0x2FC3, 0x2F57, 0x2FF3, 0x2F0F, 0x2FCF, 0x2F3F, 0x2FFF, 
   0x2F00, 0x2FC0, 0x2F54, 0x2FF0, 0x2F0C, 0x2FEA, 0x2F3C, 0x2FFC, 
   0x2F05, 0x2FC5, 0x2F55, 0x2FF5, 0x2F0F, 0x2FCF, 0x2F3F, 0x2FFF, 
   0x2F00, 0x2FC0, 0x2F54, 0x2FF0, 0x2F2A, 0x2FEA, 0x2F3C, 0x2FFC, 
   0x2F03, 0x2FC3, 0x2F57, 0x2FF3, 0x2F0F, 0x2FCF, 0x2F3F, 0x2FFF, 
   0x0F00, 0x0FC0, 0x0F54, 0x0FF0, 0x0F0C, 0x0FEA, 0x0F3C, 0x0FFC, 
   0x0F03, 0x0FC3, 0x0F55, 0x0FF5, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F00, 0x0FC0, 0x0F54, 0x0FF0, 0x0F2A, 0x0FEA, 0x0F3E, 0x0FFE, 
   0x0F03, 0x0FC3, 0x0F57, 0x0FF3, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F00, 0x0FC0, 0x0F54, 0x0FF0, 0x0F0C, 0x0FEA, 0x0F3C, 0x0FFC, 
   0x0F05, 0x0FC5, 0x0F55, 0x0FF5, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F00, 0x0FC0, 0x0F54, 0x0FF0, 0x0F2A, 0x0FEA, 0x0F3C, 0x0FFC, 
   0x0F03, 0x0FC3, 0x0F57, 0x0FF3, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F00, 0x0FC0, 0x0F54, 0x0FF0, 0x0F0C, 0x0FEA, 0x0F3C, 0x0FFC, 
   0x0F03, 0x0FC3, 0x0F55, 0x0FF5, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F02, 0x0FC2, 0x0F56, 0x0FF2, 0x0F2A, 0x0FEA, 0x0F3E, 0x0FFE, 
   0x0F03, 0x0FC3, 0x0F57, 0x0FF3, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F00, 0x0FC0, 0x0F54, 0x0FF0, 0x0F0C, 0x0FEA, 0x0F3C, 0x0FFC, 
   0x0F05, 0x0FC5, 0x0F55, 0x0FF5, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F00, 0x0FC0, 0x0F54, 0x0FF0, 0x0F2A, 0x0FEA, 0x0F3C, 0x0FFC, 
   0x0F03, 0x0FC3, 0x0F57, 0x0FF3, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F00, 0x0FC0, 0x0F54, 0x0FF0, 0x0F0C, 0x0FEA, 0x0F3C, 0x0FFC, 
   0x0F03, 0x0FC3, 0x0F55, 0x0FF5, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F00, 0x0FC0, 0x0F54, 0x0FF0, 0x0F2A, 0x0FEA, 0x0F3E, 0x0FFE, 
   0x0F03, 0x0FC3, 0x0F57, 0x0FF3, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F00, 0x0FC0, 0x0F54, 0x0FF0, 0x0F0C, 0x0FEA, 0x0F3C, 0x0FFC, 
   0x0F05, 0x0FC5, 0x0F55, 0x0FF5, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F00, 0x0FC0, 0x0F54, 0x0FF0, 0x0F2A, 0x0FEA, 0x0F3C, 0x0FFC, 
   0x0F03, 0x0FC3, 0x0F57, 0x0FF3, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F00, 0x0FC0, 0x0F54, 0x0FF0, 0x0F0C, 0x0FEA, 0x0F3C, 0x0FFC, 
   0x0F03, 0x0FC3, 0x0F55, 0x0FF5, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F02, 0x0FC2, 0x0F56, 0x0FF2, 0x0F2A, 0x0FEA, 0x0F3E, 0x0FFE, 
   0x0F03, 0x0FC3, 0x0F57, 0x0FF3, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F00, 0x0FC0, 0x0F54, 0x0FF0, 0x0F0C, 0x0FEA, 0x0F3C, 0x0FFC, 
   0x0F05, 0x0FC5, 0x0F55, 0x0FF5, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F00, 0x0FC0, 0x0F54, 0x0FF0, 0x0F2A, 0x0FEA, 0x0F3C, 0x0FFC, 
   0x0F03, 0x0FC3, 0x0F57, 0x0FF3, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F00, 0x0FC0, 0x0F54, 0x0FF0, 0x0F0C, 0x0FEA, 0x0F3C, 0x0FFC, 
   0x0F03, 0x0FC3, 0x0F55, 0x0FF5, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F00, 0x0FC0, 0x0F54, 0x0FF0, 0x0F2A, 0x0FEA, 0x0F3E, 0x0FFE, 
   0x0F03, 0x0FC3, 0x0F57, 0x0FF3, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F00, 0x0FC0, 0x0F54, 0x0FF0, 0x0F0C, 0x0FEA, 0x0F3C, 0x0FFC, 
   0x0F05, 0x0FC5, 0x0F55, 0x0FF5, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F00, 0x0FC0, 0x0F54, 0x0FF0, 0x0F2A, 0x0FEA, 0x0F3C, 0x0FFC, 
   0x0F03, 0x0FC3, 0x0F57, 0x0FF3, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F00, 0x0FC0, 0x0F54, 0x0FF0, 0x0F0C, 0x0FEA, 0x0F3C, 0x0FFC, 
   0x0F03, 0x0FC3, 0x0F55, 0x0FF5, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F02, 0x0FC2, 0x0F56, 0x0FF2, 0x0F2A, 0x0FEA, 0x0F3E, 0x0FFE, 
   0x0F03, 0x0FC3, 0x0F57, 0x0FF3, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F00, 0x0FC0, 0x0F54, 0x0FF0, 0x0F0C, 0x0FEA, 0x0F3C, 0x0FFC, 
   0x0F05, 0x0FC5, 0x0F55, 0x0FF5, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F00, 0x0FC0, 0x0F54, 0x0FF0, 0x0F2A, 0x0FEA, 0x0F3C, 0x0FFC, 
   0x0F03, 0x0FC3, 0x0F57, 0x0FF3, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F00, 0x0FC0, 0x0F54, 0x0FF0, 0x0F0C, 0x0FEA, 0x0F3C, 0x0FFC, 
   0x0F03, 0x0FC3, 0x0F55, 0x0FF5, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F00, 0x0FC0, 0x0F54, 0x0FF0, 0x0F2A, 0x0FEA, 0x0F3E, 0x0FFE, 
   0x0F03, 0x0FC3, 0x0F57, 0x0FF3, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F00, 0x0FC0, 0x0F54, 0x0FF0, 0x0F0C, 0x0FEA, 0x0F3C, 0x0FFC, 
   0x0F05, 0x0FC5, 0x0F55, 0x0FF5, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F00, 0x0FC0, 0x0F54, 0x0FF0, 0x0F2A, 0x0FEA, 0x0F3C, 0x0FFC, 
   0x0F03, 0x0FC3, 0x0F57, 0x0FF3, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F00, 0x0FC0, 0x0F54, 0x0FF0, 0x0F0C, 0x0FEA, 0x0F3C, 0x0FFC, 
   0x0F03, 0x0FC3, 0x0F55, 0x0FF5, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F02, 0x0FC2, 0x0F56, 0x0FF2, 0x0F2A, 0x0FEA, 0x0F3E, 0x0FFE, 
   0x0F03, 0x0FC3, 0x0F57, 0x0FF3, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F00, 0x0FC0, 0x0F54, 0x0FF0, 0x0F0C, 0x0FEA, 0x0F3C, 0x0FFC, 
   0x0F05, 0x0FC5, 0x0F55, 0x0FF5, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F00, 0x0FC0, 0x0F54, 0x0FF0, 0x0F2A, 0x0FEA, 0x0F3C, 0x0FFC, 
   0x0F03, 0x0FC3, 0x0F57, 0x0FF3, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x3F00, 0x3FC0, 0x3F54, 0x3FF0, 0x3F0C, 0x3FEA, 0x3F3C, 0x3FFC, 
   0x3F03, 0x3FC3, 0x3F55, 0x3FF5, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3F54, 0x3FF0, 0x3F2A, 0x3FEA, 0x3F3E, 0x3FFE, 
   0x3F03, 0x3FC3, 0x3F57, 0x3FF3, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3F54, 0x3FF0, 0x3F0C, 0x3FEA, 0x3F3C, 0x3FFC, 
   0x3F05, 0x3FC5, 0x3F55, 0x3FF5, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3F54, 0x3FF0, 0x3F2A, 0x3FEA, 0x3F3C, 0x3FFC, 
   0x3F03, 0x3FC3, 0x3F57, 0x3FF3, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3F54, 0x3FF0, 0x3F0C, 0x3FEA, 0x3F3C, 0x3FFC, 
   0x3F03, 0x3FC3, 0x3F55, 0x3FF5, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F02, 0x3FC2, 0x3F56, 0x3FF2, 0x3F2A, 0x3FEA, 0x3F3E, 0x3FFE, 
   0x3F03, 0x3FC3, 0x3F57, 0x3FF3, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3F54, 0x3FF0, 0x3F0C, 0x3FEA, 0x3F3C, 0x3FFC, 
   0x3F05, 0x3FC5, 0x3F55, 0x3FF5, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3F54, 0x3FF0, 0x3F2A, 0x3FEA, 0x3F3C, 0x3FFC, 
   0x3F03, 0x3FC3, 0x3F57, 0x3FF3, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3F54, 0x3FF0, 0x3F0C, 0x3FEA, 0x3F3C, 0x3FFC, 
   0x3F03, 0x3FC3, 0x3F55, 0x3FF5, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3F54, 0x3FF0, 0x3F2A, 0x3FEA, 0x3F3E, 0x3FFE, 
   0x3F03, 0x3FC3, 0x3F57, 0x3FF3, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3F54, 0x3FF0, 0x3F0C, 0x3FEA, 0x3F3C, 0x3FFC, 
   0x3F05, 0x3FC5, 0x3F55, 0x3FF5, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3F54, 0x3FF0, 0x3F2A, 0x3FEA, 0x3F3C, 0x3FFC, 
   0x3F03, 0x3FC3, 0x3F57, 0x3FF3, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3F54, 0x3FF0, 0x3F0C, 0x3FEA, 0x3F3C, 0x3FFC, 
   0x3F03, 0x3FC3, 0x3F55, 0x3FF5, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F02, 0x3FC2, 0x3F56, 0x3FF2, 0x3F2A, 0x3FEA, 0x3F3E, 0x3FFE, 
   0x3F03, 0x3FC3, 0x3F57, 0x3FF3, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3F54, 0x3FF0, 0x3F0C, 0x3FEA, 0x3F3C, 0x3FFC, 
   0x3F05, 0x3FC5, 0x3F55, 0x3FF5, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3F54, 0x3FF0, 0x3F2A, 0x3FEA, 0x3F3C, 0x3FFC, 
   0x3F03, 0x3FC3, 0x3F57, 0x3FF3, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3F54, 0x3FF0, 0x3F0C, 0x3FEA, 0x3F3C, 0x3FFC, 
   0x3F03, 0x3FC3, 0x3F55, 0x3FF5, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3F54, 0x3FF0, 0x3F2A, 0x3FEA, 0x3F3E, 0x3FFE, 
   0x3F03, 0x3FC3, 0x3F57, 0x3FF3, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3F54, 0x3FF0, 0x3F0C, 0x3FEA, 0x3F3C, 0x3FFC, 
   0x3F05, 0x3FC5, 0x3F55, 0x3FF5, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3F54, 0x3FF0, 0x3F2A, 0x3FEA, 0x3F3C, 0x3FFC, 
   0x3F03, 0x3FC3, 0x3F57, 0x3FF3, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3F54, 0x3FF0, 0x3F0C, 0x3FEA, 0x3F3C, 0x3FFC, 
   0x3F03, 0x3FC3, 0x3F55, 0x3FF5, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F02, 0x3FC2, 0x3F56, 0x3FF2, 0x3F2A, 0x3FEA, 0x3F3E, 0x3FFE, 
   0x3F03, 0x3FC3, 0x3F57, 0x3FF3, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3F54, 0x3FF0, 0x3F0C, 0x3FEA, 0x3F3C, 0x3FFC, 
   0x3F05, 0x3FC5, 0x3F55, 0x3FF5, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3F54, 0x3FF0, 0x3F2A, 0x3FEA, 0x3F3C, 0x3FFC, 
   0x3F03, 0x3FC3, 0x3F57, 0x3FF3, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3F54, 0x3FF0, 0x3F0C, 0x3FEA, 0x3F3C, 0x3FFC, 
   0x3F03, 0x3FC3, 0x3F55, 0x3FF5, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3F54, 0x3FF0, 0x3F2A, 0x3FEA, 0x3F3E, 0x3FFE, 
   0x3F03, 0x3FC3, 0x3F57, 0x3FF3, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3F54, 0x3FF0, 0x3F0C, 0x3FEA, 0x3F3C, 0x3FFC, 
   0x3F05, 0x3FC5, 0x3F55, 0x3FF5, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3F54, 0x3FF0, 0x3F2A, 0x3FEA, 0x3F3C, 0x3FFC, 
   0x3F03, 0x3FC3, 0x3F57, 0x3FF3, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3F54, 0x3FF0, 0x3F0C, 0x3FEA, 0x3F3C, 0x3FFC, 
   0x3F03, 0x3FC3, 0x3F55, 0x3FF5, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F02, 0x3FC2, 0x3F56, 0x3FF2, 0x3F2A, 0x3FEA, 0x3F3E, 0x3FFE, 
   0x3F03, 0x3FC3, 0x3F57, 0x3FF3, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3F54, 0x3FF0, 0x3F0C, 0x3FEA, 0x3F3C, 0x3FFC, 
   0x3F05, 0x3FC5, 0x3F55, 0x3FF5, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3F54, 0x3FF0, 0x3F2A, 0x3FEA, 0x3F3C, 0x3FFC, 
   0x3F03, 0x3FC3, 0x3F57, 0x3FF3, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3F54, 0x3FF0, 0x3F0C, 0x3FEA, 0x3F3C, 0x3FFC, 
   0x3F03, 0x3FC3, 0x3F55, 0x3FF5, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3F54, 0x3FF0, 0x3F2A, 0x3FEA, 0x3F3E, 0x3FFE, 
   0x3F03, 0x3FC3, 0x3F57, 0x3FF3, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3F54, 0x3FF0, 0x3F0C, 0x3FEA, 0x3F3C, 0x3FFC, 
   0x3F05, 0x3FC5, 0x3F55, 0x3FF5, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3F54, 0x3FF0, 0x3F2A, 0x3FEA, 0x3F3C, 0x3FFC, 
   0x3F03, 0x3FC3, 0x3F57, 0x3FF3, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3F54, 0x3FF0, 0x3F0C, 0x3FEA, 0x3F3C, 0x3FFC, 
   0x3F03, 0x3FC3, 0x3F55, 0x3FF5, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F02, 0x3FC2, 0x3F56, 0x3FF2, 0x3F2A, 0x3FEA, 0x3F3E, 0x3FFE, 
   0x3F03, 0x3FC3, 0x3F57, 0x3FF3, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3F54, 0x3FF0, 0x3F0C, 0x3FEA, 0x3F3C, 0x3FFC, 
   0x3F05, 0x3FC5, 0x3F55, 0x3FF5, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3F54, 0x3FF0, 0x3F2A, 0x3FEA, 0x3F3C, 0x3FFC, 
   0x3F03, 0x3FC3, 0x3F57, 0x3FF3, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3F54, 0x3FF0, 0x3F0C, 0x3FEA, 0x3F3C, 0x3FFC, 
   0x3F03, 0x3FC3, 0x3F55, 0x3FF5, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3F54, 0x3FF0, 0x3F2A, 0x3FEA, 0x3F3E, 0x3FFE, 
   0x3F03, 0x3FC3, 0x3F57, 0x3FF3, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3F54, 0x3FF0, 0x3F0C, 0x3FEA, 0x3F3C, 0x3FFC, 
   0x3F05, 0x3FC5, 0x3F55, 0x3FF5, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3F54, 0x3FF0, 0x3F2A, 0x3FEA, 0x3F3C, 0x3FFC, 
   0x3F03, 0x3FC3, 0x3F57, 0x3FF3, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3F54, 0x3FF0, 0x3F0C, 0x3FEA, 0x3F3C, 0x3FFC, 
   0x3F03, 0x3FC3, 0x3F55, 0x3FF5, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F02, 0x3FC2, 0x3F56, 0x3FF2, 0x3F2A, 0x3FEA, 0x3F3E, 0x3FFE, 
   0x3F03, 0x3FC3, 0x3F57, 0x3FF3, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3F54, 0x3FF0, 0x3F0C, 0x3FEA, 0x3F3C, 0x3FFC, 
   0x3F05, 0x3FC5, 0x3F55, 0x3FF5, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3F54, 0x3FF0, 0x3F2A, 0x3FEA, 0x3F3C, 0x3FFC, 
   0x3F03, 0x3FC3, 0x3F57, 0x3FF3, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3F54, 0x3FF0, 0x3F0C, 0x3FEA, 0x3F3C, 0x3FFC, 
   0x3F03, 0x3FC3, 0x3F55, 0x3FF5, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3F54, 0x3FF0, 0x3F2A, 0x3FEA, 0x3F3E, 0x3FFE, 
   0x3F03, 0x3FC3, 0x3F57, 0x3FF3, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3F54, 0x3FF0, 0x3F0C, 0x3FEA, 0x3F3C, 0x3FFC, 
   0x3F05, 0x3FC5, 0x3F55, 0x3FF5, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3F54, 0x3FF0, 0x3F2A, 0x3FEA, 0x3F3C, 0x3FFC, 
   0x3F03, 0x3FC3, 0x3F57, 0x3FF3, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3F54, 0x3FF0, 0x3F0C, 0x3FEA, 0x3F3C, 0x3FFC, 
   0x3F03, 0x3FC3, 0x3F55, 0x3FF5, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F02, 0x3FC2, 0x3F56, 0x3FF2, 0x3F2A, 0x3FEA, 0x3F3E, 0x3FFE, 
   0x3F03, 0x3FC3, 0x3F57, 0x3FF3, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3F54, 0x3FF0, 0x3F0C, 0x3FEA, 0x3F3C, 0x3FFC, 
   0x3F05, 0x3FC5, 0x3F55, 0x3FF5, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3F54, 0x3FF0, 0x3F2A, 0x3FEA, 0x3F3C, 0x3FFC, 
   0x3F03, 0x3FC3, 0x3F57, 0x3FF3, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3F54, 0x3FF0, 0x3F0C, 0x3FEA, 0x3F3C, 0x3FFC, 
   0x3F03, 0x3FC3, 0x3F55, 0x3FF5, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3F54, 0x3FF0, 0x3F2A, 0x3FEA, 0x3F3E, 0x3FFE, 
   0x3F03, 0x3FC3, 0x3F57, 0x3FF3, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3F54, 0x3FF0, 0x3F0C, 0x3FEA, 0x3F3C, 0x3FFC, 
   0x3F05, 0x3FC5, 0x3F55, 0x3FF5, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3F54, 0x3FF0, 0x3F2A, 0x3FEA, 0x3F3C, 0x3FFC, 
   0x3F03, 0x3FC3, 0x3F57, 0x3FF3, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3F54, 0x3FF0, 0x3F0C, 0x3FEA, 0x3F3C, 0x3FFC, 
   0x3F03, 0x3FC3, 0x3F55, 0x3FF5, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F02, 0x3FC2, 0x3F56, 0x3FF2, 0x3F2A, 0x3FEA, 0x3F3E, 0x3FFE, 
   0x3F03, 0x3FC3, 0x3F57, 0x3FF3, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3F54, 0x3FF0, 0x3F0C, 0x3FEA, 0x3F3C, 0x3FFC, 
   0x3F05, 0x3FC5, 0x3F55, 0x3FF5, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3F54, 0x3FF0, 0x3F2A, 0x3FEA, 0x3F3C, 0x3FFC, 
   0x3F03, 0x3FC3, 0x3F57, 0x3FF3, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3F54, 0x3FF0, 0x3F0C, 0x3FEA, 0x3F3C, 0x3FFC, 
   0x3F03, 0x3FC3, 0x3F55, 0x3FF5, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3F54, 0x3FF0, 0x3F2A, 0x3FEA, 0x3F3E, 0x3FFE, 
   0x3F03, 0x3FC3, 0x3F57, 0x3FF3, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3F54, 0x3FF0, 0x3F0C, 0x3FEA, 0x3F3C, 0x3FFC, 
   0x3F05, 0x3FC5, 0x3F55, 0x3FF5, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3F54, 0x3FF0, 0x3F2A, 0x3FEA, 0x3F3C, 0x3FFC, 
   0x3F03, 0x3FC3, 0x3F57, 0x3FF3, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3F54, 0x3FF0, 0x3F0C, 0x3FEA, 0x3F3C, 0x3FFC, 
   0x3F03, 0x3FC3, 0x3F55, 0x3FF5, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F02, 0x3FC2, 0x3F56, 0x3FF2, 0x3F2A, 0x3FEA, 0x3F3E, 0x3FFE, 
   0x3F03, 0x3FC3, 0x3F57, 0x3FF3, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3F54, 0x3FF0, 0x3F0C, 0x3FEA, 0x3F3C, 0x3FFC, 
   0x3F05, 0x3FC5, 0x3F55, 0x3FF5, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3F54, 0x3FF0, 0x3F2A, 0x3FEA, 0x3F3C, 0x3FFC, 
   0x3F03, 0x3FC3, 0x3F57, 0x3FF3, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3F54, 0x3FF0, 0x3F0C, 0x3FEA, 0x3F3C, 0x3FFC, 
   0x3F03, 0x3FC3, 0x3F55, 0x3FF5, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3F54, 0x3FF0, 0x3F2A, 0x3FEA, 0x3F3E, 0x3FFE, 
   0x3F03, 0x3FC3, 0x3F57, 0x3FF3, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3F54, 0x3FF0, 0x3F0C, 0x3FEA, 0x3F3C, 0x3FFC, 
   0x3F05, 0x3FC5, 0x3F55, 0x3FF5, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3F54, 0x3FF0, 0x3F2A, 0x3FEA, 0x3F3C, 0x3FFC, 
   0x3F03, 0x3FC3, 0x3F57, 0x3FF3, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3F54, 0x3FF0, 0x3F0C, 0x3FEA, 0x3F3C, 0x3FFC, 
   0x3F03, 0x3FC3, 0x3F55, 0x3FF5, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F02, 0x3FC2, 0x3F56, 0x3FF2, 0x3F2A, 0x3FEA, 0x3F3E, 0x3FFE, 
   0x3F03, 0x3FC3, 0x3F57, 0x3FF3, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3F54, 0x3FF0, 0x3F0C, 0x3FEA, 0x3F3C, 0x3FFC, 
   0x3F05, 0x3FC5, 0x3F55, 0x3FF5, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3F54, 0x3FF0, 0x3F2A, 0x3FEA, 0x3F3C, 0x3FFC, 
   0x3F03, 0x3FC3, 0x3F57, 0x3FF3, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3F54, 0x3FF0, 0x3F0C, 0x3FEA, 0x3F3C, 0x3FFC, 
   0x3F03, 0x3FC3, 0x3F55, 0x3FF5, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3F54, 0x3FF0, 0x3F2A, 0x3FEA, 0x3F3E, 0x3FFE, 
   0x3F03, 0x3FC3, 0x3F57, 0x3FF3, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3F54, 0x3FF0, 0x3F0C, 0x3FEA, 0x3F3C, 0x3FFC, 
   0x3F05, 0x3FC5, 0x3F55, 0x3FF5, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3F54, 0x3FF0, 0x3F2A, 0x3FEA, 0x3F3C, 0x3FFC, 
   0x3F03, 0x3FC3, 0x3F57, 0x3FF3, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3F54, 0x3FF0, 0x3F0C, 0x3FEA, 0x3F3C, 0x3FFC, 
   0x3F03, 0x3FC3, 0x3F55, 0x3FF5, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F02, 0x3FC2, 0x3F56, 0x3FF2, 0x3F2A, 0x3FEA, 0x3F3E, 0x3FFE, 
   0x3F03, 0x3FC3, 0x3F57, 0x3FF3, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3F54, 0x3FF0, 0x3F0C, 0x3FEA, 0x3F3C, 0x3FFC, 
   0x3F05, 0x3FC5, 0x3F55, 0x3FF5, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3F54, 0x3FF0, 0x3F2A, 0x3FEA, 0x3F3C, 0x3FFC, 
   0x3F03, 0x3FC3, 0x3F57, 0x3FF3, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3F54, 0x3FF0, 0x3F0C, 0x3FEA, 0x3F3C, 0x3FFC, 
   0x3F03, 0x3FC3, 0x3F55, 0x3FF5, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3F54, 0x3FF0, 0x3F2A, 0x3FEA, 0x3F3E, 0x3FFE, 
   0x3F03, 0x3FC3, 0x3F57, 0x3FF3, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3F54, 0x3FF0, 0x3F0C, 0x3FEA, 0x3F3C, 0x3FFC, 
   0x3F05, 0x3FC5, 0x3F55, 0x3FF5, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3F54, 0x3FF0, 0x3F2A, 0x3FEA, 0x3F3C, 0x3FFC, 
   0x3F03, 0x3FC3, 0x3F57, 0x3FF3, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3F54, 0x3FF0, 0x3F0C, 0x3FEA, 0x3F3C, 0x3FFC, 
   0x3F03, 0x3FC3, 0x3F55, 0x3FF5, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F02, 0x3FC2, 0x3F56, 0x3FF2, 0x3F2A, 0x3FEA, 0x3F3E, 0x3FFE, 
   0x3F03, 0x3FC3, 0x3F57, 0x3FF3, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3F54, 0x3FF0, 0x3F0C, 0x3FEA, 0x3F3C, 0x3FFC, 
   0x3F05, 0x3FC5, 0x3F55, 0x3FF5, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3F54, 0x3FF0, 0x3F2A, 0x3FEA, 0x3F3C, 0x3FFC, 
   0x3F03, 0x3FC3, 0x3F57, 0x3FF3, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3F54, 0x3FF0, 0x3F0C, 0x3FEA, 0x3F3C, 0x3FFC, 
   0x3F03, 0x3FC3, 0x3F55, 0x3FF5, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3F54, 0x3FF0, 0x3F2A, 0x3FEA, 0x3F3E, 0x3FFE, 
   0x3F03, 0x3FC3, 0x3F57, 0x3FF3, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3F54, 0x3FF0, 0x3F0C, 0x3FEA, 0x3F3C, 0x3FFC, 
   0x3F05, 0x3FC5, 0x3F55, 0x3FF5, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3F54, 0x3FF0, 0x3F2A, 0x3FEA, 0x3F3C, 0x3FFC, 
   0x3F03, 0x3FC3, 0x3F57, 0x3FF3, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3F54, 0x3FF0, 0x3F0C, 0x3FEA, 0x3F3C, 0x3FFC, 
   0x3F03, 0x3FC3, 0x3F55, 0x3FF5, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F02, 0x3FC2, 0x3F56, 0x3FF2, 0x3F2A, 0x3FEA, 0x3F3E, 0x3FFE, 
   0x3F03, 0x3FC3, 0x3F57, 0x3FF3, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3F54, 0x3FF0, 0x3F0C, 0x3FEA, 0x3F3C, 0x3FFC, 
   0x3F05, 0x3FC5, 0x3F55, 0x3FF5, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3F54, 0x3FF0, 0x3F2A, 0x3FEA, 0x3F3C, 0x3FFC, 
   0x3F03, 0x3FC3, 0x3F57, 0x3FF3, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3F54, 0x3FF0, 0x3F0C, 0x3FEA, 0x3F3C, 0x3FFC, 
   0x3F03, 0x3FC3, 0x3F55, 0x3FF5, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3F54, 0x3FF0, 0x3F2A, 0x3FEA, 0x3F3E, 0x3FFE, 
   0x3F03, 0x3FC3, 0x3F57, 0x3FF3, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3F54, 0x3FF0, 0x3F0C, 0x3FEA, 0x3F3C, 0x3FFC, 
   0x3F05, 0x3FC5, 0x3F55, 0x3FF5, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3F54, 0x3FF0, 0x3F2A, 0x3FEA, 0x3F3C, 0x3FFC, 
   0x3F03, 0x3FC3, 0x3F57, 0x3FF3, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3F54, 0x3FF0, 0x3F0C, 0x3FEA, 0x3F3C, 0x3FFC, 
   0x3F03, 0x3FC3, 0x3F55, 0x3FF5, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F02, 0x3FC2, 0x3F56, 0x3FF2, 0x3F2A, 0x3FEA, 0x3F3E, 0x3FFE, 
   0x3F03, 0x3FC3, 0x3F57, 0x3FF3, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3F54, 0x3FF0, 0x3F0C, 0x3FEA, 0x3F3C, 0x3FFC, 
   0x3F05, 0x3FC5, 0x3F55, 0x3FF5, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3F54, 0x3FF0, 0x3F2A, 0x3FEA, 0x3F3C, 0x3FFC, 
   0x3F03, 0x3FC3, 0x3F57, 0x3FF3, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3F54, 0x3FF0, 0x3F0C, 0x3FEA, 0x3F3C, 0x3FFC, 
   0x3F03, 0x3FC3, 0x3F55, 0x3FF5, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3F54, 0x3FF0, 0x3F2A, 0x3FEA, 0x3F3E, 0x3FFE, 
   0x3F03, 0x3FC3, 0x3F57, 0x3FF3, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3F54, 0x3FF0, 0x3F0C, 0x3FEA, 0x3F3C, 0x3FFC, 
   0x3F05, 0x3FC5, 0x3F55, 0x3FF5, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3F54, 0x3FF0, 0x3F2A, 0x3FEA, 0x3F3C, 0x3FFC, 
   0x3F03, 0x3FC3, 0x3F57, 0x3FF3, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3F54, 0x3FF0, 0x3F0C, 0x3FEA, 0x3F3C, 0x3FFC, 
   0x3F03, 0x3FC3, 0x3F55, 0x3FF5, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F02, 0x3FC2, 0x3F56, 0x3FF2, 0x3F2A, 0x3FEA, 0x3F3E, 0x3FFE, 
   0x3F03, 0x3FC3, 0x3F57, 0x3FF3, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3F54, 0x3FF0, 0x3F0C, 0x3FEA, 0x3F3C, 0x3FFC, 
   0x3F05, 0x3FC5, 0x3F55, 0x3FF5, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3F54, 0x3FF0, 0x3F2A, 0x3FEA, 0x3F3C, 0x3FFC, 
   0x3F03, 0x3FC3, 0x3F57, 0x3FF3, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3F54, 0x3FF0, 0x3F0C, 0x3FEA, 0x3F3C, 0x3FFC, 
   0x3F03, 0x3FC3, 0x3F55, 0x3FF5, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3F54, 0x3FF0, 0x3F2A, 0x3FEA, 0x3F3E, 0x3FFE, 
   0x3F03, 0x3FC3, 0x3F57, 0x3FF3, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3F54, 0x3FF0, 0x3F0C, 0x3FEA, 0x3F3C, 0x3FFC, 
   0x3F05, 0x3FC5, 0x3F55, 0x3FF5, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3F54, 0x3FF0, 0x3F2A, 0x3FEA, 0x3F3C, 0x3FFC, 
   0x3F03, 0x3FC3, 0x3F57, 0x3FF3, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3F54, 0x3FF0, 0x3F0C, 0x3FEA, 0x3F3C, 0x3FFC, 
   0x3F03, 0x3FC3, 0x3F55, 0x3FF5, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F02, 0x3FC2, 0x3F56, 0x3FF2, 0x3F2A, 0x3FEA, 0x3F3E, 0x3FFE, 
   0x3F03, 0x3FC3, 0x3F57, 0x3FF3, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3F54, 0x3FF0, 0x3F0C, 0x3FEA, 0x3F3C, 0x3FFC, 
   0x3F05, 0x3FC5, 0x3F55, 0x3FF5, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3F54, 0x3FF0, 0x3F2A, 0x3FEA, 0x3F3C, 0x3FFC, 
   0x3F03, 0x3FC3, 0x3F57, 0x3FF3, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF 
};

const unsigned short color_one_to_two_bpp_odd[] = {
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x000C, 0x0155, 0x003C, 0x00FC, 
   0x0003, 0x00C3, 0x00AA, 0x00FA, 0x000F, 0x015F, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x0015, 0x0155, 0x003D, 0x00FD, 
   0x0003, 0x00C3, 0x00AB, 0x00F3, 0x000F, 0x015F, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x000C, 0x0155, 0x003C, 0x00FC, 
   0x000A, 0x00CA, 0x00AA, 0x00FA, 0x000F, 0x015F, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x0015, 0x0155, 0x003C, 0x00FC, 
   0x0003, 0x00C3, 0x00AB, 0x00F3, 0x000F, 0x015F, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x000C, 0x0155, 0x003C, 0x00FC, 
   0x0003, 0x00C3, 0x00AA, 0x00FA, 0x000F, 0x015F, 0x003F, 0x00FF, 
   0x0001, 0x00C1, 0x0031, 0x00F1, 0x0015, 0x0155, 0x003D, 0x00FD, 
   0x0003, 0x00C3, 0x00AB, 0x00F3, 0x000F, 0x015F, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x000C, 0x0155, 0x003C, 0x00FC, 
   0x000A, 0x00CA, 0x00AA, 0x00FA, 0x000F, 0x015F, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x0015, 0x0155, 0x003C, 0x00FC, 
   0x0003, 0x00C3, 0x00AB, 0x00F3, 0x000F, 0x015F, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x000C, 0x0155, 0x003C, 0x00FC, 
   0x0003, 0x00C3, 0x00AA, 0x00FA, 0x000F, 0x015F, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x0015, 0x0155, 0x003D, 0x00FD, 
   0x0003, 0x00C3, 0x00AB, 0x00F3, 0x000F, 0x015F, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x000C, 0x0155, 0x003C, 0x00FC, 
   0x000A, 0x00CA, 0x00AA, 0x00FA, 0x000F, 0x015F, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x0015, 0x0155, 0x003C, 0x00FC, 
   0x0003, 0x00C3, 0x00AB, 0x00F3, 0x000F, 0x015F, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x000C, 0x0155, 0x003C, 0x00FC, 
   0x0003, 0x00C3, 0x00AA, 0x00FA, 0x000F, 0x015F, 0x003F, 0x00FF, 
   0x0001, 0x00C1, 0x0031, 0x00F1, 0x0015, 0x0155, 0x003D, 0x00FD, 
   0x0003, 0x00C3, 0x00AB, 0x00F3, 0x000F, 0x015F, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x000C, 0x0155, 0x003C, 0x00FC, 
   0x000A, 0x00CA, 0x00AA, 0x00FA, 0x000F, 0x015F, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x0015, 0x0155, 0x003C, 0x00FC, 
   0x0003, 0x00C3, 0x00AB, 0x00F3, 0x000F, 0x015F, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x000C, 0x0155, 0x003C, 0x00FC, 
   0x0003, 0x00C3, 0x00AA, 0x00FA, 0x000F, 0x015F, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x0015, 0x0155, 0x003D, 0x00FD, 
   0x0003, 0x00C3, 0x00AB, 0x00F3, 0x000F, 0x015F, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x000C, 0x0155, 0x003C, 0x00FC, 
   0x000A, 0x00CA, 0x00AA, 0x00FA, 0x000F, 0x015F, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x0015, 0x0155, 0x003C, 0x00FC, 
   0x0003, 0x00C3, 0x00AB, 0x00F3, 0x000F, 0x015F, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x000C, 0x0155, 0x003C, 0x00FC, 
   0x0003, 0x00C3, 0x00AA, 0x00FA, 0x000F, 0x015F, 0x003F, 0x00FF, 
   0x0001, 0x00C1, 0x0031, 0x00F1, 0x0015, 0x0155, 0x003D, 0x00FD, 
   0x0003, 0x00C3, 0x00AB, 0x00F3, 0x000F, 0x015F, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x000C, 0x0155, 0x003C, 0x00FC, 
   0x000A, 0x00CA, 0x00AA, 0x00FA, 0x000F, 0x015F, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x0015, 0x0155, 0x003C, 0x00FC, 
   0x0003, 0x00C3, 0x00AB, 0x00F3, 0x000F, 0x015F, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x000C, 0x0155, 0x003C, 0x00FC, 
   0x0003, 0x00C3, 0x00AA, 0x00FA, 0x000F, 0x015F, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x0015, 0x0155, 0x003D, 0x00FD, 
   0x0003, 0x00C3, 0x00AB, 0x00F3, 0x000F, 0x015F, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x000C, 0x0155, 0x003C, 0x00FC, 
   0x000A, 0x00CA, 0x00AA, 0x00FA, 0x000F, 0x015F, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x0015, 0x0155, 0x003C, 0x00FC, 
   0x0003, 0x00C3, 0x00AB, 0x00F3, 0x000F, 0x015F, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x000C, 0x0155, 0x003C, 0x00FC, 
   0x0003, 0x00C3, 0x00AA, 0x00FA, 0x000F, 0x015F, 0x003F, 0x00FF, 
   0x0001, 0x00C1, 0x0031, 0x00F1, 0x0015, 0x0155, 0x003D, 0x00FD, 
   0x0003, 0x00C3, 0x00AB, 0x00F3, 0x000F, 0x015F, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x000C, 0x0155, 0x003C, 0x00FC, 
   0x000A, 0x00CA, 0x00AA, 0x00FA, 0x000F, 0x015F, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x0015, 0x0155, 0x003C, 0x00FC, 
   0x0003, 0x00C3, 0x00AB, 0x00F3, 0x000F, 0x015F, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x000C, 0x0155, 0x003C, 0x00FC, 
   0x0003, 0x00C3, 0x00AA, 0x00FA, 0x000F, 0x015F, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x0015, 0x0155, 0x003D, 0x00FD, 
   0x0003, 0x00C3, 0x00AB, 0x00F3, 0x000F, 0x015F, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x000C, 0x0155, 0x003C, 0x00FC, 
   0x000A, 0x00CA, 0x00AA, 0x00FA, 0x000F, 0x015F, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x0015, 0x0155, 0x003C, 0x00FC, 
   0x0003, 0x00C3, 0x00AB, 0x00F3, 0x000F, 0x015F, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x000C, 0x0155, 0x003C, 0x00FC, 
   0x0003, 0x00C3, 0x00AA, 0x00FA, 0x000F, 0x015F, 0x003F, 0x00FF, 
   0x0001, 0x00C1, 0x0031, 0x00F1, 0x0015, 0x0155, 0x003D, 0x00FD, 
   0x0003, 0x00C3, 0x00AB, 0x00F3, 0x000F, 0x015F, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x000C, 0x0155, 0x003C, 0x00FC, 
   0x000A, 0x00CA, 0x00AA, 0x00FA, 0x000F, 0x015F, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x0015, 0x0155, 0x003C, 0x00FC, 
   0x0003, 0x00C3, 0x00AB, 0x00F3, 0x000F, 0x015F, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x000C, 0x0155, 0x003C, 0x00FC, 
   0x0003, 0x00C3, 0x00AA, 0x00FA, 0x000F, 0x015F, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x0015, 0x0155, 0x003D, 0x00FD, 
   0x0003, 0x00C3, 0x00AB, 0x00F3, 0x000F, 0x015F, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x000C, 0x0155, 0x003C, 0x00FC, 
   0x000A, 0x00CA, 0x00AA, 0x00FA, 0x000F, 0x015F, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x0015, 0x0155, 0x003C, 0x00FC, 
   0x0003, 0x00C3, 0x00AB, 0x00F3, 0x000F, 0x015F, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x000C, 0x0155, 0x003C, 0x00FC, 
   0x0003, 0x00C3, 0x00AA, 0x00FA, 0x000F, 0x015F, 0x003F, 0x00FF, 
   0x0001, 0x00C1, 0x0031, 0x00F1, 0x0015, 0x0155, 0x003D, 0x00FD, 
   0x0003, 0x00C3, 0x00AB, 0x00F3, 0x000F, 0x015F, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x000C, 0x0155, 0x003C, 0x00FC, 
   0x000A, 0x00CA, 0x00AA, 0x00FA, 0x000F, 0x015F, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x0015, 0x0155, 0x003C, 0x00FC, 
   0x0003, 0x00C3, 0x00AB, 0x00F3, 0x000F, 0x015F, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x000C, 0x0155, 0x003C, 0x00FC, 
   0x0003, 0x00C3, 0x00AA, 0x00FA, 0x000F, 0x015F, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x0015, 0x0155, 0x003D, 0x00FD, 
   0x0003, 0x00C3, 0x00AB, 0x00F3, 0x000F, 0x015F, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x000C, 0x0155, 0x003C, 0x00FC, 
   0x000A, 0x00CA, 0x00AA, 0x00FA, 0x000F, 0x015F, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x0015, 0x0155, 0x003C, 0x00FC, 
   0x0003, 0x00C3, 0x00AB, 0x00F3, 0x000F, 0x015F, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x000C, 0x0155, 0x003C, 0x00FC, 
   0x0003, 0x00C3, 0x00AA, 0x00FA, 0x000F, 0x015F, 0x003F, 0x00FF, 
   0x0001, 0x00C1, 0x0031, 0x00F1, 0x0015, 0x0155, 0x003D, 0x00FD, 
   0x0003, 0x00C3, 0x00AB, 0x00F3, 0x000F, 0x015F, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x000C, 0x0155, 0x003C, 0x00FC, 
   0x000A, 0x00CA, 0x00AA, 0x00FA, 0x000F, 0x015F, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x0015, 0x0155, 0x003C, 0x00FC, 
   0x0003, 0x00C3, 0x00AB, 0x00F3, 0x000F, 0x015F, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x000C, 0x0155, 0x003C, 0x00FC, 
   0x0003, 0x00C3, 0x00AA, 0x00FA, 0x000F, 0x015F, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x0015, 0x0155, 0x003D, 0x00FD, 
   0x0003, 0x00C3, 0x00AB, 0x00F3, 0x000F, 0x015F, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x000C, 0x0155, 0x003C, 0x00FC, 
   0x000A, 0x00CA, 0x00AA, 0x00FA, 0x000F, 0x015F, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x0015, 0x0155, 0x003C, 0x00FC, 
   0x0003, 0x00C3, 0x00AB, 0x00F3, 0x000F, 0x015F, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x000C, 0x0155, 0x003C, 0x00FC, 
   0x0003, 0x00C3, 0x00AA, 0x00FA, 0x000F, 0x015F, 0x003F, 0x00FF, 
   0x0001, 0x00C1, 0x0031, 0x00F1, 0x0015, 0x0155, 0x003D, 0x00FD, 
   0x0003, 0x00C3, 0x00AB, 0x00F3, 0x000F, 0x015F, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x000C, 0x0155, 0x003C, 0x00FC, 
   0x000A, 0x00CA, 0x00AA, 0x00FA, 0x000F, 0x015F, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x0015, 0x0155, 0x003C, 0x00FC, 
   0x0003, 0x00C3, 0x00AB, 0x00F3, 0x000F, 0x015F, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x000C, 0x0155, 0x003C, 0x00FC, 
   0x0003, 0x00C3, 0x00AA, 0x00FA, 0x000F, 0x015F, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x0015, 0x0155, 0x003D, 0x00FD, 
   0x0003, 0x00C3, 0x00AB, 0x00F3, 0x000F, 0x015F, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x000C, 0x0155, 0x003C, 0x00FC, 
   0x000A, 0x00CA, 0x00AA, 0x00FA, 0x000F, 0x015F, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x0015, 0x0155, 0x003C, 0x00FC, 
   0x0003, 0x00C3, 0x00AB, 0x00F3, 0x000F, 0x015F, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x000C, 0x0155, 0x003C, 0x00FC, 
   0x0003, 0x00C3, 0x00AA, 0x00FA, 0x000F, 0x015F, 0x003F, 0x00FF, 
   0x0001, 0x00C1, 0x0031, 0x00F1, 0x0015, 0x0155, 0x003D, 0x00FD, 
   0x0003, 0x00C3, 0x00AB, 0x00F3, 0x000F, 0x015F, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x000C, 0x0155, 0x003C, 0x00FC, 
   0x000A, 0x00CA, 0x00AA, 0x00FA, 0x000F, 0x015F, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x0015, 0x0155, 0x003C, 0x00FC, 
   0x0003, 0x00C3, 0x00AB, 0x00F3, 0x000F, 0x015F, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x000C, 0x0155, 0x003C, 0x00FC, 
   0x0003, 0x00C3, 0x00AA, 0x00FA, 0x000F, 0x015F, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x0015, 0x0155, 0x003D, 0x00FD, 
   0x0003, 0x00C3, 0x00AB, 0x00F3, 0x000F, 0x015F, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x000C, 0x0155, 0x003C, 0x00FC, 
   0x000A, 0x00CA, 0x00AA, 0x00FA, 0x000F, 0x015F, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x0015, 0x0155, 0x003C, 0x00FC, 
   0x0003, 0x00C3, 0x00AB, 0x00F3, 0x000F, 0x015F, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x000C, 0x0155, 0x003C, 0x00FC, 
   0x0003, 0x00C3, 0x00AA, 0x00FA, 0x000F, 0x015F, 0x003F, 0x00FF, 
   0x0001, 0x00C1, 0x0031, 0x00F1, 0x0015, 0x0155, 0x003D, 0x00FD, 
   0x0003, 0x00C3, 0x00AB, 0x00F3, 0x000F, 0x015F, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x000C, 0x0155, 0x003C, 0x00FC, 
   0x000A, 0x00CA, 0x00AA, 0x00FA, 0x000F, 0x015F, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x0015, 0x0155, 0x003C, 0x00FC, 
   0x0003, 0x00C3, 0x00AB, 0x00F3, 0x000F, 0x015F, 0x003F, 0x00FF, 
   0x1000, 0x10C0, 0x1030, 0x10F0, 0x100C, 0x1155, 0x103C, 0x10FC, 
   0x1003, 0x10C3, 0x10AA, 0x10FA, 0x100F, 0x115F, 0x103F, 0x10FF, 
   0x1000, 0x10C0, 0x1030, 0x10F0, 0x1015, 0x1155, 0x103D, 0x10FD, 
   0x1003, 0x10C3, 0x10AB, 0x10F3, 0x100F, 0x115F, 0x103F, 0x10FF, 
   0x1000, 0x10C0, 0x1030, 0x10F0, 0x100C, 0x1155, 0x103C, 0x10FC, 
   0x100A, 0x10CA, 0x10AA, 0x10FA, 0x100F, 0x115F, 0x103F, 0x10FF, 
   0x1000, 0x10C0, 0x1030, 0x10F0, 0x1015, 0x1155, 0x103C, 0x10FC, 
   0x1003, 0x10C3, 0x10AB, 0x10F3, 0x100F, 0x115F, 0x103F, 0x10FF, 
   0x1000, 0x10C0, 0x1030, 0x10F0, 0x100C, 0x1155, 0x103C, 0x10FC, 
   0x1003, 0x10C3, 0x10AA, 0x10FA, 0x100F, 0x115F, 0x103F, 0x10FF, 
   0x1001, 0x10C1, 0x1031, 0x10F1, 0x1015, 0x1155, 0x103D, 0x10FD, 
   0x1003, 0x10C3, 0x10AB, 0x10F3, 0x100F, 0x115F, 0x103F, 0x10FF, 
   0x1000, 0x10C0, 0x1030, 0x10F0, 0x100C, 0x1155, 0x103C, 0x10FC, 
   0x100A, 0x10CA, 0x10AA, 0x10FA, 0x100F, 0x115F, 0x103F, 0x10FF, 
   0x1000, 0x10C0, 0x1030, 0x10F0, 0x1015, 0x1155, 0x103C, 0x10FC, 
   0x1003, 0x10C3, 0x10AB, 0x10F3, 0x100F, 0x115F, 0x103F, 0x10FF, 
   0x1000, 0x10C0, 0x1030, 0x10F0, 0x100C, 0x1155, 0x103C, 0x10FC, 
   0x1003, 0x10C3, 0x10AA, 0x10FA, 0x100F, 0x115F, 0x103F, 0x10FF, 
   0x1000, 0x10C0, 0x1030, 0x10F0, 0x1015, 0x1155, 0x103D, 0x10FD, 
   0x1003, 0x10C3, 0x10AB, 0x10F3, 0x100F, 0x115F, 0x103F, 0x10FF, 
   0x1000, 0x10C0, 0x1030, 0x10F0, 0x100C, 0x1155, 0x103C, 0x10FC, 
   0x100A, 0x10CA, 0x10AA, 0x10FA, 0x100F, 0x115F, 0x103F, 0x10FF, 
   0x1000, 0x10C0, 0x1030, 0x10F0, 0x1015, 0x1155, 0x103C, 0x10FC, 
   0x1003, 0x10C3, 0x10AB, 0x10F3, 0x100F, 0x115F, 0x103F, 0x10FF, 
   0x1000, 0x10C0, 0x1030, 0x10F0, 0x100C, 0x1155, 0x103C, 0x10FC, 
   0x1003, 0x10C3, 0x10AA, 0x10FA, 0x100F, 0x115F, 0x103F, 0x10FF, 
   0x1001, 0x10C1, 0x1031, 0x10F1, 0x1015, 0x1155, 0x103D, 0x10FD, 
   0x1003, 0x10C3, 0x10AB, 0x10F3, 0x100F, 0x115F, 0x103F, 0x10FF, 
   0x1000, 0x10C0, 0x1030, 0x10F0, 0x100C, 0x1155, 0x103C, 0x10FC, 
   0x100A, 0x10CA, 0x10AA, 0x10FA, 0x100F, 0x115F, 0x103F, 0x10FF, 
   0x1000, 0x10C0, 0x1030, 0x10F0, 0x1015, 0x1155, 0x103C, 0x10FC, 
   0x1003, 0x10C3, 0x10AB, 0x10F3, 0x100F, 0x115F, 0x103F, 0x10FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x000C, 0x0155, 0x003C, 0x00FC, 
   0x0003, 0x00C3, 0x00AA, 0x00FA, 0x000F, 0x015F, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x0015, 0x0155, 0x003D, 0x00FD, 
   0x0003, 0x00C3, 0x00AB, 0x00F3, 0x000F, 0x015F, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x000C, 0x0155, 0x003C, 0x00FC, 
   0x000A, 0x00CA, 0x00AA, 0x00FA, 0x000F, 0x015F, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x0015, 0x0155, 0x003C, 0x00FC, 
   0x0003, 0x00C3, 0x00AB, 0x00F3, 0x000F, 0x015F, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x000C, 0x0155, 0x003C, 0x00FC, 
   0x0003, 0x00C3, 0x00AA, 0x00FA, 0x000F, 0x015F, 0x003F, 0x00FF, 
   0x0001, 0x00C1, 0x0031, 0x00F1, 0x0015, 0x0155, 0x003D, 0x00FD, 
   0x0003, 0x00C3, 0x00AB, 0x00F3, 0x000F, 0x015F, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x000C, 0x0155, 0x003C, 0x00FC, 
   0x000A, 0x00CA, 0x00AA, 0x00FA, 0x000F, 0x015F, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x0015, 0x0155, 0x003C, 0x00FC, 
   0x0003, 0x00C3, 0x00AB, 0x00F3, 0x000F, 0x015F, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x000C, 0x0155, 0x003C, 0x00FC, 
   0x0003, 0x00C3, 0x00AA, 0x00FA, 0x000F, 0x015F, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x0015, 0x0155, 0x003D, 0x00FD, 
   0x0003, 0x00C3, 0x00AB, 0x00F3, 0x000F, 0x015F, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x000C, 0x0155, 0x003C, 0x00FC, 
   0x000A, 0x00CA, 0x00AA, 0x00FA, 0x000F, 0x015F, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x0015, 0x0155, 0x003C, 0x00FC, 
   0x0003, 0x00C3, 0x00AB, 0x00F3, 0x000F, 0x015F, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x000C, 0x0155, 0x003C, 0x00FC, 
   0x0003, 0x00C3, 0x00AA, 0x00FA, 0x000F, 0x015F, 0x003F, 0x00FF, 
   0x0001, 0x00C1, 0x0031, 0x00F1, 0x0015, 0x0155, 0x003D, 0x00FD, 
   0x0003, 0x00C3, 0x00AB, 0x00F3, 0x000F, 0x015F, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x000C, 0x0155, 0x003C, 0x00FC, 
   0x000A, 0x00CA, 0x00AA, 0x00FA, 0x000F, 0x015F, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x0015, 0x0155, 0x003C, 0x00FC, 
   0x0003, 0x00C3, 0x00AB, 0x00F3, 0x000F, 0x015F, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x000C, 0x0155, 0x003C, 0x00FC, 
   0x0003, 0x00C3, 0x00AA, 0x00FA, 0x000F, 0x015F, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x0015, 0x0155, 0x003D, 0x00FD, 
   0x0003, 0x00C3, 0x00AB, 0x00F3, 0x000F, 0x015F, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x000C, 0x0155, 0x003C, 0x00FC, 
   0x000A, 0x00CA, 0x00AA, 0x00FA, 0x000F, 0x015F, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x0015, 0x0155, 0x003C, 0x00FC, 
   0x0003, 0x00C3, 0x00AB, 0x00F3, 0x000F, 0x015F, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x000C, 0x0155, 0x003C, 0x00FC, 
   0x0003, 0x00C3, 0x00AA, 0x00FA, 0x000F, 0x015F, 0x003F, 0x00FF, 
   0x0001, 0x00C1, 0x0031, 0x00F1, 0x0015, 0x0155, 0x003D, 0x00FD, 
   0x0003, 0x00C3, 0x00AB, 0x00F3, 0x000F, 0x015F, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x000C, 0x0155, 0x003C, 0x00FC, 
   0x000A, 0x00CA, 0x00AA, 0x00FA, 0x000F, 0x015F, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x0015, 0x0155, 0x003C, 0x00FC, 
   0x0003, 0x00C3, 0x00AB, 0x00F3, 0x000F, 0x015F, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x000C, 0x0155, 0x003C, 0x00FC, 
   0x0003, 0x00C3, 0x00AA, 0x00FA, 0x000F, 0x015F, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x0015, 0x0155, 0x003D, 0x00FD, 
   0x0003, 0x00C3, 0x00AB, 0x00F3, 0x000F, 0x015F, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x000C, 0x0155, 0x003C, 0x00FC, 
   0x000A, 0x00CA, 0x00AA, 0x00FA, 0x000F, 0x015F, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x0015, 0x0155, 0x003C, 0x00FC, 
   0x0003, 0x00C3, 0x00AB, 0x00F3, 0x000F, 0x015F, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x000C, 0x0155, 0x003C, 0x00FC, 
   0x0003, 0x00C3, 0x00AA, 0x00FA, 0x000F, 0x015F, 0x003F, 0x00FF, 
   0x0001, 0x00C1, 0x0031, 0x00F1, 0x0015, 0x0155, 0x003D, 0x00FD, 
   0x0003, 0x00C3, 0x00AB, 0x00F3, 0x000F, 0x015F, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x000C, 0x0155, 0x003C, 0x00FC, 
   0x000A, 0x00CA, 0x00AA, 0x00FA, 0x000F, 0x015F, 0x003F, 0x00FF, 
   0x0000, 0x00C0, 0x0030, 0x00F0, 0x0015, 0x0155, 0x003C, 0x00FC, 
   0x0003, 0x00C3, 0x00AB, 0x00F3, 0x000F, 0x015F, 0x003F, 0x00FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x300C, 0x3155, 0x303C, 0x30FC, 
   0x3003, 0x30C3, 0x30AA, 0x30FA, 0x300F, 0x315F, 0x303F, 0x30FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x3015, 0x3155, 0x303D, 0x30FD, 
   0x3003, 0x30C3, 0x30AB, 0x30F3, 0x300F, 0x315F, 0x303F, 0x30FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x300C, 0x3155, 0x303C, 0x30FC, 
   0x300A, 0x30CA, 0x30AA, 0x30FA, 0x300F, 0x315F, 0x303F, 0x30FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x3015, 0x3155, 0x303C, 0x30FC, 
   0x3003, 0x30C3, 0x30AB, 0x30F3, 0x300F, 0x315F, 0x303F, 0x30FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x300C, 0x3155, 0x303C, 0x30FC, 
   0x3003, 0x30C3, 0x30AA, 0x30FA, 0x300F, 0x315F, 0x303F, 0x30FF, 
   0x3001, 0x30C1, 0x3031, 0x30F1, 0x3015, 0x3155, 0x303D, 0x30FD, 
   0x3003, 0x30C3, 0x30AB, 0x30F3, 0x300F, 0x315F, 0x303F, 0x30FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x300C, 0x3155, 0x303C, 0x30FC, 
   0x300A, 0x30CA, 0x30AA, 0x30FA, 0x300F, 0x315F, 0x303F, 0x30FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x3015, 0x3155, 0x303C, 0x30FC, 
   0x3003, 0x30C3, 0x30AB, 0x30F3, 0x300F, 0x315F, 0x303F, 0x30FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x300C, 0x3155, 0x303C, 0x30FC, 
   0x3003, 0x30C3, 0x30AA, 0x30FA, 0x300F, 0x315F, 0x303F, 0x30FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x3015, 0x3155, 0x303D, 0x30FD, 
   0x3003, 0x30C3, 0x30AB, 0x30F3, 0x300F, 0x315F, 0x303F, 0x30FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x300C, 0x3155, 0x303C, 0x30FC, 
   0x300A, 0x30CA, 0x30AA, 0x30FA, 0x300F, 0x315F, 0x303F, 0x30FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x3015, 0x3155, 0x303C, 0x30FC, 
   0x3003, 0x30C3, 0x30AB, 0x30F3, 0x300F, 0x315F, 0x303F, 0x30FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x300C, 0x3155, 0x303C, 0x30FC, 
   0x3003, 0x30C3, 0x30AA, 0x30FA, 0x300F, 0x315F, 0x303F, 0x30FF, 
   0x3001, 0x30C1, 0x3031, 0x30F1, 0x3015, 0x3155, 0x303D, 0x30FD, 
   0x3003, 0x30C3, 0x30AB, 0x30F3, 0x300F, 0x315F, 0x303F, 0x30FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x300C, 0x3155, 0x303C, 0x30FC, 
   0x300A, 0x30CA, 0x30AA, 0x30FA, 0x300F, 0x315F, 0x303F, 0x30FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x3015, 0x3155, 0x303C, 0x30FC, 
   0x3003, 0x30C3, 0x30AB, 0x30F3, 0x300F, 0x315F, 0x303F, 0x30FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x300C, 0x3155, 0x303C, 0x30FC, 
   0x3003, 0x30C3, 0x30AA, 0x30FA, 0x300F, 0x315F, 0x303F, 0x30FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x3015, 0x3155, 0x303D, 0x30FD, 
   0x3003, 0x30C3, 0x30AB, 0x30F3, 0x300F, 0x315F, 0x303F, 0x30FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x300C, 0x3155, 0x303C, 0x30FC, 
   0x300A, 0x30CA, 0x30AA, 0x30FA, 0x300F, 0x315F, 0x303F, 0x30FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x3015, 0x3155, 0x303C, 0x30FC, 
   0x3003, 0x30C3, 0x30AB, 0x30F3, 0x300F, 0x315F, 0x303F, 0x30FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x300C, 0x3155, 0x303C, 0x30FC, 
   0x3003, 0x30C3, 0x30AA, 0x30FA, 0x300F, 0x315F, 0x303F, 0x30FF, 
   0x3001, 0x30C1, 0x3031, 0x30F1, 0x3015, 0x3155, 0x303D, 0x30FD, 
   0x3003, 0x30C3, 0x30AB, 0x30F3, 0x300F, 0x315F, 0x303F, 0x30FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x300C, 0x3155, 0x303C, 0x30FC, 
   0x300A, 0x30CA, 0x30AA, 0x30FA, 0x300F, 0x315F, 0x303F, 0x30FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x3015, 0x3155, 0x303C, 0x30FC, 
   0x3003, 0x30C3, 0x30AB, 0x30F3, 0x300F, 0x315F, 0x303F, 0x30FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x300C, 0x3155, 0x303C, 0x30FC, 
   0x3003, 0x30C3, 0x30AA, 0x30FA, 0x300F, 0x315F, 0x303F, 0x30FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x3015, 0x3155, 0x303D, 0x30FD, 
   0x3003, 0x30C3, 0x30AB, 0x30F3, 0x300F, 0x315F, 0x303F, 0x30FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x300C, 0x3155, 0x303C, 0x30FC, 
   0x300A, 0x30CA, 0x30AA, 0x30FA, 0x300F, 0x315F, 0x303F, 0x30FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x3015, 0x3155, 0x303C, 0x30FC, 
   0x3003, 0x30C3, 0x30AB, 0x30F3, 0x300F, 0x315F, 0x303F, 0x30FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x300C, 0x3155, 0x303C, 0x30FC, 
   0x3003, 0x30C3, 0x30AA, 0x30FA, 0x300F, 0x315F, 0x303F, 0x30FF, 
   0x3001, 0x30C1, 0x3031, 0x30F1, 0x3015, 0x3155, 0x303D, 0x30FD, 
   0x3003, 0x30C3, 0x30AB, 0x30F3, 0x300F, 0x315F, 0x303F, 0x30FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x300C, 0x3155, 0x303C, 0x30FC, 
   0x300A, 0x30CA, 0x30AA, 0x30FA, 0x300F, 0x315F, 0x303F, 0x30FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x3015, 0x3155, 0x303C, 0x30FC, 
   0x3003, 0x30C3, 0x30AB, 0x30F3, 0x300F, 0x315F, 0x303F, 0x30FF, 
   0x2800, 0x28C0, 0x2830, 0x28F0, 0x280C, 0x2955, 0x283C, 0x28FC, 
   0x2803, 0x28C3, 0x28AA, 0x28FA, 0x280F, 0x295F, 0x283F, 0x28FF, 
   0x2800, 0x28C0, 0x2830, 0x28F0, 0x2815, 0x2955, 0x283D, 0x28FD, 
   0x2803, 0x28C3, 0x28AB, 0x28F3, 0x280F, 0x295F, 0x283F, 0x28FF, 
   0x2800, 0x28C0, 0x2830, 0x28F0, 0x280C, 0x2955, 0x283C, 0x28FC, 
   0x280A, 0x28CA, 0x28AA, 0x28FA, 0x280F, 0x295F, 0x283F, 0x28FF, 
   0x2800, 0x28C0, 0x2830, 0x28F0, 0x2815, 0x2955, 0x283C, 0x28FC, 
   0x2803, 0x28C3, 0x28AB, 0x28F3, 0x280F, 0x295F, 0x283F, 0x28FF, 
   0x2800, 0x28C0, 0x2830, 0x28F0, 0x280C, 0x2955, 0x283C, 0x28FC, 
   0x2803, 0x28C3, 0x28AA, 0x28FA, 0x280F, 0x295F, 0x283F, 0x28FF, 
   0x2801, 0x28C1, 0x2831, 0x28F1, 0x2815, 0x2955, 0x283D, 0x28FD, 
   0x2803, 0x28C3, 0x28AB, 0x28F3, 0x280F, 0x295F, 0x283F, 0x28FF, 
   0x2800, 0x28C0, 0x2830, 0x28F0, 0x280C, 0x2955, 0x283C, 0x28FC, 
   0x280A, 0x28CA, 0x28AA, 0x28FA, 0x280F, 0x295F, 0x283F, 0x28FF, 
   0x2800, 0x28C0, 0x2830, 0x28F0, 0x2815, 0x2955, 0x283C, 0x28FC, 
   0x2803, 0x28C3, 0x28AB, 0x28F3, 0x280F, 0x295F, 0x283F, 0x28FF, 
   0x2800, 0x28C0, 0x2830, 0x28F0, 0x280C, 0x2955, 0x283C, 0x28FC, 
   0x2803, 0x28C3, 0x28AA, 0x28FA, 0x280F, 0x295F, 0x283F, 0x28FF, 
   0x2800, 0x28C0, 0x2830, 0x28F0, 0x2815, 0x2955, 0x283D, 0x28FD, 
   0x2803, 0x28C3, 0x28AB, 0x28F3, 0x280F, 0x295F, 0x283F, 0x28FF, 
   0x2800, 0x28C0, 0x2830, 0x28F0, 0x280C, 0x2955, 0x283C, 0x28FC, 
   0x280A, 0x28CA, 0x28AA, 0x28FA, 0x280F, 0x295F, 0x283F, 0x28FF, 
   0x2800, 0x28C0, 0x2830, 0x28F0, 0x2815, 0x2955, 0x283C, 0x28FC, 
   0x2803, 0x28C3, 0x28AB, 0x28F3, 0x280F, 0x295F, 0x283F, 0x28FF, 
   0x2800, 0x28C0, 0x2830, 0x28F0, 0x280C, 0x2955, 0x283C, 0x28FC, 
   0x2803, 0x28C3, 0x28AA, 0x28FA, 0x280F, 0x295F, 0x283F, 0x28FF, 
   0x2801, 0x28C1, 0x2831, 0x28F1, 0x2815, 0x2955, 0x283D, 0x28FD, 
   0x2803, 0x28C3, 0x28AB, 0x28F3, 0x280F, 0x295F, 0x283F, 0x28FF, 
   0x2800, 0x28C0, 0x2830, 0x28F0, 0x280C, 0x2955, 0x283C, 0x28FC, 
   0x280A, 0x28CA, 0x28AA, 0x28FA, 0x280F, 0x295F, 0x283F, 0x28FF, 
   0x2800, 0x28C0, 0x2830, 0x28F0, 0x2815, 0x2955, 0x283C, 0x28FC, 
   0x2803, 0x28C3, 0x28AB, 0x28F3, 0x280F, 0x295F, 0x283F, 0x28FF, 
   0x2800, 0x28C0, 0x2830, 0x28F0, 0x280C, 0x2955, 0x283C, 0x28FC, 
   0x2803, 0x28C3, 0x28AA, 0x28FA, 0x280F, 0x295F, 0x283F, 0x28FF, 
   0x2800, 0x28C0, 0x2830, 0x28F0, 0x2815, 0x2955, 0x283D, 0x28FD, 
   0x2803, 0x28C3, 0x28AB, 0x28F3, 0x280F, 0x295F, 0x283F, 0x28FF, 
   0x2800, 0x28C0, 0x2830, 0x28F0, 0x280C, 0x2955, 0x283C, 0x28FC, 
   0x280A, 0x28CA, 0x28AA, 0x28FA, 0x280F, 0x295F, 0x283F, 0x28FF, 
   0x2800, 0x28C0, 0x2830, 0x28F0, 0x2815, 0x2955, 0x283C, 0x28FC, 
   0x2803, 0x28C3, 0x28AB, 0x28F3, 0x280F, 0x295F, 0x283F, 0x28FF, 
   0x2800, 0x28C0, 0x2830, 0x28F0, 0x280C, 0x2955, 0x283C, 0x28FC, 
   0x2803, 0x28C3, 0x28AA, 0x28FA, 0x280F, 0x295F, 0x283F, 0x28FF, 
   0x2801, 0x28C1, 0x2831, 0x28F1, 0x2815, 0x2955, 0x283D, 0x28FD, 
   0x2803, 0x28C3, 0x28AB, 0x28F3, 0x280F, 0x295F, 0x283F, 0x28FF, 
   0x2800, 0x28C0, 0x2830, 0x28F0, 0x280C, 0x2955, 0x283C, 0x28FC, 
   0x280A, 0x28CA, 0x28AA, 0x28FA, 0x280F, 0x295F, 0x283F, 0x28FF, 
   0x2800, 0x28C0, 0x2830, 0x28F0, 0x2815, 0x2955, 0x283C, 0x28FC, 
   0x2803, 0x28C3, 0x28AB, 0x28F3, 0x280F, 0x295F, 0x283F, 0x28FF, 
   0x2800, 0x28C0, 0x2830, 0x28F0, 0x280C, 0x2955, 0x283C, 0x28FC, 
   0x2803, 0x28C3, 0x28AA, 0x28FA, 0x280F, 0x295F, 0x283F, 0x28FF, 
   0x2800, 0x28C0, 0x2830, 0x28F0, 0x2815, 0x2955, 0x283D, 0x28FD, 
   0x2803, 0x28C3, 0x28AB, 0x28F3, 0x280F, 0x295F, 0x283F, 0x28FF, 
   0x2800, 0x28C0, 0x2830, 0x28F0, 0x280C, 0x2955, 0x283C, 0x28FC, 
   0x280A, 0x28CA, 0x28AA, 0x28FA, 0x280F, 0x295F, 0x283F, 0x28FF, 
   0x2800, 0x28C0, 0x2830, 0x28F0, 0x2815, 0x2955, 0x283C, 0x28FC, 
   0x2803, 0x28C3, 0x28AB, 0x28F3, 0x280F, 0x295F, 0x283F, 0x28FF, 
   0x2800, 0x28C0, 0x2830, 0x28F0, 0x280C, 0x2955, 0x283C, 0x28FC, 
   0x2803, 0x28C3, 0x28AA, 0x28FA, 0x280F, 0x295F, 0x283F, 0x28FF, 
   0x2801, 0x28C1, 0x2831, 0x28F1, 0x2815, 0x2955, 0x283D, 0x28FD, 
   0x2803, 0x28C3, 0x28AB, 0x28F3, 0x280F, 0x295F, 0x283F, 0x28FF, 
   0x2800, 0x28C0, 0x2830, 0x28F0, 0x280C, 0x2955, 0x283C, 0x28FC, 
   0x280A, 0x28CA, 0x28AA, 0x28FA, 0x280F, 0x295F, 0x283F, 0x28FF, 
   0x2800, 0x28C0, 0x2830, 0x28F0, 0x2815, 0x2955, 0x283C, 0x28FC, 
   0x2803, 0x28C3, 0x28AB, 0x28F3, 0x280F, 0x295F, 0x283F, 0x28FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x300C, 0x3155, 0x303C, 0x30FC, 
   0x3003, 0x30C3, 0x30AA, 0x30FA, 0x300F, 0x315F, 0x303F, 0x30FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x3015, 0x3155, 0x303D, 0x30FD, 
   0x3003, 0x30C3, 0x30AB, 0x30F3, 0x300F, 0x315F, 0x303F, 0x30FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x300C, 0x3155, 0x303C, 0x30FC, 
   0x300A, 0x30CA, 0x30AA, 0x30FA, 0x300F, 0x315F, 0x303F, 0x30FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x3015, 0x3155, 0x303C, 0x30FC, 
   0x3003, 0x30C3, 0x30AB, 0x30F3, 0x300F, 0x315F, 0x303F, 0x30FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x300C, 0x3155, 0x303C, 0x30FC, 
   0x3003, 0x30C3, 0x30AA, 0x30FA, 0x300F, 0x315F, 0x303F, 0x30FF, 
   0x3001, 0x30C1, 0x3031, 0x30F1, 0x3015, 0x3155, 0x303D, 0x30FD, 
   0x3003, 0x30C3, 0x30AB, 0x30F3, 0x300F, 0x315F, 0x303F, 0x30FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x300C, 0x3155, 0x303C, 0x30FC, 
   0x300A, 0x30CA, 0x30AA, 0x30FA, 0x300F, 0x315F, 0x303F, 0x30FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x3015, 0x3155, 0x303C, 0x30FC, 
   0x3003, 0x30C3, 0x30AB, 0x30F3, 0x300F, 0x315F, 0x303F, 0x30FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x300C, 0x3155, 0x303C, 0x30FC, 
   0x3003, 0x30C3, 0x30AA, 0x30FA, 0x300F, 0x315F, 0x303F, 0x30FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x3015, 0x3155, 0x303D, 0x30FD, 
   0x3003, 0x30C3, 0x30AB, 0x30F3, 0x300F, 0x315F, 0x303F, 0x30FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x300C, 0x3155, 0x303C, 0x30FC, 
   0x300A, 0x30CA, 0x30AA, 0x30FA, 0x300F, 0x315F, 0x303F, 0x30FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x3015, 0x3155, 0x303C, 0x30FC, 
   0x3003, 0x30C3, 0x30AB, 0x30F3, 0x300F, 0x315F, 0x303F, 0x30FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x300C, 0x3155, 0x303C, 0x30FC, 
   0x3003, 0x30C3, 0x30AA, 0x30FA, 0x300F, 0x315F, 0x303F, 0x30FF, 
   0x3001, 0x30C1, 0x3031, 0x30F1, 0x3015, 0x3155, 0x303D, 0x30FD, 
   0x3003, 0x30C3, 0x30AB, 0x30F3, 0x300F, 0x315F, 0x303F, 0x30FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x300C, 0x3155, 0x303C, 0x30FC, 
   0x300A, 0x30CA, 0x30AA, 0x30FA, 0x300F, 0x315F, 0x303F, 0x30FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x3015, 0x3155, 0x303C, 0x30FC, 
   0x3003, 0x30C3, 0x30AB, 0x30F3, 0x300F, 0x315F, 0x303F, 0x30FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x300C, 0x3155, 0x303C, 0x30FC, 
   0x3003, 0x30C3, 0x30AA, 0x30FA, 0x300F, 0x315F, 0x303F, 0x30FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x3015, 0x3155, 0x303D, 0x30FD, 
   0x3003, 0x30C3, 0x30AB, 0x30F3, 0x300F, 0x315F, 0x303F, 0x30FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x300C, 0x3155, 0x303C, 0x30FC, 
   0x300A, 0x30CA, 0x30AA, 0x30FA, 0x300F, 0x315F, 0x303F, 0x30FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x3015, 0x3155, 0x303C, 0x30FC, 
   0x3003, 0x30C3, 0x30AB, 0x30F3, 0x300F, 0x315F, 0x303F, 0x30FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x300C, 0x3155, 0x303C, 0x30FC, 
   0x3003, 0x30C3, 0x30AA, 0x30FA, 0x300F, 0x315F, 0x303F, 0x30FF, 
   0x3001, 0x30C1, 0x3031, 0x30F1, 0x3015, 0x3155, 0x303D, 0x30FD, 
   0x3003, 0x30C3, 0x30AB, 0x30F3, 0x300F, 0x315F, 0x303F, 0x30FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x300C, 0x3155, 0x303C, 0x30FC, 
   0x300A, 0x30CA, 0x30AA, 0x30FA, 0x300F, 0x315F, 0x303F, 0x30FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x3015, 0x3155, 0x303C, 0x30FC, 
   0x3003, 0x30C3, 0x30AB, 0x30F3, 0x300F, 0x315F, 0x303F, 0x30FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x300C, 0x3155, 0x303C, 0x30FC, 
   0x3003, 0x30C3, 0x30AA, 0x30FA, 0x300F, 0x315F, 0x303F, 0x30FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x3015, 0x3155, 0x303D, 0x30FD, 
   0x3003, 0x30C3, 0x30AB, 0x30F3, 0x300F, 0x315F, 0x303F, 0x30FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x300C, 0x3155, 0x303C, 0x30FC, 
   0x300A, 0x30CA, 0x30AA, 0x30FA, 0x300F, 0x315F, 0x303F, 0x30FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x3015, 0x3155, 0x303C, 0x30FC, 
   0x3003, 0x30C3, 0x30AB, 0x30F3, 0x300F, 0x315F, 0x303F, 0x30FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x300C, 0x3155, 0x303C, 0x30FC, 
   0x3003, 0x30C3, 0x30AA, 0x30FA, 0x300F, 0x315F, 0x303F, 0x30FF, 
   0x3001, 0x30C1, 0x3031, 0x30F1, 0x3015, 0x3155, 0x303D, 0x30FD, 
   0x3003, 0x30C3, 0x30AB, 0x30F3, 0x300F, 0x315F, 0x303F, 0x30FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x300C, 0x3155, 0x303C, 0x30FC, 
   0x300A, 0x30CA, 0x30AA, 0x30FA, 0x300F, 0x315F, 0x303F, 0x30FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x3015, 0x3155, 0x303C, 0x30FC, 
   0x3003, 0x30C3, 0x30AB, 0x30F3, 0x300F, 0x315F, 0x303F, 0x30FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x300C, 0x3155, 0x303C, 0x30FC, 
   0x3003, 0x30C3, 0x30AA, 0x30FA, 0x300F, 0x315F, 0x303F, 0x30FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x3015, 0x3155, 0x303D, 0x30FD, 
   0x3003, 0x30C3, 0x30AB, 0x30F3, 0x300F, 0x315F, 0x303F, 0x30FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x300C, 0x3155, 0x303C, 0x30FC, 
   0x300A, 0x30CA, 0x30AA, 0x30FA, 0x300F, 0x315F, 0x303F, 0x30FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x3015, 0x3155, 0x303C, 0x30FC, 
   0x3003, 0x30C3, 0x30AB, 0x30F3, 0x300F, 0x315F, 0x303F, 0x30FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x300C, 0x3155, 0x303C, 0x30FC, 
   0x3003, 0x30C3, 0x30AA, 0x30FA, 0x300F, 0x315F, 0x303F, 0x30FF, 
   0x3001, 0x30C1, 0x3031, 0x30F1, 0x3015, 0x3155, 0x303D, 0x30FD, 
   0x3003, 0x30C3, 0x30AB, 0x30F3, 0x300F, 0x315F, 0x303F, 0x30FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x300C, 0x3155, 0x303C, 0x30FC, 
   0x300A, 0x30CA, 0x30AA, 0x30FA, 0x300F, 0x315F, 0x303F, 0x30FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x3015, 0x3155, 0x303C, 0x30FC, 
   0x3003, 0x30C3, 0x30AB, 0x30F3, 0x300F, 0x315F, 0x303F, 0x30FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x300C, 0x3155, 0x303C, 0x30FC, 
   0x3003, 0x30C3, 0x30AA, 0x30FA, 0x300F, 0x315F, 0x303F, 0x30FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x3015, 0x3155, 0x303D, 0x30FD, 
   0x3003, 0x30C3, 0x30AB, 0x30F3, 0x300F, 0x315F, 0x303F, 0x30FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x300C, 0x3155, 0x303C, 0x30FC, 
   0x300A, 0x30CA, 0x30AA, 0x30FA, 0x300F, 0x315F, 0x303F, 0x30FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x3015, 0x3155, 0x303C, 0x30FC, 
   0x3003, 0x30C3, 0x30AB, 0x30F3, 0x300F, 0x315F, 0x303F, 0x30FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x300C, 0x3155, 0x303C, 0x30FC, 
   0x3003, 0x30C3, 0x30AA, 0x30FA, 0x300F, 0x315F, 0x303F, 0x30FF, 
   0x3001, 0x30C1, 0x3031, 0x30F1, 0x3015, 0x3155, 0x303D, 0x30FD, 
   0x3003, 0x30C3, 0x30AB, 0x30F3, 0x300F, 0x315F, 0x303F, 0x30FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x300C, 0x3155, 0x303C, 0x30FC, 
   0x300A, 0x30CA, 0x30AA, 0x30FA, 0x300F, 0x315F, 0x303F, 0x30FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x3015, 0x3155, 0x303C, 0x30FC, 
   0x3003, 0x30C3, 0x30AB, 0x30F3, 0x300F, 0x315F, 0x303F, 0x30FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x300C, 0x3155, 0x303C, 0x30FC, 
   0x3003, 0x30C3, 0x30AA, 0x30FA, 0x300F, 0x315F, 0x303F, 0x30FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x3015, 0x3155, 0x303D, 0x30FD, 
   0x3003, 0x30C3, 0x30AB, 0x30F3, 0x300F, 0x315F, 0x303F, 0x30FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x300C, 0x3155, 0x303C, 0x30FC, 
   0x300A, 0x30CA, 0x30AA, 0x30FA, 0x300F, 0x315F, 0x303F, 0x30FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x3015, 0x3155, 0x303C, 0x30FC, 
   0x3003, 0x30C3, 0x30AB, 0x30F3, 0x300F, 0x315F, 0x303F, 0x30FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x300C, 0x3155, 0x303C, 0x30FC, 
   0x3003, 0x30C3, 0x30AA, 0x30FA, 0x300F, 0x315F, 0x303F, 0x30FF, 
   0x3001, 0x30C1, 0x3031, 0x30F1, 0x3015, 0x3155, 0x303D, 0x30FD, 
   0x3003, 0x30C3, 0x30AB, 0x30F3, 0x300F, 0x315F, 0x303F, 0x30FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x300C, 0x3155, 0x303C, 0x30FC, 
   0x300A, 0x30CA, 0x30AA, 0x30FA, 0x300F, 0x315F, 0x303F, 0x30FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x3015, 0x3155, 0x303C, 0x30FC, 
   0x3003, 0x30C3, 0x30AB, 0x30F3, 0x300F, 0x315F, 0x303F, 0x30FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x300C, 0x3155, 0x303C, 0x30FC, 
   0x3003, 0x30C3, 0x30AA, 0x30FA, 0x300F, 0x315F, 0x303F, 0x30FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x3015, 0x3155, 0x303D, 0x30FD, 
   0x3003, 0x30C3, 0x30AB, 0x30F3, 0x300F, 0x315F, 0x303F, 0x30FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x300C, 0x3155, 0x303C, 0x30FC, 
   0x300A, 0x30CA, 0x30AA, 0x30FA, 0x300F, 0x315F, 0x303F, 0x30FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x3015, 0x3155, 0x303C, 0x30FC, 
   0x3003, 0x30C3, 0x30AB, 0x30F3, 0x300F, 0x315F, 0x303F, 0x30FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x300C, 0x3155, 0x303C, 0x30FC, 
   0x3003, 0x30C3, 0x30AA, 0x30FA, 0x300F, 0x315F, 0x303F, 0x30FF, 
   0x3001, 0x30C1, 0x3031, 0x30F1, 0x3015, 0x3155, 0x303D, 0x30FD, 
   0x3003, 0x30C3, 0x30AB, 0x30F3, 0x300F, 0x315F, 0x303F, 0x30FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x300C, 0x3155, 0x303C, 0x30FC, 
   0x300A, 0x30CA, 0x30AA, 0x30FA, 0x300F, 0x315F, 0x303F, 0x30FF, 
   0x3000, 0x30C0, 0x3030, 0x30F0, 0x3015, 0x3155, 0x303C, 0x30FC, 
   0x3003, 0x30C3, 0x30AB, 0x30F3, 0x300F, 0x315F, 0x303F, 0x30FF, 
   0x0C00, 0x1550, 0x0C30, 0x15F0, 0x0C0C, 0x1555, 0x0C3C, 0x15FC, 
   0x0C03, 0x1553, 0x0CAA, 0x15FA, 0x0C0F, 0x155F, 0x0C3F, 0x15FF, 
   0x0C00, 0x1550, 0x0C30, 0x15F0, 0x0C15, 0x1555, 0x0C3D, 0x15FD, 
   0x0C03, 0x1553, 0x0CAB, 0x15F3, 0x0C0F, 0x155F, 0x0C3F, 0x15FF, 
   0x0C00, 0x1550, 0x0C30, 0x15F0, 0x0C0C, 0x1555, 0x0C3C, 0x15FC, 
   0x0C0A, 0x155A, 0x0CAA, 0x15FA, 0x0C0F, 0x155F, 0x0C3F, 0x15FF, 
   0x0C00, 0x1550, 0x0C30, 0x15F0, 0x0C15, 0x1555, 0x0C3C, 0x15FC, 
   0x0C03, 0x1553, 0x0CAB, 0x15F3, 0x0C0F, 0x155F, 0x0C3F, 0x15FF, 
   0x0C00, 0x1550, 0x0C30, 0x15F0, 0x0C0C, 0x1555, 0x0C3C, 0x15FC, 
   0x0C03, 0x1553, 0x0CAA, 0x15FA, 0x0C0F, 0x155F, 0x0C3F, 0x15FF, 
   0x0C01, 0x1551, 0x0C31, 0x15F1, 0x0C15, 0x1555, 0x0C3D, 0x15FD, 
   0x0C03, 0x1553, 0x0CAB, 0x15F3, 0x0C0F, 0x155F, 0x0C3F, 0x15FF, 
   0x0C00, 0x1550, 0x0C30, 0x15F0, 0x0C0C, 0x1555, 0x0C3C, 0x15FC, 
   0x0C0A, 0x155A, 0x0CAA, 0x15FA, 0x0C0F, 0x155F, 0x0C3F, 0x15FF, 
   0x0C00, 0x1550, 0x0C30, 0x15F0, 0x0C15, 0x1555, 0x0C3C, 0x15FC, 
   0x0C03, 0x1553, 0x0CAB, 0x15F3, 0x0C0F, 0x155F, 0x0C3F, 0x15FF, 
   0x0C00, 0x1550, 0x0C30, 0x15F0, 0x0C0C, 0x1555, 0x0C3C, 0x15FC, 
   0x0C03, 0x1553, 0x0CAA, 0x15FA, 0x0C0F, 0x155F, 0x0C3F, 0x15FF, 
   0x0C00, 0x1550, 0x0C30, 0x15F0, 0x0C15, 0x1555, 0x0C3D, 0x15FD, 
   0x0C03, 0x1553, 0x0CAB, 0x15F3, 0x0C0F, 0x155F, 0x0C3F, 0x15FF, 
   0x0C00, 0x1550, 0x0C30, 0x15F0, 0x0C0C, 0x1555, 0x0C3C, 0x15FC, 
   0x0C0A, 0x155A, 0x0CAA, 0x15FA, 0x0C0F, 0x155F, 0x0C3F, 0x15FF, 
   0x0C00, 0x1550, 0x0C30, 0x15F0, 0x0C15, 0x1555, 0x0C3C, 0x15FC, 
   0x0C03, 0x1553, 0x0CAB, 0x15F3, 0x0C0F, 0x155F, 0x0C3F, 0x15FF, 
   0x0C00, 0x1550, 0x0C30, 0x15F0, 0x0C0C, 0x1555, 0x0C3C, 0x15FC, 
   0x0C03, 0x1553, 0x0CAA, 0x15FA, 0x0C0F, 0x155F, 0x0C3F, 0x15FF, 
   0x0C01, 0x1551, 0x0C31, 0x15F1, 0x0C15, 0x1555, 0x0C3D, 0x15FD, 
   0x0C03, 0x1553, 0x0CAB, 0x15F3, 0x0C0F, 0x155F, 0x0C3F, 0x15FF, 
   0x0C00, 0x1550, 0x0C30, 0x15F0, 0x0C0C, 0x1555, 0x0C3C, 0x15FC, 
   0x0C0A, 0x155A, 0x0CAA, 0x15FA, 0x0C0F, 0x155F, 0x0C3F, 0x15FF, 
   0x0C00, 0x1550, 0x0C30, 0x15F0, 0x0C15, 0x1555, 0x0C3C, 0x15FC, 
   0x0C03, 0x1553, 0x0CAB, 0x15F3, 0x0C0F, 0x155F, 0x0C3F, 0x15FF, 
   0x0C00, 0x1550, 0x0C30, 0x15F0, 0x0C0C, 0x1555, 0x0C3C, 0x15FC, 
   0x0C03, 0x1553, 0x0CAA, 0x15FA, 0x0C0F, 0x155F, 0x0C3F, 0x15FF, 
   0x0C00, 0x1550, 0x0C30, 0x15F0, 0x0C15, 0x1555, 0x0C3D, 0x15FD, 
   0x0C03, 0x1553, 0x0CAB, 0x15F3, 0x0C0F, 0x155F, 0x0C3F, 0x15FF, 
   0x0C00, 0x1550, 0x0C30, 0x15F0, 0x0C0C, 0x1555, 0x0C3C, 0x15FC, 
   0x0C0A, 0x155A, 0x0CAA, 0x15FA, 0x0C0F, 0x155F, 0x0C3F, 0x15FF, 
   0x0C00, 0x1550, 0x0C30, 0x15F0, 0x0C15, 0x1555, 0x0C3C, 0x15FC, 
   0x0C03, 0x1553, 0x0CAB, 0x15F3, 0x0C0F, 0x155F, 0x0C3F, 0x15FF, 
   0x0C00, 0x1550, 0x0C30, 0x15F0, 0x0C0C, 0x1555, 0x0C3C, 0x15FC, 
   0x0C03, 0x1553, 0x0CAA, 0x15FA, 0x0C0F, 0x155F, 0x0C3F, 0x15FF, 
   0x0C01, 0x1551, 0x0C31, 0x15F1, 0x0C15, 0x1555, 0x0C3D, 0x15FD, 
   0x0C03, 0x1553, 0x0CAB, 0x15F3, 0x0C0F, 0x155F, 0x0C3F, 0x15FF, 
   0x0C00, 0x1550, 0x0C30, 0x15F0, 0x0C0C, 0x1555, 0x0C3C, 0x15FC, 
   0x0C0A, 0x155A, 0x0CAA, 0x15FA, 0x0C0F, 0x155F, 0x0C3F, 0x15FF, 
   0x0C00, 0x1550, 0x0C30, 0x15F0, 0x0C15, 0x1555, 0x0C3C, 0x15FC, 
   0x0C03, 0x1553, 0x0CAB, 0x15F3, 0x0C0F, 0x155F, 0x0C3F, 0x15FF, 
   0x0C00, 0x1550, 0x0C30, 0x15F0, 0x0C0C, 0x1555, 0x0C3C, 0x15FC, 
   0x0C03, 0x1553, 0x0CAA, 0x15FA, 0x0C0F, 0x155F, 0x0C3F, 0x15FF, 
   0x0C00, 0x1550, 0x0C30, 0x15F0, 0x0C15, 0x1555, 0x0C3D, 0x15FD, 
   0x0C03, 0x1553, 0x0CAB, 0x15F3, 0x0C0F, 0x155F, 0x0C3F, 0x15FF, 
   0x0C00, 0x1550, 0x0C30, 0x15F0, 0x0C0C, 0x1555, 0x0C3C, 0x15FC, 
   0x0C0A, 0x155A, 0x0CAA, 0x15FA, 0x0C0F, 0x155F, 0x0C3F, 0x15FF, 
   0x0C00, 0x1550, 0x0C30, 0x15F0, 0x0C15, 0x1555, 0x0C3C, 0x15FC, 
   0x0C03, 0x1553, 0x0CAB, 0x15F3, 0x0C0F, 0x155F, 0x0C3F, 0x15FF, 
   0x0C00, 0x1550, 0x0C30, 0x15F0, 0x0C0C, 0x1555, 0x0C3C, 0x15FC, 
   0x0C03, 0x1553, 0x0CAA, 0x15FA, 0x0C0F, 0x155F, 0x0C3F, 0x15FF, 
   0x0C01, 0x1551, 0x0C31, 0x15F1, 0x0C15, 0x1555, 0x0C3D, 0x15FD, 
   0x0C03, 0x1553, 0x0CAB, 0x15F3, 0x0C0F, 0x155F, 0x0C3F, 0x15FF, 
   0x0C00, 0x1550, 0x0C30, 0x15F0, 0x0C0C, 0x1555, 0x0C3C, 0x15FC, 
   0x0C0A, 0x155A, 0x0CAA, 0x15FA, 0x0C0F, 0x155F, 0x0C3F, 0x15FF, 
   0x0C00, 0x1550, 0x0C30, 0x15F0, 0x0C15, 0x1555, 0x0C3C, 0x15FC, 
   0x0C03, 0x1553, 0x0CAB, 0x15F3, 0x0C0F, 0x155F, 0x0C3F, 0x15FF, 
   0x0C00, 0x1550, 0x0C30, 0x15F0, 0x0C0C, 0x1555, 0x0C3C, 0x15FC, 
   0x0C03, 0x1553, 0x0CAA, 0x15FA, 0x0C0F, 0x155F, 0x0C3F, 0x15FF, 
   0x0C00, 0x1550, 0x0C30, 0x15F0, 0x0C15, 0x1555, 0x0C3D, 0x15FD, 
   0x0C03, 0x1553, 0x0CAB, 0x15F3, 0x0C0F, 0x155F, 0x0C3F, 0x15FF, 
   0x0C00, 0x1550, 0x0C30, 0x15F0, 0x0C0C, 0x1555, 0x0C3C, 0x15FC, 
   0x0C0A, 0x155A, 0x0CAA, 0x15FA, 0x0C0F, 0x155F, 0x0C3F, 0x15FF, 
   0x0C00, 0x1550, 0x0C30, 0x15F0, 0x0C15, 0x1555, 0x0C3C, 0x15FC, 
   0x0C03, 0x1553, 0x0CAB, 0x15F3, 0x0C0F, 0x155F, 0x0C3F, 0x15FF, 
   0x0C00, 0x1550, 0x0C30, 0x15F0, 0x0C0C, 0x1555, 0x0C3C, 0x15FC, 
   0x0C03, 0x1553, 0x0CAA, 0x15FA, 0x0C0F, 0x155F, 0x0C3F, 0x15FF, 
   0x0C01, 0x1551, 0x0C31, 0x15F1, 0x0C15, 0x1555, 0x0C3D, 0x15FD, 
   0x0C03, 0x1553, 0x0CAB, 0x15F3, 0x0C0F, 0x155F, 0x0C3F, 0x15FF, 
   0x0C00, 0x1550, 0x0C30, 0x15F0, 0x0C0C, 0x1555, 0x0C3C, 0x15FC, 
   0x0C0A, 0x155A, 0x0CAA, 0x15FA, 0x0C0F, 0x155F, 0x0C3F, 0x15FF, 
   0x0C00, 0x1550, 0x0C30, 0x15F0, 0x0C15, 0x1555, 0x0C3C, 0x15FC, 
   0x0C03, 0x1553, 0x0CAB, 0x15F3, 0x0C0F, 0x155F, 0x0C3F, 0x15FF, 
   0x0C00, 0x1550, 0x0C30, 0x15F0, 0x0C0C, 0x1555, 0x0C3C, 0x15FC, 
   0x0C03, 0x1553, 0x0CAA, 0x15FA, 0x0C0F, 0x155F, 0x0C3F, 0x15FF, 
   0x0C00, 0x1550, 0x0C30, 0x15F0, 0x0C15, 0x1555, 0x0C3D, 0x15FD, 
   0x0C03, 0x1553, 0x0CAB, 0x15F3, 0x0C0F, 0x155F, 0x0C3F, 0x15FF, 
   0x0C00, 0x1550, 0x0C30, 0x15F0, 0x0C0C, 0x1555, 0x0C3C, 0x15FC, 
   0x0C0A, 0x155A, 0x0CAA, 0x15FA, 0x0C0F, 0x155F, 0x0C3F, 0x15FF, 
   0x0C00, 0x1550, 0x0C30, 0x15F0, 0x0C15, 0x1555, 0x0C3C, 0x15FC, 
   0x0C03, 0x1553, 0x0CAB, 0x15F3, 0x0C0F, 0x155F, 0x0C3F, 0x15FF, 
   0x0C00, 0x1550, 0x0C30, 0x15F0, 0x0C0C, 0x1555, 0x0C3C, 0x15FC, 
   0x0C03, 0x1553, 0x0CAA, 0x15FA, 0x0C0F, 0x155F, 0x0C3F, 0x15FF, 
   0x0C01, 0x1551, 0x0C31, 0x15F1, 0x0C15, 0x1555, 0x0C3D, 0x15FD, 
   0x0C03, 0x1553, 0x0CAB, 0x15F3, 0x0C0F, 0x155F, 0x0C3F, 0x15FF, 
   0x0C00, 0x1550, 0x0C30, 0x15F0, 0x0C0C, 0x1555, 0x0C3C, 0x15FC, 
   0x0C0A, 0x155A, 0x0CAA, 0x15FA, 0x0C0F, 0x155F, 0x0C3F, 0x15FF, 
   0x0C00, 0x1550, 0x0C30, 0x15F0, 0x0C15, 0x1555, 0x0C3C, 0x15FC, 
   0x0C03, 0x1553, 0x0CAB, 0x15F3, 0x0C0F, 0x155F, 0x0C3F, 0x15FF, 
   0x0C00, 0x1550, 0x0C30, 0x15F0, 0x0C0C, 0x1555, 0x0C3C, 0x15FC, 
   0x0C03, 0x1553, 0x0CAA, 0x15FA, 0x0C0F, 0x155F, 0x0C3F, 0x15FF, 
   0x0C00, 0x1550, 0x0C30, 0x15F0, 0x0C15, 0x1555, 0x0C3D, 0x15FD, 
   0x0C03, 0x1553, 0x0CAB, 0x15F3, 0x0C0F, 0x155F, 0x0C3F, 0x15FF, 
   0x0C00, 0x1550, 0x0C30, 0x15F0, 0x0C0C, 0x1555, 0x0C3C, 0x15FC, 
   0x0C0A, 0x155A, 0x0CAA, 0x15FA, 0x0C0F, 0x155F, 0x0C3F, 0x15FF, 
   0x0C00, 0x1550, 0x0C30, 0x15F0, 0x0C15, 0x1555, 0x0C3C, 0x15FC, 
   0x0C03, 0x1553, 0x0CAB, 0x15F3, 0x0C0F, 0x155F, 0x0C3F, 0x15FF, 
   0x0C00, 0x1550, 0x0C30, 0x15F0, 0x0C0C, 0x1555, 0x0C3C, 0x15FC, 
   0x0C03, 0x1553, 0x0CAA, 0x15FA, 0x0C0F, 0x155F, 0x0C3F, 0x15FF, 
   0x0C01, 0x1551, 0x0C31, 0x15F1, 0x0C15, 0x1555, 0x0C3D, 0x15FD, 
   0x0C03, 0x1553, 0x0CAB, 0x15F3, 0x0C0F, 0x155F, 0x0C3F, 0x15FF, 
   0x0C00, 0x1550, 0x0C30, 0x15F0, 0x0C0C, 0x1555, 0x0C3C, 0x15FC, 
   0x0C0A, 0x155A, 0x0CAA, 0x15FA, 0x0C0F, 0x155F, 0x0C3F, 0x15FF, 
   0x0C00, 0x1550, 0x0C30, 0x15F0, 0x0C15, 0x1555, 0x0C3C, 0x15FC, 
   0x0C03, 0x1553, 0x0CAB, 0x15F3, 0x0C0F, 0x155F, 0x0C3F, 0x15FF, 
   0x0C00, 0x1550, 0x0C30, 0x15F0, 0x0C0C, 0x1555, 0x0C3C, 0x15FC, 
   0x0C03, 0x1553, 0x0CAA, 0x15FA, 0x0C0F, 0x155F, 0x0C3F, 0x15FF, 
   0x0C00, 0x1550, 0x0C30, 0x15F0, 0x0C15, 0x1555, 0x0C3D, 0x15FD, 
   0x0C03, 0x1553, 0x0CAB, 0x15F3, 0x0C0F, 0x155F, 0x0C3F, 0x15FF, 
   0x0C00, 0x1550, 0x0C30, 0x15F0, 0x0C0C, 0x1555, 0x0C3C, 0x15FC, 
   0x0C0A, 0x155A, 0x0CAA, 0x15FA, 0x0C0F, 0x155F, 0x0C3F, 0x15FF, 
   0x0C00, 0x1550, 0x0C30, 0x15F0, 0x0C15, 0x1555, 0x0C3C, 0x15FC, 
   0x0C03, 0x1553, 0x0CAB, 0x15F3, 0x0C0F, 0x155F, 0x0C3F, 0x15FF, 
   0x0C00, 0x1550, 0x0C30, 0x15F0, 0x0C0C, 0x1555, 0x0C3C, 0x15FC, 
   0x0C03, 0x1553, 0x0CAA, 0x15FA, 0x0C0F, 0x155F, 0x0C3F, 0x15FF, 
   0x0C01, 0x1551, 0x0C31, 0x15F1, 0x0C15, 0x1555, 0x0C3D, 0x15FD, 
   0x0C03, 0x1553, 0x0CAB, 0x15F3, 0x0C0F, 0x155F, 0x0C3F, 0x15FF, 
   0x0C00, 0x1550, 0x0C30, 0x15F0, 0x0C0C, 0x1555, 0x0C3C, 0x15FC, 
   0x0C0A, 0x155A, 0x0CAA, 0x15FA, 0x0C0F, 0x155F, 0x0C3F, 0x15FF, 
   0x0C00, 0x1550, 0x0C30, 0x15F0, 0x0C15, 0x1555, 0x0C3C, 0x15FC, 
   0x0C03, 0x1553, 0x0CAB, 0x15F3, 0x0C0F, 0x155F, 0x0C3F, 0x15FF, 
   0x1500, 0x1550, 0x1530, 0x15F0, 0x150C, 0x1555, 0x153C, 0x15FC, 
   0x1503, 0x1553, 0x15AA, 0x15FA, 0x150F, 0x155F, 0x153F, 0x15FF, 
   0x1500, 0x1550, 0x1530, 0x15F0, 0x1515, 0x1555, 0x153D, 0x15FD, 
   0x1503, 0x1553, 0x15AB, 0x15F3, 0x150F, 0x155F, 0x153F, 0x15FF, 
   0x1500, 0x1550, 0x1530, 0x15F0, 0x150C, 0x1555, 0x153C, 0x15FC, 
   0x150A, 0x155A, 0x15AA, 0x15FA, 0x150F, 0x155F, 0x153F, 0x15FF, 
   0x1500, 0x1550, 0x1530, 0x15F0, 0x1515, 0x1555, 0x153C, 0x15FC, 
   0x1503, 0x1553, 0x15AB, 0x15F3, 0x150F, 0x155F, 0x153F, 0x15FF, 
   0x1500, 0x1550, 0x1530, 0x15F0, 0x150C, 0x1555, 0x153C, 0x15FC, 
   0x1503, 0x1553, 0x15AA, 0x15FA, 0x150F, 0x155F, 0x153F, 0x15FF, 
   0x1501, 0x1551, 0x1531, 0x15F1, 0x1515, 0x1555, 0x153D, 0x15FD, 
   0x1503, 0x1553, 0x15AB, 0x15F3, 0x150F, 0x155F, 0x153F, 0x15FF, 
   0x1500, 0x1550, 0x1530, 0x15F0, 0x150C, 0x1555, 0x153C, 0x15FC, 
   0x150A, 0x155A, 0x15AA, 0x15FA, 0x150F, 0x155F, 0x153F, 0x15FF, 
   0x1500, 0x1550, 0x1530, 0x15F0, 0x1515, 0x1555, 0x153C, 0x15FC, 
   0x1503, 0x1553, 0x15AB, 0x15F3, 0x150F, 0x155F, 0x153F, 0x15FF, 
   0x1500, 0x1550, 0x1530, 0x15F0, 0x150C, 0x1555, 0x153C, 0x15FC, 
   0x1503, 0x1553, 0x15AA, 0x15FA, 0x150F, 0x155F, 0x153F, 0x15FF, 
   0x1500, 0x1550, 0x1530, 0x15F0, 0x1515, 0x1555, 0x153D, 0x15FD, 
   0x1503, 0x1553, 0x15AB, 0x15F3, 0x150F, 0x155F, 0x153F, 0x15FF, 
   0x1500, 0x1550, 0x1530, 0x15F0, 0x150C, 0x1555, 0x153C, 0x15FC, 
   0x150A, 0x155A, 0x15AA, 0x15FA, 0x150F, 0x155F, 0x153F, 0x15FF, 
   0x1500, 0x1550, 0x1530, 0x15F0, 0x1515, 0x1555, 0x153C, 0x15FC, 
   0x1503, 0x1553, 0x15AB, 0x15F3, 0x150F, 0x155F, 0x153F, 0x15FF, 
   0x1500, 0x1550, 0x1530, 0x15F0, 0x150C, 0x1555, 0x153C, 0x15FC, 
   0x1503, 0x1553, 0x15AA, 0x15FA, 0x150F, 0x155F, 0x153F, 0x15FF, 
   0x1501, 0x1551, 0x1531, 0x15F1, 0x1515, 0x1555, 0x153D, 0x15FD, 
   0x1503, 0x1553, 0x15AB, 0x15F3, 0x150F, 0x155F, 0x153F, 0x15FF, 
   0x1500, 0x1550, 0x1530, 0x15F0, 0x150C, 0x1555, 0x153C, 0x15FC, 
   0x150A, 0x155A, 0x15AA, 0x15FA, 0x150F, 0x155F, 0x153F, 0x15FF, 
   0x1500, 0x1550, 0x1530, 0x15F0, 0x1515, 0x1555, 0x153C, 0x15FC, 
   0x1503, 0x1553, 0x15AB, 0x15F3, 0x150F, 0x155F, 0x153F, 0x15FF, 
   0x1500, 0x1550, 0x1530, 0x15F0, 0x150C, 0x1555, 0x153C, 0x15FC, 
   0x1503, 0x1553, 0x15AA, 0x15FA, 0x150F, 0x155F, 0x153F, 0x15FF, 
   0x1500, 0x1550, 0x1530, 0x15F0, 0x1515, 0x1555, 0x153D, 0x15FD, 
   0x1503, 0x1553, 0x15AB, 0x15F3, 0x150F, 0x155F, 0x153F, 0x15FF, 
   0x1500, 0x1550, 0x1530, 0x15F0, 0x150C, 0x1555, 0x153C, 0x15FC, 
   0x150A, 0x155A, 0x15AA, 0x15FA, 0x150F, 0x155F, 0x153F, 0x15FF, 
   0x1500, 0x1550, 0x1530, 0x15F0, 0x1515, 0x1555, 0x153C, 0x15FC, 
   0x1503, 0x1553, 0x15AB, 0x15F3, 0x150F, 0x155F, 0x153F, 0x15FF, 
   0x1500, 0x1550, 0x1530, 0x15F0, 0x150C, 0x1555, 0x153C, 0x15FC, 
   0x1503, 0x1553, 0x15AA, 0x15FA, 0x150F, 0x155F, 0x153F, 0x15FF, 
   0x1501, 0x1551, 0x1531, 0x15F1, 0x1515, 0x1555, 0x153D, 0x15FD, 
   0x1503, 0x1553, 0x15AB, 0x15F3, 0x150F, 0x155F, 0x153F, 0x15FF, 
   0x1500, 0x1550, 0x1530, 0x15F0, 0x150C, 0x1555, 0x153C, 0x15FC, 
   0x150A, 0x155A, 0x15AA, 0x15FA, 0x150F, 0x155F, 0x153F, 0x15FF, 
   0x1500, 0x1550, 0x1530, 0x15F0, 0x1515, 0x1555, 0x153C, 0x15FC, 
   0x1503, 0x1553, 0x15AB, 0x15F3, 0x150F, 0x155F, 0x153F, 0x15FF, 
   0x1500, 0x1550, 0x1530, 0x15F0, 0x150C, 0x1555, 0x153C, 0x15FC, 
   0x1503, 0x1553, 0x15AA, 0x15FA, 0x150F, 0x155F, 0x153F, 0x15FF, 
   0x1500, 0x1550, 0x1530, 0x15F0, 0x1515, 0x1555, 0x153D, 0x15FD, 
   0x1503, 0x1553, 0x15AB, 0x15F3, 0x150F, 0x155F, 0x153F, 0x15FF, 
   0x1500, 0x1550, 0x1530, 0x15F0, 0x150C, 0x1555, 0x153C, 0x15FC, 
   0x150A, 0x155A, 0x15AA, 0x15FA, 0x150F, 0x155F, 0x153F, 0x15FF, 
   0x1500, 0x1550, 0x1530, 0x15F0, 0x1515, 0x1555, 0x153C, 0x15FC, 
   0x1503, 0x1553, 0x15AB, 0x15F3, 0x150F, 0x155F, 0x153F, 0x15FF, 
   0x1500, 0x1550, 0x1530, 0x15F0, 0x150C, 0x1555, 0x153C, 0x15FC, 
   0x1503, 0x1553, 0x15AA, 0x15FA, 0x150F, 0x155F, 0x153F, 0x15FF, 
   0x1501, 0x1551, 0x1531, 0x15F1, 0x1515, 0x1555, 0x153D, 0x15FD, 
   0x1503, 0x1553, 0x15AB, 0x15F3, 0x150F, 0x155F, 0x153F, 0x15FF, 
   0x1500, 0x1550, 0x1530, 0x15F0, 0x150C, 0x1555, 0x153C, 0x15FC, 
   0x150A, 0x155A, 0x15AA, 0x15FA, 0x150F, 0x155F, 0x153F, 0x15FF, 
   0x1500, 0x1550, 0x1530, 0x15F0, 0x1515, 0x1555, 0x153C, 0x15FC, 
   0x1503, 0x1553, 0x15AB, 0x15F3, 0x150F, 0x155F, 0x153F, 0x15FF, 
   0x1500, 0x1550, 0x1530, 0x15F0, 0x150C, 0x1555, 0x153C, 0x15FC, 
   0x1503, 0x1553, 0x15AA, 0x15FA, 0x150F, 0x155F, 0x153F, 0x15FF, 
   0x1500, 0x1550, 0x1530, 0x15F0, 0x1515, 0x1555, 0x153D, 0x15FD, 
   0x1503, 0x1553, 0x15AB, 0x15F3, 0x150F, 0x155F, 0x153F, 0x15FF, 
   0x1500, 0x1550, 0x1530, 0x15F0, 0x150C, 0x1555, 0x153C, 0x15FC, 
   0x150A, 0x155A, 0x15AA, 0x15FA, 0x150F, 0x155F, 0x153F, 0x15FF, 
   0x1500, 0x1550, 0x1530, 0x15F0, 0x1515, 0x1555, 0x153C, 0x15FC, 
   0x1503, 0x1553, 0x15AB, 0x15F3, 0x150F, 0x155F, 0x153F, 0x15FF, 
   0x1500, 0x1550, 0x1530, 0x15F0, 0x150C, 0x1555, 0x153C, 0x15FC, 
   0x1503, 0x1553, 0x15AA, 0x15FA, 0x150F, 0x155F, 0x153F, 0x15FF, 
   0x1501, 0x1551, 0x1531, 0x15F1, 0x1515, 0x1555, 0x153D, 0x15FD, 
   0x1503, 0x1553, 0x15AB, 0x15F3, 0x150F, 0x155F, 0x153F, 0x15FF, 
   0x1500, 0x1550, 0x1530, 0x15F0, 0x150C, 0x1555, 0x153C, 0x15FC, 
   0x150A, 0x155A, 0x15AA, 0x15FA, 0x150F, 0x155F, 0x153F, 0x15FF, 
   0x1500, 0x1550, 0x1530, 0x15F0, 0x1515, 0x1555, 0x153C, 0x15FC, 
   0x1503, 0x1553, 0x15AB, 0x15F3, 0x150F, 0x155F, 0x153F, 0x15FF, 
   0x1500, 0x1550, 0x1530, 0x15F0, 0x150C, 0x1555, 0x153C, 0x15FC, 
   0x1503, 0x1553, 0x15AA, 0x15FA, 0x150F, 0x155F, 0x153F, 0x15FF, 
   0x1500, 0x1550, 0x1530, 0x15F0, 0x1515, 0x1555, 0x153D, 0x15FD, 
   0x1503, 0x1553, 0x15AB, 0x15F3, 0x150F, 0x155F, 0x153F, 0x15FF, 
   0x1500, 0x1550, 0x1530, 0x15F0, 0x150C, 0x1555, 0x153C, 0x15FC, 
   0x150A, 0x155A, 0x15AA, 0x15FA, 0x150F, 0x155F, 0x153F, 0x15FF, 
   0x1500, 0x1550, 0x1530, 0x15F0, 0x1515, 0x1555, 0x153C, 0x15FC, 
   0x1503, 0x1553, 0x15AB, 0x15F3, 0x150F, 0x155F, 0x153F, 0x15FF, 
   0x1500, 0x1550, 0x1530, 0x15F0, 0x150C, 0x1555, 0x153C, 0x15FC, 
   0x1503, 0x1553, 0x15AA, 0x15FA, 0x150F, 0x155F, 0x153F, 0x15FF, 
   0x1501, 0x1551, 0x1531, 0x15F1, 0x1515, 0x1555, 0x153D, 0x15FD, 
   0x1503, 0x1553, 0x15AB, 0x15F3, 0x150F, 0x155F, 0x153F, 0x15FF, 
   0x1500, 0x1550, 0x1530, 0x15F0, 0x150C, 0x1555, 0x153C, 0x15FC, 
   0x150A, 0x155A, 0x15AA, 0x15FA, 0x150F, 0x155F, 0x153F, 0x15FF, 
   0x1500, 0x1550, 0x1530, 0x15F0, 0x1515, 0x1555, 0x153C, 0x15FC, 
   0x1503, 0x1553, 0x15AB, 0x15F3, 0x150F, 0x155F, 0x153F, 0x15FF, 
   0x1500, 0x1550, 0x1530, 0x15F0, 0x150C, 0x1555, 0x153C, 0x15FC, 
   0x1503, 0x1553, 0x15AA, 0x15FA, 0x150F, 0x155F, 0x153F, 0x15FF, 
   0x1500, 0x1550, 0x1530, 0x15F0, 0x1515, 0x1555, 0x153D, 0x15FD, 
   0x1503, 0x1553, 0x15AB, 0x15F3, 0x150F, 0x155F, 0x153F, 0x15FF, 
   0x1500, 0x1550, 0x1530, 0x15F0, 0x150C, 0x1555, 0x153C, 0x15FC, 
   0x150A, 0x155A, 0x15AA, 0x15FA, 0x150F, 0x155F, 0x153F, 0x15FF, 
   0x1500, 0x1550, 0x1530, 0x15F0, 0x1515, 0x1555, 0x153C, 0x15FC, 
   0x1503, 0x1553, 0x15AB, 0x15F3, 0x150F, 0x155F, 0x153F, 0x15FF, 
   0x1500, 0x1550, 0x1530, 0x15F0, 0x150C, 0x1555, 0x153C, 0x15FC, 
   0x1503, 0x1553, 0x15AA, 0x15FA, 0x150F, 0x155F, 0x153F, 0x15FF, 
   0x1501, 0x1551, 0x1531, 0x15F1, 0x1515, 0x1555, 0x153D, 0x15FD, 
   0x1503, 0x1553, 0x15AB, 0x15F3, 0x150F, 0x155F, 0x153F, 0x15FF, 
   0x1500, 0x1550, 0x1530, 0x15F0, 0x150C, 0x1555, 0x153C, 0x15FC, 
   0x150A, 0x155A, 0x15AA, 0x15FA, 0x150F, 0x155F, 0x153F, 0x15FF, 
   0x1500, 0x1550, 0x1530, 0x15F0, 0x1515, 0x1555, 0x153C, 0x15FC, 
   0x1503, 0x1553, 0x15AB, 0x15F3, 0x150F, 0x155F, 0x153F, 0x15FF, 
   0x1500, 0x1550, 0x1530, 0x15F0, 0x150C, 0x1555, 0x153C, 0x15FC, 
   0x1503, 0x1553, 0x15AA, 0x15FA, 0x150F, 0x155F, 0x153F, 0x15FF, 
   0x1500, 0x1550, 0x1530, 0x15F0, 0x1515, 0x1555, 0x153D, 0x15FD, 
   0x1503, 0x1553, 0x15AB, 0x15F3, 0x150F, 0x155F, 0x153F, 0x15FF, 
   0x1500, 0x1550, 0x1530, 0x15F0, 0x150C, 0x1555, 0x153C, 0x15FC, 
   0x150A, 0x155A, 0x15AA, 0x15FA, 0x150F, 0x155F, 0x153F, 0x15FF, 
   0x1500, 0x1550, 0x1530, 0x15F0, 0x1515, 0x1555, 0x153C, 0x15FC, 
   0x1503, 0x1553, 0x15AB, 0x15F3, 0x150F, 0x155F, 0x153F, 0x15FF, 
   0x1500, 0x1550, 0x1530, 0x15F0, 0x150C, 0x1555, 0x153C, 0x15FC, 
   0x1503, 0x1553, 0x15AA, 0x15FA, 0x150F, 0x155F, 0x153F, 0x15FF, 
   0x1501, 0x1551, 0x1531, 0x15F1, 0x1515, 0x1555, 0x153D, 0x15FD, 
   0x1503, 0x1553, 0x15AB, 0x15F3, 0x150F, 0x155F, 0x153F, 0x15FF, 
   0x1500, 0x1550, 0x1530, 0x15F0, 0x150C, 0x1555, 0x153C, 0x15FC, 
   0x150A, 0x155A, 0x15AA, 0x15FA, 0x150F, 0x155F, 0x153F, 0x15FF, 
   0x1500, 0x1550, 0x1530, 0x15F0, 0x1515, 0x1555, 0x153C, 0x15FC, 
   0x1503, 0x1553, 0x15AB, 0x15F3, 0x150F, 0x155F, 0x153F, 0x15FF, 
   0x3C00, 0x3D50, 0x3C30, 0x3CF0, 0x3C0C, 0x3D55, 0x3C3C, 0x3CFC, 
   0x3C03, 0x3D53, 0x3CAA, 0x3CFA, 0x3C0F, 0x3D5F, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3D50, 0x3C30, 0x3CF0, 0x3C15, 0x3D55, 0x3C3D, 0x3CFD, 
   0x3C03, 0x3D53, 0x3CAB, 0x3CF3, 0x3C0F, 0x3D5F, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3D50, 0x3C30, 0x3CF0, 0x3C0C, 0x3D55, 0x3C3C, 0x3CFC, 
   0x3C0A, 0x3D5A, 0x3CAA, 0x3CFA, 0x3C0F, 0x3D5F, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3D50, 0x3C30, 0x3CF0, 0x3C15, 0x3D55, 0x3C3C, 0x3CFC, 
   0x3C03, 0x3D53, 0x3CAB, 0x3CF3, 0x3C0F, 0x3D5F, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3D50, 0x3C30, 0x3CF0, 0x3C0C, 0x3D55, 0x3C3C, 0x3CFC, 
   0x3C03, 0x3D53, 0x3CAA, 0x3CFA, 0x3C0F, 0x3D5F, 0x3C3F, 0x3CFF, 
   0x3C01, 0x3D51, 0x3C31, 0x3CF1, 0x3C15, 0x3D55, 0x3C3D, 0x3CFD, 
   0x3C03, 0x3D53, 0x3CAB, 0x3CF3, 0x3C0F, 0x3D5F, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3D50, 0x3C30, 0x3CF0, 0x3C0C, 0x3D55, 0x3C3C, 0x3CFC, 
   0x3C0A, 0x3D5A, 0x3CAA, 0x3CFA, 0x3C0F, 0x3D5F, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3D50, 0x3C30, 0x3CF0, 0x3C15, 0x3D55, 0x3C3C, 0x3CFC, 
   0x3C03, 0x3D53, 0x3CAB, 0x3CF3, 0x3C0F, 0x3D5F, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3D50, 0x3C30, 0x3CF0, 0x3C0C, 0x3D55, 0x3C3C, 0x3CFC, 
   0x3C03, 0x3D53, 0x3CAA, 0x3CFA, 0x3C0F, 0x3D5F, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3D50, 0x3C30, 0x3CF0, 0x3C15, 0x3D55, 0x3C3D, 0x3CFD, 
   0x3C03, 0x3D53, 0x3CAB, 0x3CF3, 0x3C0F, 0x3D5F, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3D50, 0x3C30, 0x3CF0, 0x3C0C, 0x3D55, 0x3C3C, 0x3CFC, 
   0x3C0A, 0x3D5A, 0x3CAA, 0x3CFA, 0x3C0F, 0x3D5F, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3D50, 0x3C30, 0x3CF0, 0x3C15, 0x3D55, 0x3C3C, 0x3CFC, 
   0x3C03, 0x3D53, 0x3CAB, 0x3CF3, 0x3C0F, 0x3D5F, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3D50, 0x3C30, 0x3CF0, 0x3C0C, 0x3D55, 0x3C3C, 0x3CFC, 
   0x3C03, 0x3D53, 0x3CAA, 0x3CFA, 0x3C0F, 0x3D5F, 0x3C3F, 0x3CFF, 
   0x3C01, 0x3D51, 0x3C31, 0x3CF1, 0x3C15, 0x3D55, 0x3C3D, 0x3CFD, 
   0x3C03, 0x3D53, 0x3CAB, 0x3CF3, 0x3C0F, 0x3D5F, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3D50, 0x3C30, 0x3CF0, 0x3C0C, 0x3D55, 0x3C3C, 0x3CFC, 
   0x3C0A, 0x3D5A, 0x3CAA, 0x3CFA, 0x3C0F, 0x3D5F, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3D50, 0x3C30, 0x3CF0, 0x3C15, 0x3D55, 0x3C3C, 0x3CFC, 
   0x3C03, 0x3D53, 0x3CAB, 0x3CF3, 0x3C0F, 0x3D5F, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3D50, 0x3C30, 0x3CF0, 0x3C0C, 0x3D55, 0x3C3C, 0x3CFC, 
   0x3C03, 0x3D53, 0x3CAA, 0x3CFA, 0x3C0F, 0x3D5F, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3D50, 0x3C30, 0x3CF0, 0x3C15, 0x3D55, 0x3C3D, 0x3CFD, 
   0x3C03, 0x3D53, 0x3CAB, 0x3CF3, 0x3C0F, 0x3D5F, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3D50, 0x3C30, 0x3CF0, 0x3C0C, 0x3D55, 0x3C3C, 0x3CFC, 
   0x3C0A, 0x3D5A, 0x3CAA, 0x3CFA, 0x3C0F, 0x3D5F, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3D50, 0x3C30, 0x3CF0, 0x3C15, 0x3D55, 0x3C3C, 0x3CFC, 
   0x3C03, 0x3D53, 0x3CAB, 0x3CF3, 0x3C0F, 0x3D5F, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3D50, 0x3C30, 0x3CF0, 0x3C0C, 0x3D55, 0x3C3C, 0x3CFC, 
   0x3C03, 0x3D53, 0x3CAA, 0x3CFA, 0x3C0F, 0x3D5F, 0x3C3F, 0x3CFF, 
   0x3C01, 0x3D51, 0x3C31, 0x3CF1, 0x3C15, 0x3D55, 0x3C3D, 0x3CFD, 
   0x3C03, 0x3D53, 0x3CAB, 0x3CF3, 0x3C0F, 0x3D5F, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3D50, 0x3C30, 0x3CF0, 0x3C0C, 0x3D55, 0x3C3C, 0x3CFC, 
   0x3C0A, 0x3D5A, 0x3CAA, 0x3CFA, 0x3C0F, 0x3D5F, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3D50, 0x3C30, 0x3CF0, 0x3C15, 0x3D55, 0x3C3C, 0x3CFC, 
   0x3C03, 0x3D53, 0x3CAB, 0x3CF3, 0x3C0F, 0x3D5F, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3D50, 0x3C30, 0x3CF0, 0x3C0C, 0x3D55, 0x3C3C, 0x3CFC, 
   0x3C03, 0x3D53, 0x3CAA, 0x3CFA, 0x3C0F, 0x3D5F, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3D50, 0x3C30, 0x3CF0, 0x3C15, 0x3D55, 0x3C3D, 0x3CFD, 
   0x3C03, 0x3D53, 0x3CAB, 0x3CF3, 0x3C0F, 0x3D5F, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3D50, 0x3C30, 0x3CF0, 0x3C0C, 0x3D55, 0x3C3C, 0x3CFC, 
   0x3C0A, 0x3D5A, 0x3CAA, 0x3CFA, 0x3C0F, 0x3D5F, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3D50, 0x3C30, 0x3CF0, 0x3C15, 0x3D55, 0x3C3C, 0x3CFC, 
   0x3C03, 0x3D53, 0x3CAB, 0x3CF3, 0x3C0F, 0x3D5F, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3D50, 0x3C30, 0x3CF0, 0x3C0C, 0x3D55, 0x3C3C, 0x3CFC, 
   0x3C03, 0x3D53, 0x3CAA, 0x3CFA, 0x3C0F, 0x3D5F, 0x3C3F, 0x3CFF, 
   0x3C01, 0x3D51, 0x3C31, 0x3CF1, 0x3C15, 0x3D55, 0x3C3D, 0x3CFD, 
   0x3C03, 0x3D53, 0x3CAB, 0x3CF3, 0x3C0F, 0x3D5F, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3D50, 0x3C30, 0x3CF0, 0x3C0C, 0x3D55, 0x3C3C, 0x3CFC, 
   0x3C0A, 0x3D5A, 0x3CAA, 0x3CFA, 0x3C0F, 0x3D5F, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3D50, 0x3C30, 0x3CF0, 0x3C15, 0x3D55, 0x3C3C, 0x3CFC, 
   0x3C03, 0x3D53, 0x3CAB, 0x3CF3, 0x3C0F, 0x3D5F, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3D50, 0x3C30, 0x3CF0, 0x3C0C, 0x3D55, 0x3C3C, 0x3CFC, 
   0x3C03, 0x3D53, 0x3CAA, 0x3CFA, 0x3C0F, 0x3D5F, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3D50, 0x3C30, 0x3CF0, 0x3C15, 0x3D55, 0x3C3D, 0x3CFD, 
   0x3C03, 0x3D53, 0x3CAB, 0x3CF3, 0x3C0F, 0x3D5F, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3D50, 0x3C30, 0x3CF0, 0x3C0C, 0x3D55, 0x3C3C, 0x3CFC, 
   0x3C0A, 0x3D5A, 0x3CAA, 0x3CFA, 0x3C0F, 0x3D5F, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3D50, 0x3C30, 0x3CF0, 0x3C15, 0x3D55, 0x3C3C, 0x3CFC, 
   0x3C03, 0x3D53, 0x3CAB, 0x3CF3, 0x3C0F, 0x3D5F, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3D50, 0x3C30, 0x3CF0, 0x3C0C, 0x3D55, 0x3C3C, 0x3CFC, 
   0x3C03, 0x3D53, 0x3CAA, 0x3CFA, 0x3C0F, 0x3D5F, 0x3C3F, 0x3CFF, 
   0x3C01, 0x3D51, 0x3C31, 0x3CF1, 0x3C15, 0x3D55, 0x3C3D, 0x3CFD, 
   0x3C03, 0x3D53, 0x3CAB, 0x3CF3, 0x3C0F, 0x3D5F, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3D50, 0x3C30, 0x3CF0, 0x3C0C, 0x3D55, 0x3C3C, 0x3CFC, 
   0x3C0A, 0x3D5A, 0x3CAA, 0x3CFA, 0x3C0F, 0x3D5F, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3D50, 0x3C30, 0x3CF0, 0x3C15, 0x3D55, 0x3C3C, 0x3CFC, 
   0x3C03, 0x3D53, 0x3CAB, 0x3CF3, 0x3C0F, 0x3D5F, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3D50, 0x3C30, 0x3CF0, 0x3C0C, 0x3D55, 0x3C3C, 0x3CFC, 
   0x3C03, 0x3D53, 0x3CAA, 0x3CFA, 0x3C0F, 0x3D5F, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3D50, 0x3C30, 0x3CF0, 0x3C15, 0x3D55, 0x3C3D, 0x3CFD, 
   0x3C03, 0x3D53, 0x3CAB, 0x3CF3, 0x3C0F, 0x3D5F, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3D50, 0x3C30, 0x3CF0, 0x3C0C, 0x3D55, 0x3C3C, 0x3CFC, 
   0x3C0A, 0x3D5A, 0x3CAA, 0x3CFA, 0x3C0F, 0x3D5F, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3D50, 0x3C30, 0x3CF0, 0x3C15, 0x3D55, 0x3C3C, 0x3CFC, 
   0x3C03, 0x3D53, 0x3CAB, 0x3CF3, 0x3C0F, 0x3D5F, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3D50, 0x3C30, 0x3CF0, 0x3C0C, 0x3D55, 0x3C3C, 0x3CFC, 
   0x3C03, 0x3D53, 0x3CAA, 0x3CFA, 0x3C0F, 0x3D5F, 0x3C3F, 0x3CFF, 
   0x3C01, 0x3D51, 0x3C31, 0x3CF1, 0x3C15, 0x3D55, 0x3C3D, 0x3CFD, 
   0x3C03, 0x3D53, 0x3CAB, 0x3CF3, 0x3C0F, 0x3D5F, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3D50, 0x3C30, 0x3CF0, 0x3C0C, 0x3D55, 0x3C3C, 0x3CFC, 
   0x3C0A, 0x3D5A, 0x3CAA, 0x3CFA, 0x3C0F, 0x3D5F, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3D50, 0x3C30, 0x3CF0, 0x3C15, 0x3D55, 0x3C3C, 0x3CFC, 
   0x3C03, 0x3D53, 0x3CAB, 0x3CF3, 0x3C0F, 0x3D5F, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3D50, 0x3C30, 0x3CF0, 0x3C0C, 0x3D55, 0x3C3C, 0x3CFC, 
   0x3C03, 0x3D53, 0x3CAA, 0x3CFA, 0x3C0F, 0x3D5F, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3D50, 0x3C30, 0x3CF0, 0x3C15, 0x3D55, 0x3C3D, 0x3CFD, 
   0x3C03, 0x3D53, 0x3CAB, 0x3CF3, 0x3C0F, 0x3D5F, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3D50, 0x3C30, 0x3CF0, 0x3C0C, 0x3D55, 0x3C3C, 0x3CFC, 
   0x3C0A, 0x3D5A, 0x3CAA, 0x3CFA, 0x3C0F, 0x3D5F, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3D50, 0x3C30, 0x3CF0, 0x3C15, 0x3D55, 0x3C3C, 0x3CFC, 
   0x3C03, 0x3D53, 0x3CAB, 0x3CF3, 0x3C0F, 0x3D5F, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3D50, 0x3C30, 0x3CF0, 0x3C0C, 0x3D55, 0x3C3C, 0x3CFC, 
   0x3C03, 0x3D53, 0x3CAA, 0x3CFA, 0x3C0F, 0x3D5F, 0x3C3F, 0x3CFF, 
   0x3C01, 0x3D51, 0x3C31, 0x3CF1, 0x3C15, 0x3D55, 0x3C3D, 0x3CFD, 
   0x3C03, 0x3D53, 0x3CAB, 0x3CF3, 0x3C0F, 0x3D5F, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3D50, 0x3C30, 0x3CF0, 0x3C0C, 0x3D55, 0x3C3C, 0x3CFC, 
   0x3C0A, 0x3D5A, 0x3CAA, 0x3CFA, 0x3C0F, 0x3D5F, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3D50, 0x3C30, 0x3CF0, 0x3C15, 0x3D55, 0x3C3C, 0x3CFC, 
   0x3C03, 0x3D53, 0x3CAB, 0x3CF3, 0x3C0F, 0x3D5F, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3D50, 0x3C30, 0x3CF0, 0x3C0C, 0x3D55, 0x3C3C, 0x3CFC, 
   0x3C03, 0x3D53, 0x3CAA, 0x3CFA, 0x3C0F, 0x3D5F, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3D50, 0x3C30, 0x3CF0, 0x3C15, 0x3D55, 0x3C3D, 0x3CFD, 
   0x3C03, 0x3D53, 0x3CAB, 0x3CF3, 0x3C0F, 0x3D5F, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3D50, 0x3C30, 0x3CF0, 0x3C0C, 0x3D55, 0x3C3C, 0x3CFC, 
   0x3C0A, 0x3D5A, 0x3CAA, 0x3CFA, 0x3C0F, 0x3D5F, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3D50, 0x3C30, 0x3CF0, 0x3C15, 0x3D55, 0x3C3C, 0x3CFC, 
   0x3C03, 0x3D53, 0x3CAB, 0x3CF3, 0x3C0F, 0x3D5F, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3D50, 0x3C30, 0x3CF0, 0x3C0C, 0x3D55, 0x3C3C, 0x3CFC, 
   0x3C03, 0x3D53, 0x3CAA, 0x3CFA, 0x3C0F, 0x3D5F, 0x3C3F, 0x3CFF, 
   0x3C01, 0x3D51, 0x3C31, 0x3CF1, 0x3C15, 0x3D55, 0x3C3D, 0x3CFD, 
   0x3C03, 0x3D53, 0x3CAB, 0x3CF3, 0x3C0F, 0x3D5F, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3D50, 0x3C30, 0x3CF0, 0x3C0C, 0x3D55, 0x3C3C, 0x3CFC, 
   0x3C0A, 0x3D5A, 0x3CAA, 0x3CFA, 0x3C0F, 0x3D5F, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3D50, 0x3C30, 0x3CF0, 0x3C15, 0x3D55, 0x3C3C, 0x3CFC, 
   0x3C03, 0x3D53, 0x3CAB, 0x3CF3, 0x3C0F, 0x3D5F, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3D50, 0x3C30, 0x3CF0, 0x3C0C, 0x3D55, 0x3C3C, 0x3CFC, 
   0x3C03, 0x3D53, 0x3CAA, 0x3CFA, 0x3C0F, 0x3D5F, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3D50, 0x3C30, 0x3CF0, 0x3C15, 0x3D55, 0x3C3D, 0x3CFD, 
   0x3C03, 0x3D53, 0x3CAB, 0x3CF3, 0x3C0F, 0x3D5F, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3D50, 0x3C30, 0x3CF0, 0x3C0C, 0x3D55, 0x3C3C, 0x3CFC, 
   0x3C0A, 0x3D5A, 0x3CAA, 0x3CFA, 0x3C0F, 0x3D5F, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3D50, 0x3C30, 0x3CF0, 0x3C15, 0x3D55, 0x3C3C, 0x3CFC, 
   0x3C03, 0x3D53, 0x3CAB, 0x3CF3, 0x3C0F, 0x3D5F, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3D50, 0x3C30, 0x3CF0, 0x3C0C, 0x3D55, 0x3C3C, 0x3CFC, 
   0x3C03, 0x3D53, 0x3CAA, 0x3CFA, 0x3C0F, 0x3D5F, 0x3C3F, 0x3CFF, 
   0x3C01, 0x3D51, 0x3C31, 0x3CF1, 0x3C15, 0x3D55, 0x3C3D, 0x3CFD, 
   0x3C03, 0x3D53, 0x3CAB, 0x3CF3, 0x3C0F, 0x3D5F, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3D50, 0x3C30, 0x3CF0, 0x3C0C, 0x3D55, 0x3C3C, 0x3CFC, 
   0x3C0A, 0x3D5A, 0x3CAA, 0x3CFA, 0x3C0F, 0x3D5F, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3D50, 0x3C30, 0x3CF0, 0x3C15, 0x3D55, 0x3C3C, 0x3CFC, 
   0x3C03, 0x3D53, 0x3CAB, 0x3CF3, 0x3C0F, 0x3D5F, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3D50, 0x3C30, 0x3CF0, 0x3C0C, 0x3D55, 0x3C3C, 0x3CFC, 
   0x3C03, 0x3D53, 0x3CAA, 0x3CFA, 0x3C0F, 0x3D5F, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3D50, 0x3C30, 0x3CF0, 0x3C15, 0x3D55, 0x3C3D, 0x3CFD, 
   0x3C03, 0x3D53, 0x3CAB, 0x3CF3, 0x3C0F, 0x3D5F, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3D50, 0x3C30, 0x3CF0, 0x3C0C, 0x3D55, 0x3C3C, 0x3CFC, 
   0x3C0A, 0x3D5A, 0x3CAA, 0x3CFA, 0x3C0F, 0x3D5F, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3D50, 0x3C30, 0x3CF0, 0x3C15, 0x3D55, 0x3C3C, 0x3CFC, 
   0x3C03, 0x3D53, 0x3CAB, 0x3CF3, 0x3C0F, 0x3D5F, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3D50, 0x3C30, 0x3CF0, 0x3C0C, 0x3D55, 0x3C3C, 0x3CFC, 
   0x3C03, 0x3D53, 0x3CAA, 0x3CFA, 0x3C0F, 0x3D5F, 0x3C3F, 0x3CFF, 
   0x3C01, 0x3D51, 0x3C31, 0x3CF1, 0x3C15, 0x3D55, 0x3C3D, 0x3CFD, 
   0x3C03, 0x3D53, 0x3CAB, 0x3CF3, 0x3C0F, 0x3D5F, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3D50, 0x3C30, 0x3CF0, 0x3C0C, 0x3D55, 0x3C3C, 0x3CFC, 
   0x3C0A, 0x3D5A, 0x3CAA, 0x3CFA, 0x3C0F, 0x3D5F, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3D50, 0x3C30, 0x3CF0, 0x3C15, 0x3D55, 0x3C3C, 0x3CFC, 
   0x3C03, 0x3D53, 0x3CAB, 0x3CF3, 0x3C0F, 0x3D5F, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3D50, 0x3C30, 0x3CF0, 0x3C0C, 0x3D55, 0x3C3C, 0x3CFC, 
   0x3C03, 0x3D53, 0x3CAA, 0x3CFA, 0x3C0F, 0x3D5F, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3D50, 0x3C30, 0x3CF0, 0x3C15, 0x3D55, 0x3C3D, 0x3CFD, 
   0x3C03, 0x3D53, 0x3CAB, 0x3CF3, 0x3C0F, 0x3D5F, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3D50, 0x3C30, 0x3CF0, 0x3C0C, 0x3D55, 0x3C3C, 0x3CFC, 
   0x3C0A, 0x3D5A, 0x3CAA, 0x3CFA, 0x3C0F, 0x3D5F, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3D50, 0x3C30, 0x3CF0, 0x3C15, 0x3D55, 0x3C3C, 0x3CFC, 
   0x3C03, 0x3D53, 0x3CAB, 0x3CF3, 0x3C0F, 0x3D5F, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3D50, 0x3C30, 0x3CF0, 0x3C0C, 0x3D55, 0x3C3C, 0x3CFC, 
   0x3C03, 0x3D53, 0x3CAA, 0x3CFA, 0x3C0F, 0x3D5F, 0x3C3F, 0x3CFF, 
   0x3C01, 0x3D51, 0x3C31, 0x3CF1, 0x3C15, 0x3D55, 0x3C3D, 0x3CFD, 
   0x3C03, 0x3D53, 0x3CAB, 0x3CF3, 0x3C0F, 0x3D5F, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3D50, 0x3C30, 0x3CF0, 0x3C0C, 0x3D55, 0x3C3C, 0x3CFC, 
   0x3C0A, 0x3D5A, 0x3CAA, 0x3CFA, 0x3C0F, 0x3D5F, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3D50, 0x3C30, 0x3CF0, 0x3C15, 0x3D55, 0x3C3C, 0x3CFC, 
   0x3C03, 0x3D53, 0x3CAB, 0x3CF3, 0x3C0F, 0x3D5F, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3D50, 0x3C30, 0x3CF0, 0x3C0C, 0x3D55, 0x3C3C, 0x3CFC, 
   0x3C03, 0x3D53, 0x3CAA, 0x3CFA, 0x3C0F, 0x3D5F, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3D50, 0x3C30, 0x3CF0, 0x3C15, 0x3D55, 0x3C3D, 0x3CFD, 
   0x3C03, 0x3D53, 0x3CAB, 0x3CF3, 0x3C0F, 0x3D5F, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3D50, 0x3C30, 0x3CF0, 0x3C0C, 0x3D55, 0x3C3C, 0x3CFC, 
   0x3C0A, 0x3D5A, 0x3CAA, 0x3CFA, 0x3C0F, 0x3D5F, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3D50, 0x3C30, 0x3CF0, 0x3C15, 0x3D55, 0x3C3C, 0x3CFC, 
   0x3C03, 0x3D53, 0x3CAB, 0x3CF3, 0x3C0F, 0x3D5F, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3D50, 0x3C30, 0x3CF0, 0x3C0C, 0x3D55, 0x3C3C, 0x3CFC, 
   0x3C03, 0x3D53, 0x3CAA, 0x3CFA, 0x3C0F, 0x3D5F, 0x3C3F, 0x3CFF, 
   0x3C01, 0x3D51, 0x3C31, 0x3CF1, 0x3C15, 0x3D55, 0x3C3D, 0x3CFD, 
   0x3C03, 0x3D53, 0x3CAB, 0x3CF3, 0x3C0F, 0x3D5F, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3D50, 0x3C30, 0x3CF0, 0x3C0C, 0x3D55, 0x3C3C, 0x3CFC, 
   0x3C0A, 0x3D5A, 0x3CAA, 0x3CFA, 0x3C0F, 0x3D5F, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3D50, 0x3C30, 0x3CF0, 0x3C15, 0x3D55, 0x3C3C, 0x3CFC, 
   0x3C03, 0x3D53, 0x3CAB, 0x3CF3, 0x3C0F, 0x3D5F, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3D50, 0x3C30, 0x3CF0, 0x3C0C, 0x3D55, 0x3C3C, 0x3CFC, 
   0x3C03, 0x3D53, 0x3CAA, 0x3CFA, 0x3C0F, 0x3D5F, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3D50, 0x3C30, 0x3CF0, 0x3C15, 0x3D55, 0x3C3D, 0x3CFD, 
   0x3C03, 0x3D53, 0x3CAB, 0x3CF3, 0x3C0F, 0x3D5F, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3D50, 0x3C30, 0x3CF0, 0x3C0C, 0x3D55, 0x3C3C, 0x3CFC, 
   0x3C0A, 0x3D5A, 0x3CAA, 0x3CFA, 0x3C0F, 0x3D5F, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3D50, 0x3C30, 0x3CF0, 0x3C15, 0x3D55, 0x3C3C, 0x3CFC, 
   0x3C03, 0x3D53, 0x3CAB, 0x3CF3, 0x3C0F, 0x3D5F, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3D50, 0x3C30, 0x3CF0, 0x3C0C, 0x3D55, 0x3C3C, 0x3CFC, 
   0x3C03, 0x3D53, 0x3CAA, 0x3CFA, 0x3C0F, 0x3D5F, 0x3C3F, 0x3CFF, 
   0x3C01, 0x3D51, 0x3C31, 0x3CF1, 0x3C15, 0x3D55, 0x3C3D, 0x3CFD, 
   0x3C03, 0x3D53, 0x3CAB, 0x3CF3, 0x3C0F, 0x3D5F, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3D50, 0x3C30, 0x3CF0, 0x3C0C, 0x3D55, 0x3C3C, 0x3CFC, 
   0x3C0A, 0x3D5A, 0x3CAA, 0x3CFA, 0x3C0F, 0x3D5F, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3D50, 0x3C30, 0x3CF0, 0x3C15, 0x3D55, 0x3C3C, 0x3CFC, 
   0x3C03, 0x3D53, 0x3CAB, 0x3CF3, 0x3C0F, 0x3D5F, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3D50, 0x3C30, 0x3CF0, 0x3C0C, 0x3D55, 0x3C3C, 0x3CFC, 
   0x3C03, 0x3D53, 0x3CAA, 0x3CFA, 0x3C0F, 0x3D5F, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3D50, 0x3C30, 0x3CF0, 0x3C15, 0x3D55, 0x3C3D, 0x3CFD, 
   0x3C03, 0x3D53, 0x3CAB, 0x3CF3, 0x3C0F, 0x3D5F, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3D50, 0x3C30, 0x3CF0, 0x3C0C, 0x3D55, 0x3C3C, 0x3CFC, 
   0x3C0A, 0x3D5A, 0x3CAA, 0x3CFA, 0x3C0F, 0x3D5F, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3D50, 0x3C30, 0x3CF0, 0x3C15, 0x3D55, 0x3C3C, 0x3CFC, 
   0x3C03, 0x3D53, 0x3CAB, 0x3CF3, 0x3C0F, 0x3D5F, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3D50, 0x3C30, 0x3CF0, 0x3C0C, 0x3D55, 0x3C3C, 0x3CFC, 
   0x3C03, 0x3D53, 0x3CAA, 0x3CFA, 0x3C0F, 0x3D5F, 0x3C3F, 0x3CFF, 
   0x3C01, 0x3D51, 0x3C31, 0x3CF1, 0x3C15, 0x3D55, 0x3C3D, 0x3CFD, 
   0x3C03, 0x3D53, 0x3CAB, 0x3CF3, 0x3C0F, 0x3D5F, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3D50, 0x3C30, 0x3CF0, 0x3C0C, 0x3D55, 0x3C3C, 0x3CFC, 
   0x3C0A, 0x3D5A, 0x3CAA, 0x3CFA, 0x3C0F, 0x3D5F, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3D50, 0x3C30, 0x3CF0, 0x3C15, 0x3D55, 0x3C3C, 0x3CFC, 
   0x3C03, 0x3D53, 0x3CAB, 0x3CF3, 0x3C0F, 0x3D5F, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3D50, 0x3C30, 0x3CF0, 0x3C0C, 0x3D55, 0x3C3C, 0x3CFC, 
   0x3C03, 0x3D53, 0x3CAA, 0x3CFA, 0x3C0F, 0x3D5F, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3D50, 0x3C30, 0x3CF0, 0x3C15, 0x3D55, 0x3C3D, 0x3CFD, 
   0x3C03, 0x3D53, 0x3CAB, 0x3CF3, 0x3C0F, 0x3D5F, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3D50, 0x3C30, 0x3CF0, 0x3C0C, 0x3D55, 0x3C3C, 0x3CFC, 
   0x3C0A, 0x3D5A, 0x3CAA, 0x3CFA, 0x3C0F, 0x3D5F, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3D50, 0x3C30, 0x3CF0, 0x3C15, 0x3D55, 0x3C3C, 0x3CFC, 
   0x3C03, 0x3D53, 0x3CAB, 0x3CF3, 0x3C0F, 0x3D5F, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3D50, 0x3C30, 0x3CF0, 0x3C0C, 0x3D55, 0x3C3C, 0x3CFC, 
   0x3C03, 0x3D53, 0x3CAA, 0x3CFA, 0x3C0F, 0x3D5F, 0x3C3F, 0x3CFF, 
   0x3C01, 0x3D51, 0x3C31, 0x3CF1, 0x3C15, 0x3D55, 0x3C3D, 0x3CFD, 
   0x3C03, 0x3D53, 0x3CAB, 0x3CF3, 0x3C0F, 0x3D5F, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3D50, 0x3C30, 0x3CF0, 0x3C0C, 0x3D55, 0x3C3C, 0x3CFC, 
   0x3C0A, 0x3D5A, 0x3CAA, 0x3CFA, 0x3C0F, 0x3D5F, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3D50, 0x3C30, 0x3CF0, 0x3C15, 0x3D55, 0x3C3C, 0x3CFC, 
   0x3C03, 0x3D53, 0x3CAB, 0x3CF3, 0x3C0F, 0x3D5F, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3D50, 0x3C30, 0x3CF0, 0x3C0C, 0x3D55, 0x3C3C, 0x3CFC, 
   0x3C03, 0x3D53, 0x3CAA, 0x3CFA, 0x3C0F, 0x3D5F, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3D50, 0x3C30, 0x3CF0, 0x3C15, 0x3D55, 0x3C3D, 0x3CFD, 
   0x3C03, 0x3D53, 0x3CAB, 0x3CF3, 0x3C0F, 0x3D5F, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3D50, 0x3C30, 0x3CF0, 0x3C0C, 0x3D55, 0x3C3C, 0x3CFC, 
   0x3C0A, 0x3D5A, 0x3CAA, 0x3CFA, 0x3C0F, 0x3D5F, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3D50, 0x3C30, 0x3CF0, 0x3C15, 0x3D55, 0x3C3C, 0x3CFC, 
   0x3C03, 0x3D53, 0x3CAB, 0x3CF3, 0x3C0F, 0x3D5F, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3D50, 0x3C30, 0x3CF0, 0x3C0C, 0x3D55, 0x3C3C, 0x3CFC, 
   0x3C03, 0x3D53, 0x3CAA, 0x3CFA, 0x3C0F, 0x3D5F, 0x3C3F, 0x3CFF, 
   0x3C01, 0x3D51, 0x3C31, 0x3CF1, 0x3C15, 0x3D55, 0x3C3D, 0x3CFD, 
   0x3C03, 0x3D53, 0x3CAB, 0x3CF3, 0x3C0F, 0x3D5F, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3D50, 0x3C30, 0x3CF0, 0x3C0C, 0x3D55, 0x3C3C, 0x3CFC, 
   0x3C0A, 0x3D5A, 0x3CAA, 0x3CFA, 0x3C0F, 0x3D5F, 0x3C3F, 0x3CFF, 
   0x3C00, 0x3D50, 0x3C30, 0x3CF0, 0x3C15, 0x3D55, 0x3C3C, 0x3CFC, 
   0x3C03, 0x3D53, 0x3CAB, 0x3CF3, 0x3C0F, 0x3D5F, 0x3C3F, 0x3CFF, 
   0x0300, 0x03C0, 0x0AA8, 0x03F0, 0x030C, 0x03D5, 0x0ABC, 0x03FC, 
   0x0303, 0x03C3, 0x0AAA, 0x03FA, 0x030F, 0x03CF, 0x0ABF, 0x03FF, 
   0x0300, 0x03C0, 0x0AA8, 0x03F0, 0x0315, 0x03D5, 0x0ABD, 0x03FD, 
   0x0303, 0x03C3, 0x0AAB, 0x03F3, 0x030F, 0x03CF, 0x0ABF, 0x03FF, 
   0x0300, 0x03C0, 0x0AA8, 0x03F0, 0x030C, 0x03D5, 0x0ABC, 0x03FC, 
   0x030A, 0x03CA, 0x0AAA, 0x03FA, 0x030F, 0x03CF, 0x0ABF, 0x03FF, 
   0x0300, 0x03C0, 0x0AA8, 0x03F0, 0x0315, 0x03D5, 0x0ABC, 0x03FC, 
   0x0303, 0x03C3, 0x0AAB, 0x03F3, 0x030F, 0x03CF, 0x0ABF, 0x03FF, 
   0x0300, 0x03C0, 0x0AA8, 0x03F0, 0x030C, 0x03D5, 0x0ABC, 0x03FC, 
   0x0303, 0x03C3, 0x0AAA, 0x03FA, 0x030F, 0x03CF, 0x0ABF, 0x03FF, 
   0x0301, 0x03C1, 0x0AA9, 0x03F1, 0x0315, 0x03D5, 0x0ABD, 0x03FD, 
   0x0303, 0x03C3, 0x0AAB, 0x03F3, 0x030F, 0x03CF, 0x0ABF, 0x03FF, 
   0x0300, 0x03C0, 0x0AA8, 0x03F0, 0x030C, 0x03D5, 0x0ABC, 0x03FC, 
   0x030A, 0x03CA, 0x0AAA, 0x03FA, 0x030F, 0x03CF, 0x0ABF, 0x03FF, 
   0x0300, 0x03C0, 0x0AA8, 0x03F0, 0x0315, 0x03D5, 0x0ABC, 0x03FC, 
   0x0303, 0x03C3, 0x0AAB, 0x03F3, 0x030F, 0x03CF, 0x0ABF, 0x03FF, 
   0x0300, 0x03C0, 0x0AA8, 0x03F0, 0x030C, 0x03D5, 0x0ABC, 0x03FC, 
   0x0303, 0x03C3, 0x0AAA, 0x03FA, 0x030F, 0x03CF, 0x0ABF, 0x03FF, 
   0x0300, 0x03C0, 0x0AA8, 0x03F0, 0x0315, 0x03D5, 0x0ABD, 0x03FD, 
   0x0303, 0x03C3, 0x0AAB, 0x03F3, 0x030F, 0x03CF, 0x0ABF, 0x03FF, 
   0x0300, 0x03C0, 0x0AA8, 0x03F0, 0x030C, 0x03D5, 0x0ABC, 0x03FC, 
   0x030A, 0x03CA, 0x0AAA, 0x03FA, 0x030F, 0x03CF, 0x0ABF, 0x03FF, 
   0x0300, 0x03C0, 0x0AA8, 0x03F0, 0x0315, 0x03D5, 0x0ABC, 0x03FC, 
   0x0303, 0x03C3, 0x0AAB, 0x03F3, 0x030F, 0x03CF, 0x0ABF, 0x03FF, 
   0x0300, 0x03C0, 0x0AA8, 0x03F0, 0x030C, 0x03D5, 0x0ABC, 0x03FC, 
   0x0303, 0x03C3, 0x0AAA, 0x03FA, 0x030F, 0x03CF, 0x0ABF, 0x03FF, 
   0x0301, 0x03C1, 0x0AA9, 0x03F1, 0x0315, 0x03D5, 0x0ABD, 0x03FD, 
   0x0303, 0x03C3, 0x0AAB, 0x03F3, 0x030F, 0x03CF, 0x0ABF, 0x03FF, 
   0x0300, 0x03C0, 0x0AA8, 0x03F0, 0x030C, 0x03D5, 0x0ABC, 0x03FC, 
   0x030A, 0x03CA, 0x0AAA, 0x03FA, 0x030F, 0x03CF, 0x0ABF, 0x03FF, 
   0x0300, 0x03C0, 0x0AA8, 0x03F0, 0x0315, 0x03D5, 0x0ABC, 0x03FC, 
   0x0303, 0x03C3, 0x0AAB, 0x03F3, 0x030F, 0x03CF, 0x0ABF, 0x03FF, 
   0x0300, 0x03C0, 0x0AA8, 0x03F0, 0x030C, 0x03D5, 0x0ABC, 0x03FC, 
   0x0303, 0x03C3, 0x0AAA, 0x03FA, 0x030F, 0x03CF, 0x0ABF, 0x03FF, 
   0x0300, 0x03C0, 0x0AA8, 0x03F0, 0x0315, 0x03D5, 0x0ABD, 0x03FD, 
   0x0303, 0x03C3, 0x0AAB, 0x03F3, 0x030F, 0x03CF, 0x0ABF, 0x03FF, 
   0x0300, 0x03C0, 0x0AA8, 0x03F0, 0x030C, 0x03D5, 0x0ABC, 0x03FC, 
   0x030A, 0x03CA, 0x0AAA, 0x03FA, 0x030F, 0x03CF, 0x0ABF, 0x03FF, 
   0x0300, 0x03C0, 0x0AA8, 0x03F0, 0x0315, 0x03D5, 0x0ABC, 0x03FC, 
   0x0303, 0x03C3, 0x0AAB, 0x03F3, 0x030F, 0x03CF, 0x0ABF, 0x03FF, 
   0x0300, 0x03C0, 0x0AA8, 0x03F0, 0x030C, 0x03D5, 0x0ABC, 0x03FC, 
   0x0303, 0x03C3, 0x0AAA, 0x03FA, 0x030F, 0x03CF, 0x0ABF, 0x03FF, 
   0x0301, 0x03C1, 0x0AA9, 0x03F1, 0x0315, 0x03D5, 0x0ABD, 0x03FD, 
   0x0303, 0x03C3, 0x0AAB, 0x03F3, 0x030F, 0x03CF, 0x0ABF, 0x03FF, 
   0x0300, 0x03C0, 0x0AA8, 0x03F0, 0x030C, 0x03D5, 0x0ABC, 0x03FC, 
   0x030A, 0x03CA, 0x0AAA, 0x03FA, 0x030F, 0x03CF, 0x0ABF, 0x03FF, 
   0x0300, 0x03C0, 0x0AA8, 0x03F0, 0x0315, 0x03D5, 0x0ABC, 0x03FC, 
   0x0303, 0x03C3, 0x0AAB, 0x03F3, 0x030F, 0x03CF, 0x0ABF, 0x03FF, 
   0x0300, 0x03C0, 0x0AA8, 0x03F0, 0x030C, 0x03D5, 0x0ABC, 0x03FC, 
   0x0303, 0x03C3, 0x0AAA, 0x03FA, 0x030F, 0x03CF, 0x0ABF, 0x03FF, 
   0x0300, 0x03C0, 0x0AA8, 0x03F0, 0x0315, 0x03D5, 0x0ABD, 0x03FD, 
   0x0303, 0x03C3, 0x0AAB, 0x03F3, 0x030F, 0x03CF, 0x0ABF, 0x03FF, 
   0x0300, 0x03C0, 0x0AA8, 0x03F0, 0x030C, 0x03D5, 0x0ABC, 0x03FC, 
   0x030A, 0x03CA, 0x0AAA, 0x03FA, 0x030F, 0x03CF, 0x0ABF, 0x03FF, 
   0x0300, 0x03C0, 0x0AA8, 0x03F0, 0x0315, 0x03D5, 0x0ABC, 0x03FC, 
   0x0303, 0x03C3, 0x0AAB, 0x03F3, 0x030F, 0x03CF, 0x0ABF, 0x03FF, 
   0x0300, 0x03C0, 0x0AA8, 0x03F0, 0x030C, 0x03D5, 0x0ABC, 0x03FC, 
   0x0303, 0x03C3, 0x0AAA, 0x03FA, 0x030F, 0x03CF, 0x0ABF, 0x03FF, 
   0x0301, 0x03C1, 0x0AA9, 0x03F1, 0x0315, 0x03D5, 0x0ABD, 0x03FD, 
   0x0303, 0x03C3, 0x0AAB, 0x03F3, 0x030F, 0x03CF, 0x0ABF, 0x03FF, 
   0x0300, 0x03C0, 0x0AA8, 0x03F0, 0x030C, 0x03D5, 0x0ABC, 0x03FC, 
   0x030A, 0x03CA, 0x0AAA, 0x03FA, 0x030F, 0x03CF, 0x0ABF, 0x03FF, 
   0x0300, 0x03C0, 0x0AA8, 0x03F0, 0x0315, 0x03D5, 0x0ABC, 0x03FC, 
   0x0303, 0x03C3, 0x0AAB, 0x03F3, 0x030F, 0x03CF, 0x0ABF, 0x03FF, 
   0x0300, 0x03C0, 0x0AA8, 0x03F0, 0x030C, 0x03D5, 0x0ABC, 0x03FC, 
   0x0303, 0x03C3, 0x0AAA, 0x03FA, 0x030F, 0x03CF, 0x0ABF, 0x03FF, 
   0x0300, 0x03C0, 0x0AA8, 0x03F0, 0x0315, 0x03D5, 0x0ABD, 0x03FD, 
   0x0303, 0x03C3, 0x0AAB, 0x03F3, 0x030F, 0x03CF, 0x0ABF, 0x03FF, 
   0x0300, 0x03C0, 0x0AA8, 0x03F0, 0x030C, 0x03D5, 0x0ABC, 0x03FC, 
   0x030A, 0x03CA, 0x0AAA, 0x03FA, 0x030F, 0x03CF, 0x0ABF, 0x03FF, 
   0x0300, 0x03C0, 0x0AA8, 0x03F0, 0x0315, 0x03D5, 0x0ABC, 0x03FC, 
   0x0303, 0x03C3, 0x0AAB, 0x03F3, 0x030F, 0x03CF, 0x0ABF, 0x03FF, 
   0x0300, 0x03C0, 0x0AA8, 0x03F0, 0x030C, 0x03D5, 0x0ABC, 0x03FC, 
   0x0303, 0x03C3, 0x0AAA, 0x03FA, 0x030F, 0x03CF, 0x0ABF, 0x03FF, 
   0x0301, 0x03C1, 0x0AA9, 0x03F1, 0x0315, 0x03D5, 0x0ABD, 0x03FD, 
   0x0303, 0x03C3, 0x0AAB, 0x03F3, 0x030F, 0x03CF, 0x0ABF, 0x03FF, 
   0x0300, 0x03C0, 0x0AA8, 0x03F0, 0x030C, 0x03D5, 0x0ABC, 0x03FC, 
   0x030A, 0x03CA, 0x0AAA, 0x03FA, 0x030F, 0x03CF, 0x0ABF, 0x03FF, 
   0x0300, 0x03C0, 0x0AA8, 0x03F0, 0x0315, 0x03D5, 0x0ABC, 0x03FC, 
   0x0303, 0x03C3, 0x0AAB, 0x03F3, 0x030F, 0x03CF, 0x0ABF, 0x03FF, 
   0x0300, 0x03C0, 0x0AA8, 0x03F0, 0x030C, 0x03D5, 0x0ABC, 0x03FC, 
   0x0303, 0x03C3, 0x0AAA, 0x03FA, 0x030F, 0x03CF, 0x0ABF, 0x03FF, 
   0x0300, 0x03C0, 0x0AA8, 0x03F0, 0x0315, 0x03D5, 0x0ABD, 0x03FD, 
   0x0303, 0x03C3, 0x0AAB, 0x03F3, 0x030F, 0x03CF, 0x0ABF, 0x03FF, 
   0x0300, 0x03C0, 0x0AA8, 0x03F0, 0x030C, 0x03D5, 0x0ABC, 0x03FC, 
   0x030A, 0x03CA, 0x0AAA, 0x03FA, 0x030F, 0x03CF, 0x0ABF, 0x03FF, 
   0x0300, 0x03C0, 0x0AA8, 0x03F0, 0x0315, 0x03D5, 0x0ABC, 0x03FC, 
   0x0303, 0x03C3, 0x0AAB, 0x03F3, 0x030F, 0x03CF, 0x0ABF, 0x03FF, 
   0x0300, 0x03C0, 0x0AA8, 0x03F0, 0x030C, 0x03D5, 0x0ABC, 0x03FC, 
   0x0303, 0x03C3, 0x0AAA, 0x03FA, 0x030F, 0x03CF, 0x0ABF, 0x03FF, 
   0x0301, 0x03C1, 0x0AA9, 0x03F1, 0x0315, 0x03D5, 0x0ABD, 0x03FD, 
   0x0303, 0x03C3, 0x0AAB, 0x03F3, 0x030F, 0x03CF, 0x0ABF, 0x03FF, 
   0x0300, 0x03C0, 0x0AA8, 0x03F0, 0x030C, 0x03D5, 0x0ABC, 0x03FC, 
   0x030A, 0x03CA, 0x0AAA, 0x03FA, 0x030F, 0x03CF, 0x0ABF, 0x03FF, 
   0x0300, 0x03C0, 0x0AA8, 0x03F0, 0x0315, 0x03D5, 0x0ABC, 0x03FC, 
   0x0303, 0x03C3, 0x0AAB, 0x03F3, 0x030F, 0x03CF, 0x0ABF, 0x03FF, 
   0x0300, 0x03C0, 0x0AA8, 0x03F0, 0x030C, 0x03D5, 0x0ABC, 0x03FC, 
   0x0303, 0x03C3, 0x0AAA, 0x03FA, 0x030F, 0x03CF, 0x0ABF, 0x03FF, 
   0x0300, 0x03C0, 0x0AA8, 0x03F0, 0x0315, 0x03D5, 0x0ABD, 0x03FD, 
   0x0303, 0x03C3, 0x0AAB, 0x03F3, 0x030F, 0x03CF, 0x0ABF, 0x03FF, 
   0x0300, 0x03C0, 0x0AA8, 0x03F0, 0x030C, 0x03D5, 0x0ABC, 0x03FC, 
   0x030A, 0x03CA, 0x0AAA, 0x03FA, 0x030F, 0x03CF, 0x0ABF, 0x03FF, 
   0x0300, 0x03C0, 0x0AA8, 0x03F0, 0x0315, 0x03D5, 0x0ABC, 0x03FC, 
   0x0303, 0x03C3, 0x0AAB, 0x03F3, 0x030F, 0x03CF, 0x0ABF, 0x03FF, 
   0x0300, 0x03C0, 0x0AA8, 0x03F0, 0x030C, 0x03D5, 0x0ABC, 0x03FC, 
   0x0303, 0x03C3, 0x0AAA, 0x03FA, 0x030F, 0x03CF, 0x0ABF, 0x03FF, 
   0x0301, 0x03C1, 0x0AA9, 0x03F1, 0x0315, 0x03D5, 0x0ABD, 0x03FD, 
   0x0303, 0x03C3, 0x0AAB, 0x03F3, 0x030F, 0x03CF, 0x0ABF, 0x03FF, 
   0x0300, 0x03C0, 0x0AA8, 0x03F0, 0x030C, 0x03D5, 0x0ABC, 0x03FC, 
   0x030A, 0x03CA, 0x0AAA, 0x03FA, 0x030F, 0x03CF, 0x0ABF, 0x03FF, 
   0x0300, 0x03C0, 0x0AA8, 0x03F0, 0x0315, 0x03D5, 0x0ABC, 0x03FC, 
   0x0303, 0x03C3, 0x0AAB, 0x03F3, 0x030F, 0x03CF, 0x0ABF, 0x03FF, 
   0x0300, 0x03C0, 0x0AA8, 0x03F0, 0x030C, 0x03D5, 0x0ABC, 0x03FC, 
   0x0303, 0x03C3, 0x0AAA, 0x03FA, 0x030F, 0x03CF, 0x0ABF, 0x03FF, 
   0x0300, 0x03C0, 0x0AA8, 0x03F0, 0x0315, 0x03D5, 0x0ABD, 0x03FD, 
   0x0303, 0x03C3, 0x0AAB, 0x03F3, 0x030F, 0x03CF, 0x0ABF, 0x03FF, 
   0x0300, 0x03C0, 0x0AA8, 0x03F0, 0x030C, 0x03D5, 0x0ABC, 0x03FC, 
   0x030A, 0x03CA, 0x0AAA, 0x03FA, 0x030F, 0x03CF, 0x0ABF, 0x03FF, 
   0x0300, 0x03C0, 0x0AA8, 0x03F0, 0x0315, 0x03D5, 0x0ABC, 0x03FC, 
   0x0303, 0x03C3, 0x0AAB, 0x03F3, 0x030F, 0x03CF, 0x0ABF, 0x03FF, 
   0x0300, 0x03C0, 0x0AA8, 0x03F0, 0x030C, 0x03D5, 0x0ABC, 0x03FC, 
   0x0303, 0x03C3, 0x0AAA, 0x03FA, 0x030F, 0x03CF, 0x0ABF, 0x03FF, 
   0x0301, 0x03C1, 0x0AA9, 0x03F1, 0x0315, 0x03D5, 0x0ABD, 0x03FD, 
   0x0303, 0x03C3, 0x0AAB, 0x03F3, 0x030F, 0x03CF, 0x0ABF, 0x03FF, 
   0x0300, 0x03C0, 0x0AA8, 0x03F0, 0x030C, 0x03D5, 0x0ABC, 0x03FC, 
   0x030A, 0x03CA, 0x0AAA, 0x03FA, 0x030F, 0x03CF, 0x0ABF, 0x03FF, 
   0x0300, 0x03C0, 0x0AA8, 0x03F0, 0x0315, 0x03D5, 0x0ABC, 0x03FC, 
   0x0303, 0x03C3, 0x0AAB, 0x03F3, 0x030F, 0x03CF, 0x0ABF, 0x03FF, 
   0x0300, 0x03C0, 0x0AA8, 0x03F0, 0x030C, 0x03D5, 0x0ABC, 0x03FC, 
   0x0303, 0x03C3, 0x0AAA, 0x03FA, 0x030F, 0x03CF, 0x0ABF, 0x03FF, 
   0x0300, 0x03C0, 0x0AA8, 0x03F0, 0x0315, 0x03D5, 0x0ABD, 0x03FD, 
   0x0303, 0x03C3, 0x0AAB, 0x03F3, 0x030F, 0x03CF, 0x0ABF, 0x03FF, 
   0x0300, 0x03C0, 0x0AA8, 0x03F0, 0x030C, 0x03D5, 0x0ABC, 0x03FC, 
   0x030A, 0x03CA, 0x0AAA, 0x03FA, 0x030F, 0x03CF, 0x0ABF, 0x03FF, 
   0x0300, 0x03C0, 0x0AA8, 0x03F0, 0x0315, 0x03D5, 0x0ABC, 0x03FC, 
   0x0303, 0x03C3, 0x0AAB, 0x03F3, 0x030F, 0x03CF, 0x0ABF, 0x03FF, 
   0x0300, 0x03C0, 0x0AA8, 0x03F0, 0x030C, 0x03D5, 0x0ABC, 0x03FC, 
   0x0303, 0x03C3, 0x0AAA, 0x03FA, 0x030F, 0x03CF, 0x0ABF, 0x03FF, 
   0x0301, 0x03C1, 0x0AA9, 0x03F1, 0x0315, 0x03D5, 0x0ABD, 0x03FD, 
   0x0303, 0x03C3, 0x0AAB, 0x03F3, 0x030F, 0x03CF, 0x0ABF, 0x03FF, 
   0x0300, 0x03C0, 0x0AA8, 0x03F0, 0x030C, 0x03D5, 0x0ABC, 0x03FC, 
   0x030A, 0x03CA, 0x0AAA, 0x03FA, 0x030F, 0x03CF, 0x0ABF, 0x03FF, 
   0x0300, 0x03C0, 0x0AA8, 0x03F0, 0x0315, 0x03D5, 0x0ABC, 0x03FC, 
   0x0303, 0x03C3, 0x0AAB, 0x03F3, 0x030F, 0x03CF, 0x0ABF, 0x03FF, 
   0x0300, 0x03C0, 0x0AA8, 0x03F0, 0x030C, 0x03D5, 0x0ABC, 0x03FC, 
   0x0303, 0x03C3, 0x0AAA, 0x03FA, 0x030F, 0x03CF, 0x0ABF, 0x03FF, 
   0x0300, 0x03C0, 0x0AA8, 0x03F0, 0x0315, 0x03D5, 0x0ABD, 0x03FD, 
   0x0303, 0x03C3, 0x0AAB, 0x03F3, 0x030F, 0x03CF, 0x0ABF, 0x03FF, 
   0x0300, 0x03C0, 0x0AA8, 0x03F0, 0x030C, 0x03D5, 0x0ABC, 0x03FC, 
   0x030A, 0x03CA, 0x0AAA, 0x03FA, 0x030F, 0x03CF, 0x0ABF, 0x03FF, 
   0x0300, 0x03C0, 0x0AA8, 0x03F0, 0x0315, 0x03D5, 0x0ABC, 0x03FC, 
   0x0303, 0x03C3, 0x0AAB, 0x03F3, 0x030F, 0x03CF, 0x0ABF, 0x03FF, 
   0x0300, 0x03C0, 0x0AA8, 0x03F0, 0x030C, 0x03D5, 0x0ABC, 0x03FC, 
   0x0303, 0x03C3, 0x0AAA, 0x03FA, 0x030F, 0x03CF, 0x0ABF, 0x03FF, 
   0x0301, 0x03C1, 0x0AA9, 0x03F1, 0x0315, 0x03D5, 0x0ABD, 0x03FD, 
   0x0303, 0x03C3, 0x0AAB, 0x03F3, 0x030F, 0x03CF, 0x0ABF, 0x03FF, 
   0x0300, 0x03C0, 0x0AA8, 0x03F0, 0x030C, 0x03D5, 0x0ABC, 0x03FC, 
   0x030A, 0x03CA, 0x0AAA, 0x03FA, 0x030F, 0x03CF, 0x0ABF, 0x03FF, 
   0x0300, 0x03C0, 0x0AA8, 0x03F0, 0x0315, 0x03D5, 0x0ABC, 0x03FC, 
   0x0303, 0x03C3, 0x0AAB, 0x03F3, 0x030F, 0x03CF, 0x0ABF, 0x03FF, 
   0x1300, 0x13C0, 0x1AA8, 0x13F0, 0x130C, 0x13D5, 0x1ABC, 0x13FC, 
   0x1303, 0x13C3, 0x1AAA, 0x13FA, 0x130F, 0x13CF, 0x1ABF, 0x13FF, 
   0x1300, 0x13C0, 0x1AA8, 0x13F0, 0x1315, 0x13D5, 0x1ABD, 0x13FD, 
   0x1303, 0x13C3, 0x1AAB, 0x13F3, 0x130F, 0x13CF, 0x1ABF, 0x13FF, 
   0x1300, 0x13C0, 0x1AA8, 0x13F0, 0x130C, 0x13D5, 0x1ABC, 0x13FC, 
   0x130A, 0x13CA, 0x1AAA, 0x13FA, 0x130F, 0x13CF, 0x1ABF, 0x13FF, 
   0x1300, 0x13C0, 0x1AA8, 0x13F0, 0x1315, 0x13D5, 0x1ABC, 0x13FC, 
   0x1303, 0x13C3, 0x1AAB, 0x13F3, 0x130F, 0x13CF, 0x1ABF, 0x13FF, 
   0x1300, 0x13C0, 0x1AA8, 0x13F0, 0x130C, 0x13D5, 0x1ABC, 0x13FC, 
   0x1303, 0x13C3, 0x1AAA, 0x13FA, 0x130F, 0x13CF, 0x1ABF, 0x13FF, 
   0x1301, 0x13C1, 0x1AA9, 0x13F1, 0x1315, 0x13D5, 0x1ABD, 0x13FD, 
   0x1303, 0x13C3, 0x1AAB, 0x13F3, 0x130F, 0x13CF, 0x1ABF, 0x13FF, 
   0x1300, 0x13C0, 0x1AA8, 0x13F0, 0x130C, 0x13D5, 0x1ABC, 0x13FC, 
   0x130A, 0x13CA, 0x1AAA, 0x13FA, 0x130F, 0x13CF, 0x1ABF, 0x13FF, 
   0x1300, 0x13C0, 0x1AA8, 0x13F0, 0x1315, 0x13D5, 0x1ABC, 0x13FC, 
   0x1303, 0x13C3, 0x1AAB, 0x13F3, 0x130F, 0x13CF, 0x1ABF, 0x13FF, 
   0x1300, 0x13C0, 0x1AA8, 0x13F0, 0x130C, 0x13D5, 0x1ABC, 0x13FC, 
   0x1303, 0x13C3, 0x1AAA, 0x13FA, 0x130F, 0x13CF, 0x1ABF, 0x13FF, 
   0x1300, 0x13C0, 0x1AA8, 0x13F0, 0x1315, 0x13D5, 0x1ABD, 0x13FD, 
   0x1303, 0x13C3, 0x1AAB, 0x13F3, 0x130F, 0x13CF, 0x1ABF, 0x13FF, 
   0x1300, 0x13C0, 0x1AA8, 0x13F0, 0x130C, 0x13D5, 0x1ABC, 0x13FC, 
   0x130A, 0x13CA, 0x1AAA, 0x13FA, 0x130F, 0x13CF, 0x1ABF, 0x13FF, 
   0x1300, 0x13C0, 0x1AA8, 0x13F0, 0x1315, 0x13D5, 0x1ABC, 0x13FC, 
   0x1303, 0x13C3, 0x1AAB, 0x13F3, 0x130F, 0x13CF, 0x1ABF, 0x13FF, 
   0x1300, 0x13C0, 0x1AA8, 0x13F0, 0x130C, 0x13D5, 0x1ABC, 0x13FC, 
   0x1303, 0x13C3, 0x1AAA, 0x13FA, 0x130F, 0x13CF, 0x1ABF, 0x13FF, 
   0x1301, 0x13C1, 0x1AA9, 0x13F1, 0x1315, 0x13D5, 0x1ABD, 0x13FD, 
   0x1303, 0x13C3, 0x1AAB, 0x13F3, 0x130F, 0x13CF, 0x1ABF, 0x13FF, 
   0x1300, 0x13C0, 0x1AA8, 0x13F0, 0x130C, 0x13D5, 0x1ABC, 0x13FC, 
   0x130A, 0x13CA, 0x1AAA, 0x13FA, 0x130F, 0x13CF, 0x1ABF, 0x13FF, 
   0x1300, 0x13C0, 0x1AA8, 0x13F0, 0x1315, 0x13D5, 0x1ABC, 0x13FC, 
   0x1303, 0x13C3, 0x1AAB, 0x13F3, 0x130F, 0x13CF, 0x1ABF, 0x13FF, 
   0x0300, 0x03C0, 0x0AA8, 0x03F0, 0x030C, 0x03D5, 0x0ABC, 0x03FC, 
   0x0303, 0x03C3, 0x0AAA, 0x03FA, 0x030F, 0x03CF, 0x0ABF, 0x03FF, 
   0x0300, 0x03C0, 0x0AA8, 0x03F0, 0x0315, 0x03D5, 0x0ABD, 0x03FD, 
   0x0303, 0x03C3, 0x0AAB, 0x03F3, 0x030F, 0x03CF, 0x0ABF, 0x03FF, 
   0x0300, 0x03C0, 0x0AA8, 0x03F0, 0x030C, 0x03D5, 0x0ABC, 0x03FC, 
   0x030A, 0x03CA, 0x0AAA, 0x03FA, 0x030F, 0x03CF, 0x0ABF, 0x03FF, 
   0x0300, 0x03C0, 0x0AA8, 0x03F0, 0x0315, 0x03D5, 0x0ABC, 0x03FC, 
   0x0303, 0x03C3, 0x0AAB, 0x03F3, 0x030F, 0x03CF, 0x0ABF, 0x03FF, 
   0x0300, 0x03C0, 0x0AA8, 0x03F0, 0x030C, 0x03D5, 0x0ABC, 0x03FC, 
   0x0303, 0x03C3, 0x0AAA, 0x03FA, 0x030F, 0x03CF, 0x0ABF, 0x03FF, 
   0x0301, 0x03C1, 0x0AA9, 0x03F1, 0x0315, 0x03D5, 0x0ABD, 0x03FD, 
   0x0303, 0x03C3, 0x0AAB, 0x03F3, 0x030F, 0x03CF, 0x0ABF, 0x03FF, 
   0x0300, 0x03C0, 0x0AA8, 0x03F0, 0x030C, 0x03D5, 0x0ABC, 0x03FC, 
   0x030A, 0x03CA, 0x0AAA, 0x03FA, 0x030F, 0x03CF, 0x0ABF, 0x03FF, 
   0x0300, 0x03C0, 0x0AA8, 0x03F0, 0x0315, 0x03D5, 0x0ABC, 0x03FC, 
   0x0303, 0x03C3, 0x0AAB, 0x03F3, 0x030F, 0x03CF, 0x0ABF, 0x03FF, 
   0x0300, 0x03C0, 0x0AA8, 0x03F0, 0x030C, 0x03D5, 0x0ABC, 0x03FC, 
   0x0303, 0x03C3, 0x0AAA, 0x03FA, 0x030F, 0x03CF, 0x0ABF, 0x03FF, 
   0x0300, 0x03C0, 0x0AA8, 0x03F0, 0x0315, 0x03D5, 0x0ABD, 0x03FD, 
   0x0303, 0x03C3, 0x0AAB, 0x03F3, 0x030F, 0x03CF, 0x0ABF, 0x03FF, 
   0x0300, 0x03C0, 0x0AA8, 0x03F0, 0x030C, 0x03D5, 0x0ABC, 0x03FC, 
   0x030A, 0x03CA, 0x0AAA, 0x03FA, 0x030F, 0x03CF, 0x0ABF, 0x03FF, 
   0x0300, 0x03C0, 0x0AA8, 0x03F0, 0x0315, 0x03D5, 0x0ABC, 0x03FC, 
   0x0303, 0x03C3, 0x0AAB, 0x03F3, 0x030F, 0x03CF, 0x0ABF, 0x03FF, 
   0x0300, 0x03C0, 0x0AA8, 0x03F0, 0x030C, 0x03D5, 0x0ABC, 0x03FC, 
   0x0303, 0x03C3, 0x0AAA, 0x03FA, 0x030F, 0x03CF, 0x0ABF, 0x03FF, 
   0x0301, 0x03C1, 0x0AA9, 0x03F1, 0x0315, 0x03D5, 0x0ABD, 0x03FD, 
   0x0303, 0x03C3, 0x0AAB, 0x03F3, 0x030F, 0x03CF, 0x0ABF, 0x03FF, 
   0x0300, 0x03C0, 0x0AA8, 0x03F0, 0x030C, 0x03D5, 0x0ABC, 0x03FC, 
   0x030A, 0x03CA, 0x0AAA, 0x03FA, 0x030F, 0x03CF, 0x0ABF, 0x03FF, 
   0x0300, 0x03C0, 0x0AA8, 0x03F0, 0x0315, 0x03D5, 0x0ABC, 0x03FC, 
   0x0303, 0x03C3, 0x0AAB, 0x03F3, 0x030F, 0x03CF, 0x0ABF, 0x03FF, 
   0x0300, 0x03C0, 0x0AA8, 0x03F0, 0x030C, 0x03D5, 0x0ABC, 0x03FC, 
   0x0303, 0x03C3, 0x0AAA, 0x03FA, 0x030F, 0x03CF, 0x0ABF, 0x03FF, 
   0x0300, 0x03C0, 0x0AA8, 0x03F0, 0x0315, 0x03D5, 0x0ABD, 0x03FD, 
   0x0303, 0x03C3, 0x0AAB, 0x03F3, 0x030F, 0x03CF, 0x0ABF, 0x03FF, 
   0x0300, 0x03C0, 0x0AA8, 0x03F0, 0x030C, 0x03D5, 0x0ABC, 0x03FC, 
   0x030A, 0x03CA, 0x0AAA, 0x03FA, 0x030F, 0x03CF, 0x0ABF, 0x03FF, 
   0x0300, 0x03C0, 0x0AA8, 0x03F0, 0x0315, 0x03D5, 0x0ABC, 0x03FC, 
   0x0303, 0x03C3, 0x0AAB, 0x03F3, 0x030F, 0x03CF, 0x0ABF, 0x03FF, 
   0x0300, 0x03C0, 0x0AA8, 0x03F0, 0x030C, 0x03D5, 0x0ABC, 0x03FC, 
   0x0303, 0x03C3, 0x0AAA, 0x03FA, 0x030F, 0x03CF, 0x0ABF, 0x03FF, 
   0x0301, 0x03C1, 0x0AA9, 0x03F1, 0x0315, 0x03D5, 0x0ABD, 0x03FD, 
   0x0303, 0x03C3, 0x0AAB, 0x03F3, 0x030F, 0x03CF, 0x0ABF, 0x03FF, 
   0x0300, 0x03C0, 0x0AA8, 0x03F0, 0x030C, 0x03D5, 0x0ABC, 0x03FC, 
   0x030A, 0x03CA, 0x0AAA, 0x03FA, 0x030F, 0x03CF, 0x0ABF, 0x03FF, 
   0x0300, 0x03C0, 0x0AA8, 0x03F0, 0x0315, 0x03D5, 0x0ABC, 0x03FC, 
   0x0303, 0x03C3, 0x0AAB, 0x03F3, 0x030F, 0x03CF, 0x0ABF, 0x03FF, 
   0x0300, 0x03C0, 0x0AA8, 0x03F0, 0x030C, 0x03D5, 0x0ABC, 0x03FC, 
   0x0303, 0x03C3, 0x0AAA, 0x03FA, 0x030F, 0x03CF, 0x0ABF, 0x03FF, 
   0x0300, 0x03C0, 0x0AA8, 0x03F0, 0x0315, 0x03D5, 0x0ABD, 0x03FD, 
   0x0303, 0x03C3, 0x0AAB, 0x03F3, 0x030F, 0x03CF, 0x0ABF, 0x03FF, 
   0x0300, 0x03C0, 0x0AA8, 0x03F0, 0x030C, 0x03D5, 0x0ABC, 0x03FC, 
   0x030A, 0x03CA, 0x0AAA, 0x03FA, 0x030F, 0x03CF, 0x0ABF, 0x03FF, 
   0x0300, 0x03C0, 0x0AA8, 0x03F0, 0x0315, 0x03D5, 0x0ABC, 0x03FC, 
   0x0303, 0x03C3, 0x0AAB, 0x03F3, 0x030F, 0x03CF, 0x0ABF, 0x03FF, 
   0x0300, 0x03C0, 0x0AA8, 0x03F0, 0x030C, 0x03D5, 0x0ABC, 0x03FC, 
   0x0303, 0x03C3, 0x0AAA, 0x03FA, 0x030F, 0x03CF, 0x0ABF, 0x03FF, 
   0x0301, 0x03C1, 0x0AA9, 0x03F1, 0x0315, 0x03D5, 0x0ABD, 0x03FD, 
   0x0303, 0x03C3, 0x0AAB, 0x03F3, 0x030F, 0x03CF, 0x0ABF, 0x03FF, 
   0x0300, 0x03C0, 0x0AA8, 0x03F0, 0x030C, 0x03D5, 0x0ABC, 0x03FC, 
   0x030A, 0x03CA, 0x0AAA, 0x03FA, 0x030F, 0x03CF, 0x0ABF, 0x03FF, 
   0x0300, 0x03C0, 0x0AA8, 0x03F0, 0x0315, 0x03D5, 0x0ABC, 0x03FC, 
   0x0303, 0x03C3, 0x0AAB, 0x03F3, 0x030F, 0x03CF, 0x0ABF, 0x03FF, 
   0x2A80, 0x2BC0, 0x2AA8, 0x2BF0, 0x2A8C, 0x2BD5, 0x2ABC, 0x2BFC, 
   0x2A83, 0x2BC3, 0x2AAA, 0x2BFA, 0x2A8F, 0x2BCF, 0x2ABF, 0x2BFF, 
   0x2A80, 0x2BC0, 0x2AA8, 0x2BF0, 0x2A95, 0x2BD5, 0x2ABD, 0x2BFD, 
   0x2A83, 0x2BC3, 0x2AAB, 0x2BF3, 0x2A8F, 0x2BCF, 0x2ABF, 0x2BFF, 
   0x2A80, 0x2BC0, 0x2AA8, 0x2BF0, 0x2A8C, 0x2BD5, 0x2ABC, 0x2BFC, 
   0x2A8A, 0x2BCA, 0x2AAA, 0x2BFA, 0x2A8F, 0x2BCF, 0x2ABF, 0x2BFF, 
   0x2A80, 0x2BC0, 0x2AA8, 0x2BF0, 0x2A95, 0x2BD5, 0x2ABC, 0x2BFC, 
   0x2A83, 0x2BC3, 0x2AAB, 0x2BF3, 0x2A8F, 0x2BCF, 0x2ABF, 0x2BFF, 
   0x2A80, 0x2BC0, 0x2AA8, 0x2BF0, 0x2A8C, 0x2BD5, 0x2ABC, 0x2BFC, 
   0x2A83, 0x2BC3, 0x2AAA, 0x2BFA, 0x2A8F, 0x2BCF, 0x2ABF, 0x2BFF, 
   0x2A81, 0x2BC1, 0x2AA9, 0x2BF1, 0x2A95, 0x2BD5, 0x2ABD, 0x2BFD, 
   0x2A83, 0x2BC3, 0x2AAB, 0x2BF3, 0x2A8F, 0x2BCF, 0x2ABF, 0x2BFF, 
   0x2A80, 0x2BC0, 0x2AA8, 0x2BF0, 0x2A8C, 0x2BD5, 0x2ABC, 0x2BFC, 
   0x2A8A, 0x2BCA, 0x2AAA, 0x2BFA, 0x2A8F, 0x2BCF, 0x2ABF, 0x2BFF, 
   0x2A80, 0x2BC0, 0x2AA8, 0x2BF0, 0x2A95, 0x2BD5, 0x2ABC, 0x2BFC, 
   0x2A83, 0x2BC3, 0x2AAB, 0x2BF3, 0x2A8F, 0x2BCF, 0x2ABF, 0x2BFF, 
   0x2A80, 0x2BC0, 0x2AA8, 0x2BF0, 0x2A8C, 0x2BD5, 0x2ABC, 0x2BFC, 
   0x2A83, 0x2BC3, 0x2AAA, 0x2BFA, 0x2A8F, 0x2BCF, 0x2ABF, 0x2BFF, 
   0x2A80, 0x2BC0, 0x2AA8, 0x2BF0, 0x2A95, 0x2BD5, 0x2ABD, 0x2BFD, 
   0x2A83, 0x2BC3, 0x2AAB, 0x2BF3, 0x2A8F, 0x2BCF, 0x2ABF, 0x2BFF, 
   0x2A80, 0x2BC0, 0x2AA8, 0x2BF0, 0x2A8C, 0x2BD5, 0x2ABC, 0x2BFC, 
   0x2A8A, 0x2BCA, 0x2AAA, 0x2BFA, 0x2A8F, 0x2BCF, 0x2ABF, 0x2BFF, 
   0x2A80, 0x2BC0, 0x2AA8, 0x2BF0, 0x2A95, 0x2BD5, 0x2ABC, 0x2BFC, 
   0x2A83, 0x2BC3, 0x2AAB, 0x2BF3, 0x2A8F, 0x2BCF, 0x2ABF, 0x2BFF, 
   0x2A80, 0x2BC0, 0x2AA8, 0x2BF0, 0x2A8C, 0x2BD5, 0x2ABC, 0x2BFC, 
   0x2A83, 0x2BC3, 0x2AAA, 0x2BFA, 0x2A8F, 0x2BCF, 0x2ABF, 0x2BFF, 
   0x2A81, 0x2BC1, 0x2AA9, 0x2BF1, 0x2A95, 0x2BD5, 0x2ABD, 0x2BFD, 
   0x2A83, 0x2BC3, 0x2AAB, 0x2BF3, 0x2A8F, 0x2BCF, 0x2ABF, 0x2BFF, 
   0x2A80, 0x2BC0, 0x2AA8, 0x2BF0, 0x2A8C, 0x2BD5, 0x2ABC, 0x2BFC, 
   0x2A8A, 0x2BCA, 0x2AAA, 0x2BFA, 0x2A8F, 0x2BCF, 0x2ABF, 0x2BFF, 
   0x2A80, 0x2BC0, 0x2AA8, 0x2BF0, 0x2A95, 0x2BD5, 0x2ABC, 0x2BFC, 
   0x2A83, 0x2BC3, 0x2AAB, 0x2BF3, 0x2A8F, 0x2BCF, 0x2ABF, 0x2BFF, 
   0x2A80, 0x2BC0, 0x2AA8, 0x2BF0, 0x2A8C, 0x2BD5, 0x2ABC, 0x2BFC, 
   0x2A83, 0x2BC3, 0x2AAA, 0x2BFA, 0x2A8F, 0x2BCF, 0x2ABF, 0x2BFF, 
   0x2A80, 0x2BC0, 0x2AA8, 0x2BF0, 0x2A95, 0x2BD5, 0x2ABD, 0x2BFD, 
   0x2A83, 0x2BC3, 0x2AAB, 0x2BF3, 0x2A8F, 0x2BCF, 0x2ABF, 0x2BFF, 
   0x2A80, 0x2BC0, 0x2AA8, 0x2BF0, 0x2A8C, 0x2BD5, 0x2ABC, 0x2BFC, 
   0x2A8A, 0x2BCA, 0x2AAA, 0x2BFA, 0x2A8F, 0x2BCF, 0x2ABF, 0x2BFF, 
   0x2A80, 0x2BC0, 0x2AA8, 0x2BF0, 0x2A95, 0x2BD5, 0x2ABC, 0x2BFC, 
   0x2A83, 0x2BC3, 0x2AAB, 0x2BF3, 0x2A8F, 0x2BCF, 0x2ABF, 0x2BFF, 
   0x2A80, 0x2BC0, 0x2AA8, 0x2BF0, 0x2A8C, 0x2BD5, 0x2ABC, 0x2BFC, 
   0x2A83, 0x2BC3, 0x2AAA, 0x2BFA, 0x2A8F, 0x2BCF, 0x2ABF, 0x2BFF, 
   0x2A81, 0x2BC1, 0x2AA9, 0x2BF1, 0x2A95, 0x2BD5, 0x2ABD, 0x2BFD, 
   0x2A83, 0x2BC3, 0x2AAB, 0x2BF3, 0x2A8F, 0x2BCF, 0x2ABF, 0x2BFF, 
   0x2A80, 0x2BC0, 0x2AA8, 0x2BF0, 0x2A8C, 0x2BD5, 0x2ABC, 0x2BFC, 
   0x2A8A, 0x2BCA, 0x2AAA, 0x2BFA, 0x2A8F, 0x2BCF, 0x2ABF, 0x2BFF, 
   0x2A80, 0x2BC0, 0x2AA8, 0x2BF0, 0x2A95, 0x2BD5, 0x2ABC, 0x2BFC, 
   0x2A83, 0x2BC3, 0x2AAB, 0x2BF3, 0x2A8F, 0x2BCF, 0x2ABF, 0x2BFF, 
   0x2A80, 0x2BC0, 0x2AA8, 0x2BF0, 0x2A8C, 0x2BD5, 0x2ABC, 0x2BFC, 
   0x2A83, 0x2BC3, 0x2AAA, 0x2BFA, 0x2A8F, 0x2BCF, 0x2ABF, 0x2BFF, 
   0x2A80, 0x2BC0, 0x2AA8, 0x2BF0, 0x2A95, 0x2BD5, 0x2ABD, 0x2BFD, 
   0x2A83, 0x2BC3, 0x2AAB, 0x2BF3, 0x2A8F, 0x2BCF, 0x2ABF, 0x2BFF, 
   0x2A80, 0x2BC0, 0x2AA8, 0x2BF0, 0x2A8C, 0x2BD5, 0x2ABC, 0x2BFC, 
   0x2A8A, 0x2BCA, 0x2AAA, 0x2BFA, 0x2A8F, 0x2BCF, 0x2ABF, 0x2BFF, 
   0x2A80, 0x2BC0, 0x2AA8, 0x2BF0, 0x2A95, 0x2BD5, 0x2ABC, 0x2BFC, 
   0x2A83, 0x2BC3, 0x2AAB, 0x2BF3, 0x2A8F, 0x2BCF, 0x2ABF, 0x2BFF, 
   0x2A80, 0x2BC0, 0x2AA8, 0x2BF0, 0x2A8C, 0x2BD5, 0x2ABC, 0x2BFC, 
   0x2A83, 0x2BC3, 0x2AAA, 0x2BFA, 0x2A8F, 0x2BCF, 0x2ABF, 0x2BFF, 
   0x2A81, 0x2BC1, 0x2AA9, 0x2BF1, 0x2A95, 0x2BD5, 0x2ABD, 0x2BFD, 
   0x2A83, 0x2BC3, 0x2AAB, 0x2BF3, 0x2A8F, 0x2BCF, 0x2ABF, 0x2BFF, 
   0x2A80, 0x2BC0, 0x2AA8, 0x2BF0, 0x2A8C, 0x2BD5, 0x2ABC, 0x2BFC, 
   0x2A8A, 0x2BCA, 0x2AAA, 0x2BFA, 0x2A8F, 0x2BCF, 0x2ABF, 0x2BFF, 
   0x2A80, 0x2BC0, 0x2AA8, 0x2BF0, 0x2A95, 0x2BD5, 0x2ABC, 0x2BFC, 
   0x2A83, 0x2BC3, 0x2AAB, 0x2BF3, 0x2A8F, 0x2BCF, 0x2ABF, 0x2BFF, 
   0x2A80, 0x2BC0, 0x2AA8, 0x2BF0, 0x2A8C, 0x2BD5, 0x2ABC, 0x2BFC, 
   0x2A83, 0x2BC3, 0x2AAA, 0x2BFA, 0x2A8F, 0x2BCF, 0x2ABF, 0x2BFF, 
   0x2A80, 0x2BC0, 0x2AA8, 0x2BF0, 0x2A95, 0x2BD5, 0x2ABD, 0x2BFD, 
   0x2A83, 0x2BC3, 0x2AAB, 0x2BF3, 0x2A8F, 0x2BCF, 0x2ABF, 0x2BFF, 
   0x2A80, 0x2BC0, 0x2AA8, 0x2BF0, 0x2A8C, 0x2BD5, 0x2ABC, 0x2BFC, 
   0x2A8A, 0x2BCA, 0x2AAA, 0x2BFA, 0x2A8F, 0x2BCF, 0x2ABF, 0x2BFF, 
   0x2A80, 0x2BC0, 0x2AA8, 0x2BF0, 0x2A95, 0x2BD5, 0x2ABC, 0x2BFC, 
   0x2A83, 0x2BC3, 0x2AAB, 0x2BF3, 0x2A8F, 0x2BCF, 0x2ABF, 0x2BFF, 
   0x2A80, 0x2BC0, 0x2AA8, 0x2BF0, 0x2A8C, 0x2BD5, 0x2ABC, 0x2BFC, 
   0x2A83, 0x2BC3, 0x2AAA, 0x2BFA, 0x2A8F, 0x2BCF, 0x2ABF, 0x2BFF, 
   0x2A81, 0x2BC1, 0x2AA9, 0x2BF1, 0x2A95, 0x2BD5, 0x2ABD, 0x2BFD, 
   0x2A83, 0x2BC3, 0x2AAB, 0x2BF3, 0x2A8F, 0x2BCF, 0x2ABF, 0x2BFF, 
   0x2A80, 0x2BC0, 0x2AA8, 0x2BF0, 0x2A8C, 0x2BD5, 0x2ABC, 0x2BFC, 
   0x2A8A, 0x2BCA, 0x2AAA, 0x2BFA, 0x2A8F, 0x2BCF, 0x2ABF, 0x2BFF, 
   0x2A80, 0x2BC0, 0x2AA8, 0x2BF0, 0x2A95, 0x2BD5, 0x2ABC, 0x2BFC, 
   0x2A83, 0x2BC3, 0x2AAB, 0x2BF3, 0x2A8F, 0x2BCF, 0x2ABF, 0x2BFF, 
   0x2A80, 0x2BC0, 0x2AA8, 0x2BF0, 0x2A8C, 0x2BD5, 0x2ABC, 0x2BFC, 
   0x2A83, 0x2BC3, 0x2AAA, 0x2BFA, 0x2A8F, 0x2BCF, 0x2ABF, 0x2BFF, 
   0x2A80, 0x2BC0, 0x2AA8, 0x2BF0, 0x2A95, 0x2BD5, 0x2ABD, 0x2BFD, 
   0x2A83, 0x2BC3, 0x2AAB, 0x2BF3, 0x2A8F, 0x2BCF, 0x2ABF, 0x2BFF, 
   0x2A80, 0x2BC0, 0x2AA8, 0x2BF0, 0x2A8C, 0x2BD5, 0x2ABC, 0x2BFC, 
   0x2A8A, 0x2BCA, 0x2AAA, 0x2BFA, 0x2A8F, 0x2BCF, 0x2ABF, 0x2BFF, 
   0x2A80, 0x2BC0, 0x2AA8, 0x2BF0, 0x2A95, 0x2BD5, 0x2ABC, 0x2BFC, 
   0x2A83, 0x2BC3, 0x2AAB, 0x2BF3, 0x2A8F, 0x2BCF, 0x2ABF, 0x2BFF, 
   0x2A80, 0x2BC0, 0x2AA8, 0x2BF0, 0x2A8C, 0x2BD5, 0x2ABC, 0x2BFC, 
   0x2A83, 0x2BC3, 0x2AAA, 0x2BFA, 0x2A8F, 0x2BCF, 0x2ABF, 0x2BFF, 
   0x2A81, 0x2BC1, 0x2AA9, 0x2BF1, 0x2A95, 0x2BD5, 0x2ABD, 0x2BFD, 
   0x2A83, 0x2BC3, 0x2AAB, 0x2BF3, 0x2A8F, 0x2BCF, 0x2ABF, 0x2BFF, 
   0x2A80, 0x2BC0, 0x2AA8, 0x2BF0, 0x2A8C, 0x2BD5, 0x2ABC, 0x2BFC, 
   0x2A8A, 0x2BCA, 0x2AAA, 0x2BFA, 0x2A8F, 0x2BCF, 0x2ABF, 0x2BFF, 
   0x2A80, 0x2BC0, 0x2AA8, 0x2BF0, 0x2A95, 0x2BD5, 0x2ABC, 0x2BFC, 
   0x2A83, 0x2BC3, 0x2AAB, 0x2BF3, 0x2A8F, 0x2BCF, 0x2ABF, 0x2BFF, 
   0x2A80, 0x2BC0, 0x2AA8, 0x2BF0, 0x2A8C, 0x2BD5, 0x2ABC, 0x2BFC, 
   0x2A83, 0x2BC3, 0x2AAA, 0x2BFA, 0x2A8F, 0x2BCF, 0x2ABF, 0x2BFF, 
   0x2A80, 0x2BC0, 0x2AA8, 0x2BF0, 0x2A95, 0x2BD5, 0x2ABD, 0x2BFD, 
   0x2A83, 0x2BC3, 0x2AAB, 0x2BF3, 0x2A8F, 0x2BCF, 0x2ABF, 0x2BFF, 
   0x2A80, 0x2BC0, 0x2AA8, 0x2BF0, 0x2A8C, 0x2BD5, 0x2ABC, 0x2BFC, 
   0x2A8A, 0x2BCA, 0x2AAA, 0x2BFA, 0x2A8F, 0x2BCF, 0x2ABF, 0x2BFF, 
   0x2A80, 0x2BC0, 0x2AA8, 0x2BF0, 0x2A95, 0x2BD5, 0x2ABC, 0x2BFC, 
   0x2A83, 0x2BC3, 0x2AAB, 0x2BF3, 0x2A8F, 0x2BCF, 0x2ABF, 0x2BFF, 
   0x2A80, 0x2BC0, 0x2AA8, 0x2BF0, 0x2A8C, 0x2BD5, 0x2ABC, 0x2BFC, 
   0x2A83, 0x2BC3, 0x2AAA, 0x2BFA, 0x2A8F, 0x2BCF, 0x2ABF, 0x2BFF, 
   0x2A81, 0x2BC1, 0x2AA9, 0x2BF1, 0x2A95, 0x2BD5, 0x2ABD, 0x2BFD, 
   0x2A83, 0x2BC3, 0x2AAB, 0x2BF3, 0x2A8F, 0x2BCF, 0x2ABF, 0x2BFF, 
   0x2A80, 0x2BC0, 0x2AA8, 0x2BF0, 0x2A8C, 0x2BD5, 0x2ABC, 0x2BFC, 
   0x2A8A, 0x2BCA, 0x2AAA, 0x2BFA, 0x2A8F, 0x2BCF, 0x2ABF, 0x2BFF, 
   0x2A80, 0x2BC0, 0x2AA8, 0x2BF0, 0x2A95, 0x2BD5, 0x2ABC, 0x2BFC, 
   0x2A83, 0x2BC3, 0x2AAB, 0x2BF3, 0x2A8F, 0x2BCF, 0x2ABF, 0x2BFF, 
   0x2A80, 0x2BC0, 0x2AA8, 0x2BF0, 0x2A8C, 0x2BD5, 0x2ABC, 0x2BFC, 
   0x2A83, 0x2BC3, 0x2AAA, 0x2BFA, 0x2A8F, 0x2BCF, 0x2ABF, 0x2BFF, 
   0x2A80, 0x2BC0, 0x2AA8, 0x2BF0, 0x2A95, 0x2BD5, 0x2ABD, 0x2BFD, 
   0x2A83, 0x2BC3, 0x2AAB, 0x2BF3, 0x2A8F, 0x2BCF, 0x2ABF, 0x2BFF, 
   0x2A80, 0x2BC0, 0x2AA8, 0x2BF0, 0x2A8C, 0x2BD5, 0x2ABC, 0x2BFC, 
   0x2A8A, 0x2BCA, 0x2AAA, 0x2BFA, 0x2A8F, 0x2BCF, 0x2ABF, 0x2BFF, 
   0x2A80, 0x2BC0, 0x2AA8, 0x2BF0, 0x2A95, 0x2BD5, 0x2ABC, 0x2BFC, 
   0x2A83, 0x2BC3, 0x2AAB, 0x2BF3, 0x2A8F, 0x2BCF, 0x2ABF, 0x2BFF, 
   0x2A80, 0x2BC0, 0x2AA8, 0x2BF0, 0x2A8C, 0x2BD5, 0x2ABC, 0x2BFC, 
   0x2A83, 0x2BC3, 0x2AAA, 0x2BFA, 0x2A8F, 0x2BCF, 0x2ABF, 0x2BFF, 
   0x2A81, 0x2BC1, 0x2AA9, 0x2BF1, 0x2A95, 0x2BD5, 0x2ABD, 0x2BFD, 
   0x2A83, 0x2BC3, 0x2AAB, 0x2BF3, 0x2A8F, 0x2BCF, 0x2ABF, 0x2BFF, 
   0x2A80, 0x2BC0, 0x2AA8, 0x2BF0, 0x2A8C, 0x2BD5, 0x2ABC, 0x2BFC, 
   0x2A8A, 0x2BCA, 0x2AAA, 0x2BFA, 0x2A8F, 0x2BCF, 0x2ABF, 0x2BFF, 
   0x2A80, 0x2BC0, 0x2AA8, 0x2BF0, 0x2A95, 0x2BD5, 0x2ABC, 0x2BFC, 
   0x2A83, 0x2BC3, 0x2AAB, 0x2BF3, 0x2A8F, 0x2BCF, 0x2ABF, 0x2BFF, 
   0x3A80, 0x33C0, 0x3AA8, 0x33F0, 0x3A8C, 0x33D5, 0x3ABC, 0x33FC, 
   0x3A83, 0x33C3, 0x3AAA, 0x33FA, 0x3A8F, 0x33CF, 0x3ABF, 0x33FF, 
   0x3A80, 0x33C0, 0x3AA8, 0x33F0, 0x3A95, 0x33D5, 0x3ABD, 0x33FD, 
   0x3A83, 0x33C3, 0x3AAB, 0x33F3, 0x3A8F, 0x33CF, 0x3ABF, 0x33FF, 
   0x3A80, 0x33C0, 0x3AA8, 0x33F0, 0x3A8C, 0x33D5, 0x3ABC, 0x33FC, 
   0x3A8A, 0x33CA, 0x3AAA, 0x33FA, 0x3A8F, 0x33CF, 0x3ABF, 0x33FF, 
   0x3A80, 0x33C0, 0x3AA8, 0x33F0, 0x3A95, 0x33D5, 0x3ABC, 0x33FC, 
   0x3A83, 0x33C3, 0x3AAB, 0x33F3, 0x3A8F, 0x33CF, 0x3ABF, 0x33FF, 
   0x3A80, 0x33C0, 0x3AA8, 0x33F0, 0x3A8C, 0x33D5, 0x3ABC, 0x33FC, 
   0x3A83, 0x33C3, 0x3AAA, 0x33FA, 0x3A8F, 0x33CF, 0x3ABF, 0x33FF, 
   0x3A81, 0x33C1, 0x3AA9, 0x33F1, 0x3A95, 0x33D5, 0x3ABD, 0x33FD, 
   0x3A83, 0x33C3, 0x3AAB, 0x33F3, 0x3A8F, 0x33CF, 0x3ABF, 0x33FF, 
   0x3A80, 0x33C0, 0x3AA8, 0x33F0, 0x3A8C, 0x33D5, 0x3ABC, 0x33FC, 
   0x3A8A, 0x33CA, 0x3AAA, 0x33FA, 0x3A8F, 0x33CF, 0x3ABF, 0x33FF, 
   0x3A80, 0x33C0, 0x3AA8, 0x33F0, 0x3A95, 0x33D5, 0x3ABC, 0x33FC, 
   0x3A83, 0x33C3, 0x3AAB, 0x33F3, 0x3A8F, 0x33CF, 0x3ABF, 0x33FF, 
   0x3A80, 0x33C0, 0x3AA8, 0x33F0, 0x3A8C, 0x33D5, 0x3ABC, 0x33FC, 
   0x3A83, 0x33C3, 0x3AAA, 0x33FA, 0x3A8F, 0x33CF, 0x3ABF, 0x33FF, 
   0x3A80, 0x33C0, 0x3AA8, 0x33F0, 0x3A95, 0x33D5, 0x3ABD, 0x33FD, 
   0x3A83, 0x33C3, 0x3AAB, 0x33F3, 0x3A8F, 0x33CF, 0x3ABF, 0x33FF, 
   0x3A80, 0x33C0, 0x3AA8, 0x33F0, 0x3A8C, 0x33D5, 0x3ABC, 0x33FC, 
   0x3A8A, 0x33CA, 0x3AAA, 0x33FA, 0x3A8F, 0x33CF, 0x3ABF, 0x33FF, 
   0x3A80, 0x33C0, 0x3AA8, 0x33F0, 0x3A95, 0x33D5, 0x3ABC, 0x33FC, 
   0x3A83, 0x33C3, 0x3AAB, 0x33F3, 0x3A8F, 0x33CF, 0x3ABF, 0x33FF, 
   0x3A80, 0x33C0, 0x3AA8, 0x33F0, 0x3A8C, 0x33D5, 0x3ABC, 0x33FC, 
   0x3A83, 0x33C3, 0x3AAA, 0x33FA, 0x3A8F, 0x33CF, 0x3ABF, 0x33FF, 
   0x3A81, 0x33C1, 0x3AA9, 0x33F1, 0x3A95, 0x33D5, 0x3ABD, 0x33FD, 
   0x3A83, 0x33C3, 0x3AAB, 0x33F3, 0x3A8F, 0x33CF, 0x3ABF, 0x33FF, 
   0x3A80, 0x33C0, 0x3AA8, 0x33F0, 0x3A8C, 0x33D5, 0x3ABC, 0x33FC, 
   0x3A8A, 0x33CA, 0x3AAA, 0x33FA, 0x3A8F, 0x33CF, 0x3ABF, 0x33FF, 
   0x3A80, 0x33C0, 0x3AA8, 0x33F0, 0x3A95, 0x33D5, 0x3ABC, 0x33FC, 
   0x3A83, 0x33C3, 0x3AAB, 0x33F3, 0x3A8F, 0x33CF, 0x3ABF, 0x33FF, 
   0x3A80, 0x33C0, 0x3AA8, 0x33F0, 0x3A8C, 0x33D5, 0x3ABC, 0x33FC, 
   0x3A83, 0x33C3, 0x3AAA, 0x33FA, 0x3A8F, 0x33CF, 0x3ABF, 0x33FF, 
   0x3A80, 0x33C0, 0x3AA8, 0x33F0, 0x3A95, 0x33D5, 0x3ABD, 0x33FD, 
   0x3A83, 0x33C3, 0x3AAB, 0x33F3, 0x3A8F, 0x33CF, 0x3ABF, 0x33FF, 
   0x3A80, 0x33C0, 0x3AA8, 0x33F0, 0x3A8C, 0x33D5, 0x3ABC, 0x33FC, 
   0x3A8A, 0x33CA, 0x3AAA, 0x33FA, 0x3A8F, 0x33CF, 0x3ABF, 0x33FF, 
   0x3A80, 0x33C0, 0x3AA8, 0x33F0, 0x3A95, 0x33D5, 0x3ABC, 0x33FC, 
   0x3A83, 0x33C3, 0x3AAB, 0x33F3, 0x3A8F, 0x33CF, 0x3ABF, 0x33FF, 
   0x3A80, 0x33C0, 0x3AA8, 0x33F0, 0x3A8C, 0x33D5, 0x3ABC, 0x33FC, 
   0x3A83, 0x33C3, 0x3AAA, 0x33FA, 0x3A8F, 0x33CF, 0x3ABF, 0x33FF, 
   0x3A81, 0x33C1, 0x3AA9, 0x33F1, 0x3A95, 0x33D5, 0x3ABD, 0x33FD, 
   0x3A83, 0x33C3, 0x3AAB, 0x33F3, 0x3A8F, 0x33CF, 0x3ABF, 0x33FF, 
   0x3A80, 0x33C0, 0x3AA8, 0x33F0, 0x3A8C, 0x33D5, 0x3ABC, 0x33FC, 
   0x3A8A, 0x33CA, 0x3AAA, 0x33FA, 0x3A8F, 0x33CF, 0x3ABF, 0x33FF, 
   0x3A80, 0x33C0, 0x3AA8, 0x33F0, 0x3A95, 0x33D5, 0x3ABC, 0x33FC, 
   0x3A83, 0x33C3, 0x3AAB, 0x33F3, 0x3A8F, 0x33CF, 0x3ABF, 0x33FF, 
   0x3A80, 0x33C0, 0x3AA8, 0x33F0, 0x3A8C, 0x33D5, 0x3ABC, 0x33FC, 
   0x3A83, 0x33C3, 0x3AAA, 0x33FA, 0x3A8F, 0x33CF, 0x3ABF, 0x33FF, 
   0x3A80, 0x33C0, 0x3AA8, 0x33F0, 0x3A95, 0x33D5, 0x3ABD, 0x33FD, 
   0x3A83, 0x33C3, 0x3AAB, 0x33F3, 0x3A8F, 0x33CF, 0x3ABF, 0x33FF, 
   0x3A80, 0x33C0, 0x3AA8, 0x33F0, 0x3A8C, 0x33D5, 0x3ABC, 0x33FC, 
   0x3A8A, 0x33CA, 0x3AAA, 0x33FA, 0x3A8F, 0x33CF, 0x3ABF, 0x33FF, 
   0x3A80, 0x33C0, 0x3AA8, 0x33F0, 0x3A95, 0x33D5, 0x3ABC, 0x33FC, 
   0x3A83, 0x33C3, 0x3AAB, 0x33F3, 0x3A8F, 0x33CF, 0x3ABF, 0x33FF, 
   0x3A80, 0x33C0, 0x3AA8, 0x33F0, 0x3A8C, 0x33D5, 0x3ABC, 0x33FC, 
   0x3A83, 0x33C3, 0x3AAA, 0x33FA, 0x3A8F, 0x33CF, 0x3ABF, 0x33FF, 
   0x3A81, 0x33C1, 0x3AA9, 0x33F1, 0x3A95, 0x33D5, 0x3ABD, 0x33FD, 
   0x3A83, 0x33C3, 0x3AAB, 0x33F3, 0x3A8F, 0x33CF, 0x3ABF, 0x33FF, 
   0x3A80, 0x33C0, 0x3AA8, 0x33F0, 0x3A8C, 0x33D5, 0x3ABC, 0x33FC, 
   0x3A8A, 0x33CA, 0x3AAA, 0x33FA, 0x3A8F, 0x33CF, 0x3ABF, 0x33FF, 
   0x3A80, 0x33C0, 0x3AA8, 0x33F0, 0x3A95, 0x33D5, 0x3ABC, 0x33FC, 
   0x3A83, 0x33C3, 0x3AAB, 0x33F3, 0x3A8F, 0x33CF, 0x3ABF, 0x33FF, 
   0x3A80, 0x33C0, 0x3AA8, 0x33F0, 0x3A8C, 0x33D5, 0x3ABC, 0x33FC, 
   0x3A83, 0x33C3, 0x3AAA, 0x33FA, 0x3A8F, 0x33CF, 0x3ABF, 0x33FF, 
   0x3A80, 0x33C0, 0x3AA8, 0x33F0, 0x3A95, 0x33D5, 0x3ABD, 0x33FD, 
   0x3A83, 0x33C3, 0x3AAB, 0x33F3, 0x3A8F, 0x33CF, 0x3ABF, 0x33FF, 
   0x3A80, 0x33C0, 0x3AA8, 0x33F0, 0x3A8C, 0x33D5, 0x3ABC, 0x33FC, 
   0x3A8A, 0x33CA, 0x3AAA, 0x33FA, 0x3A8F, 0x33CF, 0x3ABF, 0x33FF, 
   0x3A80, 0x33C0, 0x3AA8, 0x33F0, 0x3A95, 0x33D5, 0x3ABC, 0x33FC, 
   0x3A83, 0x33C3, 0x3AAB, 0x33F3, 0x3A8F, 0x33CF, 0x3ABF, 0x33FF, 
   0x3A80, 0x33C0, 0x3AA8, 0x33F0, 0x3A8C, 0x33D5, 0x3ABC, 0x33FC, 
   0x3A83, 0x33C3, 0x3AAA, 0x33FA, 0x3A8F, 0x33CF, 0x3ABF, 0x33FF, 
   0x3A81, 0x33C1, 0x3AA9, 0x33F1, 0x3A95, 0x33D5, 0x3ABD, 0x33FD, 
   0x3A83, 0x33C3, 0x3AAB, 0x33F3, 0x3A8F, 0x33CF, 0x3ABF, 0x33FF, 
   0x3A80, 0x33C0, 0x3AA8, 0x33F0, 0x3A8C, 0x33D5, 0x3ABC, 0x33FC, 
   0x3A8A, 0x33CA, 0x3AAA, 0x33FA, 0x3A8F, 0x33CF, 0x3ABF, 0x33FF, 
   0x3A80, 0x33C0, 0x3AA8, 0x33F0, 0x3A95, 0x33D5, 0x3ABC, 0x33FC, 
   0x3A83, 0x33C3, 0x3AAB, 0x33F3, 0x3A8F, 0x33CF, 0x3ABF, 0x33FF, 
   0x3A80, 0x33C0, 0x3AA8, 0x33F0, 0x3A8C, 0x33D5, 0x3ABC, 0x33FC, 
   0x3A83, 0x33C3, 0x3AAA, 0x33FA, 0x3A8F, 0x33CF, 0x3ABF, 0x33FF, 
   0x3A80, 0x33C0, 0x3AA8, 0x33F0, 0x3A95, 0x33D5, 0x3ABD, 0x33FD, 
   0x3A83, 0x33C3, 0x3AAB, 0x33F3, 0x3A8F, 0x33CF, 0x3ABF, 0x33FF, 
   0x3A80, 0x33C0, 0x3AA8, 0x33F0, 0x3A8C, 0x33D5, 0x3ABC, 0x33FC, 
   0x3A8A, 0x33CA, 0x3AAA, 0x33FA, 0x3A8F, 0x33CF, 0x3ABF, 0x33FF, 
   0x3A80, 0x33C0, 0x3AA8, 0x33F0, 0x3A95, 0x33D5, 0x3ABC, 0x33FC, 
   0x3A83, 0x33C3, 0x3AAB, 0x33F3, 0x3A8F, 0x33CF, 0x3ABF, 0x33FF, 
   0x3A80, 0x33C0, 0x3AA8, 0x33F0, 0x3A8C, 0x33D5, 0x3ABC, 0x33FC, 
   0x3A83, 0x33C3, 0x3AAA, 0x33FA, 0x3A8F, 0x33CF, 0x3ABF, 0x33FF, 
   0x3A81, 0x33C1, 0x3AA9, 0x33F1, 0x3A95, 0x33D5, 0x3ABD, 0x33FD, 
   0x3A83, 0x33C3, 0x3AAB, 0x33F3, 0x3A8F, 0x33CF, 0x3ABF, 0x33FF, 
   0x3A80, 0x33C0, 0x3AA8, 0x33F0, 0x3A8C, 0x33D5, 0x3ABC, 0x33FC, 
   0x3A8A, 0x33CA, 0x3AAA, 0x33FA, 0x3A8F, 0x33CF, 0x3ABF, 0x33FF, 
   0x3A80, 0x33C0, 0x3AA8, 0x33F0, 0x3A95, 0x33D5, 0x3ABC, 0x33FC, 
   0x3A83, 0x33C3, 0x3AAB, 0x33F3, 0x3A8F, 0x33CF, 0x3ABF, 0x33FF, 
   0x3A80, 0x33C0, 0x3AA8, 0x33F0, 0x3A8C, 0x33D5, 0x3ABC, 0x33FC, 
   0x3A83, 0x33C3, 0x3AAA, 0x33FA, 0x3A8F, 0x33CF, 0x3ABF, 0x33FF, 
   0x3A80, 0x33C0, 0x3AA8, 0x33F0, 0x3A95, 0x33D5, 0x3ABD, 0x33FD, 
   0x3A83, 0x33C3, 0x3AAB, 0x33F3, 0x3A8F, 0x33CF, 0x3ABF, 0x33FF, 
   0x3A80, 0x33C0, 0x3AA8, 0x33F0, 0x3A8C, 0x33D5, 0x3ABC, 0x33FC, 
   0x3A8A, 0x33CA, 0x3AAA, 0x33FA, 0x3A8F, 0x33CF, 0x3ABF, 0x33FF, 
   0x3A80, 0x33C0, 0x3AA8, 0x33F0, 0x3A95, 0x33D5, 0x3ABC, 0x33FC, 
   0x3A83, 0x33C3, 0x3AAB, 0x33F3, 0x3A8F, 0x33CF, 0x3ABF, 0x33FF, 
   0x3A80, 0x33C0, 0x3AA8, 0x33F0, 0x3A8C, 0x33D5, 0x3ABC, 0x33FC, 
   0x3A83, 0x33C3, 0x3AAA, 0x33FA, 0x3A8F, 0x33CF, 0x3ABF, 0x33FF, 
   0x3A81, 0x33C1, 0x3AA9, 0x33F1, 0x3A95, 0x33D5, 0x3ABD, 0x33FD, 
   0x3A83, 0x33C3, 0x3AAB, 0x33F3, 0x3A8F, 0x33CF, 0x3ABF, 0x33FF, 
   0x3A80, 0x33C0, 0x3AA8, 0x33F0, 0x3A8C, 0x33D5, 0x3ABC, 0x33FC, 
   0x3A8A, 0x33CA, 0x3AAA, 0x33FA, 0x3A8F, 0x33CF, 0x3ABF, 0x33FF, 
   0x3A80, 0x33C0, 0x3AA8, 0x33F0, 0x3A95, 0x33D5, 0x3ABC, 0x33FC, 
   0x3A83, 0x33C3, 0x3AAB, 0x33F3, 0x3A8F, 0x33CF, 0x3ABF, 0x33FF, 
   0x3A80, 0x33C0, 0x3AA8, 0x33F0, 0x3A8C, 0x33D5, 0x3ABC, 0x33FC, 
   0x3A83, 0x33C3, 0x3AAA, 0x33FA, 0x3A8F, 0x33CF, 0x3ABF, 0x33FF, 
   0x3A80, 0x33C0, 0x3AA8, 0x33F0, 0x3A95, 0x33D5, 0x3ABD, 0x33FD, 
   0x3A83, 0x33C3, 0x3AAB, 0x33F3, 0x3A8F, 0x33CF, 0x3ABF, 0x33FF, 
   0x3A80, 0x33C0, 0x3AA8, 0x33F0, 0x3A8C, 0x33D5, 0x3ABC, 0x33FC, 
   0x3A8A, 0x33CA, 0x3AAA, 0x33FA, 0x3A8F, 0x33CF, 0x3ABF, 0x33FF, 
   0x3A80, 0x33C0, 0x3AA8, 0x33F0, 0x3A95, 0x33D5, 0x3ABC, 0x33FC, 
   0x3A83, 0x33C3, 0x3AAB, 0x33F3, 0x3A8F, 0x33CF, 0x3ABF, 0x33FF, 
   0x3A80, 0x33C0, 0x3AA8, 0x33F0, 0x3A8C, 0x33D5, 0x3ABC, 0x33FC, 
   0x3A83, 0x33C3, 0x3AAA, 0x33FA, 0x3A8F, 0x33CF, 0x3ABF, 0x33FF, 
   0x3A81, 0x33C1, 0x3AA9, 0x33F1, 0x3A95, 0x33D5, 0x3ABD, 0x33FD, 
   0x3A83, 0x33C3, 0x3AAB, 0x33F3, 0x3A8F, 0x33CF, 0x3ABF, 0x33FF, 
   0x3A80, 0x33C0, 0x3AA8, 0x33F0, 0x3A8C, 0x33D5, 0x3ABC, 0x33FC, 
   0x3A8A, 0x33CA, 0x3AAA, 0x33FA, 0x3A8F, 0x33CF, 0x3ABF, 0x33FF, 
   0x3A80, 0x33C0, 0x3AA8, 0x33F0, 0x3A95, 0x33D5, 0x3ABC, 0x33FC, 
   0x3A83, 0x33C3, 0x3AAB, 0x33F3, 0x3A8F, 0x33CF, 0x3ABF, 0x33FF, 
   0x0F00, 0x0FC0, 0x0FA8, 0x0FF0, 0x0F0C, 0x0FD5, 0x0F3C, 0x0FFC, 
   0x0F03, 0x0FC3, 0x0FAA, 0x0FFA, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F00, 0x0FC0, 0x0FA8, 0x0FF0, 0x0F15, 0x0FD5, 0x0F3D, 0x0FFD, 
   0x0F03, 0x0FC3, 0x0FAB, 0x0FF3, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F00, 0x0FC0, 0x0FA8, 0x0FF0, 0x0F0C, 0x0FD5, 0x0F3C, 0x0FFC, 
   0x0F0A, 0x0FCA, 0x0FAA, 0x0FFA, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F00, 0x0FC0, 0x0FA8, 0x0FF0, 0x0F15, 0x0FD5, 0x0F3C, 0x0FFC, 
   0x0F03, 0x0FC3, 0x0FAB, 0x0FF3, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F00, 0x0FC0, 0x0FA8, 0x0FF0, 0x0F0C, 0x0FD5, 0x0F3C, 0x0FFC, 
   0x0F03, 0x0FC3, 0x0FAA, 0x0FFA, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F01, 0x0FC1, 0x0FA9, 0x0FF1, 0x0F15, 0x0FD5, 0x0F3D, 0x0FFD, 
   0x0F03, 0x0FC3, 0x0FAB, 0x0FF3, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F00, 0x0FC0, 0x0FA8, 0x0FF0, 0x0F0C, 0x0FD5, 0x0F3C, 0x0FFC, 
   0x0F0A, 0x0FCA, 0x0FAA, 0x0FFA, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F00, 0x0FC0, 0x0FA8, 0x0FF0, 0x0F15, 0x0FD5, 0x0F3C, 0x0FFC, 
   0x0F03, 0x0FC3, 0x0FAB, 0x0FF3, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F00, 0x0FC0, 0x0FA8, 0x0FF0, 0x0F0C, 0x0FD5, 0x0F3C, 0x0FFC, 
   0x0F03, 0x0FC3, 0x0FAA, 0x0FFA, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F00, 0x0FC0, 0x0FA8, 0x0FF0, 0x0F15, 0x0FD5, 0x0F3D, 0x0FFD, 
   0x0F03, 0x0FC3, 0x0FAB, 0x0FF3, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F00, 0x0FC0, 0x0FA8, 0x0FF0, 0x0F0C, 0x0FD5, 0x0F3C, 0x0FFC, 
   0x0F0A, 0x0FCA, 0x0FAA, 0x0FFA, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F00, 0x0FC0, 0x0FA8, 0x0FF0, 0x0F15, 0x0FD5, 0x0F3C, 0x0FFC, 
   0x0F03, 0x0FC3, 0x0FAB, 0x0FF3, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F00, 0x0FC0, 0x0FA8, 0x0FF0, 0x0F0C, 0x0FD5, 0x0F3C, 0x0FFC, 
   0x0F03, 0x0FC3, 0x0FAA, 0x0FFA, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F01, 0x0FC1, 0x0FA9, 0x0FF1, 0x0F15, 0x0FD5, 0x0F3D, 0x0FFD, 
   0x0F03, 0x0FC3, 0x0FAB, 0x0FF3, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F00, 0x0FC0, 0x0FA8, 0x0FF0, 0x0F0C, 0x0FD5, 0x0F3C, 0x0FFC, 
   0x0F0A, 0x0FCA, 0x0FAA, 0x0FFA, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F00, 0x0FC0, 0x0FA8, 0x0FF0, 0x0F15, 0x0FD5, 0x0F3C, 0x0FFC, 
   0x0F03, 0x0FC3, 0x0FAB, 0x0FF3, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F00, 0x0FC0, 0x0FA8, 0x0FF0, 0x0F0C, 0x0FD5, 0x0F3C, 0x0FFC, 
   0x0F03, 0x0FC3, 0x0FAA, 0x0FFA, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F00, 0x0FC0, 0x0FA8, 0x0FF0, 0x0F15, 0x0FD5, 0x0F3D, 0x0FFD, 
   0x0F03, 0x0FC3, 0x0FAB, 0x0FF3, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F00, 0x0FC0, 0x0FA8, 0x0FF0, 0x0F0C, 0x0FD5, 0x0F3C, 0x0FFC, 
   0x0F0A, 0x0FCA, 0x0FAA, 0x0FFA, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F00, 0x0FC0, 0x0FA8, 0x0FF0, 0x0F15, 0x0FD5, 0x0F3C, 0x0FFC, 
   0x0F03, 0x0FC3, 0x0FAB, 0x0FF3, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F00, 0x0FC0, 0x0FA8, 0x0FF0, 0x0F0C, 0x0FD5, 0x0F3C, 0x0FFC, 
   0x0F03, 0x0FC3, 0x0FAA, 0x0FFA, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F01, 0x0FC1, 0x0FA9, 0x0FF1, 0x0F15, 0x0FD5, 0x0F3D, 0x0FFD, 
   0x0F03, 0x0FC3, 0x0FAB, 0x0FF3, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F00, 0x0FC0, 0x0FA8, 0x0FF0, 0x0F0C, 0x0FD5, 0x0F3C, 0x0FFC, 
   0x0F0A, 0x0FCA, 0x0FAA, 0x0FFA, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F00, 0x0FC0, 0x0FA8, 0x0FF0, 0x0F15, 0x0FD5, 0x0F3C, 0x0FFC, 
   0x0F03, 0x0FC3, 0x0FAB, 0x0FF3, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F00, 0x0FC0, 0x0FA8, 0x0FF0, 0x0F0C, 0x0FD5, 0x0F3C, 0x0FFC, 
   0x0F03, 0x0FC3, 0x0FAA, 0x0FFA, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F00, 0x0FC0, 0x0FA8, 0x0FF0, 0x0F15, 0x0FD5, 0x0F3D, 0x0FFD, 
   0x0F03, 0x0FC3, 0x0FAB, 0x0FF3, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F00, 0x0FC0, 0x0FA8, 0x0FF0, 0x0F0C, 0x0FD5, 0x0F3C, 0x0FFC, 
   0x0F0A, 0x0FCA, 0x0FAA, 0x0FFA, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F00, 0x0FC0, 0x0FA8, 0x0FF0, 0x0F15, 0x0FD5, 0x0F3C, 0x0FFC, 
   0x0F03, 0x0FC3, 0x0FAB, 0x0FF3, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F00, 0x0FC0, 0x0FA8, 0x0FF0, 0x0F0C, 0x0FD5, 0x0F3C, 0x0FFC, 
   0x0F03, 0x0FC3, 0x0FAA, 0x0FFA, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F01, 0x0FC1, 0x0FA9, 0x0FF1, 0x0F15, 0x0FD5, 0x0F3D, 0x0FFD, 
   0x0F03, 0x0FC3, 0x0FAB, 0x0FF3, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F00, 0x0FC0, 0x0FA8, 0x0FF0, 0x0F0C, 0x0FD5, 0x0F3C, 0x0FFC, 
   0x0F0A, 0x0FCA, 0x0FAA, 0x0FFA, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F00, 0x0FC0, 0x0FA8, 0x0FF0, 0x0F15, 0x0FD5, 0x0F3C, 0x0FFC, 
   0x0F03, 0x0FC3, 0x0FAB, 0x0FF3, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F00, 0x0FC0, 0x0FA8, 0x0FF0, 0x0F0C, 0x0FD5, 0x0F3C, 0x0FFC, 
   0x0F03, 0x0FC3, 0x0FAA, 0x0FFA, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F00, 0x0FC0, 0x0FA8, 0x0FF0, 0x0F15, 0x0FD5, 0x0F3D, 0x0FFD, 
   0x0F03, 0x0FC3, 0x0FAB, 0x0FF3, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F00, 0x0FC0, 0x0FA8, 0x0FF0, 0x0F0C, 0x0FD5, 0x0F3C, 0x0FFC, 
   0x0F0A, 0x0FCA, 0x0FAA, 0x0FFA, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F00, 0x0FC0, 0x0FA8, 0x0FF0, 0x0F15, 0x0FD5, 0x0F3C, 0x0FFC, 
   0x0F03, 0x0FC3, 0x0FAB, 0x0FF3, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F00, 0x0FC0, 0x0FA8, 0x0FF0, 0x0F0C, 0x0FD5, 0x0F3C, 0x0FFC, 
   0x0F03, 0x0FC3, 0x0FAA, 0x0FFA, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F01, 0x0FC1, 0x0FA9, 0x0FF1, 0x0F15, 0x0FD5, 0x0F3D, 0x0FFD, 
   0x0F03, 0x0FC3, 0x0FAB, 0x0FF3, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F00, 0x0FC0, 0x0FA8, 0x0FF0, 0x0F0C, 0x0FD5, 0x0F3C, 0x0FFC, 
   0x0F0A, 0x0FCA, 0x0FAA, 0x0FFA, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F00, 0x0FC0, 0x0FA8, 0x0FF0, 0x0F15, 0x0FD5, 0x0F3C, 0x0FFC, 
   0x0F03, 0x0FC3, 0x0FAB, 0x0FF3, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F00, 0x0FC0, 0x0FA8, 0x0FF0, 0x0F0C, 0x0FD5, 0x0F3C, 0x0FFC, 
   0x0F03, 0x0FC3, 0x0FAA, 0x0FFA, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F00, 0x0FC0, 0x0FA8, 0x0FF0, 0x0F15, 0x0FD5, 0x0F3D, 0x0FFD, 
   0x0F03, 0x0FC3, 0x0FAB, 0x0FF3, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F00, 0x0FC0, 0x0FA8, 0x0FF0, 0x0F0C, 0x0FD5, 0x0F3C, 0x0FFC, 
   0x0F0A, 0x0FCA, 0x0FAA, 0x0FFA, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F00, 0x0FC0, 0x0FA8, 0x0FF0, 0x0F15, 0x0FD5, 0x0F3C, 0x0FFC, 
   0x0F03, 0x0FC3, 0x0FAB, 0x0FF3, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F00, 0x0FC0, 0x0FA8, 0x0FF0, 0x0F0C, 0x0FD5, 0x0F3C, 0x0FFC, 
   0x0F03, 0x0FC3, 0x0FAA, 0x0FFA, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F01, 0x0FC1, 0x0FA9, 0x0FF1, 0x0F15, 0x0FD5, 0x0F3D, 0x0FFD, 
   0x0F03, 0x0FC3, 0x0FAB, 0x0FF3, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F00, 0x0FC0, 0x0FA8, 0x0FF0, 0x0F0C, 0x0FD5, 0x0F3C, 0x0FFC, 
   0x0F0A, 0x0FCA, 0x0FAA, 0x0FFA, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F00, 0x0FC0, 0x0FA8, 0x0FF0, 0x0F15, 0x0FD5, 0x0F3C, 0x0FFC, 
   0x0F03, 0x0FC3, 0x0FAB, 0x0FF3, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F00, 0x0FC0, 0x0FA8, 0x0FF0, 0x0F0C, 0x0FD5, 0x0F3C, 0x0FFC, 
   0x0F03, 0x0FC3, 0x0FAA, 0x0FFA, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F00, 0x0FC0, 0x0FA8, 0x0FF0, 0x0F15, 0x0FD5, 0x0F3D, 0x0FFD, 
   0x0F03, 0x0FC3, 0x0FAB, 0x0FF3, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F00, 0x0FC0, 0x0FA8, 0x0FF0, 0x0F0C, 0x0FD5, 0x0F3C, 0x0FFC, 
   0x0F0A, 0x0FCA, 0x0FAA, 0x0FFA, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F00, 0x0FC0, 0x0FA8, 0x0FF0, 0x0F15, 0x0FD5, 0x0F3C, 0x0FFC, 
   0x0F03, 0x0FC3, 0x0FAB, 0x0FF3, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F00, 0x0FC0, 0x0FA8, 0x0FF0, 0x0F0C, 0x0FD5, 0x0F3C, 0x0FFC, 
   0x0F03, 0x0FC3, 0x0FAA, 0x0FFA, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F01, 0x0FC1, 0x0FA9, 0x0FF1, 0x0F15, 0x0FD5, 0x0F3D, 0x0FFD, 
   0x0F03, 0x0FC3, 0x0FAB, 0x0FF3, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F00, 0x0FC0, 0x0FA8, 0x0FF0, 0x0F0C, 0x0FD5, 0x0F3C, 0x0FFC, 
   0x0F0A, 0x0FCA, 0x0FAA, 0x0FFA, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F00, 0x0FC0, 0x0FA8, 0x0FF0, 0x0F15, 0x0FD5, 0x0F3C, 0x0FFC, 
   0x0F03, 0x0FC3, 0x0FAB, 0x0FF3, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F00, 0x0FC0, 0x0FA8, 0x0FF0, 0x0F0C, 0x0FD5, 0x0F3C, 0x0FFC, 
   0x0F03, 0x0FC3, 0x0FAA, 0x0FFA, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F00, 0x0FC0, 0x0FA8, 0x0FF0, 0x0F15, 0x0FD5, 0x0F3D, 0x0FFD, 
   0x0F03, 0x0FC3, 0x0FAB, 0x0FF3, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F00, 0x0FC0, 0x0FA8, 0x0FF0, 0x0F0C, 0x0FD5, 0x0F3C, 0x0FFC, 
   0x0F0A, 0x0FCA, 0x0FAA, 0x0FFA, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F00, 0x0FC0, 0x0FA8, 0x0FF0, 0x0F15, 0x0FD5, 0x0F3C, 0x0FFC, 
   0x0F03, 0x0FC3, 0x0FAB, 0x0FF3, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F00, 0x0FC0, 0x0FA8, 0x0FF0, 0x0F0C, 0x0FD5, 0x0F3C, 0x0FFC, 
   0x0F03, 0x0FC3, 0x0FAA, 0x0FFA, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F01, 0x0FC1, 0x0FA9, 0x0FF1, 0x0F15, 0x0FD5, 0x0F3D, 0x0FFD, 
   0x0F03, 0x0FC3, 0x0FAB, 0x0FF3, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F00, 0x0FC0, 0x0FA8, 0x0FF0, 0x0F0C, 0x0FD5, 0x0F3C, 0x0FFC, 
   0x0F0A, 0x0FCA, 0x0FAA, 0x0FFA, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F00, 0x0FC0, 0x0FA8, 0x0FF0, 0x0F15, 0x0FD5, 0x0F3C, 0x0FFC, 
   0x0F03, 0x0FC3, 0x0FAB, 0x0FF3, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x1F00, 0x1FC0, 0x1FA8, 0x1FF0, 0x1F0C, 0x1FD5, 0x1F3C, 0x1FFC, 
   0x1F03, 0x1FC3, 0x1FAA, 0x1FFA, 0x1F0F, 0x1FCF, 0x1F3F, 0x1FFF, 
   0x1F00, 0x1FC0, 0x1FA8, 0x1FF0, 0x1F15, 0x1FD5, 0x1F3D, 0x1FFD, 
   0x1F03, 0x1FC3, 0x1FAB, 0x1FF3, 0x1F0F, 0x1FCF, 0x1F3F, 0x1FFF, 
   0x1F00, 0x1FC0, 0x1FA8, 0x1FF0, 0x1F0C, 0x1FD5, 0x1F3C, 0x1FFC, 
   0x1F0A, 0x1FCA, 0x1FAA, 0x1FFA, 0x1F0F, 0x1FCF, 0x1F3F, 0x1FFF, 
   0x1F00, 0x1FC0, 0x1FA8, 0x1FF0, 0x1F15, 0x1FD5, 0x1F3C, 0x1FFC, 
   0x1F03, 0x1FC3, 0x1FAB, 0x1FF3, 0x1F0F, 0x1FCF, 0x1F3F, 0x1FFF, 
   0x1F00, 0x1FC0, 0x1FA8, 0x1FF0, 0x1F0C, 0x1FD5, 0x1F3C, 0x1FFC, 
   0x1F03, 0x1FC3, 0x1FAA, 0x1FFA, 0x1F0F, 0x1FCF, 0x1F3F, 0x1FFF, 
   0x1F01, 0x1FC1, 0x1FA9, 0x1FF1, 0x1F15, 0x1FD5, 0x1F3D, 0x1FFD, 
   0x1F03, 0x1FC3, 0x1FAB, 0x1FF3, 0x1F0F, 0x1FCF, 0x1F3F, 0x1FFF, 
   0x1F00, 0x1FC0, 0x1FA8, 0x1FF0, 0x1F0C, 0x1FD5, 0x1F3C, 0x1FFC, 
   0x1F0A, 0x1FCA, 0x1FAA, 0x1FFA, 0x1F0F, 0x1FCF, 0x1F3F, 0x1FFF, 
   0x1F00, 0x1FC0, 0x1FA8, 0x1FF0, 0x1F15, 0x1FD5, 0x1F3C, 0x1FFC, 
   0x1F03, 0x1FC3, 0x1FAB, 0x1FF3, 0x1F0F, 0x1FCF, 0x1F3F, 0x1FFF, 
   0x1F00, 0x1FC0, 0x1FA8, 0x1FF0, 0x1F0C, 0x1FD5, 0x1F3C, 0x1FFC, 
   0x1F03, 0x1FC3, 0x1FAA, 0x1FFA, 0x1F0F, 0x1FCF, 0x1F3F, 0x1FFF, 
   0x1F00, 0x1FC0, 0x1FA8, 0x1FF0, 0x1F15, 0x1FD5, 0x1F3D, 0x1FFD, 
   0x1F03, 0x1FC3, 0x1FAB, 0x1FF3, 0x1F0F, 0x1FCF, 0x1F3F, 0x1FFF, 
   0x1F00, 0x1FC0, 0x1FA8, 0x1FF0, 0x1F0C, 0x1FD5, 0x1F3C, 0x1FFC, 
   0x1F0A, 0x1FCA, 0x1FAA, 0x1FFA, 0x1F0F, 0x1FCF, 0x1F3F, 0x1FFF, 
   0x1F00, 0x1FC0, 0x1FA8, 0x1FF0, 0x1F15, 0x1FD5, 0x1F3C, 0x1FFC, 
   0x1F03, 0x1FC3, 0x1FAB, 0x1FF3, 0x1F0F, 0x1FCF, 0x1F3F, 0x1FFF, 
   0x1F00, 0x1FC0, 0x1FA8, 0x1FF0, 0x1F0C, 0x1FD5, 0x1F3C, 0x1FFC, 
   0x1F03, 0x1FC3, 0x1FAA, 0x1FFA, 0x1F0F, 0x1FCF, 0x1F3F, 0x1FFF, 
   0x1F01, 0x1FC1, 0x1FA9, 0x1FF1, 0x1F15, 0x1FD5, 0x1F3D, 0x1FFD, 
   0x1F03, 0x1FC3, 0x1FAB, 0x1FF3, 0x1F0F, 0x1FCF, 0x1F3F, 0x1FFF, 
   0x1F00, 0x1FC0, 0x1FA8, 0x1FF0, 0x1F0C, 0x1FD5, 0x1F3C, 0x1FFC, 
   0x1F0A, 0x1FCA, 0x1FAA, 0x1FFA, 0x1F0F, 0x1FCF, 0x1F3F, 0x1FFF, 
   0x1F00, 0x1FC0, 0x1FA8, 0x1FF0, 0x1F15, 0x1FD5, 0x1F3C, 0x1FFC, 
   0x1F03, 0x1FC3, 0x1FAB, 0x1FF3, 0x1F0F, 0x1FCF, 0x1F3F, 0x1FFF, 
   0x1F00, 0x1FC0, 0x1FA8, 0x1FF0, 0x1F0C, 0x1FD5, 0x1F3C, 0x1FFC, 
   0x1F03, 0x1FC3, 0x1FAA, 0x1FFA, 0x1F0F, 0x1FCF, 0x1F3F, 0x1FFF, 
   0x1F00, 0x1FC0, 0x1FA8, 0x1FF0, 0x1F15, 0x1FD5, 0x1F3D, 0x1FFD, 
   0x1F03, 0x1FC3, 0x1FAB, 0x1FF3, 0x1F0F, 0x1FCF, 0x1F3F, 0x1FFF, 
   0x1F00, 0x1FC0, 0x1FA8, 0x1FF0, 0x1F0C, 0x1FD5, 0x1F3C, 0x1FFC, 
   0x1F0A, 0x1FCA, 0x1FAA, 0x1FFA, 0x1F0F, 0x1FCF, 0x1F3F, 0x1FFF, 
   0x1F00, 0x1FC0, 0x1FA8, 0x1FF0, 0x1F15, 0x1FD5, 0x1F3C, 0x1FFC, 
   0x1F03, 0x1FC3, 0x1FAB, 0x1FF3, 0x1F0F, 0x1FCF, 0x1F3F, 0x1FFF, 
   0x1F00, 0x1FC0, 0x1FA8, 0x1FF0, 0x1F0C, 0x1FD5, 0x1F3C, 0x1FFC, 
   0x1F03, 0x1FC3, 0x1FAA, 0x1FFA, 0x1F0F, 0x1FCF, 0x1F3F, 0x1FFF, 
   0x1F01, 0x1FC1, 0x1FA9, 0x1FF1, 0x1F15, 0x1FD5, 0x1F3D, 0x1FFD, 
   0x1F03, 0x1FC3, 0x1FAB, 0x1FF3, 0x1F0F, 0x1FCF, 0x1F3F, 0x1FFF, 
   0x1F00, 0x1FC0, 0x1FA8, 0x1FF0, 0x1F0C, 0x1FD5, 0x1F3C, 0x1FFC, 
   0x1F0A, 0x1FCA, 0x1FAA, 0x1FFA, 0x1F0F, 0x1FCF, 0x1F3F, 0x1FFF, 
   0x1F00, 0x1FC0, 0x1FA8, 0x1FF0, 0x1F15, 0x1FD5, 0x1F3C, 0x1FFC, 
   0x1F03, 0x1FC3, 0x1FAB, 0x1FF3, 0x1F0F, 0x1FCF, 0x1F3F, 0x1FFF, 
   0x1F00, 0x1FC0, 0x1FA8, 0x1FF0, 0x1F0C, 0x1FD5, 0x1F3C, 0x1FFC, 
   0x1F03, 0x1FC3, 0x1FAA, 0x1FFA, 0x1F0F, 0x1FCF, 0x1F3F, 0x1FFF, 
   0x1F00, 0x1FC0, 0x1FA8, 0x1FF0, 0x1F15, 0x1FD5, 0x1F3D, 0x1FFD, 
   0x1F03, 0x1FC3, 0x1FAB, 0x1FF3, 0x1F0F, 0x1FCF, 0x1F3F, 0x1FFF, 
   0x1F00, 0x1FC0, 0x1FA8, 0x1FF0, 0x1F0C, 0x1FD5, 0x1F3C, 0x1FFC, 
   0x1F0A, 0x1FCA, 0x1FAA, 0x1FFA, 0x1F0F, 0x1FCF, 0x1F3F, 0x1FFF, 
   0x1F00, 0x1FC0, 0x1FA8, 0x1FF0, 0x1F15, 0x1FD5, 0x1F3C, 0x1FFC, 
   0x1F03, 0x1FC3, 0x1FAB, 0x1FF3, 0x1F0F, 0x1FCF, 0x1F3F, 0x1FFF, 
   0x1F00, 0x1FC0, 0x1FA8, 0x1FF0, 0x1F0C, 0x1FD5, 0x1F3C, 0x1FFC, 
   0x1F03, 0x1FC3, 0x1FAA, 0x1FFA, 0x1F0F, 0x1FCF, 0x1F3F, 0x1FFF, 
   0x1F01, 0x1FC1, 0x1FA9, 0x1FF1, 0x1F15, 0x1FD5, 0x1F3D, 0x1FFD, 
   0x1F03, 0x1FC3, 0x1FAB, 0x1FF3, 0x1F0F, 0x1FCF, 0x1F3F, 0x1FFF, 
   0x1F00, 0x1FC0, 0x1FA8, 0x1FF0, 0x1F0C, 0x1FD5, 0x1F3C, 0x1FFC, 
   0x1F0A, 0x1FCA, 0x1FAA, 0x1FFA, 0x1F0F, 0x1FCF, 0x1F3F, 0x1FFF, 
   0x1F00, 0x1FC0, 0x1FA8, 0x1FF0, 0x1F15, 0x1FD5, 0x1F3C, 0x1FFC, 
   0x1F03, 0x1FC3, 0x1FAB, 0x1FF3, 0x1F0F, 0x1FCF, 0x1F3F, 0x1FFF, 
   0x0F00, 0x0FC0, 0x0FA8, 0x0FF0, 0x0F0C, 0x0FD5, 0x0F3C, 0x0FFC, 
   0x0F03, 0x0FC3, 0x0FAA, 0x0FFA, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F00, 0x0FC0, 0x0FA8, 0x0FF0, 0x0F15, 0x0FD5, 0x0F3D, 0x0FFD, 
   0x0F03, 0x0FC3, 0x0FAB, 0x0FF3, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F00, 0x0FC0, 0x0FA8, 0x0FF0, 0x0F0C, 0x0FD5, 0x0F3C, 0x0FFC, 
   0x0F0A, 0x0FCA, 0x0FAA, 0x0FFA, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F00, 0x0FC0, 0x0FA8, 0x0FF0, 0x0F15, 0x0FD5, 0x0F3C, 0x0FFC, 
   0x0F03, 0x0FC3, 0x0FAB, 0x0FF3, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F00, 0x0FC0, 0x0FA8, 0x0FF0, 0x0F0C, 0x0FD5, 0x0F3C, 0x0FFC, 
   0x0F03, 0x0FC3, 0x0FAA, 0x0FFA, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F01, 0x0FC1, 0x0FA9, 0x0FF1, 0x0F15, 0x0FD5, 0x0F3D, 0x0FFD, 
   0x0F03, 0x0FC3, 0x0FAB, 0x0FF3, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F00, 0x0FC0, 0x0FA8, 0x0FF0, 0x0F0C, 0x0FD5, 0x0F3C, 0x0FFC, 
   0x0F0A, 0x0FCA, 0x0FAA, 0x0FFA, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F00, 0x0FC0, 0x0FA8, 0x0FF0, 0x0F15, 0x0FD5, 0x0F3C, 0x0FFC, 
   0x0F03, 0x0FC3, 0x0FAB, 0x0FF3, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F00, 0x0FC0, 0x0FA8, 0x0FF0, 0x0F0C, 0x0FD5, 0x0F3C, 0x0FFC, 
   0x0F03, 0x0FC3, 0x0FAA, 0x0FFA, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F00, 0x0FC0, 0x0FA8, 0x0FF0, 0x0F15, 0x0FD5, 0x0F3D, 0x0FFD, 
   0x0F03, 0x0FC3, 0x0FAB, 0x0FF3, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F00, 0x0FC0, 0x0FA8, 0x0FF0, 0x0F0C, 0x0FD5, 0x0F3C, 0x0FFC, 
   0x0F0A, 0x0FCA, 0x0FAA, 0x0FFA, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F00, 0x0FC0, 0x0FA8, 0x0FF0, 0x0F15, 0x0FD5, 0x0F3C, 0x0FFC, 
   0x0F03, 0x0FC3, 0x0FAB, 0x0FF3, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F00, 0x0FC0, 0x0FA8, 0x0FF0, 0x0F0C, 0x0FD5, 0x0F3C, 0x0FFC, 
   0x0F03, 0x0FC3, 0x0FAA, 0x0FFA, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F01, 0x0FC1, 0x0FA9, 0x0FF1, 0x0F15, 0x0FD5, 0x0F3D, 0x0FFD, 
   0x0F03, 0x0FC3, 0x0FAB, 0x0FF3, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F00, 0x0FC0, 0x0FA8, 0x0FF0, 0x0F0C, 0x0FD5, 0x0F3C, 0x0FFC, 
   0x0F0A, 0x0FCA, 0x0FAA, 0x0FFA, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F00, 0x0FC0, 0x0FA8, 0x0FF0, 0x0F15, 0x0FD5, 0x0F3C, 0x0FFC, 
   0x0F03, 0x0FC3, 0x0FAB, 0x0FF3, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F00, 0x0FC0, 0x0FA8, 0x0FF0, 0x0F0C, 0x0FD5, 0x0F3C, 0x0FFC, 
   0x0F03, 0x0FC3, 0x0FAA, 0x0FFA, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F00, 0x0FC0, 0x0FA8, 0x0FF0, 0x0F15, 0x0FD5, 0x0F3D, 0x0FFD, 
   0x0F03, 0x0FC3, 0x0FAB, 0x0FF3, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F00, 0x0FC0, 0x0FA8, 0x0FF0, 0x0F0C, 0x0FD5, 0x0F3C, 0x0FFC, 
   0x0F0A, 0x0FCA, 0x0FAA, 0x0FFA, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F00, 0x0FC0, 0x0FA8, 0x0FF0, 0x0F15, 0x0FD5, 0x0F3C, 0x0FFC, 
   0x0F03, 0x0FC3, 0x0FAB, 0x0FF3, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F00, 0x0FC0, 0x0FA8, 0x0FF0, 0x0F0C, 0x0FD5, 0x0F3C, 0x0FFC, 
   0x0F03, 0x0FC3, 0x0FAA, 0x0FFA, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F01, 0x0FC1, 0x0FA9, 0x0FF1, 0x0F15, 0x0FD5, 0x0F3D, 0x0FFD, 
   0x0F03, 0x0FC3, 0x0FAB, 0x0FF3, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F00, 0x0FC0, 0x0FA8, 0x0FF0, 0x0F0C, 0x0FD5, 0x0F3C, 0x0FFC, 
   0x0F0A, 0x0FCA, 0x0FAA, 0x0FFA, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F00, 0x0FC0, 0x0FA8, 0x0FF0, 0x0F15, 0x0FD5, 0x0F3C, 0x0FFC, 
   0x0F03, 0x0FC3, 0x0FAB, 0x0FF3, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F00, 0x0FC0, 0x0FA8, 0x0FF0, 0x0F0C, 0x0FD5, 0x0F3C, 0x0FFC, 
   0x0F03, 0x0FC3, 0x0FAA, 0x0FFA, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F00, 0x0FC0, 0x0FA8, 0x0FF0, 0x0F15, 0x0FD5, 0x0F3D, 0x0FFD, 
   0x0F03, 0x0FC3, 0x0FAB, 0x0FF3, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F00, 0x0FC0, 0x0FA8, 0x0FF0, 0x0F0C, 0x0FD5, 0x0F3C, 0x0FFC, 
   0x0F0A, 0x0FCA, 0x0FAA, 0x0FFA, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F00, 0x0FC0, 0x0FA8, 0x0FF0, 0x0F15, 0x0FD5, 0x0F3C, 0x0FFC, 
   0x0F03, 0x0FC3, 0x0FAB, 0x0FF3, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F00, 0x0FC0, 0x0FA8, 0x0FF0, 0x0F0C, 0x0FD5, 0x0F3C, 0x0FFC, 
   0x0F03, 0x0FC3, 0x0FAA, 0x0FFA, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F01, 0x0FC1, 0x0FA9, 0x0FF1, 0x0F15, 0x0FD5, 0x0F3D, 0x0FFD, 
   0x0F03, 0x0FC3, 0x0FAB, 0x0FF3, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F00, 0x0FC0, 0x0FA8, 0x0FF0, 0x0F0C, 0x0FD5, 0x0F3C, 0x0FFC, 
   0x0F0A, 0x0FCA, 0x0FAA, 0x0FFA, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x0F00, 0x0FC0, 0x0FA8, 0x0FF0, 0x0F15, 0x0FD5, 0x0F3C, 0x0FFC, 
   0x0F03, 0x0FC3, 0x0FAB, 0x0FF3, 0x0F0F, 0x0FCF, 0x0F3F, 0x0FFF, 
   0x3F00, 0x3FC0, 0x3FA8, 0x3FF0, 0x3F0C, 0x3FD5, 0x3F3C, 0x3FFC, 
   0x3F03, 0x3FC3, 0x3FAA, 0x3FFA, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3FA8, 0x3FF0, 0x3F15, 0x3FD5, 0x3F3D, 0x3FFD, 
   0x3F03, 0x3FC3, 0x3FAB, 0x3FF3, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3FA8, 0x3FF0, 0x3F0C, 0x3FD5, 0x3F3C, 0x3FFC, 
   0x3F0A, 0x3FCA, 0x3FAA, 0x3FFA, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3FA8, 0x3FF0, 0x3F15, 0x3FD5, 0x3F3C, 0x3FFC, 
   0x3F03, 0x3FC3, 0x3FAB, 0x3FF3, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3FA8, 0x3FF0, 0x3F0C, 0x3FD5, 0x3F3C, 0x3FFC, 
   0x3F03, 0x3FC3, 0x3FAA, 0x3FFA, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F01, 0x3FC1, 0x3FA9, 0x3FF1, 0x3F15, 0x3FD5, 0x3F3D, 0x3FFD, 
   0x3F03, 0x3FC3, 0x3FAB, 0x3FF3, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3FA8, 0x3FF0, 0x3F0C, 0x3FD5, 0x3F3C, 0x3FFC, 
   0x3F0A, 0x3FCA, 0x3FAA, 0x3FFA, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3FA8, 0x3FF0, 0x3F15, 0x3FD5, 0x3F3C, 0x3FFC, 
   0x3F03, 0x3FC3, 0x3FAB, 0x3FF3, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3FA8, 0x3FF0, 0x3F0C, 0x3FD5, 0x3F3C, 0x3FFC, 
   0x3F03, 0x3FC3, 0x3FAA, 0x3FFA, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3FA8, 0x3FF0, 0x3F15, 0x3FD5, 0x3F3D, 0x3FFD, 
   0x3F03, 0x3FC3, 0x3FAB, 0x3FF3, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3FA8, 0x3FF0, 0x3F0C, 0x3FD5, 0x3F3C, 0x3FFC, 
   0x3F0A, 0x3FCA, 0x3FAA, 0x3FFA, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3FA8, 0x3FF0, 0x3F15, 0x3FD5, 0x3F3C, 0x3FFC, 
   0x3F03, 0x3FC3, 0x3FAB, 0x3FF3, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3FA8, 0x3FF0, 0x3F0C, 0x3FD5, 0x3F3C, 0x3FFC, 
   0x3F03, 0x3FC3, 0x3FAA, 0x3FFA, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F01, 0x3FC1, 0x3FA9, 0x3FF1, 0x3F15, 0x3FD5, 0x3F3D, 0x3FFD, 
   0x3F03, 0x3FC3, 0x3FAB, 0x3FF3, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3FA8, 0x3FF0, 0x3F0C, 0x3FD5, 0x3F3C, 0x3FFC, 
   0x3F0A, 0x3FCA, 0x3FAA, 0x3FFA, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3FA8, 0x3FF0, 0x3F15, 0x3FD5, 0x3F3C, 0x3FFC, 
   0x3F03, 0x3FC3, 0x3FAB, 0x3FF3, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3FA8, 0x3FF0, 0x3F0C, 0x3FD5, 0x3F3C, 0x3FFC, 
   0x3F03, 0x3FC3, 0x3FAA, 0x3FFA, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3FA8, 0x3FF0, 0x3F15, 0x3FD5, 0x3F3D, 0x3FFD, 
   0x3F03, 0x3FC3, 0x3FAB, 0x3FF3, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3FA8, 0x3FF0, 0x3F0C, 0x3FD5, 0x3F3C, 0x3FFC, 
   0x3F0A, 0x3FCA, 0x3FAA, 0x3FFA, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3FA8, 0x3FF0, 0x3F15, 0x3FD5, 0x3F3C, 0x3FFC, 
   0x3F03, 0x3FC3, 0x3FAB, 0x3FF3, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3FA8, 0x3FF0, 0x3F0C, 0x3FD5, 0x3F3C, 0x3FFC, 
   0x3F03, 0x3FC3, 0x3FAA, 0x3FFA, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F01, 0x3FC1, 0x3FA9, 0x3FF1, 0x3F15, 0x3FD5, 0x3F3D, 0x3FFD, 
   0x3F03, 0x3FC3, 0x3FAB, 0x3FF3, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3FA8, 0x3FF0, 0x3F0C, 0x3FD5, 0x3F3C, 0x3FFC, 
   0x3F0A, 0x3FCA, 0x3FAA, 0x3FFA, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3FA8, 0x3FF0, 0x3F15, 0x3FD5, 0x3F3C, 0x3FFC, 
   0x3F03, 0x3FC3, 0x3FAB, 0x3FF3, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3FA8, 0x3FF0, 0x3F0C, 0x3FD5, 0x3F3C, 0x3FFC, 
   0x3F03, 0x3FC3, 0x3FAA, 0x3FFA, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3FA8, 0x3FF0, 0x3F15, 0x3FD5, 0x3F3D, 0x3FFD, 
   0x3F03, 0x3FC3, 0x3FAB, 0x3FF3, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3FA8, 0x3FF0, 0x3F0C, 0x3FD5, 0x3F3C, 0x3FFC, 
   0x3F0A, 0x3FCA, 0x3FAA, 0x3FFA, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3FA8, 0x3FF0, 0x3F15, 0x3FD5, 0x3F3C, 0x3FFC, 
   0x3F03, 0x3FC3, 0x3FAB, 0x3FF3, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3FA8, 0x3FF0, 0x3F0C, 0x3FD5, 0x3F3C, 0x3FFC, 
   0x3F03, 0x3FC3, 0x3FAA, 0x3FFA, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F01, 0x3FC1, 0x3FA9, 0x3FF1, 0x3F15, 0x3FD5, 0x3F3D, 0x3FFD, 
   0x3F03, 0x3FC3, 0x3FAB, 0x3FF3, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3FA8, 0x3FF0, 0x3F0C, 0x3FD5, 0x3F3C, 0x3FFC, 
   0x3F0A, 0x3FCA, 0x3FAA, 0x3FFA, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3FA8, 0x3FF0, 0x3F15, 0x3FD5, 0x3F3C, 0x3FFC, 
   0x3F03, 0x3FC3, 0x3FAB, 0x3FF3, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3FA8, 0x3FF0, 0x3F0C, 0x3FD5, 0x3F3C, 0x3FFC, 
   0x3F03, 0x3FC3, 0x3FAA, 0x3FFA, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3FA8, 0x3FF0, 0x3F15, 0x3FD5, 0x3F3D, 0x3FFD, 
   0x3F03, 0x3FC3, 0x3FAB, 0x3FF3, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3FA8, 0x3FF0, 0x3F0C, 0x3FD5, 0x3F3C, 0x3FFC, 
   0x3F0A, 0x3FCA, 0x3FAA, 0x3FFA, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3FA8, 0x3FF0, 0x3F15, 0x3FD5, 0x3F3C, 0x3FFC, 
   0x3F03, 0x3FC3, 0x3FAB, 0x3FF3, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3FA8, 0x3FF0, 0x3F0C, 0x3FD5, 0x3F3C, 0x3FFC, 
   0x3F03, 0x3FC3, 0x3FAA, 0x3FFA, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F01, 0x3FC1, 0x3FA9, 0x3FF1, 0x3F15, 0x3FD5, 0x3F3D, 0x3FFD, 
   0x3F03, 0x3FC3, 0x3FAB, 0x3FF3, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3FA8, 0x3FF0, 0x3F0C, 0x3FD5, 0x3F3C, 0x3FFC, 
   0x3F0A, 0x3FCA, 0x3FAA, 0x3FFA, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3FA8, 0x3FF0, 0x3F15, 0x3FD5, 0x3F3C, 0x3FFC, 
   0x3F03, 0x3FC3, 0x3FAB, 0x3FF3, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3FA8, 0x3FF0, 0x3F0C, 0x3FD5, 0x3F3C, 0x3FFC, 
   0x3F03, 0x3FC3, 0x3FAA, 0x3FFA, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3FA8, 0x3FF0, 0x3F15, 0x3FD5, 0x3F3D, 0x3FFD, 
   0x3F03, 0x3FC3, 0x3FAB, 0x3FF3, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3FA8, 0x3FF0, 0x3F0C, 0x3FD5, 0x3F3C, 0x3FFC, 
   0x3F0A, 0x3FCA, 0x3FAA, 0x3FFA, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3FA8, 0x3FF0, 0x3F15, 0x3FD5, 0x3F3C, 0x3FFC, 
   0x3F03, 0x3FC3, 0x3FAB, 0x3FF3, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3FA8, 0x3FF0, 0x3F0C, 0x3FD5, 0x3F3C, 0x3FFC, 
   0x3F03, 0x3FC3, 0x3FAA, 0x3FFA, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F01, 0x3FC1, 0x3FA9, 0x3FF1, 0x3F15, 0x3FD5, 0x3F3D, 0x3FFD, 
   0x3F03, 0x3FC3, 0x3FAB, 0x3FF3, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3FA8, 0x3FF0, 0x3F0C, 0x3FD5, 0x3F3C, 0x3FFC, 
   0x3F0A, 0x3FCA, 0x3FAA, 0x3FFA, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3FA8, 0x3FF0, 0x3F15, 0x3FD5, 0x3F3C, 0x3FFC, 
   0x3F03, 0x3FC3, 0x3FAB, 0x3FF3, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3FA8, 0x3FF0, 0x3F0C, 0x3FD5, 0x3F3C, 0x3FFC, 
   0x3F03, 0x3FC3, 0x3FAA, 0x3FFA, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3FA8, 0x3FF0, 0x3F15, 0x3FD5, 0x3F3D, 0x3FFD, 
   0x3F03, 0x3FC3, 0x3FAB, 0x3FF3, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3FA8, 0x3FF0, 0x3F0C, 0x3FD5, 0x3F3C, 0x3FFC, 
   0x3F0A, 0x3FCA, 0x3FAA, 0x3FFA, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3FA8, 0x3FF0, 0x3F15, 0x3FD5, 0x3F3C, 0x3FFC, 
   0x3F03, 0x3FC3, 0x3FAB, 0x3FF3, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3FA8, 0x3FF0, 0x3F0C, 0x3FD5, 0x3F3C, 0x3FFC, 
   0x3F03, 0x3FC3, 0x3FAA, 0x3FFA, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F01, 0x3FC1, 0x3FA9, 0x3FF1, 0x3F15, 0x3FD5, 0x3F3D, 0x3FFD, 
   0x3F03, 0x3FC3, 0x3FAB, 0x3FF3, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3FA8, 0x3FF0, 0x3F0C, 0x3FD5, 0x3F3C, 0x3FFC, 
   0x3F0A, 0x3FCA, 0x3FAA, 0x3FFA, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3FA8, 0x3FF0, 0x3F15, 0x3FD5, 0x3F3C, 0x3FFC, 
   0x3F03, 0x3FC3, 0x3FAB, 0x3FF3, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3FA8, 0x3FF0, 0x3F0C, 0x3FD5, 0x3F3C, 0x3FFC, 
   0x3F03, 0x3FC3, 0x3FAA, 0x3FFA, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3FA8, 0x3FF0, 0x3F15, 0x3FD5, 0x3F3D, 0x3FFD, 
   0x3F03, 0x3FC3, 0x3FAB, 0x3FF3, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3FA8, 0x3FF0, 0x3F0C, 0x3FD5, 0x3F3C, 0x3FFC, 
   0x3F0A, 0x3FCA, 0x3FAA, 0x3FFA, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3FA8, 0x3FF0, 0x3F15, 0x3FD5, 0x3F3C, 0x3FFC, 
   0x3F03, 0x3FC3, 0x3FAB, 0x3FF3, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3FA8, 0x3FF0, 0x3F0C, 0x3FD5, 0x3F3C, 0x3FFC, 
   0x3F03, 0x3FC3, 0x3FAA, 0x3FFA, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F01, 0x3FC1, 0x3FA9, 0x3FF1, 0x3F15, 0x3FD5, 0x3F3D, 0x3FFD, 
   0x3F03, 0x3FC3, 0x3FAB, 0x3FF3, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3FA8, 0x3FF0, 0x3F0C, 0x3FD5, 0x3F3C, 0x3FFC, 
   0x3F0A, 0x3FCA, 0x3FAA, 0x3FFA, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3FA8, 0x3FF0, 0x3F15, 0x3FD5, 0x3F3C, 0x3FFC, 
   0x3F03, 0x3FC3, 0x3FAB, 0x3FF3, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3FA8, 0x3FF0, 0x3F0C, 0x3FD5, 0x3F3C, 0x3FFC, 
   0x3F03, 0x3FC3, 0x3FAA, 0x3FFA, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3FA8, 0x3FF0, 0x3F15, 0x3FD5, 0x3F3D, 0x3FFD, 
   0x3F03, 0x3FC3, 0x3FAB, 0x3FF3, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3FA8, 0x3FF0, 0x3F0C, 0x3FD5, 0x3F3C, 0x3FFC, 
   0x3F0A, 0x3FCA, 0x3FAA, 0x3FFA, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3FA8, 0x3FF0, 0x3F15, 0x3FD5, 0x3F3C, 0x3FFC, 
   0x3F03, 0x3FC3, 0x3FAB, 0x3FF3, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3FA8, 0x3FF0, 0x3F0C, 0x3FD5, 0x3F3C, 0x3FFC, 
   0x3F03, 0x3FC3, 0x3FAA, 0x3FFA, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F01, 0x3FC1, 0x3FA9, 0x3FF1, 0x3F15, 0x3FD5, 0x3F3D, 0x3FFD, 
   0x3F03, 0x3FC3, 0x3FAB, 0x3FF3, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3FA8, 0x3FF0, 0x3F0C, 0x3FD5, 0x3F3C, 0x3FFC, 
   0x3F0A, 0x3FCA, 0x3FAA, 0x3FFA, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3FA8, 0x3FF0, 0x3F15, 0x3FD5, 0x3F3C, 0x3FFC, 
   0x3F03, 0x3FC3, 0x3FAB, 0x3FF3, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3FA8, 0x3FF0, 0x3F0C, 0x3FD5, 0x3F3C, 0x3FFC, 
   0x3F03, 0x3FC3, 0x3FAA, 0x3FFA, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3FA8, 0x3FF0, 0x3F15, 0x3FD5, 0x3F3D, 0x3FFD, 
   0x3F03, 0x3FC3, 0x3FAB, 0x3FF3, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3FA8, 0x3FF0, 0x3F0C, 0x3FD5, 0x3F3C, 0x3FFC, 
   0x3F0A, 0x3FCA, 0x3FAA, 0x3FFA, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3FA8, 0x3FF0, 0x3F15, 0x3FD5, 0x3F3C, 0x3FFC, 
   0x3F03, 0x3FC3, 0x3FAB, 0x3FF3, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3FA8, 0x3FF0, 0x3F0C, 0x3FD5, 0x3F3C, 0x3FFC, 
   0x3F03, 0x3FC3, 0x3FAA, 0x3FFA, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F01, 0x3FC1, 0x3FA9, 0x3FF1, 0x3F15, 0x3FD5, 0x3F3D, 0x3FFD, 
   0x3F03, 0x3FC3, 0x3FAB, 0x3FF3, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3FA8, 0x3FF0, 0x3F0C, 0x3FD5, 0x3F3C, 0x3FFC, 
   0x3F0A, 0x3FCA, 0x3FAA, 0x3FFA, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3FA8, 0x3FF0, 0x3F15, 0x3FD5, 0x3F3C, 0x3FFC, 
   0x3F03, 0x3FC3, 0x3FAB, 0x3FF3, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3FA8, 0x3FF0, 0x3F0C, 0x3FD5, 0x3F3C, 0x3FFC, 
   0x3F03, 0x3FC3, 0x3FAA, 0x3FFA, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3FA8, 0x3FF0, 0x3F15, 0x3FD5, 0x3F3D, 0x3FFD, 
   0x3F03, 0x3FC3, 0x3FAB, 0x3FF3, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3FA8, 0x3FF0, 0x3F0C, 0x3FD5, 0x3F3C, 0x3FFC, 
   0x3F0A, 0x3FCA, 0x3FAA, 0x3FFA, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3FA8, 0x3FF0, 0x3F15, 0x3FD5, 0x3F3C, 0x3FFC, 
   0x3F03, 0x3FC3, 0x3FAB, 0x3FF3, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3FA8, 0x3FF0, 0x3F0C, 0x3FD5, 0x3F3C, 0x3FFC, 
   0x3F03, 0x3FC3, 0x3FAA, 0x3FFA, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F01, 0x3FC1, 0x3FA9, 0x3FF1, 0x3F15, 0x3FD5, 0x3F3D, 0x3FFD, 
   0x3F03, 0x3FC3, 0x3FAB, 0x3FF3, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3FA8, 0x3FF0, 0x3F0C, 0x3FD5, 0x3F3C, 0x3FFC, 
   0x3F0A, 0x3FCA, 0x3FAA, 0x3FFA, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3FA8, 0x3FF0, 0x3F15, 0x3FD5, 0x3F3C, 0x3FFC, 
   0x3F03, 0x3FC3, 0x3FAB, 0x3FF3, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3FA8, 0x3FF0, 0x3F0C, 0x3FD5, 0x3F3C, 0x3FFC, 
   0x3F03, 0x3FC3, 0x3FAA, 0x3FFA, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3FA8, 0x3FF0, 0x3F15, 0x3FD5, 0x3F3D, 0x3FFD, 
   0x3F03, 0x3FC3, 0x3FAB, 0x3FF3, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3FA8, 0x3FF0, 0x3F0C, 0x3FD5, 0x3F3C, 0x3FFC, 
   0x3F0A, 0x3FCA, 0x3FAA, 0x3FFA, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3FA8, 0x3FF0, 0x3F15, 0x3FD5, 0x3F3C, 0x3FFC, 
   0x3F03, 0x3FC3, 0x3FAB, 0x3FF3, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3FA8, 0x3FF0, 0x3F0C, 0x3FD5, 0x3F3C, 0x3FFC, 
   0x3F03, 0x3FC3, 0x3FAA, 0x3FFA, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F01, 0x3FC1, 0x3FA9, 0x3FF1, 0x3F15, 0x3FD5, 0x3F3D, 0x3FFD, 
   0x3F03, 0x3FC3, 0x3FAB, 0x3FF3, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3FA8, 0x3FF0, 0x3F0C, 0x3FD5, 0x3F3C, 0x3FFC, 
   0x3F0A, 0x3FCA, 0x3FAA, 0x3FFA, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3FA8, 0x3FF0, 0x3F15, 0x3FD5, 0x3F3C, 0x3FFC, 
   0x3F03, 0x3FC3, 0x3FAB, 0x3FF3, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3FA8, 0x3FF0, 0x3F0C, 0x3FD5, 0x3F3C, 0x3FFC, 
   0x3F03, 0x3FC3, 0x3FAA, 0x3FFA, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3FA8, 0x3FF0, 0x3F15, 0x3FD5, 0x3F3D, 0x3FFD, 
   0x3F03, 0x3FC3, 0x3FAB, 0x3FF3, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3FA8, 0x3FF0, 0x3F0C, 0x3FD5, 0x3F3C, 0x3FFC, 
   0x3F0A, 0x3FCA, 0x3FAA, 0x3FFA, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3FA8, 0x3FF0, 0x3F15, 0x3FD5, 0x3F3C, 0x3FFC, 
   0x3F03, 0x3FC3, 0x3FAB, 0x3FF3, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3FA8, 0x3FF0, 0x3F0C, 0x3FD5, 0x3F3C, 0x3FFC, 
   0x3F03, 0x3FC3, 0x3FAA, 0x3FFA, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F01, 0x3FC1, 0x3FA9, 0x3FF1, 0x3F15, 0x3FD5, 0x3F3D, 0x3FFD, 
   0x3F03, 0x3FC3, 0x3FAB, 0x3FF3, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3FA8, 0x3FF0, 0x3F0C, 0x3FD5, 0x3F3C, 0x3FFC, 
   0x3F0A, 0x3FCA, 0x3FAA, 0x3FFA, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3FA8, 0x3FF0, 0x3F15, 0x3FD5, 0x3F3C, 0x3FFC, 
   0x3F03, 0x3FC3, 0x3FAB, 0x3FF3, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3FA8, 0x3FF0, 0x3F0C, 0x3FD5, 0x3F3C, 0x3FFC, 
   0x3F03, 0x3FC3, 0x3FAA, 0x3FFA, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3FA8, 0x3FF0, 0x3F15, 0x3FD5, 0x3F3D, 0x3FFD, 
   0x3F03, 0x3FC3, 0x3FAB, 0x3FF3, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3FA8, 0x3FF0, 0x3F0C, 0x3FD5, 0x3F3C, 0x3FFC, 
   0x3F0A, 0x3FCA, 0x3FAA, 0x3FFA, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3FA8, 0x3FF0, 0x3F15, 0x3FD5, 0x3F3C, 0x3FFC, 
   0x3F03, 0x3FC3, 0x3FAB, 0x3FF3, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3FA8, 0x3FF0, 0x3F0C, 0x3FD5, 0x3F3C, 0x3FFC, 
   0x3F03, 0x3FC3, 0x3FAA, 0x3FFA, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F01, 0x3FC1, 0x3FA9, 0x3FF1, 0x3F15, 0x3FD5, 0x3F3D, 0x3FFD, 
   0x3F03, 0x3FC3, 0x3FAB, 0x3FF3, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3FA8, 0x3FF0, 0x3F0C, 0x3FD5, 0x3F3C, 0x3FFC, 
   0x3F0A, 0x3FCA, 0x3FAA, 0x3FFA, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3FA8, 0x3FF0, 0x3F15, 0x3FD5, 0x3F3C, 0x3FFC, 
   0x3F03, 0x3FC3, 0x3FAB, 0x3FF3, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3FA8, 0x3FF0, 0x3F0C, 0x3FD5, 0x3F3C, 0x3FFC, 
   0x3F03, 0x3FC3, 0x3FAA, 0x3FFA, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3FA8, 0x3FF0, 0x3F15, 0x3FD5, 0x3F3D, 0x3FFD, 
   0x3F03, 0x3FC3, 0x3FAB, 0x3FF3, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3FA8, 0x3FF0, 0x3F0C, 0x3FD5, 0x3F3C, 0x3FFC, 
   0x3F0A, 0x3FCA, 0x3FAA, 0x3FFA, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3FA8, 0x3FF0, 0x3F15, 0x3FD5, 0x3F3C, 0x3FFC, 
   0x3F03, 0x3FC3, 0x3FAB, 0x3FF3, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3FA8, 0x3FF0, 0x3F0C, 0x3FD5, 0x3F3C, 0x3FFC, 
   0x3F03, 0x3FC3, 0x3FAA, 0x3FFA, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F01, 0x3FC1, 0x3FA9, 0x3FF1, 0x3F15, 0x3FD5, 0x3F3D, 0x3FFD, 
   0x3F03, 0x3FC3, 0x3FAB, 0x3FF3, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3FA8, 0x3FF0, 0x3F0C, 0x3FD5, 0x3F3C, 0x3FFC, 
   0x3F0A, 0x3FCA, 0x3FAA, 0x3FFA, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3FA8, 0x3FF0, 0x3F15, 0x3FD5, 0x3F3C, 0x3FFC, 
   0x3F03, 0x3FC3, 0x3FAB, 0x3FF3, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3FA8, 0x3FF0, 0x3F0C, 0x3FD5, 0x3F3C, 0x3FFC, 
   0x3F03, 0x3FC3, 0x3FAA, 0x3FFA, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3FA8, 0x3FF0, 0x3F15, 0x3FD5, 0x3F3D, 0x3FFD, 
   0x3F03, 0x3FC3, 0x3FAB, 0x3FF3, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3FA8, 0x3FF0, 0x3F0C, 0x3FD5, 0x3F3C, 0x3FFC, 
   0x3F0A, 0x3FCA, 0x3FAA, 0x3FFA, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3FA8, 0x3FF0, 0x3F15, 0x3FD5, 0x3F3C, 0x3FFC, 
   0x3F03, 0x3FC3, 0x3FAB, 0x3FF3, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3FA8, 0x3FF0, 0x3F0C, 0x3FD5, 0x3F3C, 0x3FFC, 
   0x3F03, 0x3FC3, 0x3FAA, 0x3FFA, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F01, 0x3FC1, 0x3FA9, 0x3FF1, 0x3F15, 0x3FD5, 0x3F3D, 0x3FFD, 
   0x3F03, 0x3FC3, 0x3FAB, 0x3FF3, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3FA8, 0x3FF0, 0x3F0C, 0x3FD5, 0x3F3C, 0x3FFC, 
   0x3F0A, 0x3FCA, 0x3FAA, 0x3FFA, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF, 
   0x3F00, 0x3FC0, 0x3FA8, 0x3FF0, 0x3F15, 0x3FD5, 0x3F3C, 0x3FFC, 
   0x3F03, 0x3FC3, 0x3FAB, 0x3FF3, 0x3F0F, 0x3FCF, 0x3F3F, 0x3FFF 
};
#endif
