
/* Generated by Interface Builder */

#import "WozView.h"
#import "hgrconv.h"
#import <appkit/graphics.h>
#import <defaults/defaults.h>
#import <appkit/NXBitmapImageRep.h>
#import <appkit/tiff.h>
#import <string.h>

@implementation WozView

- initFrame:(const NXRect *) frameRect
{
#ifdef	USE_COLOR
    NXRect newFrameRect;
    
    /* nib file view width is 576 (or 2 * 288) for greyscale. */
    /* We need it to be only 280 * 2 or 560 for color */
    newFrameRect.origin = frameRect->origin;
    newFrameRect.size = frameRect->size;
    newFrameRect.size.width = 560;
    
    [super initFrame:&newFrameRect];
#else	USE_COLOR
    [super initFrame:frameRect];
#endif	USE_COLOR

  memset (fbuf, 0, sizeof fbuf);            /* Clear to black. */
  return self;
}

- drawSelf:(const NXRect *) rects: (int) rectCount
{
    const unsigned char *my_data[5]
	= { (unsigned char *)fbuf,
	    (unsigned char *)NULL, (unsigned char *)NULL,
	    (unsigned char *)NULL, (unsigned char *)NULL};

#ifndef	USE_COLOR
    NXDrawBitmap(&bounds, 280, 192, 2, 1, 2, 70, NO, NO,
	    NX_OneIsWhiteColorSpace, my_data);
#else	USE_COLOR
    NXDrawBitmap(&bounds, 280, 192, 2, 4, 8, 280, NO, YES,
	    NX_RGBColorSpace, my_data);
#endif	USE_COLOR
  
    return self;
}


- drawChangedAreas:(const unsigned char *) a2_screen
                   shadow:(unsigned char *) a2_shadow
{
  unsigned char changed[192 / 16];
  NXRect r = bounds;
  int i, start, height;


//#ifdef	USE_COLOR
//    r.origin.x -= 7 * 2.0;
//#endif	USE_COLOR
 
  [self lockFocus];

  /* Find out what areas changed, if any. */
  if (find_changed_areas (a2_screen, a2_shadow, changed))
    {
      for (i = 0; i < sizeof changed; i++)
	if (changed[i])
	  {
	    start = i * 16;
	    for (i++; i < sizeof changed && changed[i]; i++);
	    height = i * 16 - start;
	    r.origin.y = (192 - (start + height)) * 2.0;
	    r.size.height = height * 2.0;  /*  * 2.0 since we are scaled. */
	    apple_to_next (a2_screen, fbuf, start, height);

	    {
		const unsigned char *my_data[5]
		    = { (unsigned char *)&fbuf[start][0],
			(unsigned char *)NULL, (unsigned char *)NULL,
			(unsigned char *)NULL, (unsigned char *)NULL};
		
#ifndef	USE_COLOR
		NXDrawBitmap(&r, 288, height, 2, 1, 2, 72, NO, NO,
			    NX_OneIsWhiteColorSpace, my_data );
#else	USE_COLOR
//		NXDrawBitmap(&r, 288, height, 2, 4, 8, 288, NO, YES,
//			    NX_RGBColorSpace, my_data );
		NXDrawBitmap(&r, 280, height, 2, 4, 8, 280, NO, YES,
			    NX_RGBColorSpace, my_data );
#endif	USE_COLOR
	    }
	}
	copy_changed_areas (a2_screen, a2_shadow, changed);
    }

    [self unlockFocus];

    return self;
}


- (unsigned char *) data
{
  return &fbuf[0][0];
}


- appDidInit:(id) sender
{
    void simulator_main(int argc,char **argv);
    
    extern id screen_wozview;
    extern unsigned char *wozview_buf;
    
    screen_wozview = self;
    wozview_buf = &fbuf[0][0];

    simulator_main (NXArgc, NXArgv);
    return self;
}

@end

