// WWSelectList.h
// Copyright (c) 1995, Linus Upson. All rights reserved.

#import <foundation/NSString.h>
#import <foundation/NSDictionary.h>
#import <foundation/NSArray.h>
#import <foundation/NSData.h>

@class WWHtmlString;

@interface WWSelectList:NSObject
{
    NSString *_name;
    NSArray *_options;
    NSArray *_values;
    BOOL _multiple;
    BOOL _separateInputs;
}

- initWithName:(NSString *)name;
    // Name of the select list.

- (void)setOptions:(NSArray *)options values:(NSArray *)values;
    // Values may be nil, in which case the options are also the values.

- (void)setAllowsMultipleSelection:(BOOL)yn;
- (BOOL)allowsMultipleSelection;
    // Sets whether the widget will allow multiple items to be selected.

- (void)setUsesSeparateInputs:(BOOL)yn;
- (BOOL)usesSeparateInputs;
    // If set to YES, then the select list will be rendered as an unordered
    // list of radio buttons, or checkboxes if multiple selection is allowed.
    // This is useful if the text of the options is rather long.  These
    // methods need a better name.

- (WWHtmlString *)htmlDescription;

@end

