// WWPage.h
// Copyright (c) 1995, Linus Upson. All rights reserved.

#import <foundation/NSString.h>
#import <foundation/NSDictionary.h>
#import <foundation/NSArray.h>
#import <foundation/NSData.h>

@class WWHtmlString;

#define SPECIAL_SUB_FILE_DIR		@"ServedFiles"

@interface WWPage:NSObject
{
    NSString *_basePage;
    NSMutableDictionary *_anchorBindings;
    NSMutableDictionary *_formBindings;
}

+ (WWPage *)pageWithResource:(NSString *)resource ofType:(NSString *)type;
    // Convenience method.

- initWithString:(NSString *)html;
    // primitive init method.

- initWithContentsOfFile:(NSString *)htmlFile;
    // just loads the file and calls initWithData:.

// There needs to be some way to remove objects from the bindings.  In general
// there needs to be ways to manipulate the underlying dictionary state of
// stuff, using all possible dictionary methods.

- (NSDictionary *)anchorBindings;
- (NSDictionary *)formBindings;
    // returns the data to be bound into the page

- (void)bindValue:value forAnchorWithName:(NSString *)name;
- (void)bindAnchorValues:(NSDictionary *)binding;
    // substitues [value htmlDescription] for the html contents of the anchors
    // with a matching name

- (void)bindValues:(NSDictionary *)values forFormWithAction:(NSString *)action;
    // sets up the form with values -- it puts values in inputs, selects
    // checkboxes, insets hidden fields, etc...

- (WWHtmlString *)htmlDescription;
    // Returns the html string for the page.  The bindings are done lazily, so
    // this is where the work gets done.  The bound page is cached until a new
    // binding is set.

@end







@interface WWPage (WWPageCaching)

+ (WWPage *)cachedPageWithContentsOfFile:(NSString *)htmlFile;

+ (WWPage *)cachedPageWithResource:(NSString *)resource
    ofType:(NSString *)type;

@end








@interface WWPage (copying)
- copy;
@end
