// WWHtmlString.h
// Copyright (c) 1995, Linus Upson. All rights reserved.

#import <foundation/NSString.h>
#import <foundation/NSDictionary.h>
#import <foundation/NSArray.h>
#import <foundation/NSData.h>

// I have some questions about how to subclass NSString.  What can I do in
// -isEqual:, -hash, -description, methods which return (NSString *), etc.
// What about initWithFormat:...?

@interface WWHtmlString:NSString
{
    NSString *_string;
}

- initWithString:(NSString *)string;
- initWithStringNoCopy:(NSString *)string;
    // Some basic init methods.

- initWithContentsOfFile:(NSString *)path;
    // A convenience init method.  Should I implement all the common init
    // methods of NSString for convenience?  This particular method is kind
    // of special because it might do special things to figure out what kind
    // of character encoding is used in the file.

- (unsigned int)length;			
- (unichar)characterAtIndex:(unsigned)index;
- (void)getCharacters:(unichar *)buffer range:(NSRange)aRange;
    // These are the primitive NSString methods.

- (WWHtmlString *)htmlDescription;
    // For instances if WWHtmlString, this method simply returns self.

@end


@interface NSObject (WWHtmlDescription)

- (WWHtmlString *)htmlDescription;
    // This method is the -description of the Web Framework.  The default
    // implementation asks the object for it's description and then escapes
    // any reserved HTML characters.  Any object that knows how to generate
    // html can do so here.

@end

