// ImageMap.h
// Copyright (c) 1995-6, Information Technology Solutions, inc. 
//	All rights reserved.

#import <foundation/NSString.h>
#import <foundation/NSPathUtilities.h>
#import <foundation/NSDictionary.h>
#import <foundation/NSArray.h>
#import <foundation/NSData.h>

#import "WWRequest.h"
#import "WWResponse.h"
#import "WWServer.h"
#import "WWHtmlString.h"
#import "Imap_Support.h"

@class WWHtmlString;

@interface ImageMap:NSObject
{
    NSString *_imageFile;
    NSString *_mapResource;     // this currently should be a filename
    NSMutableArray *_mapData;   // this contains an array of (char *)'s
    BOOL _mapInitialized;       // have we loaded map data from the resource?
}

// designated initializers
- initWithName:(NSString *) name;          // assume name.gif and name.map
- initWithImageFile:(NSString *)imageFile; // assume foo.gif has foo.map
- initWithImageFile:(NSString *)imageFile mapResource:(NSString *)mapResource;

// this reads in the mapfile and fills in the mapData array
- generateMappingData;

// this returns the HTML description of the anchor used for this imagemap
- (WWHtmlString *)htmlDescription;

// returns the response for the given coordinates
- (WWResponse *) responseForRequest:(WWRequest *)request atX:(int)x atY:(int)y;

// basic accessor methods
- (NSString *)imageFile;
- setImageFile:(NSString *)imageFile;
- (NSString *)mapResource;
- setMapResource:(NSString *)mapResource;

@end
