// Copyright (c) 1995-1996, Information Technology Solutions. 
//  All rights reserved.

#import "HRPage.h"

@implementation HRPage
	
	/*" This subclass of WWPage automatically appends a footer (see #footer)
	to every html string containing a named anchor matching HR_FOOTER_ANCHOR
	passed to #initWithString:.  All initialization	methods call
	#initWithString:.
	"*/

+ (WWHtmlString *)footer
	/*" Returns the html string which will be inserted as a footer in html 
	doc's containing the HR_FOOTER_ANCHOR. "*/
{
	static 	WWHtmlString	*footer		= nil;
	
	if (!footer) {
		footer = [[WWHtmlString alloc] initWithString:@"<br>\n<hr>\n<br>\n<center><pre><i>Human Resources Options Menu</i>\n --------------- ------------------------ ------------------- \n| <a href=\"option_info.html\">Browse HR Info</a> | <a href=\"HRE_employee_access.html\">Enter Employee Options</a> | <a href=\"HRA_admin_summary\">View HR Elections</a> |\n --------------- ------------------------ ------------------- </pre></center>\n\n\n<p>\n<hr>\nPlease send comments and questions to <a href=\"mailto:webmaster@its.com\">webmaster@its.com</a><br> Copyright &#169; 1995, <a href=\"http://www.its.com/index.html\"><FONT SIZE=\"-3\">Information Technology Solutions, Inc.</A>  All Rights Reserved.</FONT></p>"];
	}
	
	return footer;
}

- initWithString:(NSString *)html
{
	NSString 	*foot		= nil;
	[super initWithString:html];
	
	if ((foot = [[self class] footer]))
		[self bindValue:foot forAnchorWithName:HR_FOOTER_ANCHOR];
	return self;
}

@end
