
rem create the oracle flybynight database in its entirety.


rem drop table CUSTOMER;
rem drop table PACKAGE;


rem ****************************************************************
rem store a row for every customer of flybynight shipping.
create table CUSTOMER (
    CUST_ID		int				not null,
    NAME		varchar(60)	,
    PASSWORD	varchar(60)
);
grant all on CUSTOMER to public;
create unique index CUSTOMER_CUSTID on CUSTOMER ( CUST_ID );


rem ****************************************************************
rem stores a line for every package containing its current status
rem CUST_ID is a fk to the CUSTOMER table.
create table PACKAGE (
    PACK_ID				int				not null,
	CUST_ID				int,
	DESCRIPTION			varchar(60),
    IS_DELIVERED		char(1),
	DATE_ENTERED		date,
    SEND_DATE			date,
	RECV_DATE			date,
	DELIVERY_SIGNATURE	varchar(60)
);
grant all on PACKAGE to public;
create unique	index PACKAGE_PACKID on PACKAGE ( PACK_ID );
create			index PACKAGE_CUSTID_FK on PACKAGE ( CUST_ID );




rem ****************************************************************
rem store a row for every entity that needs unique IDs tracked.
create table ITSUNIQUEID (
    ENTITYNAME	varchar(60),
    IDCOUNT		int,
    MAXID		int
);
grant all on ITSUNIQUEID to public;
create unique index ITSUNIQUEID_ENTITYNAME on ITSUNIQUEID ( ENTITYNAME );

