/*
         Unpublished Confidential Information of
  Information Technology Solutions, Inc. Do not disclose.
Copyright (c) Information Technology Solutions, Inc., 1994.
                  All Rights Reserved.

     500 West Madison, Suite 2210, Chicago, IL 60661
      312-474-7700  312-474-9361 (Fax)  info@its.com

Filename: ITSSharedChannel.m
Author:   Drew Davidson,
		  adapted from UniqueKey example by Steve Herrick
Date:	  Wed Apr 19 1995 12:31:38 CDT
$Id: ITSSharedChannel.m,v 1.1 1996/01/03 14:44:14 trieger Exp $
 $Log: ITSSharedChannel.m,v $
 * Revision 1.1  1996/01/03  14:44:14  trieger
 * Probably stable, hopeful last attempt at checking in fbn that is webrex
 * 1.15 compatible.
 *
 * Revision 1.1  1995/09/01  18:14:31  trieger
 * *** empty log message ***
 *
*/
// drewd said this isn't needed. 
//#import "ITSModelUtils/modelutils.h"
# import "ITSSharedChannel.h"

@implementation ITSSharedChannel
	/*"
	"*/

/*----------------------------< PRIVATE METHODS >----------------------------*/
- (void)logError:aString
{
	NSLog(@"%@: %s",[self class],[aString cString]);
}

/*---------------------------< INIT/FREE METHODS >---------------------------*/
- initWithDatabase:(EODatabase *)aDatabase
	/*"
	All init... methods eventually call #initWithDatabase:.
	"*/
{
	if ((database = [aDatabase retain]))
	{	if ((context = [[EODatabaseContext alloc] initWithDatabase:aDatabase]))
		{	if ((channel = [[EODatabaseChannel alloc] initWithDatabaseContext:[self context]]))
			{	if (![[channel adaptorChannel] openChannel])
				{	[self logError:[NSString stringWithFormat:@"unable to openChannel on %@",
												[channel adaptorChannel]]];
				}
			}
			else
				[self logError:@"unable to initWithDatabaseContext:"];
		}
		else
			[self logError:@"unable to initWithDatabase:"];
	}
	return((database && context && channel) ? self : nil);
}

- initWithAdaptor:(EOAdaptor *)anAdaptor
{	
	if ((adaptor = [anAdaptor retain]))
	{	if (!(database = [[EODatabase alloc] initWithAdaptor:anAdaptor]))
			[self logError:@"unable to initWithAdaptor:"];
	}
	return([self initWithDatabase:[database autorelease]]);
}

- initWithModel:(EOModel *)aModel connectionDictionary:(NSDictionary *)aDictionary
{
	connectionDictionary = [aDictionary retain];
	if ((model = [aModel retain]))
	{	if ((adaptor = [EOAdaptor adaptorWithModel:aModel]))
		{	if (connectionDictionary)
				[adaptor setConnectionDictionary:connectionDictionary];
			if (![adaptor hasValidConnectionDictionary])
				[adaptor runLoginPanelAndValidateConnectionDictionary];
		}
		else
			[self logError:@"unable to create adaptorWithModel:"];
	}
	return([self initWithAdaptor:adaptor]);
}

- initWithModel:(EOModel *)aModel
{
	return([self initWithModel:aModel connectionDictionary:nil]);
}

- (void)dealloc
{
	[model autorelease];
	[connectionDictionary autorelease];
	[adaptor autorelease];
	[database autorelease];
	[context autorelease];
	[channel autorelease];
}

/*-----------------------------< OTHER METHODS >-----------------------------*/
- (EOModel *)model
{
	return(model);
}

- (NSDictionary *)connectionDictionary
{
	return(connectionDictionary);
}

- (EOAdaptor *)adaptor
{
	return(adaptor);
}

- (EODatabase *)database
{
	return(database);
}

- (EODatabaseContext *)context
{
	return(context);
}

- (EODatabaseChannel *)channel
{
	return(channel);
}

@end
