// Copyright (c) 1995-1996, Information Technology Solutions. 
//  All rights reserved.

#import "FBNTopController.h"

#import "FBNPage.h"
#import "webrex_access.h"

#import <foundation/NSException.h>
#import <foundation/NSAutoreleasePool.h>
#import <foundation/NSUtilities.h>
#import <foundation/NSPathUtilities.h>

#import <stdio.h>

#define ERROR_PAGE				@"error_msg"
#define HTML_TYPE				@"html"
#define FBN_APPLET_CACHE_NAME	@"FBN_applet"



@interface FBNTopController (GeneralUse)
- (WWSelectList *)selectListWithName:(NSString *)name
							 options:(NSArray *)options
							  values:(NSArray *)values
						  forObjects:(NSArray *)objects;
- (WWSelectList *)selectListWithName:(NSString *)name
							 options:(NSArray *)options
							  values:(NSArray *)values
					   forDataSource:(EODatabaseDataSource *)dataSource
							  entity:(EOEntity *)entity
							fetchOrder:(NSArray *)fetchOrder;
- (WWSelectList *)selectListWithName:(NSString *)name
							 options:(NSArray *)options
							  values:(NSArray *)values
					   forDataSource:(EODatabaseDataSource *)dataSource
							  entity:(EOEntity *)entity;
							  - (NSArray *)stringArrayWithColumns:(NSArray *)columns 
						fromObjects:(NSArray *)objects
						  useParens:(BOOL)useParens;
@end


@implementation FBNTopController

- (WWResponse *)responseForRequest:(WWRequest *)request
	/*" my superclass implements this by default, but I can 
	override it if I want to do something special, like was done
	in the timeoff demo.  Perhaps your usename and password
	could be verified against the db or something.  Or the connection
	can be checked.
	PERFORMANCE: in checking this way to see if we are connected
		to the db, on an objectstation communicating with oracle
		on an old solaris box, it adds ~8000 uS to the average retrieve
		time.  This might improve if it were running PDO on the same
		machine as the db.
	"*/
{
	BOOL	yn			= NO;
	
	// check to see if we are still connected to the db in 
	// the fastest way possible.  i have found by experimentation
	// that a begin will succeed even if we lost our connected,
	// but the commit will surely fail.
	yn = [_context beginTransaction];
	if (yn == YES) {
		yn = [_context commitTransaction];
	}
	if (yn == NO) {
		// remove yourself from the cache and go away and return an error.
		// remove yourself from the cache and go away and return an error.
		[_cache removeObjectForKey:FBN_APPLET_CACHE_NAME];
		[_cache autorelease];
		return [self sendErrorMsg:@"Cannot connect to database."];
	}
	return [super responseForRequest:request];
}


- realInitWithServer:(WWServer *)server baseLocator:(NSString *)locator
	/*" Get the resources we need when we are init'd.  WWServer is the object
	that allocs us.  If we implement this method, we are not just init'd, but
	we are init'dWithServer.  This gives us a chance to get some information 
	about what's going on in the world... information we can use while initing. 
	Set up all the state that the other methods of this object assume. 
	(like the db connetion)
	"*/
{
    NSBundle			*bundle		= nil;
    NSString			*path		= nil;
    EOModel				*model		= nil;
    EODatabaseChannel 	*channel	= nil;

    // This is a potential problem when having a model fragment in each part
    // of the server tree.  There needs to be a web framework convenience
    // method or two to do this common kind of stuff.
    bundle 		= [server bundleForBaseLocator:locator];
    path 		= [bundle pathForResource:@"flybynight" ofType:@"eomodel"];
    model 		= [[[EOModel alloc] initWithContentsOfFile:path] autorelease];
	_anITSSC	= [[ITSSharedChannel alloc] initWithModel:model];
	
    _context 	= [[_anITSSC context] retain];
    channel 	= [_anITSSC channel];
    _custDS		= [[EODatabaseDataSource alloc] initWithDatabaseChannel:channel
					entityNamed:@"Customer"];
    _packDS		= [[EODatabaseDataSource alloc] initWithDatabaseChannel:channel
					entityNamed:@"Package"];
	
    if (!_custDS) {
		NSLog (@"*** Error creating customer data source! ***");
		[self autorelease];
		return nil;
    }
    if (!_packDS) {
		NSLog (@"*** Error creating package data source! ***");
		[self autorelease];
		return nil;
    }

	_customerEntity = [model entityNamed:@"Customer"];
	_packageEntity = [model entityNamed:@"Package"];

	_custUID	= [[UniqueId alloc] initWithEntityNamed:@"Customer" sharedChannel:_anITSSC];
	_packUID	= [[UniqueId alloc] initWithEntityNamed:@"Package" sharedChannel:_anITSSC];

	return self;
}

- initWithServer:(WWServer *)server baseLocator:(NSString *)baseLocator
	/*" This is the method with which we are normally init'd by the
	server.  A new instance of this class will be sent this message every
	time a new http request comes in.  Therefore I will 'cache' myself
	in this method the first time i am inited and every other time i will
	retrieve the instance in the cache and dealloc myself.  

	All of the real	work on initializing is done in a separate init method, 
	#realInitWithServer:baseLocator:.  NOTE:  since 
	the http connection is stateless, make sure you don't cache state that
	doesn't make sense to cache... At this point, basically all i am 
	caching is my connection to the database.
	"*/
{
	id					cachedInstance	= nil;
	id					ourSelves		= nil;
    NSMutableDictionary *cache			= nil;

	[super initWithServer:server baseLocator:baseLocator];

	// get the cache.
    cache = [server cachedResourcesForKey:@"FlyByNight Applet"];

	// see if there's been an object cached with our unique name.
	cachedInstance = [cache objectForKey:FBN_APPLET_CACHE_NAME];
    if (cachedInstance) {
		// blow away ourselves and return the one from the cache.
		[self autorelease];
		return [cachedInstance retain];
    }
	
	// guess not, we must be the first.  init yourself.
    ourSelves = [self realInitWithServer:server baseLocator:baseLocator];
	if (ourSelves == nil) {
		// initialization must have failed.
		return nil;
	} else {
		// store yourself in the cache. (ourSelves == self here)
		[cache setObject:ourSelves forKey:FBN_APPLET_CACHE_NAME];
		_cache = [cache retain];
		return self;
	}
}

- (void)dealloc
	/*" Foundation thing.  called implicitly when our refcount has gone to 0.
	No need to return.  Clean up all my ivars, and then super.
	"*/
{
	// clean up my ivars.
    [_custDS			autorelease];
    [_packDS			autorelease];
	[_customerEntity	autorelease];
	[_packageEntity		autorelease];
    [_context			autorelease];
    [_cache				autorelease];
	[_custUID			autorelease];
	[_packUID			autorelease];
	[_anITSSC			autorelease];
	
	// all done, call super dealloc.
	[super dealloc];
}

- (WWResponse *)sendMainPage:(WWRequest *)request
	/*" value, needs to implement htmldescription.  if this is just 
	the flat index.html page with no bindings done to it, use
	wwresponse responseforresource oftype: or something like that.
	"*/
{
	WWPage* aPage = [FBNPage pageWithResource:@"index" ofType:@"html"];

	return [WWResponse responseWithPage:aPage];
}

- (WWResponse *)sendInfoPage:(WWRequest *)request
	/*" return the info page.  in the future this should be able
	to be done without writing any code (and perhaps without modifying
	the methods.config file, although linus brought up a good point.  if
	you implement that behavior, they can ask for the methods.config file
	itself, and any other file whose name they guess in your "applet"-wrapper.
	"*/
{
	WWPage* aPage = [FBNPage pageWithResource:@"info" ofType:@"html"];

	return [WWResponse responseWithPage:aPage];
}

- (WWResponse *)showCustDataEntryPage:(WWRequest *)request
	/*" Return the customer data-entry html page.  this is different from the dataEntry:
	method in that it is meant to actually do the insert given the data
	entered in the data-entry html page.  THIS method is meant to just
	display the page.
	"*/
{
	WWPage* aPage = [FBNPage pageWithResource:@"custDataEntry" 
								ofType:@"html"];

	return [WWResponse responseWithPage:aPage];
}

- (WWResponse *)showTrackPackagesPage:(WWRequest *)request
	/*" Return the track package (customer id number) html page.  
	THIS method is meant to just display the page, so that the 
	use may enter a customer tracking number to view their packages.
	NOTE: now that I bind in an slist, this method will start and commit
		its own transaction (done in that private method).
	"*/
{
	WWPage* aPage = [FBNPage pageWithResource:@"trackPackages" 
								ofType:@"html"];
	[aPage bindValue:[self _customerSList] forAnchorWithName:@"customer_select_list"];
	return [WWResponse responseWithPage:aPage];
}

- (WWResponse *)showPackDataEntryPage:(WWRequest *)request
	/*" Return the package data-entry html page.
	  THIS method is meant to just
	display the page, not do the insert.
	ENAHNCEMENT: 1/3/96 - added select list support to make it 
		easier to pick the customer.  it used to be a text field
		and you had to type the id of the customer.

	"*/
{
	WWPage			*aPage		= [FBNPage pageWithResource:@"packDataEntry" 
								ofType:@"html"];
	
	[aPage bindValue:[self _customerSList] forAnchorWithName:@"customer_select_list"];
	return [WWResponse responseWithPage:aPage];
}

- (WWSelectList *)_customerSList
	/*" convience method since this is done is a couple places.
	create the slist of all the customers in the system.
	We will start and commit our own transaction because we
	use another general use method that will do this.
	"*/
{
	WWSelectList	*sList		= nil;
	NSMutableArray	*options	= nil;
	NSMutableArray	*values		= nil;
	
	options = [[[NSMutableArray alloc] initWithCapacity:5] autorelease];
	[options addObject:[NSString stringWithFormat:@"%@",@"name"]];
	values = [[[NSMutableArray alloc] initWithCapacity:5] autorelease];
	[values addObject:[NSString stringWithFormat:@"%@",@"custId"]];
	sList = [self selectListWithName:@"custId" options:options values:values
				forDataSource:_custDS entity:_customerEntity];
	[sList setAllowsMultipleSelection:NO];
	return sList;
}


- (WWResponse *)doCustomerDataEntry:(WWRequest *)request
	/*" Take the input from the customer data entry form and enter it 
	into the flybynight
	database.  Database state should already be established.
	(about to modify into taking the 'request' from the customer data
	MODIFICATION page and channel it into either entry, modification,
	removal, or search (need cust id)
	"*/
{
	EOGenericRecord*		customer = nil;
	NSDictionary*			row;
	NSDictionary*			valuesDict;
	BOOL					success = NO;
	BOOL					rebind = NO;
	WWPage*					page;
	NSMutableString*		msgStr;
	NSString*				submitValue;
	NSString*				errorStr;
	NSString				*custId			= nil;

	//NSLog(@"url query = %@", [request urlQuery]);
	// must be done outside transaction below.
	custId = [NSString stringWithFormat:@"%d",[_custUID nextId]];
	[_context beginTransaction];
	submitValue = [[request urlQuery] objectForKey:@"submit"];
	if ([submitValue compare:@"Enter"] == NSOrderedSame) {
		// create a new customer object based on the data in the urlquery.
		customer = [[[EOGenericRecord alloc] initWithPrimaryKey:nil
						entity:_customerEntity] autorelease];
		row = [_customerEntity rowWithSubsetOfDictionary:[request urlQuery]];
		[customer takeValuesFromDictionary:row];
		[customer setObject:custId forKey:@"custId"];
		NSLog (@"customer = %@\n", customer);
		// insert this object into the db.
		success = [_custDS insertObject:customer];
		if (success == NO) {
			// return an insert error.
			errorStr = [NSString stringWithFormat:
					@"Unable to insert new customer entry %@ into database.",
						[customer objectForKey:@"custId"]];
			return [self _rollbackAndSendErrorMsg:errorStr];
		}
		// inserted ok, commit the transaction.
		success = [_context commitTransaction];
		if (success == NO) {
			// error committing database.
			errorStr = [NSString stringWithFormat:
				@"There was a database error committing the insertion of new customer entry %@.",
				[customer objectForKey:@"custId"]];
			return [self _rollbackAndSendErrorMsg:errorStr];
		}
		// everything OK.
		rebind = NO;

	}
	// ***********************************************************************************
	// ***********************************************************************************

	page = [FBNPage pageWithResource:@"custDataEntry" ofType:@"html"];
	msgStr = [NSMutableString stringWithFormat:
		@"The previous operation on customer number %@ succeeded.",
		[customer objectForKey:@"custId"]];
	[page bindValue:msgStr forAnchorWithName:@"prevSuccess"];

	// additionally rebind all values in customer in
	// the form if it makes sense according to which operation we did above.
	if (rebind == YES) {
		valuesDict = [customer valuesForKeys:[_customerEntity classPropertyNames]];
		[page bindValues:valuesDict forFormWithAction:@"doCustomerDataEntry"];
		// rebind test - this puts <null> in page.
		//[page bindValue:[valuesDict objectForKey:@"password"] forAnchorWithName:@"prevInsertSuccess"];
	}
	return [WWResponse responseWithPage:page];
}








- (WWResponse *)doPackageDataEntry:(WWRequest *)request
	/*" Take the input from the package data entry form and enter it 
	into the flybynight
	database.  Database state should already be established.
	NOTE: do this entire method in one transaction to guarantee
	referentail integrity between what we first read and then
	what we write.
	"*/
{
	EOGenericRecord*		package;
	NSDictionary			*row		= nil;
	NSMutableDictionary		*newRow		= nil;
	BOOL					success;
	WWPage*					page;
	NSMutableString*		msgStr;
	NSDictionary*			urlQuery;
	id						custId;		// will be sent 'description'
	//EOAdaptor*			adaptor;
	EOAttribute*			custIdAtt;
	EOQualifier*			qualifier;
	NSArray*				resultSet;
	NSString*				errorStr;
	NSString				*packId			= nil;

	packId = [NSString stringWithFormat:@"%d",[_packUID nextId]];
	[_context beginTransaction];
	// verify there is 1 row for this customer.
	// get the customer id from the request.
	urlQuery = [request urlQuery];
	custId = [urlQuery objectForKey:@"custId"];
	if (!custId) {
		// they didn't enter the custid field.  return error
		return [self _rollbackAndSendErrorMsg:
			@"You failed to enter the customer ID, this field is required."];
	}

	// retrieve from the CUSTOMER entity all the rows with this
	// custid (just 1).
	//
	// the value is in the format typed in by the user, NOT necessarily the format
	// that the database needs, the adaptor can change this for us
	//adaptor = [_custDS adaptor];
	custIdAtt = [_customerEntity attributeNamed:@"custId"];
	//custId = [adaptor formatValue:custId forAttribute:custIdAtt];
	// fetch the row(s) from the db for this custid.
	qualifier = [[[EOQualifier alloc] initWithEntity:_customerEntity
					qualifierFormat:@"%@ = %@", custIdAtt, custId] autorelease];
	[_custDS setQualifier:qualifier];
	resultSet = [_custDS fetchObjects];
	if ([resultSet count] != 1) {
		// error. either no records were found, or multiple records were found.
		// get the error page and bind into it the number of
		// records actually fetched, and return that.
		errorStr = [NSString stringWithFormat:
			@"There should have been only 1 customer with customer ID %@, there were actually %d.",	
			custId, [resultSet count]];
		return [self _rollbackAndSendErrorMsg:errorStr];
	}
	// there was only 1 row in the db for this customer, thats good. continue.
	// get the data from the query

	// insert it into the db
	package = [[[EOGenericRecord alloc] initWithPrimaryKey:nil
					entity:_packageEntity] autorelease];

	row = [_packageEntity rowWithSubsetOfDictionary:[request urlQuery]];
	[package takeValuesFromDictionary:row];
	[package setObject:packId forKey:@"packId"];
	success = [_packDS insertObject:package];
	//NSLog(@"package insertion success is [%d].\n",success);
	if (success == NO) {
		// the insert failed, there's no good reason for this, so 
		// return an error.
		return [self _rollbackAndSendErrorMsg:
			@"There was an error inserting the new package entry into the database."];
	}
	[_context commitTransaction];
	// return the same page, with pre-bound values.
	page = [FBNPage pageWithResource:@"packDataEntry" ofType:@"html"];
	msgStr = [NSMutableString stringWithFormat:
		@"The previous insertion of package number %@ succeeded.",
		[package objectForKey:@"packId"]];
	[page bindValue:msgStr forAnchorWithName:@"prevInsertSuccess"];
	newRow = [[[NSMutableDictionary alloc] initWithDictionary:row] autorelease];
	[newRow removeObjectForKey:@"custId"];	// will bind with slist, otherwise becomes hidden field.
	[page bindValues:newRow forFormWithAction:@"doPackageDataEntry"];
	[page bindValue:[self _customerSList] forAnchorWithName:@"customer_select_list"];

	return [WWResponse responseWithPage:page];
}

- (WWResponse *)sendPackageDetailPage:(WWRequest *)request
	/*" Given a request that represents a URL with the package id
	embedded in it, return a page with detailed information about that
	package.  load the template page and replace the named anchors in 
	it with the data values we pull from the database.
	"*/
{
	id					packId;		// will be sent 'description'
	NSDictionary*		urlQuery;
	//EOAdaptor*			adaptor;
	EOAttribute*		packIdAtt;
	EOQualifier*		qualifier;
	NSArray*			resultSet;
	int					resultSetCount;
	WWPage*				page;	// used to store different pages for returning.


	// get the package id out of the request.
	urlQuery = [request urlQuery];
	packId = [urlQuery objectForKey:@"packId"];
	if (!packId) {
		// return an error page for a malformed url.  
		// like the URL they entered does not have the query part, but does have
		// the part that causes this method to be called. for now, just return
		// the server error page, which isn't really accurate.
		return [WWResponse responseWithServerError];
	}
	// the value is in the format typed in by the user, NOT necessarily the format
	// that the database needs, the adaptor can change this for us
	//adaptor = [_custDS adaptor];
	packIdAtt = [_packageEntity attributeNamed:@"packId"];
	//packId = [adaptor formatValue:packId forAttribute:packIdAtt];

	// fetch the ONE row from the db for this packid.
	qualifier = [[[EOQualifier alloc] initWithEntity:_packageEntity
					qualifierFormat:@"%@ = %@", packIdAtt, packId] autorelease];
	[_packDS setQualifier:qualifier];
	resultSet = [_packDS fetchObjects];
	resultSetCount = [resultSet count];
	if (resultSetCount > 1) {
		// we got back more than 1 row, but this is supposed to be a unique
		// key so the referential integrity of the db has been compromised.
		//  - probably shouldn't return from the middle of this
		//	method.
		return [self sendErrorMsg:@"There was an error finding your request in the database.  Multiple rows were returned when only one was expected."];
	} else if (resultSetCount < 1) {
		// we got back like no rows... cool..
		// - also probably shouldn't return from middle of method.
		return [self sendErrorMsg:@"There were no packages matching the specified id in our database."];
	}
	// must have gotton exactly 1 row - thats right.
	// bind those values into the template "package detail" page.
	//	we do this by first instantiating a page object that represents this
	//	page, then getting the only EOGenericRecord out of the resultset and
	//	and asking it for a dictionary of key value pairs (valuesforkeys) which
	//	you have to pass in an array of nsstrings, each containing the name
	//	of a key.  we get that from the _packageentity.
	page = [FBNPage pageWithResource:@"packageDetail" ofType:@"html"];
    [page bindAnchorValues:[[resultSet objectAtIndex:0] 
							valuesForKeys:[_packageEntity classPropertyNames]]];

	// return that page.
	return [WWResponse responseWithPage:page];
}






- (WWResponse *)sendCustomerDetailPage:(WWRequest *)request
	/*" send the customer detail page.  shows detailed customer information
	for a specific customer and a list of links, one for each package this
	customer has in the database.  these links go to the same type of page
	that the sendPackageDetailPage: method returns.
	NOTE: transaction control: we only have 1 database access command,
	fetch, in this method so there is no need to manually begin or commit
	a transaction, it will be handled automatically by eof.
	"*/
{
	NSDictionary*		urlQuery;
	id					custId;			// will be sent 'description'
	//EOAdaptor*		adaptor;
	EOAttribute*		custIdAtt;
	EOQualifier*		qualifier;
	NSArray*			resultSet;
	int					resultSetCount;
	id					table; 			// Page will be asked to bind to this.
	WWPage*				page; 			// returned correctly bound page.
	EOAttributeOrdering *packIdOrd		= nil;
	NSArray*			ordArray		= nil;


	// get the customer id from the request.
	urlQuery = [request urlQuery];
	custId = [urlQuery objectForKey:@"custId"];
	if (!custId) {
		// return an error page for a malformed url.  
		// like the URL they entered does not have the query part, but does have
		// the part that causes this method to be called. for now, just return
		// the server error page, which isn't really accurate.
		return [WWResponse responseWithServerError];
	}

	// retrieve from the PACKAGE entity all the rows with this
	// custid.  these rows include a flattened attribute for 
	// the customer's name, which is the only other piece of
	// useful info we want from the customer table, so we won't 
	// explicitly go there at all.
	//
	// the value is in the format typed in by the user, NOT necessarily the format
	// that the database needs, the adaptor can change this for us
	//adaptor = [_custDS adaptor];
	custIdAtt = [_packageEntity attributeNamed:@"custId"];
	//custId = [adaptor formatValue:custId forAttribute:custIdAtt];
	// fetch the row(s) from the db for this custid... note: use the 
	//		PACKAGE entity.
	qualifier = [[[EOQualifier alloc] initWithEntity:_packageEntity
					qualifierFormat:@"%@ = %@", custIdAtt, custId] autorelease];
	// set a fetchorder to order the resultset appropriately.
	packIdOrd = [EOAttributeOrdering
				attributeOrderingWithAttribute:[_packageEntity attributeNamed:@"packId"]
				ordering:EOAscendingOrder];
	ordArray = [NSArray arrayWithObjects:packIdOrd, nil];
	[_packDS setFetchOrder:ordArray];
	[_packDS setQualifier:qualifier];
	resultSet = [_packDS fetchObjects];
	[_packDS setFetchOrder:nil];
	resultSetCount = [resultSet count];
	if (resultSetCount == 0) {
		// we got back like NO rows... cool..
		return [self sendErrorMsg:@"There were no matches found in our database for the cutomer id specified, or the customer specified had no packages in transit."];
	}
	// must have more than 0 rows (negative count is absurd)
	// create a table object, and set it up with this data.
	table = [[[WWTable alloc] init] autorelease];
	[table addColumn:@"Package ID" key:@"packId" width:15];
	[table addColumn:@"Description" key:@"detail" width:60];
	[table linkToURL:@"packageDetail" key:@"packId"];
	[table setObjects:resultSet];

	// bind this table and the customer info into the "customer detail" page
    page = [FBNPage pageWithResource:@"customerDetail" ofType:@"html"];
	[page	bindValue:[[resultSet objectAtIndex:0] objectForKey:@"custId"]
			forAnchorWithName:@"custId"];
	[page	bindValue:[[resultSet objectAtIndex:0] objectForKey:@"joinedCustName"]
			forAnchorWithName:@"joinedCustName"];
	[page	bindValue:table forAnchorWithName:@"PackagesTable"];

	//return the page.
	return [WWResponse responseWithPage:page];
}


- (WWResponse *)sendAllCustomersListPage:(WWRequest *)request
	/*" send the page that shows a list of all customers currently in the
	database as links to the customer detail page.  No query info in
	the request.
	NOTE: transaction control: we start and commit our own transaction.
	"*/
{
	EOQualifier*			qualifier;
	NSArray*				resultSet;
	int						resultSetCount;
	id						table; // Page will be asked to bind to this.
	WWPage*					page; // returned correctly bound page.
	NSMutableString*		countStr;
	EOAttributeOrdering*	custIdOrd		= nil;



	// get all customers as eogeneric-record objects from db.
	[_context beginTransaction];
	qualifier = [[[EOQualifier alloc] initWithEntity:_customerEntity
					qualifierFormat:nil] autorelease];
	custIdOrd = [EOAttributeOrdering
				attributeOrderingWithAttribute:[_customerEntity attributeNamed:@"custId"]
				ordering:EOAscendingOrder];
	[_custDS setFetchOrder:[NSArray arrayWithObjects:custIdOrd, nil]];
	[_custDS setQualifier:qualifier];
	resultSet = [_custDS fetchObjects];
	[_context commitTransaction];
	[_custDS setFetchOrder:nil];
	resultSetCount = [resultSet count];
	//NSLog(@"Result set count in sendAllCustomersListPage is [%d].\n",resultSetCount);
	if (resultSetCount == 0) {
		// we got back like NO rows... cool..
		return [self sendErrorMsg:@"There are currently no customers in our database."];
	}

	// create and initialize a wwtable for the info we want to display.
	//		must have more than 0 rows here (negative count is absurd)
	//		create a table object, and set it up with this data.
	table = [[[WWTable alloc] init] autorelease];
	[table addColumn:@"Customer ID" key:@"custId" width:15];
	[table addColumn:@"Name" key:@"name" width:75];
	[table linkToURL:@"customerDetail" key:@"custId"];
	[table setObjects:resultSet];

	// bind the table into the page and return it.
    page = [FBNPage pageWithResource:@"allCustomersList" ofType:@"html"];
	[page bindValue:table forAnchorWithName:@"AllCustomersTable"];
	countStr = [NSMutableString stringWithFormat:@"%d",resultSetCount];
	[page bindValue:countStr forAnchorWithName:@"customersCount"];
	return [WWResponse responseWithPage:page];
}

	/** 
	** General use methods
	**/

- (WWResponse *)sendErrorMsg:(NSString *)errorMsg
	/*" Binds the errorMsg to the errorMsg anchor in the html file: 
	ERROR_PAGE, and returns the newly formed page. "*/
{
	WWPage	*page 		= nil;
	
	if (!errorMsg) 
		errorMsg = @"An error occured on the WebRex server.";
	page = [FBNPage pageWithResource:ERROR_PAGE ofType:HTML_TYPE];
	[page bindValue:errorMsg forAnchorWithName:@"errorMsg"];
	return [WWResponse responseWithPage:page];
}

- (WWResponse *)_rollbackAndSendErrorMsg:(NSString *)errorMsg
{
	[_context rollbackTransaction];
	return [self sendErrorMsg:errorMsg];
}


@end


@implementation EOEntity (flybynight_stuff)

- (NSDictionary *)rowWithSubsetOfDictionary:(NSDictionary *)dict
	/*" This takes a dictionary of stuff and extracts the parts 
		appropriate to this entity and converts the values to the proper model types.
	"*/
{
	int i, count;
	id value;
	NSString *name;
	NSMutableDictionary *row;
	NSArray *attributes;
	EOAttribute *attribute;

	row = [[[NSMutableDictionary alloc] init] autorelease];
	attributes = [self attributes];
	count = [attributes count];

	for (i = 0; i < count; i++) {
		attribute = [attributes objectAtIndex:i];
		name = [attribute name];
		value = [dict objectForKey:name];
		if (!value)
			continue;

		value = [self convertValue:value attribute:attribute];
		if (!value)
			continue;
		
		[row setObject:value forKey:name];
	}
	return row;
}


@end





@implementation FBNTopController (GeneralUse)
- (WWSelectList *)selectListWithName:(NSString *)name
							 options:(NSArray *)options
							  values:(NSArray *)values
					   forDataSource:(EODatabaseDataSource *)dataSource
							  entity:(EOEntity *)entity
	/*" Returns a select list for use in an html page.  The select list is 
	  filled with all of the objects returned by a fetch on the dataSource
	  with an open qualifier on the entity.  The options and values are
	  used to determine which properties of the objects retrieved from the 
	  datasource are displayed in the select list, and which are used for 
	  values.  If the number of objects retrieved for values and options
	  are not equal, then the values are not used.
	  "*/
{
	EOQualifier			*q				= nil;
	NSArray				*objectArray	= nil;

	if (entity && dataSource) {
		q = [[[EOQualifier alloc] initWithEntity:entity qualifierFormat:nil]
				 autorelease];
		if (q) {
			[dataSource setQualifier:q];
			objectArray = [dataSource fetchObjects];

			return [self selectListWithName:name options:options values:values
						 forObjects:objectArray];
		}
	}

	return nil;
}

- (WWSelectList *)selectListWithName:(NSString *)name
							 options:(NSArray *)options
							  values:(NSArray *)values
					   forDataSource:(EODatabaseDataSource *)dataSource
							  entity:(EOEntity *)entity
							fetchOrder:(NSArray *)fetchOrder
	/*" Duplicates above method except uses fetchOrder in query.  After 
	objects are fetched, fetchorder in datasource is set to whatever
	it was before this method was invoked.
	"*/
{
	EOQualifier			*q				= nil;
	NSArray				*objectArray	= nil;
	NSArray				*oldFetchOrder	= nil;

	if (entity && dataSource) {
		q = [[[EOQualifier alloc] initWithEntity:entity qualifierFormat:nil]
				 autorelease];
		if (q) {
			oldFetchOrder = [dataSource fetchOrder];
			[dataSource setQualifier:q];
			[dataSource setFetchOrder:fetchOrder];
			objectArray = [dataSource fetchObjects];
			[dataSource setFetchOrder:oldFetchOrder];

			return [self selectListWithName:name options:options values:values
						 forObjects:objectArray];
		}
	}

	return nil;
}

- (WWSelectList *)selectListWithName:(NSString *)name
							 options:(NSArray *)options
							  values:(NSArray *)values
						  forObjects:(NSArray *)objects
	/*" Returns a select list for use in an html page.  The select list is 
	  filled with strings representing columns specified for the options and 
	  values for each object in the array objects.  The options and values are
	  used to determine which properties of the objects are displayed in the 
	  select list, and which are used for values.  If the number of string
	  objects corresponding for values and options are not equal, then the 
	  values are not used.
	  "*/
{
	WWSelectList		*selectList		= nil;
	NSArray				*optionStrings	= nil;
	NSArray				*valueStrings	= nil;

	if (!(objects && [objects count])) 
		return nil;

	optionStrings = [self stringArrayWithColumns:options 
						  fromObjects:objects useParens:YES];
	valueStrings = [self stringArrayWithColumns:values 
						 fromObjects:objects useParens:NO];

	// build the select list with the name strings and values
	selectList = [[WWSelectList alloc] autorelease]; 
	[selectList initWithName:name];
	if ([optionStrings count] == [valueStrings count])
		[selectList setOptions:optionStrings values:valueStrings];
	else
		[selectList setOptions:optionStrings values:nil];
	[selectList setUsesSeparateInputs:NO];
	[selectList setAllowsMultipleSelection:NO];

	return selectList;
}

- (NSArray *)stringArrayWithColumns:(NSArray *)columns 
						fromObjects:(NSArray *)objects
						  useParens:(BOOL)useParens
	/*" Produces an array of strings based on the columns and enterprise 
	  objects passed to this method.  The values for each of the columns 
	  are concatenated into a space separated string for every object in the 
	  objects array.  The strings are built into an array and returned.  If 
	  useParens is YES, the strings are enclosed in parentheses.
	  "*/
{
	NSMutableArray		*stringArray	= nil;
	NSMutableString		*string			= nil;
	NSEnumerator		*objectEnum		= nil;
	NSEnumerator		*columnEnum		= nil;
	NSObject			*object			= nil;
	NSString			*column			= nil;
	NSString			*value			= nil;
	NSDictionary		*valueDict		= nil;
	NSString			*formatStr		= nil;

	objectEnum = [objects objectEnumerator];

	if (objectEnum && [objects count]) {
		stringArray = [NSMutableArray array];
		if (useParens)
			formatStr = @"(%@)";
		else 
			formatStr = @"%@";
	}
	while (object = (NSObject *)[objectEnum nextObject]) {
		valueDict = [object valuesForKeys:columns];
		columnEnum = [columns objectEnumerator];

		while (column = (NSString *)[columnEnum nextObject]) {
			if (!string) {
				string = [[[NSMutableString alloc] initWithCapacity:16]
							  autorelease];
			} else {
				[string appendString:@" "];
			}
			value = [valueDict objectForKey:column];

			if (value)
				[string appendFormat:formatStr, value];
			else 
				[string appendFormat:formatStr, @"-"];
		}
		[stringArray addObject:string];
		string = nil;
	}

	return stringArray;
}

@end




















/* code taken out of customer data entry to support additional buttons
	on the form for searching, modifying and deleting customers.  it was 
	too hairy up there, so i took it out until we support these features 
	again. - trieger
	
	
	EOQualifier*			qualifier;
	EOAttribute*			custIdAtt;
	NSArray*				resultSet;
	NSString*				custIdValue;

	
	else if ([submitValue compare:@"Search"] == NSOrderedSame) {
		// clear every qualifier except the custid and look for
		// exactly 1 row in the db

		custIdAtt = [_customerEntity attributeNamed:@"custId"];
		custIdValue = [[request urlQuery] objectForKey:@"custId"];
		qualifier = [[[EOQualifier alloc] initWithEntity:_customerEntity
						qualifierFormat:@"%@ = %@", custIdAtt, custIdValue] autorelease];
		[_custDS setQualifier:qualifier];
		resultSet = [_custDS fetchObjects];
		if ([resultSet count] != 1) {
			// error. either no records were found, or multiple records were found.
			// get the error page and bind into it the number of
			// records actually fetched, and return that.
			errorStr = [NSString stringWithFormat:@"There should have been only 1 customer with customer ID %@, there were actually %d.", custIdValue, [resultSet count]];
			return [self _rollbackAndSendErrorMsg:errorStr];
		}
		// only got 1 object back, that's correct.
		// the previous customer object has been autoreleased, so i THINK if i
		// were to just re-set the ivar "customer", the old object would only be
		// leaked until the pool is released.
		customer = [resultSet objectAtIndex:0];	// will be bound into return page.
		rebind = YES;
		success = YES;
	} else if ([submitValue compare:@"Modify"] == NSOrderedSame) {
		// assume that the custid field identifies the record that
		// is to be changed.  

		// fetch that object from the db
		custIdAtt = [_customerEntity attributeNamed:@"custId"];
		custIdValue = [[request urlQuery] objectForKey:@"custId"];
		qualifier = [[[EOQualifier alloc] initWithEntity:_customerEntity
						qualifierFormat:@"%@ = %@", custIdAtt, custIdValue] autorelease];
		[_custDS setQualifier:qualifier];
		resultSet = [_custDS fetchObjects];
		if ([resultSet count] != 1) {
			// error. either no records were found, or multiple records were found.
			// get the error page and bind into it the number of
			// records actually fetched, and return that.
			errorStr = [NSString stringWithFormat:@"There should have been only 1 customer with customer ID %@, there were actually %d.", custIdValue, [resultSet count]];
			return [self _rollbackAndSendErrorMsg:errorStr];
		}
		customer = [resultSet objectAtIndex:0];

		// change its values based on the url query (could even change unique key)
		row = [_customerEntity rowWithSubsetOfDictionary:[request urlQuery]];
		[customer takeValuesFromDictionary:row];

		// update db.
		success = [_custDS updateObject:customer];
		if (success == NO) {
			// error updating database.
			errorStr = [NSString stringWithFormat:@"There was a database error updating Customer %@.",	[customer objectForKey:@"custId"]];
			return [self _rollbackAndSendErrorMsg:errorStr];
		}

		// update OK, now commit.
		success = [_custDS saveObjects];
		if (success == NO) {
			// error committing database.
			errorStr = [NSString stringWithFormat:@"There was a database error committing the changes to Customer %@.", [customer objectForKey:@"custId"]];
			return [self _rollbackAndSendErrorMsg:errorStr];
		}

		// everything OK.
		rebind = YES;

	} else if ([submitValue compare:@"Delete"] == NSOrderedSame) {
		// assume the custID field identifies this object.
		// assume the database implements referential integrity.


		// fetch it (only one) from the db.
		custIdAtt = [_customerEntity attributeNamed:@"custId"];
		custIdValue = [[request urlQuery] objectForKey:@"custId"];
		qualifier = [[[EOQualifier alloc] initWithEntity:_customerEntity
						qualifierFormat:@"%@ = %@", custIdAtt, custIdValue] autorelease];
		[_custDS setQualifier:qualifier];
		resultSet = [_custDS fetchObjects];
		if ([resultSet count] != 1) {
			// error. either no records were found, or multiple records were found.
			// get the error page and bind into it the number of
			// records actually fetched, and return that.
			errorStr = [NSString stringWithFormat:@"There should have been only 1 customer with customer ID %@, there were actually %d.", custIdValue, [resultSet count]];
			return [self _rollbackAndSendErrorMsg:errorStr];
		}
		customer = [resultSet objectAtIndex:0];

		// delete it.
		success = [_custDS deleteObject:customer];
		if (success == NO) {
			// error committing database.
			errorStr = [NSString stringWithFormat:@"There was a database error deleting Customer %@.",	[customer objectForKey:@"custId"]];
			return [self _rollbackAndSendErrorMsg:errorStr];
		}

		// commit that operation.
		success = [_custDS saveObjects];
		if (success == NO) {
			// error committing database.
			errorStr = [NSString stringWithFormat:@"There was a database error committing the deletion of Customer %@.", [customer objectForKey:@"custId"]];
			return [self _rollbackAndSendErrorMsg:errorStr];
		}
	}

*/
