// Copyright (c) 1995-1996, Information Technology Solutions. 
//  All rights reserved.

#import <eoaccess/eoaccess.h>

#import <foundation/NSString.h>
#import <foundation/NSDictionary.h>
#import <foundation/NSArray.h>
#import <foundation/NSData.h>
#import "webrex_access.h"

#import "UniqueId.h"
#import "ITSFoundationKit.subproj/ITSSharedChannel.h"


@interface FBNTopController:WWApplet
{
    EODatabaseDataSource	*_custDS;
    EODatabaseDataSource	*_packDS;
	EOEntity				*_customerEntity;
	EOEntity				*_packageEntity;
    EODatabaseContext 		*_context;
    NSMutableDictionary 	*_cache;
	UniqueId				*_custUID;
	UniqueId				*_packUID;
	ITSSharedChannel		*_anITSSC;
}

- initWithServer:(WWServer *)server baseLocator:(NSString *)locator;
- realInitWithServer:(WWServer *)server baseLocator:(NSString *)locator;
- (void)dealloc;

- (WWResponse *)responseForRequest:(WWRequest *)request;
- (WWResponse *)sendMainPage:(WWRequest *)request;
- (WWResponse *)sendInfoPage:(WWRequest *)request;
	// show and do customer data entry
- (WWResponse *)showCustDataEntryPage:(WWRequest *)request;
- (WWResponse *)showTrackPackagesPage:(WWRequest *)request;
- (WWResponse *)doCustomerDataEntry:(WWRequest *)request;
	// show and do package data entry
- (WWResponse *)showPackDataEntryPage:(WWRequest *)request;
- (WWResponse *)doPackageDataEntry:(WWRequest *)request;
- (WWSelectList *)_customerSList;

- (WWResponse *)sendPackageDetailPage:(WWRequest *)request;
- (WWResponse *)sendCustomerDetailPage:(WWRequest *)request;
- (WWResponse *)sendAllCustomersListPage:(WWRequest *)request;

- (WWResponse *)sendErrorMsg:(NSString *)errorMsg;
- (WWResponse *)_rollbackAndSendErrorMsg:(NSString *)errorMsg;

@end

@interface EOEntity (flybynight_stuff)
- (NSDictionary *)rowWithSubsetOfDictionary:(NSDictionary *)dict;
@end

@interface EOEntity (flybynight_usePrivateMethods)
- convertValue:value attribute:(EOAttribute *)attribute;
	// This is a private method in EOF.  It takes a value and converts it to
	// the type for that attribute in the model.  EODatabaseDataSouce uses
	// this method to implement coerseValue:forKey:.
@end


