#import <appkit/appkit.h>
#import "SLogListener.h"
#import <mach/mach.h>
#import <mach/message.h>
#import <servers/netname.h>
extern port_t name_server_port;
extern id NXResponsibleDelegate();
@implementation  SLogListener :Listener
{}
static NXRemoteMethod *remoteMethods = NULL;
#define REMOTEMETHODS 6
+ initialize 
/* */
{
    if (!remoteMethods) {
	remoteMethods =
	(NXRemoteMethod *) malloc((REMOTEMETHODS+1)*sizeof(NXRemoteMethod));
	remoteMethods[0].key = 
	@selector(login:ownerships:utmp:wtmp:lastlog:);
	remoteMethods[0].types = "ciiii";
	remoteMethods[1].key = 
	@selector(login:ownerships:utmp:);
	remoteMethods[1].types = "cii";
	remoteMethods[2].key = 
	@selector(logout:ownerships:utmp:wtmp:lastlog:);
	remoteMethods[2].types = "ciiii";
	remoteMethods[3].key = 
	@selector(logout:ownerships:utmp:);
	remoteMethods[3].types = "cii";
	remoteMethods[4].key = 
	@selector(login:ownerships:utmp:ok:);
	remoteMethods[4].types = "ciiI";
	remoteMethods[5].key = 
	@selector(exit);
	remoteMethods[5].types = "";
	remoteMethods[REMOTEMETHODS].key = NULL;
    }
    return self;
}
-(int)login : (char *) pty
	ownerships : (int) oFlag
	utmp : (int) uFlag
	wtmp : (int) wFlag
	lastlog : (int) lFlag
/* */
{
    id _NXd;
    if (_NXd = NXResponsibleDelegate(self,
	@selector(login:ownerships:utmp:wtmp:lastlog:)))
	return [_NXd login : pty
		ownerships : oFlag
		utmp : uFlag
		wtmp : wFlag
		lastlog : lFlag];
    return -1;
}

-(int)login : (char *) pty
	ownerships : (int) oFlag
	utmp : (int) uFlag
/* */
{
    id _NXd;
    if (_NXd = NXResponsibleDelegate(self,
	@selector(login:ownerships:utmp:)))
	return [_NXd login : pty
		ownerships : oFlag
		utmp : uFlag];
    return -1;
}

-(int)logout : (char *) pty
	ownerships : (int) oFlag
	utmp : (int) uFlag
	wtmp : (int) wFlag
	lastlog : (int) lFlag
/* */
{
    id _NXd;
    if (_NXd = NXResponsibleDelegate(self,
	@selector(logout:ownerships:utmp:wtmp:lastlog:)))
	return [_NXd logout : pty
		ownerships : oFlag
		utmp : uFlag
		wtmp : wFlag
		lastlog : lFlag];
    return -1;
}

-(int)logout : (char *) pty
	ownerships : (int) oFlag
	utmp : (int) uFlag
/* */
{
    id _NXd;
    if (_NXd = NXResponsibleDelegate(self,
	@selector(logout:ownerships:utmp:)))
	return [_NXd logout : pty
		ownerships : oFlag
		utmp : uFlag];
    return -1;
}

-(int)login : (char *) pty
	ownerships : (int) oFlag
	utmp : (int) uFlag
	ok : (int *) okFlag
/* */
{
    id _NXd;
    if (_NXd = NXResponsibleDelegate(self,
	@selector(login:ownerships:utmp:ok:)))
	return [_NXd login : pty
		ownerships : oFlag
		utmp : uFlag
		ok : okFlag];
    return -1;
}

-(int)exit
/* */
{
    id _NXd;
    if (_NXd = NXResponsibleDelegate(self,
	@selector(exit)))
	return [_NXd exit];
    return -1;
}

- (int) performRemoteMethod : (NXRemoteMethod *) method
                  paramList : (NXParamValue *) paramList {
/* */
    switch (method - remoteMethods) {
    case 0:
	return [self login : paramList[0].bval.p
		ownerships : paramList[1].ival
		utmp : paramList[2].ival
		wtmp : paramList[3].ival
		lastlog : paramList[4].ival];
    case 1:
	return [self login : paramList[0].bval.p
		ownerships : paramList[1].ival
		utmp : paramList[2].ival];
    case 2:
	return [self logout : paramList[0].bval.p
		ownerships : paramList[1].ival
		utmp : paramList[2].ival
		wtmp : paramList[3].ival
		lastlog : paramList[4].ival];
    case 3:
	return [self logout : paramList[0].bval.p
		ownerships : paramList[1].ival
		utmp : paramList[2].ival];
    case 4:
	return [self login : paramList[0].bval.p
		ownerships : paramList[1].ival
		utmp : paramList[2].ival
		ok : &paramList[3].ival];
    case 5:
	return [self exit];
    default:
	return [super performRemoteMethod : method paramList : paramList];
    }
}
- (NXRemoteMethod *) remoteMethodFor: (SEL) aSel {
/* */
    NXRemoteMethod *rm;
    if (rm = NXRemoteMethodFromSel(aSel,remoteMethods))
        return rm;
    return [super remoteMethodFor : aSel];
}
@end
