/* Copyright (c) 1992, Scott Hess.  No rights reserved.  No
 * warranty is provided for this software, neither explicit nor
 * implied.  The source and object code for this file may be used
 * and modified as the user sees fit.
 */
#import <stdio.h>
#import <libc.h>

static inline void putQuoted( unsigned int c)
{
    switch( c) {
	case '\a' :	printf( "\\\a");	break;
	case '\b' :	printf( "\\\b");	break;
	case '\f' :	printf( "\\\f");	break;
	case '\n' :	printf( "\\\n");	break;
	case '\r' :	printf( "\\\r");	break;
	case '\t' :	printf( "\\\t");	break;
	case '\v' :	printf( "\\\v");	break;
	case '\"' :	printf( "\\\"");	break;
	case '\\' :	printf( "\\\\");	break;
	default :
	    if( c<' ') {
		printf( "\\x%02x", c);
	    } else {
		putchar( c);
	    }
    }
}
void main( int argc, char *argv[])
{
    extern char **environ;
    int i;
    char *s;
    if( argc==2) {
	if( !freopen( argv[ 1], "w", stdout)) {
	    fprintf( stderr, "Unable to open %s\n", argv[ 1]);
	    exit( 1);
	}
    } else if( argc>2) {
	fprintf( stderr,
	    "Usage:  wenv [outfile]\n\n"
	    "Writes environment to a file suitable for use by Stuart's\n"
	    "EnvironFile default.\n");
	exit( 1);
    }
    printf( "argc==%d\n", argc);
    for( i=0; environ[ i]; i++) {
	putchar( '\"');
	for( s=environ[ i]; *s && *s!='='; s++) {
	    putQuoted( *s);
	}
	if( *s=='=') {
	    printf( "\" = \"");
	    for( s++; *s; s++) {
		putQuoted( *s);
	    }
	}
	printf( "\";\n");
    }
}
