/* Copyright (c) 1990, 1992, Scott Hess.  No rights reserved.  No
 * warranty is provided for this software, neither explicit nor
 * implied.  The source and object code for this file may be used
 * and modified as the user sees fit.
 */
#import <libc.h>
#import <stdio.h>
#import <strings.h>
#import <appkit/appkit.h>
#import "StuartSpeaker.h"

void main(int argc, char *argv[])
{
    id stuart=[[StuartSpeaker alloc] init];
    const char *s=NXReadDefault( "Stuart", "Directory");
    int ret;
    if( s && *s=='.' && s[ 1]=='\0') {
	char buf[ 1024];
	[stuart default:"Directory" as:getwd( buf)];
    }
    s=getenv( "NXHOST");
    if( s && *s) {
	[stuart default:"NXHost" as:s];
    }
    if( argc==2 && !strcmp( argv[ 1], "-")) {
	ret=[stuart stuartConnectAndSend:0];
    } else {
	while( *++argv) {
	    if( **argv=='-') {
		if( argv[ 1] && *argv[ 1]!='-') {
		    [stuart default:(*argv)+1 as:argv[ 1]];
		    argv++;
		} else {
		    [stuart default:(*argv)+1 as:""];
		}
	    }
	}
	ret=[stuart stuartConnectAndNew];
    }
    if( ret) {
	fprintf( stderr, "Speak: Error connecting to Stuart\n");
    }
    stuart=[stuart free];
    exit(0);
}
