/* Copyright (c) 1990, 1992, Scott Hess.  No rights reserved.  No
 * warranty is provided for this software, neither explicit nor
 * implied.  The source and object code for this file may be used
 * and modified as the user sees fit.
 */
#import <appkit/Speaker.h>
#import <objc/NXStringTable.h>

@interface StuartSpeaker : Speaker
{
    NXStringTable *defaults;	/* The defaults for Stuart. */
}

- init;
- free;

/* These are my primitive functions.  Don't use them directly, I'd
 * say.
 */
-(int)_stuartNew:(char *)defs activate:(int)flag;
-(int)_stuartGet:(char **)defs;

/* These are for setting and getting the default values from the
 * local storage.
 */
-(const char *)default:(const char *)name;
-(int)defaultAsInt:(const char *)name;
-(float)defaultAsFloat:(const char *)name;
-(BOOL)defaultAsBOOL:(const char *)name;
- default:(const char *)name as:(const char *)value;
- default:(const char *)name asInt:(int)value;
- default:(const char *)name asFloat:(float)value;
- default:(const char *)name asBOOL:(BOOL)value;
- removeDefault:(const char *)name;

/* These communicate with Stuart. */
-(int)stuartNew;
-(int)stuartGet;
-(int)stuartSend:(int)fd;
-(int)stuartConnectAndNew;
-(int)stuartConnectAndGet;
-(int)stuartConnectAndSend:(int)fd;
@end
