INSTALLFLAGS	=	-c -s -m 755
INSTALLDIR	=	$(HOME)/Unix/bin

CFLAGS	=	-O -g -Wall
OFILES	=	$(CLASSES:.m=.o) $(MFILES:.m=.o) $(CFILES:.c=.o)
GARBAGE	=	obj $(OTHER_GARBAGE)
LIBS	=	-lNeXT_s -lsys_s
ODIR	=	obj
VPATH	=	$(ODIR)

$(NAME):	$(ODIR) $(OFILES)
	$(CC) $(CFLAGS) $(LDFLAGS) -o $(NAME) $(OFILES) $(LIBS)

obese::
	@$(MAKE) "CFLAGS = $(CFLAGS) -arch hppa -arch sparc -arch m68k -arch i386"

fat::
	@$(MAKE) "CFLAGS = $(CFLAGS) -arch m68k -arch i386"

sparc::
	@$(MAKE) "CFLAGS = $(CFLAGS) -arch sparc"

hppa::
	@$(MAKE) "CFLAGS = $(CFLAGS) -arch hppa"

intel::
	@$(MAKE) "CFLAGS = $(CFLAGS) -arch i386"

moto::
	@$(MAKE) "CFLAGS = $(CFLAGS) -arch m68k"

strip:		$(NAME)
	strip $(NAME)

clean::
	rm -rf $(GARBAGE) $(NAME)

cleanobj::
	rm -rf $(GARBAGE)

cleanbak::
	rm -f *~

install::	$(NAME) $(INSTALLDIR)
	install $(INSTALLFLAGS) $(NAME) $(INSTALLDIR)

.c.o:
	$(CC) $(CFLAGS) -c $*.c -o $(ODIR)/$*.o
.m.o:
	$(CC) $(CFLAGS) $(OBJCFLAGS) -c $*.m -o $(ODIR)/$*.o

$(ODIR):
	mkdirs $(ODIR)

$(INSTALLDIR):
	mkdirs $(INSTALLDIR)
