/* indent:4  tabsize:8  font:fixed-width */

/*---------------------------------------------------------------------------
|----------------------------------------------------------------------------
|
|    GameModule : NSObject
|
|    Abstract superclass.  Game modules (.solitaire) must have a controller
|    which is a subclass of GameModule.
|
|----------------------------------------------------------------------------
\---------------------------------------------------------------------------*/


#import <AppKit/AppKit.h>
//#import "GameModule.h"
//#import "Solitaire.h"
#import <Solitaire/CardSet.h>
#import <Solitaire/externs.h>

// Globals
//SOLFRAMEWORK_EXTERN id SolEngine(void);
//SOLFRAMEWORK_EXTERN void setSolEngine(id engine);
//SOLFRAMEWORK_EXTERN id SolGameController(void);

// Forward clss declarations
@class GamePref;


@interface GameModule : NSObject
{
    IBOutlet NSView*   	inspector;		/*" Our inspector view "*/
    IBOutlet NSWindow*	gameWindow;		/*" Active game window "*/
    IBOutlet GamePref*  prefs;			/*" Game's preference object "*/
    IBOutlet NSWindow*  rulesWindow;	/*" Window containing rules "*/

    NSBundle*  	bundle;			/*" Our bundle for this module "*/
    NSString*	gameName;       /*" The name of our game "*/
    NSString*	frameName;      /*" Frame save string for gameWindow. "*/
    
    CardSize	cardSize;		/*" Current size of the cards "*/
    BOOL		ignoreSizePref;	/*" TRUE if only one size of cards is "*/
								/*" available in this game "*/
    CardBack	cardBack;		/*" Pattern on card backs "*/
    NSColor*	desktopColor;	/*" Color of desktop "*/
}

/*" Initialization/deallocation "*/
- initFromBundle:(NSBundle*)aBundle withName:(NSString*)name;

/*" Our inspector "*/
- (NSView*) inspector:(id)sender;
- (void) inspectorWillBeRemoved;
- (void) inspectorInstalled;

/*" Showing rules "*/
- (void) showRules:(id)sender;

/*" Starting/stopping play "*/
- (void) startGame:(id)sender;
- (void) restartGame:(id)sender;
- (void) endGame:(id)sender;

/*" Win/lose actions "*/
- (void) win;
- (void) lose;

- (void) checkForWin;

/*" Setup "*/
- (BOOL) windowShouldClose:(id)sender;
- (NSString*) nibPathForCardSize:(CardSize)cardSize
                        realSize:(CardSize *)realSize;
- (void) loadGameWindow:(NSString*)path ofSize:(CardSize)size;

- (void) commonGameSetup;

@end

