/* indent:4  tabsize:8  font:fixed-width */


/*--------------------------------------------------------------------------
| --------------------------------------------------------------------------
|
|    CardPile:NSObject
|
|    Instances of this class provide low-level functionality for card 
|    games.  CardPiles contain an ordered list of cards which can be added 
|    to, removed from or shuffled by clients of the class.
|
| ----------------------------------------------------------------------------
\---------------------------------------------------------------------------*/

#import <AppKit/AppKit.h>
#import "card-defs.h"

#define    CS_BOTTOM        0
#define    CS_TOP           9999

@class Card;


@interface CardPile:NSObject
{
    NSMutableArray*	cards;		/*" Our cards. "*/
    CardSize    	cardSize;	/*" Our card size. "*/
}

/*" Class initialization "*/
+ (void) initialize;

/*" Initialization/deallocation "*/
- init;
- initForCardSize:(CardSize)aSize;
- (void) setCardSize:(CardSize)aSize;
- (CardSize) cardSize;
- (void) dealloc;

/*" Manipulating cards "*/
- (void) addCard:(Card*)aCard;
- (void) insertCard:(Card*)aCard at:(int)aPosition;
- (void) addPile:(CardPile*)aCardPile;
- (void) addCopyOfPile:(CardPile*)aCardPile;
- (void) insertCopyOfPile:(CardPile*)aCardPile at:(int)aPosition;
- (void) insertPile:(CardPile*)aCardPile at:(int)aPosition;
- (void) removeCard:(Card*)aCard;
- (Card*) cardAtIndex:(int)aPosition;
- (int) indexOfCard:(Card*)aCard;
- (Card*) topCard;
- (Card*) bottomCard;
- (Card*) dealTopCard;

/*" Manipulating the deck "*/
- (void) addDeck;
- (void) empty;
- (void) flip;
- (void) shuffle;
- (int) cardCount;

/*" Archiving "*/
- (id) initWithCoder:(NSCoder *)aDecoder;
- (void) encodeWithCoder:(NSCoder *)aCoder;

@end
