/* indent:4  tabsize:8  font:fixed-width */

/*---------------------------------------------------------------------------
|----------------------------------------------------------------------------
|
|    Card : NSObject
|
|    Instances of this class provide low-level functionality for card games.  
|    Cards can have a suit, a value, and an orientation.  These values can be
|    initialized, modified and determined by clients of the class.  Cards 	
|    also know how to render themselves on screen.
|
|----------------------------------------------------------------------------
\---------------------------------------------------------------------------*/

#import <AppKit/AppKit.h>
#import "card-defs.h"

@interface Card : NSObject
{
    CardSuit            suit;		/*" The card's suit. "*/
    CardValue           value;		/*" The card's value. "*/
    BOOL                faceUp;		/*" YES if the card is face up. "*/
}

/*" Initializing the class "*/
+ (void)initialize;
+ (void)drawCardImages;
+ (void)freeCardImages;
+ (void)setCardBackImage:(NSImage *)theImage;
+ (void)setCardBack:(CardBack)aBack;
+ (NSString *)stringForCardSuit:(CardSuit)aSuit;
+ (NSString *)stringForCardValue:(CardValue)aValue;
+ (NSString *)stringForCardColor:(CardColor)aColor;

/*" Creating and freeing "*/
- init;
- initSuit:(CardSuit)aSuit value:(CardValue)aValue;
- initSuit:(CardSuit)aSuit value:(CardValue)aValue faceUp:(BOOL)anOrientation;
- copyWithZone:(NSZone *)zone;

/*" Comparing cards "*/
-(BOOL) isEqual:(Card*)aCard;
-(BOOL) isOneLargerThan:(Card*)aCard wrap:(BOOL)flag;
-(BOOL) isOneSmallerThan:(Card*)aCard wrap:(BOOL)flag;

/*" Our state "*/
- (CardSuit)suit;
- (void)setSuit:(CardSuit)aSuit;
- (CardValue)value;
- (void)setValue:(CardValue)aValue;
- (void)setFaceUp:(BOOL)aSide;
- (BOOL)isFaceUp;
- (void)flip;
- (CardColor)cardColor;
- (NSString*)description;

/*" Drawing "*/
- (void)drawCardAt:(NSPoint)thePoint;
- (void)drawContentsAt:(NSPoint)thePoint;
- (void)drawOutlineAt:(NSPoint)thePoint;

/*" Archiving "*/
- (id)initWithCoder:(NSCoder *)aDecoder;
- (void)encodeWithCoder:(NSCoder *)aCoder;

@end
