#ifndef REGEXP_H__
#define REGEXP_H__

/*
 * Definitions etc. for regexp(3) routines.
 *
 * Caveat:  this is V8 regexp(3) [actually, a reimplementation thereof],
 * not the System V one.
 *
 * MODIFICATION NOTE -- this is a modified version
 * 
 * I hacked this to add the "regtest()" function, which behaves in the
 * same way as re_comp() in terms of returning the error. regerror()
 * was also hacked so as to record the error in a global variable, and
 * not call exit().
 *
 * I've also hacked it so that "#" will match [0-9], ie. a digit.
 * this makes my usage of this to be simpler. I've also added prototypes
 * in most places. I also added the #ifdef guard at the top of this file.
 *
 * - darcy <samurai@hasc.ca> Jan 19, 1995
 *
 */
#define NSUBEXP  10
typedef struct regexp {
	const char *startp[NSUBEXP];
	const char *endp[NSUBEXP];
	char regstart;		/* Internal use only. */
	char reganch;		/* Internal use only. */
	char *regmust;		/* Internal use only. */
	int regmlen;		/* Internal use only. */
	char program[1];	/* Unwarranted chumminess with compiler. */
} regexp;

/* the last error code - db */
extern char * regerrval;

/* call this to test a pattern. Reutns 0 if OK, an error string if not - db */
extern char * regtest(const char *exp);

extern int regexec(regexp *prog, const char *string);
extern regexp * regcomp(const char *exp);
extern void regdump(regexp *r);
extern void regsub();
extern void regerror();

#endif
