/* -*-C-*-
*******************************************************************************
*
* File:         mailtoc.h
* RCS:          /usr/local/sources/CVS/EnhanceMail/mailtoc.h,v 1.2 1997/04/19 17:37:23 tom Exp
* Description:  Structure and access routine declarations for Mail.app mailboxes
* Author:       Carl Edman
* Created:      Sun Apr 25 10:25:29 1993
* Modified:     Sat Apr 19 14:38:11 1997 Tom Hageman <tom@basil.icce.rug.nl>
* Language:     C
* Package:      N/A
* Status:       Experimental (Do Not Distribute)
*
* (C) Copyright 1993, but otherwise this file is perfect freeware.
*
*******************************************************************************
*/

#if (NS_TARGET_MAJOR < 4) // NEXTSTEP
#  import <appkit/graphics.h>
#else // OPENSTEP
#  import <Foundation/NSGeometry.h>
#  define NXCoord   float
#  define NXRect    NSRect
#endif

#import <stdio.h>

/* The following two structures have been stolen from Chris Paris excellent
   exposition of the NeXT mailbox format */

struct table_of_contents_header
{
   int magic;          /* magic number: 890712 */
   int num_msgs;       /* number of messages in mbox */
   time_t mbox_time;    /* the m_time of mbox */
   NXCoord list;        /* height of upper section of split view containing list */
   NXRect window;       /* Mail window */
};

struct message_index
{
   int record_length;  /* the length of this record, including this word */
   int mes_offset;     /* offset in mbox where this message begins */
   int mes_length;     /* length in bytes of this message in mbox */
   int mes_date;       /* the date of this message */
   char status;         /* read ' ' or '>', unread '*', deleted 'd' or 'D', flagged '+' */
   char msgtype;        /* regular ' ', NeXT mail 'r' or Mime Mail 'm' */
   char encrypted;      /* Is this message encrypted ? */
   char sync;           /* always ' ' */
   char data[0];
};

struct table_of_contents_header *get_table_of_contents_header(FILE *f,int createflag);
struct message_index *get_message_index(FILE *f);

char *message_from(const struct message_index *mi);
char *message_subject(const struct message_index *mi);
char *message_reference(const struct message_index *mi);

int message_attachsize(const struct message_index *mi);
time_t message_attachtime(const struct message_index *mi);
int message_priority(const struct message_index *mi);

int message_set_attachsize(struct message_index *mi,int size);
time_t message_set_attachtime(struct message_index *mi,time_t time);
int message_set_priority(struct message_index *mi,int priority);

long message_current_date(void);
long message_date(int year,const char *month,int day);

int message_age(const struct message_index *mi);

int put_message_index(FILE *f,struct message_index *mi);
int put_table_of_contents_header(FILE *f,struct table_of_contents_header *toc);
