/* -*-ObjC-*-
*******************************************************************************
*
* File:         TransferPanel.h
* RCS:          TransferPanel.h,v 1.4 1997/09/28 23:26:31 tom Exp
* Description:  
* Author:       Tom Hageman <tom@basil.icce.rug.nl>
* Created:      October 1996
* Modified:     April 1997
* Language:     Objective-C
* Package:      EnhanceMail
* Status:       Experimental
*
* Copyright (C) 1996, 1997 Tom Hageman, but otherwise this file is perfect freeware.
*
*******************************************************************************
*/

#import <appkit/appkit.h>
#import "MailApp.h"

@interface EnhanceTransferPanel : TransferPanel

- (void)updateBrowser;
- (void)updateBrowserForMailBoxNamed:(const char *)mailboxName;
- (void)updateMessageCount:(unsigned)newMessageCount old:(unsigned)oldMessageCount
   forMailBoxNamed:(const char *)mailBoxName isNew:(BOOL)isNew;

@end // EnhanceTransferPanel


#import <sys/stat.h>

#define FILE_TOC	"table_of_contents"

enum { STAT_TOC, NUMSTATS };

#define FILESTOSTAT	FILE_TOC

// Tag values for matrix fields.
enum { TAG_TOTAL, TAG_DELETED, TAG_READ, TAG_FLAGGED, TAG_UNREAD, TAG_NEW,
       NUMTAGS };

enum EMSLoadStatus { EMS_UNLOADED=-1, EMS_LOADED=0, EMS_LOADSUPPRESSED=-2 };

@interface EnhanceMailboxSummary : Object
{
   char *myfullname;
   enum EMSLoadStatus loadStatus;
   BOOL accurate;
   long counts[NUMTAGS];
#if 0
   unsigned long sizes[NUMTAGS];
   long attachCounts[NUMTAGS];
   unsigned long attachSizes[NUMTAGS];
#endif
   struct stat stats[NUMSTATS];	// for lazy inspection.
}

+ summaryForName:(const char *)name;
- initName:(const char *)name;
- (const char *)name;
- (enum EMSLoadStatus)loadStatus;
- (BOOL)isLoaded;
- (BOOL)shouldLoad;
- (BOOL)suppressLoad;
- (enum EMSLoadStatus)load;
- (long)numUnreadMessages;
- (long)numNewMessages;
- (void)setUnreadMessages:(long)m;
- (void)setNewMessages:(long)m;

@end // EnhanceMailboxSummary


@interface EnhanceMailboxBrowserCell : NXBrowserCell
{
   long unread;
}

- (long)unread;
- setUnread:(long)nUnread;

@end // EnhanceMailboxBrowserCell
