/* -*-C-*-
*******************************************************************************
*
* File:         TocMatrix.m
* RCS:          /usr/local/sources/CVS/EnhanceMail/TocMatrix.m,v 1.2 1997/04/20 14:52:32 tom Exp
* Description:  
* Author:       Carl Edman
* Created:      Fri Oct 20 14:47:00 1995
* Modified:     Fri Apr 19 13:32:20 1996 (Carl Edman) cedman@capitalist.princeton.edu
* Language:     C
* Package:      N/A
* Status:       Experimental (Do Not Distribute)
*
* (C) Copyright 1995, but otherwise this file is perfect freeware.
*
*******************************************************************************
*/

#import "EnhanceMail.h"
#import <regex.h>
#import "TocMatrix.h"
#import "MailBox.h"
#import "SimpleString.h"

static id cellar=nil;

@implementation EnhanceTocMatrix

+ finishLoading:(struct mach_header *)header
{
   [self poseAs:[self superclass]];
   return self;
}

- findForward:(BOOL)forward all:(BOOL)all
{
   id panel=[FindPanel new];
   id box=[[window delegate] mailbox];
   id ret;

   if ([panel searchMessage]&&![panel regExpr]&&[panel findField]
       &&(box!=nil)&&[box hasStore])
   {
      id list=nil,tmp=nil;
      int i;
      
      if (cellar==nil) cellar=[[HashTable alloc] init];

      tmp=[[SimpleString alloc] init];
      [tmp appendString:"whole(Content parse("];
      [tmp appendString:[panel findField]];
      [tmp appendString:"))"];
      list=[box query:[tmp string]];
      tmp=[tmp free];
      
      if (list!=nil)
      {
         for(i=[list count]-1;i>=0;i--)
	 {
            tmp=[self cellForMsgId:[[list objectAt:i] msgId]];
            if (tmp) [cellar insertKey:tmp value:tmp];
	 }
         list=[[list freeObjects] free];
      }
   }
   else
   {
      if (cellar!=nil) cellar=[cellar free];
   }
      
   ret=[super findForward:forward all:all];
   if (cellar!=nil) cellar=[cellar free];
   return ret;
}

- (BOOL)cell:fp16 containsRegExpr:(struct regex *)fp20 searchMessage:(BOOL)fp24
{
   if ((cellar!=nil)&&![cellar isKey:fp16]) return NO;
   return [super cell:fp16 containsRegExpr:fp20 searchMessage:fp24];
}

@end // EnhanceTocMatrix
