/* -*-C-*-
*******************************************************************************
*
* File:         MailIndex.m
* RCS:          /usr/local/sources/CVS/EnhanceMail/MailIndex.m,v 1.2 1997/04/20 14:52:21 tom Exp
* Description:  
* Author:       Carl Edman
* Created:      Fri Oct 20 14:47:00 1995
* Modified:     Sat Apr 13 22:45:07 1996 (Carl Edman) cedman@capitalist.princeton.edu
* Language:     C
* Package:      N/A
* Status:       Experimental (Do Not Distribute)
*
* (C) Copyright 1995, but otherwise this file is perfect freeware.
*
*******************************************************************************
*/

#import "EnhanceMail.h"
#import "MailIndex.h"

static id currentbox=nil;

@implementation MailIndex

+ mailBox
{
   return currentbox;
}

+ setMailBox:nmailbox
{
   currentbox=nmailbox;
   return self;
}

- initMsgId:(int)nmsgId
{
   msgId=nmsgId;
   mes=nil;
   return self;
}

- free
{
   if (mes) mes=[mes free];
   return [super free];
}

- read:(NXTypedStream *)stream
{
   [super read:stream];
   NXReadType(stream,"i",&msgId);
   mes=nil;
   return self;
}

- write:(NXTypedStream *)stream
{
   [super write:stream];
   NXWriteType(stream,"i",&msgId);
   return self;
}

- setMsgId:(int)nmsgId
{
   msgId=nmsgId;
   if (mes) mes=[mes free];
   return self;
}

- (int)msgId
{
   return msgId;
}

- mailMessage
{
   if (mes==nil) mes=[currentbox loadMessageAt:msgId];
   return mes;
}

- (char)status
{
   return [currentbox getStateForMsg:msgId];
}

- (BOOL)writeToStream:(NXStream *)stream wrapAtColumn:(int)col
{
   return [[self mailMessage] writeToStream:stream wrapAtColumn:col];
}

- (const char *)messageSubject
{
   return [[self mailMessage] headerValueForKey:"Subject"];
}

- (const char *)messageFrom
{
   return [[self mailMessage] headerValueForKey:"From"];
}

- (const char *)messageTo
{
   return [[self mailMessage] headerValueForKey:"To"];
}

- (const char *)messageCc
{
   return [[self mailMessage] headerValueForKey:"Cc"];
}

- (const char *)messageDate
{
   return [[self mailMessage] headerValueForKey:"Date"];
}

- (const char *)messageId
{
   return [[self mailMessage] headerValueForKey:"Message-Id"];
}

- (const char *)messageNextReference
{
   return [[self mailMessage] headerValueForKey:"Next-Reference"];
}

- (const char *)messageContent
{
   return [[self mailMessage] body];
}

@end // MailIndex
