/* -*-C-*-
*******************************************************************************
*
* File:         HelpPanel.m
* RCS:          /usr/local/sources/CVS/EnhanceMail/HelpPanel.m,v 1.4 1997/11/01 00:19:26 tom Exp
* Description:  
* Author:       Carl Edman
* Created:      Tue Oct 31 22:16:31 1995
* Modified:     Sun Nov  5 10:20:25 1995 (Carl Edman) cedman@capitalist.princeton.edu
* Language:     C
* Package:      N/A
* Status:       Experimental (Do Not Distribute)
*
* (C) Copyright 1995, but otherwise this file is perfect freeware.
*
*******************************************************************************
*/

#import "EnhanceMail.h"
#import "HelpPanel.h"


static id maybeAddSupplement(NXHelpPanel *helpPanel)
{
   static BOOL isLoaded = NO;
   char path[MAXPATHLEN+1],*c;
   
   if (!isLoaded && helpPanel && EnhanceBundle &&
       [EnhanceBundle getPath:path forResource:"EnhanceHelp" ofType:0])
   {
      for(c=path;*c;c++);
      while((c>=path) && (*c!='/')) c--;
      *c='\0';
      [helpPanel addSupplement:"EnhanceHelp" inPath:path];
      isLoaded = YES;
   }
   return helpPanel;
}


@implementation EnhanceHelpPanel

+ finishLoading:(struct mach_header *)header
{
   EnhanceBundleInit();
   [self poseAs:[self superclass]];
   return self;
}

+ new
{
   return maybeAddSupplement([super new]);
}

/* [TRH  1-Feb-97] Original +newForDirectory: override did not always work
   when another Mail bundle loaded before EnhanceMail adds its help
   supplement by the naive [[NXHelpPanel new] addSupplement:...] approach.
   (EM is too smart for its own good:-/) */

@end // EnhanceHelpPanel
