/* -*-C-*-
*******************************************************************************
*
* File:         ComposeHelper.m
* RCS:          /usr/local/sources/CVS/EnhanceMail/ComposeHelper.m,v 1.2 1997/04/20 13:25:31 tom Exp
* Description:  
* Author:       Carl Edman
* Created:      Fri Oct 13 11:48:05 1995
* Modified:     Tue Jun 25 20:02:38 1996 (Carl Edman) cedman@capitalist.princeton.edu
* Language:     C
* Package:      N/A
* Status:       Experimental (Do Not Distribute)
*
* (C) Copyright 1995, but otherwise this file is perfect freeware.
*
*******************************************************************************
*/

#import "EnhanceMail.h"
#import "ComposeHelper.h"
#import "Preferences.h"
#import "PGP.h"

@implementation EnhanceComposeHelper

+ finishLoading:(struct mach_header *)header
{
   [NXApp addComposeHelperClass:self];
   return self;
}


- init
{
   if (self=[super init])
   {
      if (EnhanceUsePGP)
      {
	 char path[MAXPATHLEN];

	 if ([EnhanceBundle getPath:path forResource:"EncryptComposeHelper" ofType:"nib"])
	    [NXApp loadNibFile:path owner:self];

	 [encryptSwitch setState:EnhancePGPEncrypt];
	 [signSwitch setState:EnhancePGPSign];
      }
   }
   return self;
}

- (View *)composeView
{
   if (EnhanceUsePGP) return accessoryBox;
   return nil;
}

- (BOOL)willDeliverMessage:(MailMessage *)mes to:(StringList *)rcpt
{
   if (EnhanceUsePGP)
   {
      BOOL shouldSign=[signSwitch state];
      BOOL shouldEncrypt=[encryptSwitch state];
      if ([[EnhancePGP new] encodePGP:mes to:rcpt sign:shouldSign encrypt:shouldEncrypt]==NO)
         return NO;
   }
   return YES;
}

@end // EnhanceComposeHelper
