/* Reminder.h created by wjabi on Sat 17-Jan-1998 */

#import <AppKit/AppKit.h>

@interface Reminder : NSObject
{
    int hours;
    int minutes;
    BOOL relative;
    NSString *reminderString;
    BOOL repeats;
    int seconds;
    BOOL shouldEmitSound;
    BOOL shouldShowAlertPanel;
    NSTimer *timer;
}

- (void)cancelReminder;
- (void) convertSecondsToTime:(long) totalSeconds :(int *)hours :(int *)minutes :(int *)secs;
- (long) convertTimeToSeconds:(int) hr :(int)min :(int)sec;
- (BOOL)getRelative;
- (BOOL)getRepeats;
- (BOOL)getValid;
- (void)remainingTime:(int *)hours minutes:(int *)minutes seconds:(int *)seconds;
- (void)setRelative:(BOOL)relativeValue;
- (id)setReminder:(int)hr :(int)min :(int)sec :aTarget :(SEL)aSelector :(BOOL)repeatsValue :(BOOL)relativeValue :(BOOL)soundValue :(BOOL)alertPanelValue :(NSString *)aString;
- (void)setRepeats:(BOOL)repeatsValue;
- (void)setStringValue:(NSString *)aString;
- (BOOL)shouldEmitSound;
- (BOOL)shouldShowAlertPanel;
- (NSString *)stringValue;

@end
