
/* Generated by Interface Builder */

#import "Resistor.h"
#import <appkit/Text.h>
#import <appkit/Button.h> /* Needed to button matrix */
#import <appkit/Form.h>
#import <appkit/Form.h> /* Used by the selectCellWithTag function */

@implementation Resistor

- closeInfo:sender
/* This method closes the Info panel and opens and displays the MoreInfo panel */
{
      	[Info performClose:sender]; /* This closes the Info panel */
      	[MoreInfo orderFront:sender]; /* This displays the MoreInfo panel */
      	return self;
 }

- PrintColorTable:sender
/* This method will print the Resistor Color Code Table */
{

     [ColorTable printPSCode:self];

    return self;
 }


- Calculate:sender
{
     /* Declare variables */
     int Vfirstband; /* Value of firstband */
     int Vsecondband; /* Value of secondband */
     int Vthirdband; /* Value of thirdband */
     float Vfourthband; /* Value of fourthband */
     int SwitchOne; /* Dummy int for switch statment */
     int SwitchTwo; /* Dummy int for switch statment */
     int temp;
     int temp2;
     float resistorValue;
     float resistorValueK;
     float range1;
     float range2;
     char SRvalue[20];
     char SRKvalue[20];
     char SR1value[20];
     char SR2value[20];
      
     
    /* assigns the value of the currently selected button found in the button matrixs of Resistor */
    /* using tag as a reference*/ 
   	Vfirstband = [FirstBand selectedTag]; 
   	Vsecondband = [SecondBand selectedTag];
	Vthirdband = [ThirdBand selectedTag];

   /* thirdband: Assigns the proper value depending on which button was selected */	
	SwitchOne = [ThirdBand selectedTag];
        Vthirdband = SwitchOne;
	
 	switch (SwitchOne)  { /* start switch */
   
   		case 2:
          	Vthirdband = 0.10; /* Gold (ThirdBand) */
	  	break;
	  
   		case 3:
          	Vthirdband = 0.01; /* Silver (ThirdBand) */
          	break;
	  
               case 4:
          	Vthirdband = 1000000; /* Blue (ThirdBand) */
          	break;

               case 5:
          	Vthirdband = 10000000; /* Voilet (ThirdBand) */
          	break;

               case 6:
          	Vthirdband = 100000000; /* Grey (ThirdBand) */
          	break;

	                        } /* end switch */


    	
    /* fourthband: Assigns the proper value depending on which button was selected */	
	SwitchTwo = [FourthBand selectedTag];

 	switch (SwitchTwo)  { /* start switch */
   
   		case 0:
          	Vfourthband = 0.20; /* No Band */
	  	break;
	  
   		case 1:
          	Vfourthband = 0.10; /* Silver */
          	break;
	  
   		case 2:
           	Vfourthband = 0.05; /* Gold */
	    	break;

	                        } /* end switch */

/* Calculations */

temp = Vfirstband*10;
temp2 = temp + Vsecondband;
resistorValue = temp2 * Vthirdband;
range1 = resistorValue * Vfourthband;
range1 = resistorValue - range1;
range2 = resistorValue * Vfourthband;
range2 = resistorValue + range2;
resistorValueK = resistorValue / 1000;

/* Convert a number to a string a adjust the floating point accuracy */
sprintf(SRvalue,"%.2f",resistorValue);
sprintf(SRKvalue,"%.2f",resistorValueK);
sprintf(SR1value,"%.2f",range1);
sprintf(SR2value,"%.2f",range2);



/* Assign the values to the proper display */
[ValueOhms setStringValue:SRvalue]; /* display the value of the resistor in the form */
[ ValueKOhms setStringValue:SRKvalue]; /*display the value of the resistor in K in the form */   
[RangeOne setStringValue:SR1value]; /* display the value of the range1 in the form */   
[RangeTwo setStringValue:SR2value]; /* display the value of the range2 in the form */

  
   return self;
}

- Ohms10:sender
{
        [FirstBand selectCellWithTag:1]; /* This will select radio button number 1 */ 
	[SecondBand selectCellWithTag:0];
	[ThirdBand selectCellWithTag:1];
	[FourthBand selectCellWithTag:0];
	[self Calculate:sender]; 
	return self;
}

- Ohms33:sender
{
        [FirstBand selectCellWithTag:3]; /* This will select radio button number 1 */ 
	[SecondBand selectCellWithTag:3];
	[ThirdBand selectCellWithTag:1];
	[FourthBand selectCellWithTag:0];
	[self Calculate:sender]; 
	return self;
}

- Ohms47:sender
{
        [FirstBand selectCellWithTag:4]; /* This will select radio button number 1 */ 
	[SecondBand selectCellWithTag:7];
	[ThirdBand selectCellWithTag:1];
	[FourthBand selectCellWithTag:0];
	[self Calculate:sender]; 
	return self;
}

- Ohms100:sender
{
        [FirstBand selectCellWithTag:1]; /* This will select radio button number 1 */ 
	[SecondBand selectCellWithTag:0];
	[ThirdBand selectCellWithTag:1];
	[FourthBand selectCellWithTag:0];
	[self Calculate:sender]; 
	return self;
}

- Ohms220:sender
{
        [FirstBand selectCellWithTag:2]; /* This will select radio button number 1 */ 
	[SecondBand selectCellWithTag:2];
	[ThirdBand selectCellWithTag:10];
	[FourthBand selectCellWithTag:0];
	[self Calculate:sender]; 
	return self;
}

- Ohms330:sender
{
        [FirstBand selectCellWithTag:3]; /* This will select radio button number 1 */ 
	[SecondBand selectCellWithTag:3];
	[ThirdBand selectCellWithTag:10];
	[FourthBand selectCellWithTag:0];
	[self Calculate:sender]; 
	return self;
}

- Ohms470:sender
{
        [FirstBand selectCellWithTag:4]; /* This will select radio button number 1 */ 
	[SecondBand selectCellWithTag:7];
	[ThirdBand selectCellWithTag:10];
	[FourthBand selectCellWithTag:0];
	[self Calculate:sender]; 
	return self;
}

- Ohms560:sender
{
        [FirstBand selectCellWithTag:5]; /* This will select radio button number 1 */ 
	[SecondBand selectCellWithTag:6];
	[ThirdBand selectCellWithTag:10];
	[FourthBand selectCellWithTag:0];
	[self Calculate:sender]; 
	return self;
}

- Ohms680:sender
{
        [FirstBand selectCellWithTag:6]; /* This will select radio button number 1 */ 
	[SecondBand selectCellWithTag:8];
	[ThirdBand selectCellWithTag:10];
	[FourthBand selectCellWithTag:0];
	[self Calculate:sender]; 
	return self;
}

- Ohms1K:sender
{
        [FirstBand selectCellWithTag:1]; /* This will select radio button number 1 */ 
	[SecondBand selectCellWithTag:0];
	[ThirdBand selectCellWithTag:100];
	[FourthBand selectCellWithTag:0];
	[self Calculate:sender]; 
	return self;
}

- Ohms1p5K:sender
{
        [FirstBand selectCellWithTag:1]; /* This will select radio button number 1 */ 
	[SecondBand selectCellWithTag:5];
	[ThirdBand selectCellWithTag:100];
	[FourthBand selectCellWithTag:0];
	[self Calculate:sender]; 
	return self;
}

- Ohms10K:sender
{
        [FirstBand selectCellWithTag:1]; /* This will select radio button number 1 */ 
	[SecondBand selectCellWithTag:0];
	[ThirdBand selectCellWithTag:1000];
	[FourthBand selectCellWithTag:0];
	[self Calculate:sender]; 
	return self;
}

- Ohms15K:sender
{
        [FirstBand selectCellWithTag:1]; /* This will select radio button number 1 */ 
	[SecondBand selectCellWithTag:5];
	[ThirdBand selectCellWithTag:1000];
	[FourthBand selectCellWithTag:0];
	[self Calculate:sender]; 
	return self;
}

- Ohms47K:sender
{
        [FirstBand selectCellWithTag:4]; /* This will select radio button number 1 */ 
	[SecondBand selectCellWithTag:7];
	[ThirdBand selectCellWithTag:1000];
	[FourthBand selectCellWithTag:0];
	[self Calculate:sender]; 
	return self;
}

- Ohms100K:sender
{
        [FirstBand selectCellWithTag:1]; /* This will select radio button number 1 */ 
	[SecondBand selectCellWithTag:0];
	[ThirdBand selectCellWithTag:10000];
	[FourthBand selectCellWithTag:0];
	[self Calculate:sender]; 
	return self;
}

- Reset:sender
{
        [FirstBand selectCellWithTag:0]; /* This will select radio button number 1 */ 
	[SecondBand selectCellWithTag:0];
	[ThirdBand selectCellWithTag:0];
	[FourthBand selectCellWithTag:0];
	[self Calculate:sender]; 
	return self;
}


@end
