
/* Generated by Interface Builder */

#import "Ohmslaw.h"
#import <appkit/FormCell.h>
#import <appkit/TextField.h>
#import <appkit/publicWraps.h> /* Need by NXBeep */

float VoltsValue;
float AmperesValue;
float OhmsValue;
float WattsValue;

@implementation Ohmslaw


- appDidInit:sender;
/* This method is executed right after the application was initilized but before
 * the application receives it's first event.
 */
{
        [self FindOhms:sender]; 		
	return self;
}



- Calculate:sender
{
    
     	int WhichOne;
   	WhichOne = [FindButton selectedTag]; /* assigns the value of the currently selected button */
   	/* using tag as a reference */
   
     switch (WhichOne)  { /* start switch */
   
   /* Find the Resistance "Ohms"   R=V/I  */
   case 0:
                /* Gets the value from the Ampere field */
	        AmperesValue = [Amperes floatValue];

               /* Gets the value from the Volts field */
	       VoltsValue = [Volts floatValue];

               OhmsValue= (VoltsValue/AmperesValue);
	       
	       [Ohms setFloatValue:OhmsValue];
	        
	  break;
	  
   /* Find the Current "Ampere"   I= V/R  */
   case 1:
               /* Gets the value from the Ohms field */
	        OhmsValue = [Ohms floatValue];

               /* Gets the value from the Volts field */
	       VoltsValue = [Volts floatValue];

               AmperesValue= (VoltsValue/OhmsValue);
	       
	       [Amperes setFloatValue:AmperesValue];

          break;
	  
   /* Find the Voltage "Volt"  V=I*R   */
   case 2:
              /* Gets the value from the Ohms field */
	        OhmsValue = [Ohms floatValue];

               /* Gets the value from the Ampere field */
	       AmperesValue = [Amperes floatValue];

               VoltsValue= (AmperesValue*OhmsValue);
	       
	       [Volts setFloatValue:VoltsValue];

	    break;

  /* Find the Power "Watts" */
   case 3:
               
               /* Gets the value from the Ohms field */
	       OhmsValue = [Ohms floatValue];

               /* Gets the value from the Ampere  field */
	        AmperesValue = [Amperes floatValue];

               /* Gets the value from the Volts field */
	       VoltsValue = [Volts floatValue];


/* Make sure all the values are found then find the Watts */

/*    Find the value for Ohms    */
if (OhmsValue == 0)
       {
		OhmsValue= (VoltsValue/AmperesValue);
	      	[Ohms setFloatValue:OhmsValue];
        }

/*    Find the value for Amperes    */
if (AmperesValue == 0)
       {
		AmperesValue= (VoltsValue/OhmsValue);
	       	[Amperes setFloatValue:AmperesValue];
	}

/*    Find the value for Volts    */
if (VoltsValue == 0)
       {
  		VoltsValue= (AmperesValue*OhmsValue);
	       	[Volts setFloatValue:VoltsValue];
	}

/* Find the Watts     P=I*V    */

               WattsValue= (AmperesValue*VoltsValue);
	       [Watts setFloatValue:WattsValue];
	           
	     	break;

	                        } /* end switch */    
    	return self;
}

- FindOhms:sender
{
	[self SetToZero:sender]; /* Set the form value to ZERO */
	[Ohms setEnabled:NO]; /* Disable the form (noneditable) */
	[Amperes setEnabled:YES]; /* Enables the form */
	[Volts setEnabled:YES]; /* Enables the form */
        [Watts setEnabled:NO]; /* Disable the form (noneditable) */
	return self;
      
  }

- FindAmpere:sender
{
	[self SetToZero:sender];
	[Ohms setEnabled:YES];
	[Amperes setEnabled:NO];
	[Volts setEnabled:YES];
	[Watts setEnabled:NO];
	return self;
      
  }
  
  - FindVolts:sender
{
	[self SetToZero:sender];
	[Ohms setEnabled:YES];
	[Amperes setEnabled:YES];
	[Volts setEnabled:NO];
       [Watts setEnabled:NO];
       return self;
      
  }

  - FindWatts:sender
{
	[self SetToZero:sender];
	[Ohms setEnabled:YES];
	[Amperes setEnabled:YES];
	[Volts setEnabled:YES];
        [Watts setEnabled:NO];
       return self;
      
  }

- SetToZero:sender
/* This sets the values of the forms to ZERO */
{
       	[Ohms setFloatValue:0];
	[Amperes setFloatValue:0];
	[Volts setFloatValue:0];
	[Watts setFloatValue:0];
 	return self;
  }

- PrintOhmsTable:sender
/* This method will print the Ohms Law Table */
{

     [OhmsTable printPSCode:self];

    return self;
 }


@end
