#import <appkit/appkit.h>
#import "CIC_Module.h"		// Replace "CIC_Module" with your module's name

@implementation CIC_Module	// Again, put your module name here


// required methods:

- initFromPath:(const char *)path
{
     char       fname[MAXPATHLEN];
     
     strcat(strcpy(fname,[self name]),CIC_NIB_EXT);
     if([NXApp loadNibSection:fname owner:self withNames:NO] == nil){
	  fprintf(stderr,"Module %s: Cannot load %s!\n",[self name],fname);
	  return nil;
     }
     else
	  return self;
}

// This is method, all is about:
// It operates on the image data coming from CIC.
// Do your specific processing here, it is only method you need to modify.
// The supplied source sets all activated channels of the selection to zero.

- (float)processImage:(IMAGE_INFO *)imageInfo selectionMode:(int)selMode percentBar:percentBar
{
     BOOL		ignore = (selMode >= SEL_ALL_COL ? NO : YES);
     register int	i,j;
     unsigned int	v1,v2,v3,v4,v5;


     switch(imageInfo->info.image.samplesPerPixel){
     case 1:
          for(j=0;j<=N_PERCENTSTEPS;j++){
               [percentBar showPercentage:(int)((float)j*PERCENT_SCAL)];
               end = (j < N_PERCENTSTEPS ? (end+percent_step) : bytesPerPlane);
               if(ignore)
                    for(i=start;i<end;i+=step)
                         *(channel1+i)  = 0;
               else
                    for(i=start;i<end;i+=step)
                         if((v1 = *(backup_channel1+i)) >= select1 && v1 <= range1){
                              *(channel1+i)     = 0;
                              ++match;
                         }
               start    = end;
          }
          break;
     case 2:
	    for(j=0;j<=N_PERCENTSTEPS;j++){
		        [percentBar showPercentage:(int)((float)j*PERCENT_SCAL)];
			       end = (j < N_PERCENTSTEPS ? (end+percent_step) : bytesPerPlane);
			       if(ignore)
				        for(i=start;i<end;i+=step){
					     *(channel1+i)= 0;
					     *(channel2+i)= 0;
					}
			       else
				        for(i=start;i<end;i+=step)
					      if(((v1=*(backup_channel1+i)) >= select1 && v1 <= range1) &&\
						     ((v2=*(backup_channel2+i)) >= select2 && v2 <= range2)){
						   *(channel1+i)= 0;
						   *(channel2+i)= 0;
						   ++match;
					      }
			start= end;
		   }
	    break;
     case 3:
	    for(j=0;j<=N_PERCENTSTEPS;j++){
		        [percentBar showPercentage:(int)((float)j*PERCENT_SCAL)];
			       end = (j < N_PERCENTSTEPS ? (end+percent_step) : bytesPerPlane);
			       if(ignore)
				        for(i=start;i<end;i+=step){
					     *(channel1+i)= 0;
					     *(channel2+i)= 0;
					     *(channel3+i)= 0;
					}
			       else
				        for(i=start;i<end;i+=step)
					      if(((v1=*(backup_channel1+i)) >= select1 && v1 <= range1) &&\
						     ((v2=*(backup_channel2+i)) >= select2 && v2 <= range2) &&\
						     ((v3=*(backup_channel3+i)) >= select3 && v3 <= range3)){
						   *(channel1+i)= 0;
						   *(channel2+i)= 0;
						   *(channel3+i)= 0;
						   ++match;
					      }
			start= end;
		   }
	    break;
     case 4:
	    for(j=0;j<=N_PERCENTSTEPS;j++){
		        [percentBar showPercentage:(int)((float)j*PERCENT_SCAL)];
			       end = (j < N_PERCENTSTEPS ? (end+percent_step) : bytesPerPlane);
			       if(ignore)
				        for(i=start;i<end;i+=step){
					     *(channel1+i)= 0;
					     *(channel2+i)= 0;
					     *(channel3+i)= 0;
					     *(channel4+i)= 0;
					}
			       else
				        for(i=start;i<end;i+=step)
					      if(((v1=*(backup_channel1+i)) >= select1 && v1 <= range1) &&\
						     ((v2=*(backup_channel2+i)) >= select2 && v2 <= range2) &&\
						     ((v3=*(backup_channel3+i)) >= select3 && v3 <= range3) &&\
						     ((v4=*(backup_channel4+i)) >= select4 && v4 <= range4)){
						   *(channel1+i)= 0;
						   *(channel2+i)= 0;
						   *(channel3+i)= 0;
						   *(channel4+i)= 0;
						   ++match;
					      }
			start= end;
		   }
	    break;
     case 5:
	    for(j=0;j<=N_PERCENTSTEPS;j++){
		        [percentBar showPercentage:(int)((float)j*PERCENT_SCAL)];
			       end = (j < N_PERCENTSTEPS ? (end+percent_step) : bytesPerPlane);
			       if(ignore)
				        for(i=start;i<end;i+=step){
					     *(channel1+i)= 0;
					     *(channel2+i)= 0;
					     *(channel3+i)= 0;
					     *(channel4+i)= 0;
					     *(channel5+i)= 0;
					}
			       else
				        for(i=start;i<end;i+=step)
					      if(((v1=*(backup_channel1+i)) >= select1 && v1 <= range1) &&\
						     ((v2=*(backup_channel2+i)) >= select2 && v2 <= range2) &&\
						     ((v3=*(backup_channel3+i)) >= select3 && v3 <= range3) &&\
						     ((v4=*(backup_channel4+i)) >= select4 && v4 <= range4) &&\
						     ((v5=*(backup_channel5+i)) >= select5 && v5 <= range5)){
						   *(channel1+i)= 0;
						   *(channel2+i)= 0;
						   *(channel3+i)= 0;
						   *(channel4+i)= 0;
						   *(channel5+i)= 0;
						   ++match;
					      }
			start= end;
		   }
	    break;
     }

     if(ignore)
	    return(1.0);
     else
	    return((float)match/(float)bytesPerChannel);
}

- actionView
{
     return actionView;
}

@end
