#import <sys/param.h>
#import <appkit/tiff.h>

#define	N_PERCENTSTEPS	32
#define PERCENT_SCAL	(100.0/(float)N_PERCENTSTEPS)
#define SEL_ALL		0
#define SEL_RECT	1
#define SEL_FREE	2
#define SEL_ALL_COL	3
#define SEL_RECT_COL	4
#define SEL_FREE_COL	5
#define ROUNDING	(.499999)

typedef struct _IMAGE_INFO {
     NXTIFFInfo		info;
     unsigned char 	*data;
     NXRect		imageRect;
     NXRect		contentRect;
     float		angle;
     float		alpha;	// not used
     int		extractionFactor;
     int		bytesPerPlane;
     int		bytesInImage;
     BOOL		hasAlpha;
     int		colorSpace;
     int		cmykUcr;
     int		dpi;
     BOOL		undoEnabled;
     BOOL		isCached;
     BOOL		needsSaving;
     float		percentChanged;
     char		fname[MAXPATHLEN];
} IMAGE_INFO;

