#import <stdio.h>
#import <strings.h>
#import <objc/NXStringTable.h>
#import <appkit/Application.h>
#import <appkit/View.h>
#import "Channel.h"		// Replace "CIC_Module" with your modules name

@implementation Channel	// Again, put your module name here


// required methods:

- initFromPath:(const char *)path
{
     char       fname[MAXPATHLEN];
     
     strcat(strcpy(fname,[self name]),CIC_NIB_EXT);
     if([NXApp loadNibSection:fname owner:self withNames:NO] == nil){
          fprintf(stderr,"Module %s: Cannot load %s!\n",[self name],fname);
          return nil;
     }
     else{
	  channelView = rgbView;
          return self;
     }
}

// This is method, all is about:
// It operates on the image data coming from CIC.
// Do your specific processing here, it is only method you need to modify.
// The supplied source sets all activated channels of the selection to zero.

- (float)processImage:(IMAGE_INFO *)imageInfo selectionMode:(int)selMode percentBar:percentBar
{
     BOOL		ignore = (selMode >= SEL_ALL_COL ? NO : YES);
     register int	i,j;
     unsigned int	v1,v2,v3,v4,v5;
	id			processor;


	 if(processor = [[NXApp delegate] fasterProcessorFor:self])
		return([processor run:self onImage:imageInfo selMode:selMode percentBar:percentBar args:self,NULL]);

	f_c1 = (f_c1 ? 0 : 1);
	f_c2 = (f_c2 ? 0 : 1);
	f_c3 = (f_c3 ? 0 : 1);
	f_c4 = (f_c4 ? 0 : 1);
	f_c5 = (f_c5 ? 0 : 1);

     switch(imageInfo->info.image.samplesPerPixel){
     case 1:
          for(j=0;j<=N_PERCENTSTEPS;j++){
               [percentBar showPercentage:(int)((float)j*PERCENT_SCAL)];
               end = (j < N_PERCENTSTEPS ? (end+percent_step) : bytesPerPlane);
               if(ignore)
                    for(i=start;i<end;i+=step)
                         *(channel1+i)  = 0;
               else
                    for(i=start;i<end;i+=step)
                         if((v1 = *(channel1+i)) >= select1 && v1 <= range1){
                              *(channel1+i)     = 0;
                              ++match;
                         }
               start    = end;
          }
          break;
     case 2:
	    for(j=0;j<=N_PERCENTSTEPS;j++){
		        [percentBar showPercentage:(int)((float)j*PERCENT_SCAL)];
			       end = (j < N_PERCENTSTEPS ? (end+percent_step) : bytesPerPlane);
			       if(ignore)
				        for(i=start;i<end;i+=step){
					     if(f_c1) *(channel1+i)= 0;
					     if(f_c2) *(channel2+i)= 0;
					}
			       else
				        for(i=start;i<end;i+=step)
					      if(((v1=*(channel1+i)) >= select1 && v1 <= range1) &&\
						     ((v2=*(channel2+i)) >= select2 && v2 <= range2)){
						   if(f_c1) *(channel1+i)= 0;
						   if(f_c2) *(channel2+i)= 0;
						         ++match;
					      }
			start= end;
		   }
	    break;
     case 3:
	    for(j=0;j<=N_PERCENTSTEPS;j++){
		        [percentBar showPercentage:(int)((float)j*PERCENT_SCAL)];
			       end = (j < N_PERCENTSTEPS ? (end+percent_step) : bytesPerPlane);
			       if(ignore)
				        for(i=start;i<end;i+=step){
					     if(f_c1) *(channel1+i)= 0;
					     if(f_c2) *(channel2+i)= 0;
					     if(f_c3) *(channel3+i)= 0;
					}
			       else
				        for(i=start;i<end;i+=step)
					      if(((v1=*(channel1+i)) >= select1 && v1 <= range1) &&\
						     ((v2=*(channel2+i)) >= select2 && v2 <= range2) &&\
						     ((v3=*(channel3+i)) >= select3 && v3 <= range3)){
						   if(f_c1) *(channel1+i)= 0;
						   if(f_c2) *(channel2+i)= 0;
						   if(f_c3) *(channel3+i)= 0;
						         ++match;
					      }
			start= end;
		   }
	    break;
     case 4:
	    for(j=0;j<=N_PERCENTSTEPS;j++){
		        [percentBar showPercentage:(int)((float)j*PERCENT_SCAL)];
			       end = (j < N_PERCENTSTEPS ? (end+percent_step) : bytesPerPlane);
			       if(ignore)
				        for(i=start;i<end;i+=step){
					     if(f_c1) *(channel1+i)= 0;
					     if(f_c2) *(channel2+i)= 0;
					     if(f_c3) *(channel3+i)= 0;
					     if(f_c4) *(channel4+i)= 0;
					}
			       else
				        for(i=start;i<end;i+=step)
					      if(((v1=*(channel1+i)) >= select1 && v1 <= range1) &&\
						     ((v2=*(channel2+i)) >= select2 && v2 <= range2) &&\
						     ((v3=*(channel3+i)) >= select3 && v3 <= range3) &&\
						     ((v4=*(channel4+i)) >= select4 && v4 <= range4)){
						   if(f_c1) *(channel1+i)= 0;
						   if(f_c2) *(channel2+i)= 0;
						   if(f_c3) *(channel3+i)= 0;
						   if(f_c4) *(channel4+i)= 0;
						         ++match;
					      }
			start= end;
		   }
	    break;
     case 5:
	    for(j=0;j<=N_PERCENTSTEPS;j++){
		        [percentBar showPercentage:(int)((float)j*PERCENT_SCAL)];
			       end = (j < N_PERCENTSTEPS ? (end+percent_step) : bytesPerPlane);
			       if(ignore)
				        for(i=start;i<end;i+=step){
					     if(f_c1) *(channel1+i)= 0;
					     if(f_c2) *(channel2+i)= 0;
					     if(f_c3) *(channel3+i)= 0;
					     if(f_c4) *(channel4+i)= 0;
					     if(f_c5) *(channel5+i)= 0;
					}
			       else
				        for(i=start;i<end;i+=step)
					      if(((v1=*(channel1+i)) >= select1 && v1 <= range1) &&\
						     ((v2=*(channel2+i)) >= select2 && v2 <= range2) &&\
						     ((v3=*(channel3+i)) >= select3 && v3 <= range3) &&\
						     ((v4=*(channel4+i)) >= select4 && v4 <= range4) &&\
						     ((v5=*(channel5+i)) >= select5 && v5 <= range5)){
						   if(f_c1) *(channel1+i)= 0;
						   if(f_c2) *(channel2+i)= 0;
						   if(f_c3) *(channel3+i)= 0;
						   if(f_c4) *(channel4+i)= 0;
						   if(f_c5) *(channel5+i)= 0;
						         ++match;
					      }
			start= end;
		   }
	    break;
     }

     if(ignore)
	    return(1.0);
     else
	    return((float)match/(float)bytesPerChannel);
}

- actionView
{
     return actionView;
}


// my methods:

- changeChannelViewTo:newView
{
     NXRect	rect;

     if(newView != channelView){
	  [channelView getFrame:&rect];
	  [newView setFrame:&rect];
	  [[channelView superview] replaceSubview:channelView with:newView];
	  channelView = newView;
     }

     return self;
}

// optional methods:

- channelMatrix
{
     return channelMatrix;
}

- (const char *)moduleName
{
     return [stringTable valueForStringKey:"moduleName"];
}

- readData:(float *)data
{
     return self;
}

- writeData:(float *)data
{
     return self;
}

- willBeDisplayed:(IMAGE_INFO *)imageInfo
{
     if(imageInfo->colorSpace == NX_CMYKColorSpace)
	  [self changeChannelViewTo:cmykView];
     else
	  [self changeChannelViewTo:rgbView];

     return self;
}

// dummy method
// it really does nothing, it only suppresses an error message during compilation.

- showPercentage:(int)percent
{
     return self;
}

@end
