#import <stdio.h>
#import <strings.h>
#import <libc.h>
#import <objc/NXStringTable.h>
#import <appkit/color.h>
#import <appkit/NXColorWell.h>
#import <appkit/Application.h>
#import "Blend.h"		// Replace "CIC_Module" with your module's name

@implementation Blend		// Again, put your module name here


// required methods:

- initFromPath:(const char *)path
{
     char       fname[MAXPATHLEN];
     
     strcat(strcpy(fname,[self name]),CIC_NIB_EXT);
     if([NXApp loadNibSection:fname owner:self withNames:NO] == nil){
          fprintf(stderr,"Module %s: Cannot load %s!\n",[self name],fname);
          return nil;
     }
     else
          return self;
}

// This is method, all is about:
// It operates on the image data coming from CIC.
// Do your specific processing here, it is only method you need to modify.
// The supplied source sets all activated channels of the selection to zero.

- (float)processImage:(IMAGE_INFO *)imageInfo selectionMode:(int)selMode percentBar:percentBar
{
     BOOL			ignore = (selMode >= SEL_ALL_COL ? NO : YES);
     int			x,y,i,j,offset;
     int			resx = imageInfo->info.image.width,resy = imageInfo->info.image.height;
     int			spp = imageInfo->info.image.samplesPerPixel;
     register unsigned char     v1,v2,v3,v4,v5;
     float		ul[5],ur[5],ll[5],lr[5],deltaFac;
     float		d_left[5],d_right[5],delta[5],left[5],right[5];
     float		color[5];
	id			processor;


     switch(imageInfo->colorSpace){
     case NX_RGBColorSpace:
          NXConvertColorToRGBA([upperleftWell color],&ul[0],&ul[1],&ul[2],&ul[3]);
          NXConvertColorToRGBA([upperrightWell color],&ur[0],&ur[1],&ur[2],&ur[3]);
          NXConvertColorToRGBA([lowerleftWell color],&ll[0],&ll[1],&ll[2],&ll[3]);
          NXConvertColorToRGBA([lowerrightWell color],&lr[0],&lr[1],&lr[2],&lr[3]);
          break;
     case NX_CMYKColorSpace:
          NXConvertColorToCMYKA([upperleftWell color],&ul[0],&ul[1],&ul[2],&ul[3],&ul[4]);
          NXConvertColorToCMYKA([upperrightWell color],&ur[0],&ur[1],&ur[2],&ur[3],&ur[4]);
          NXConvertColorToCMYKA([lowerleftWell color],&ll[0],&ll[1],&ll[2],&ll[3],&ll[4]);
          NXConvertColorToCMYKA([lowerrightWell color],&lr[0],&lr[1],&lr[2],&lr[3],&lr[4]);
          break;
     default:
          NXConvertColorToGrayAlpha([upperleftWell color],&ul[0],&ul[1]);
          NXConvertColorToGrayAlpha([upperrightWell color],&ur[0],&ur[1]);
          NXConvertColorToGrayAlpha([lowerleftWell color],&ll[0],&ll[1]);
          NXConvertColorToGrayAlpha([lowerrightWell color],&lr[0],&lr[1]);
          break;
     }

	if(processor = [[NXApp delegate] fasterProcessorFor:self])
		return([processor run:self onImage:imageInfo selMode:selMode percentBar:percentBar args:self,&ul[0],&ul[1],&ul[2],&ul[3],&ur[0],&ur[1],&ur[2],&ur[3],&ll[0],&ll[1],&ll[2],&ll[3],&lr[0],&lr[1],&lr[2],&lr[3],NULL]);

     for(i=0;i<spp;i++){
	  left[i]	= (ul[i] *= 255);
	  right[i]	= (ur[i] *= 255);
	  d_left[i]	= ((ll[i] *= 255)-ul[i])/resy;
	  d_right[i]	= ((lr[i] *= 255)-ur[i])/resy;
     }

     percent_step = resy/(N_PERCENTSTEPS+1);
     start	= end = 0;
     deltaFac	= 1.0/(float)resx;
     resx	*= step;

     match	= 0;
     switch(imageInfo->info.image.samplesPerPixel){
     case 1:
	  for(j=0;j<=N_PERCENTSTEPS;j++){
               [percentBar showPercentage:(int)((float)j*PERCENT_SCAL)];
               end = (j < N_PERCENTSTEPS ? (end+percent_step) : resy);
	       for(y=start;y<end;y++){
		    delta[0] = (right[0]-(color[0] = left[0]))*deltaFac;
		    offset = y*resx;
		    for(x=0;x<resx;x++){
			 if(ignore || ((v1 = *(channel1+offset)) >= select1 && v1 <= range1)){
			      *(channel1+offset) = color[0];
			      ++match;
			 }
			 color[0] += delta[0];
			 ++offset ;
		    }
		    left[0] += d_left[0];
		    right[0] += d_right[0];
	       }
	       start	= end;
	  }
	  break;
     case 2:
	  for(j=0;j<=N_PERCENTSTEPS;j++){
               [percentBar showPercentage:(int)((float)j*PERCENT_SCAL)];
               end = (j < N_PERCENTSTEPS ? (end+percent_step) : resy);
	       for(y=start;y<end;y++){
		    for(i=0;i<spp;i++)
			 delta[i] = (right[i]-(color[i] = left[i]))*deltaFac;
		    offset = y*resx;
		    for(x=0;x<resx;x+=step){
			 if(ignore || ((v1 = *(channel1+offset)) >= select1 && v1 <= range1 &&\
				      (v2 = *(channel2+offset)) >= select2 && v2 <= range2)){
			      if(f_c1) *(channel1+offset) = color[0];
			      if(f_c2) *(channel2+offset) = color[1];
			      ++match;
			 }
			 for(i=0;i<spp;i++)
			      color[i] += delta[i];
			 offset += step;
		    }
		    for(i=0;i<spp;i++){
			 left[i] += d_left[i];
			 right[i] += d_right[i];
		    }
	       }
	       start	= end;
	  }
	  break;
     case 3:
	  for(j=0;j<=N_PERCENTSTEPS;j++){
               [percentBar showPercentage:(int)((float)j*PERCENT_SCAL)];
               end = (j < N_PERCENTSTEPS ? (end+percent_step) : resy);
	       for(y=start;y<end;y++){
		    for(i=0;i<spp;i++)
			 delta[i] = (right[i]-(color[i] = left[i]))*deltaFac;
		    offset = y*resx;
		    for(x=0;x<resx;x+=step){
			 if(ignore || ((v1 = *(channel1+offset)) >= select1 && v1 <= range1 &&\
				      (v2 = *(channel2+offset)) >= select2 && v2 <= range2 &&\
				      (v3 = *(channel3+offset)) >= select3 && v3 <= range3)){
			      if(f_c1) *(channel1+offset) = color[0];
			      if(f_c2) *(channel2+offset) = color[1];
			      if(f_c3) *(channel3+offset) = color[2];
			      ++match;
			 }
			 for(i=0;i<spp;i++)
			      color[i] += delta[i];
			 offset += step;
		    }
		    for(i=0;i<spp;i++){
			 left[i] += d_left[i];
			 right[i] += d_right[i];
		    }
	       }
	       start	= end;
	  }
	  break;
     case 4:
	  for(j=0;j<=N_PERCENTSTEPS;j++){
               [percentBar showPercentage:(int)((float)j*PERCENT_SCAL)];
               end = (j < N_PERCENTSTEPS ? (end+percent_step) : resy);
	       for(y=start;y<end;y++){
		    for(i=0;i<spp;i++)
			 delta[i] = (right[i]-(color[i] = left[i]))*deltaFac;
		    offset = y*resx;
		    for(x=0;x<resx;x+=step){
			 if(ignore || ((v1 = *(channel1+offset)) >= select1 && v1 <= range1 &&\
				      (v2 = *(channel2+offset)) >= select2 && v2 <= range2 &&\
				      (v3 = *(channel3+offset)) >= select3 && v3 <= range3 &&\
				      (v4 = *(channel4+offset)) >= select4 && v4 <= range4)){
			      if(f_c1) *(channel1+offset) = color[0];
			      if(f_c2) *(channel2+offset) = color[1];
			      if(f_c3) *(channel3+offset) = color[2];
			      if(f_c4) *(channel4+offset) = color[3];
			      ++match;
			 }
			 for(i=0;i<spp;i++)
			      color[i] += delta[i];
			 offset += step;
		    }
		    for(i=0;i<spp;i++){
			 left[i] += d_left[i];
			 right[i] += d_right[i];
		    }
	       }
	       start	= end;
	  }
	  break;
     case 5:
	  for(j=0;j<=N_PERCENTSTEPS;j++){
	       [percentBar showPercentage:(int)((float)j*PERCENT_SCAL)];
               end = (j < N_PERCENTSTEPS ? (end+percent_step) : resy);
	       for(y=start;y<end;y++){
		    for(i=0;i<spp;i++)
			 delta[i] = (right[i]-(color[i] = left[i]))*deltaFac;
		    offset = y*resx;
		    for(x=0;x<resx;x+=step){
			 if(ignore || ((v1 = *(channel1+offset)) >= select1 && v1 <= range1 &&\
				      (v2 = *(channel2+offset)) >= select2 && v2 <= range2 &&\
				      (v3 = *(channel3+offset)) >= select3 && v3 <= range3 &&\
				      (v4 = *(channel4+offset)) >= select4 && v4 <= range4 &&\
				      (v5 = *(channel5+offset)) >= select5 && v5 <= range5)){
			      if(f_c1) *(channel1+offset) = color[0];
			      if(f_c2) *(channel2+offset) = color[1];
			      if(f_c3) *(channel3+offset) = color[2];
			      if(f_c4) *(channel4+offset) = color[3];
			      if(f_c5) *(channel5+offset) = color[4];
			      ++match;
			 }
			 for(i=0;i<spp;i++)
			      color[i] += delta[i];
			 offset += step;
		    }
		    for(i=0;i<spp;i++){
			 left[i] += d_left[i];
			 right[i] += d_right[i];
		    }
	       }
	       start	= end;
	  }
	  break;
     }

     if(ignore)
	  return(1.0);
     else
	  return((float)match/(float)bytesPerChannel);
}

- actionView
{
     return actionView;
}


// optional methods:

- channelMatrix
{
     return channelMatrix;
}

- (const char *)moduleName
{
     return [stringTable valueForStringKey:"moduleName"];
}

- (int)tileOffset
{
	return(NO_TILING);
}

@end
