#import "MyNSObject.h"

@implementation MyNSObject


- (void)applicationDidFinishLaunching:(NSNotification *)notification
// In order for your object to receive this notification make sure that
// your object is a delegate or "File's Owner" in IB.
// Connected from "File's Owner" to MyObject in this case.
{

      [self setContentField:NULL];
      [self setOutputTitleField:NULL];

      // Displays the window (main) Panel
      [window center];
      [window makeKeyAndOrderFront:NULL];
     

}

- (void)ClearAllText:(id)sender
{	

       [[contentField documentView] setString:@""];
       [[outputTitleField documentView] setString:@""];
       [[outputTitleField2 documentView] setString:@""];
       [[inputTitleField documentView] setString:@""];
       [inputTitleField setStringValue:@""];

}

- (void)copyText:(id)sender
{	

    	// Copy the text from the inputTitleField to both outputTitleFields
    	[[outputTitleField documentView] setString:[inputTitleField stringValue]];
    	[[outputTitleField2 documentView] setString:[inputTitleField stringValue]];
    
}

- (void)doPrint:(id)sender
{

    [group print:self];
}


- (void)SetCenter:(id)sender
{	

    // Sets the alignment to the center
    [[outputTitleField documentView] setAlignment:NSCenterTextAlignment];
    [[outputTitleField2 documentView] setAlignment:NSCenterTextAlignment];
    
}

- (void)SetRight:(id)sender
{	

    // Sets the alignment to the center
    [[outputTitleField documentView] setAlignment:NSRightTextAlignment];
    [[outputTitleField2 documentView] setAlignment:NSRightTextAlignment];

}

- (void)SetLeft:(id)sender
{	

    // Sets the alignment to the center
    [[outputTitleField documentView] setAlignment:NSLeftTextAlignment];
    [[outputTitleField2 documentView] setAlignment:NSLeftTextAlignment];


}


- setContentField:anObject
{
        contentField = anObject;

        [contentField setHasVerticalScroller:NO];
        [contentField display];

}

- setOutputTitleField:anObject
{

        outputTitleField = anObject;
        [outputTitleField setBoundsRotation:(float)90];
        [outputTitleField setHasVerticalScroller:NO];
        [outputTitleField setHasHorizontalScroller:NO];

        // Sets the alignment to the center
        [[outputTitleField documentView] setAlignment:NSCenterTextAlignment];
        [[outputTitleField2 documentView] setAlignment:NSCenterTextAlignment];
        [[outputTitleField documentView] setFont:[NSFont fontWithName:@"Helvetica-Bold" size:16.0]];
        [[outputTitleField2 documentView] setFont:[NSFont fontWithName:@"Helvetica-Bold" size:16.0]];
	
        outputTitleField = anObject;
        [outputTitleField2 setBoundsRotation:(float)90];
        [outputTitleField2 setHasVerticalScroller:NO];
        [outputTitleField2 setHasHorizontalScroller:NO];

        [[outputTitleField documentView] setString:@"CDROMer Jewel Case Labels"];
        [[outputTitleField documentView] setString:@"CDROMer Jewel Case Labels"];
        
}


- (void)ShowMoreInfo:(id)sender
{
    if (![NSBundle loadNibNamed:@"MoreInfo" owner:self])  {
        NSLog(@"Failed to load MoreInfo.nib");
        NSBeep();
        return;
        }

}


-(void)ShowHelp:(id)sender
{
    
    // Displays the Info Panel
    [HelpPanel center];
    [HelpPanel makeKeyAndOrderFront:NULL];
}

-(void)ShowInfo:(id)timer
{

    // Displays the Info Panel
    [InfoPanel center];
    [InfoPanel makeKeyAndOrderFront:NULL];

}


@end
