/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

class JarClassLoader
extends ClassLoader {
    static JarClassLoader ourLoader = new JarClassLoader();
    private Hashtable objects = new Hashtable();

    public void setDefinition(String string, byte[] byArray) {
        this.objects.put(string, byArray);
    }

    public synchronized void applyDefinitions(Vector vector) {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Class<?> clazz = this.findLoadedClass(string);
            if (clazz != null) continue;
            this.applyDefinition(string, true);
        }
    }

    private Class applyDefinition(String string, boolean bl) {
        Object object;
        Class<?> clazz;
        Object v = this.objects.get(string);
        if (v == null) {
            return null;
        }
        if (v instanceof Class) {
            clazz = (Class<?>)v;
        } else {
            object = (byte[])v;
            this.objects.remove(string);
            clazz = super.defineClass(null, (byte[])object, 0, ((byte[])object).length);
            this.objects.put(string, clazz);
        }
        if (clazz != null && bl) {
            this.resolveClass(clazz);
        }
        if (!clazz.getName().equals(string)) {
            System.err.println("\nWARNING: file name versus class name mismatch");
            object = String.valueOf(string.replace('.', '/')) + ".class";
            System.err.println("    JAR entry \"" + (String)object + "\" was expected " + "to contain class \"" + string + "\"");
            System.err.println("    but instead contained class \"" + clazz.getName() + "\"");
            System.err.println("    This may cause future class-loading problems.\n");
        }
        return clazz;
    }

    protected Class loadClass(String string, boolean bl) throws ClassNotFoundException {
        Class<?> clazz = this.findLoadedClass(string);
        if (clazz == null) {
            clazz = this.applyDefinition(string, bl);
        }
        if (clazz == null) {
            try {
                clazz = this.findSystemClass(string);
                return clazz;
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        if (clazz == null) {
            throw new ClassNotFoundException(string);
        }
        if (bl) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    JarClassLoader() {
    }
}

