/*
 * Decompiled with CFR 0.152.
 */
package uiutil;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.StringTokenizer;
import main.Oscar;
import uiutil.ChoiceListener;
import uiutil.ChoiceUI;
import uiutil.ErrorMgr;

public class UrlViewer
extends Thread {
    public static final String BROWSER_KEY = "Browser";
    public static final String DEFAULT_BROWSER = "default";
    private String url;
    private String command;
    private static final String defaultURL = "http://www.aol.com";
    public static String defaultBrowser = null;
    public boolean findBrowser;
    public boolean runSpecifiedBrowser;

    public UrlViewer(String string, String string2) {
        if (string == null || string.equalsIgnoreCase(DEFAULT_BROWSER)) {
            this.url = string2 != null ? string2 : defaultURL;
        } else {
            File file = new File(string);
            if (!file.canRead()) {
                ErrorMgr.diag("UrlViewer", "Cannot read " + string);
                return;
            }
            this.url = string2 != null ? string2 : defaultURL;
            this.command = string;
        }
        this.start();
    }

    public UrlViewer(String string) {
        String string2 = this.url = string != null ? string : defaultURL;
        if (defaultBrowser != null) {
            this.command = defaultBrowser;
        }
        this.start();
    }

    public void destroy() {
        this.command = null;
        this.url = null;
        ErrorMgr.diag("UrlViewer: ", "Browser closed...");
    }

    public void run() {
        boolean bl = false;
        this.findBrowser = false;
        boolean bl2 = this.runSpecifiedBrowser = defaultBrowser != null && !defaultBrowser.equalsIgnoreCase(DEFAULT_BROWSER);
        if (this.url.startsWith("aol://") || this.url.startsWith("AOL://")) {
            ChoiceUI.newChoiceUI("AOL URL", "This is an AOL URL, only the AOL client can display it.", Oscar.WARNING_SOUND);
            return;
        }
        String string = System.getProperty("os.name");
        if (string != null) {
            bl = (string = string.toLowerCase()).compareTo("windows 95") == 0 ? this.runWin32Browser() : (string.compareTo("macos") == 0 ? this.runMacBrowser() : this.runUnixBrowser());
        }
        if (!bl) {
            ErrorMgr.warn(BROWSER_KEY, "Attempts to start a browser have failed. Make sure there is a browser and sufficient system resource to run it. If you have specified a browser to use (via setup), please check to see the browser is installed and runs properly.");
        }
        this.destroy();
    }

    private boolean executeCommand(String string) {
        Process process = null;
        try {
            process = Runtime.getRuntime().exec(string);
        }
        catch (IOException iOException) {
            ErrorMgr.diag("UrlViewer", "exec() IO exception", iOException);
            return false;
        }
        int n = -1;
        try {
            n = process.waitFor();
        }
        catch (InterruptedException interruptedException) {
            ErrorMgr.diag("UrlViewer", "waitFor() interrupted", interruptedException);
            return false;
        }
        if (n != 0) {
            ErrorMgr.diag("UrlViewer", "Execution of " + string + " failed!");
        }
        return n == 0;
    }

    private String executeCommandS(String string) {
        Process process = null;
        try {
            process = Runtime.getRuntime().exec(string);
        }
        catch (IOException iOException) {
            ErrorMgr.diag("UrlViewer", "exec() error", iOException);
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(160);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        try {
            String string2;
            while ((string2 = bufferedReader.readLine()) != null) {
                stringBuffer.append(string2);
                if (bufferedReader.ready()) {
                    continue;
                }
                break;
            }
        }
        catch (IOException iOException) {}
        int n = 0;
        try {
            n = process.waitFor();
        }
        catch (InterruptedException interruptedException) {
            ErrorMgr.diag("UrlViewer", "waitFor() Interrupted", interruptedException);
            return null;
        }
        if (n != 0) {
            ErrorMgr.diag("UrlViewer", "failed execution of " + string);
            return null;
        }
        try {
            bufferedReader.close();
        }
        catch (IOException iOException) {
            ErrorMgr.diag("UrlViewer", "closing file interrupted", iOException);
        }
        return stringBuffer.toString();
    }

    private String findPath(String string, String string2) {
        String string3 = null;
        boolean bl = false;
        File file = new File(string);
        if (!file.canRead()) {
            return null;
        }
        file = new File("c:\\WINDOWS\\COMMAND\\FIND.EXE");
        if (!file.canRead()) {
            return null;
        }
        String string4 = "c:\\WINDOWS\\COMMAND\\FIND.EXE \"" + string2 + "\" " + string;
        string3 = this.executeCommandS(string4);
        if (string3 != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string3, ",");
            bl = false;
            while (stringTokenizer.hasMoreTokens() && !bl) {
                string4 = stringTokenizer.nextToken();
                if (!string4.endsWith(string2)) continue;
                bl = true;
            }
        }
        if (bl) {
            return string4;
        }
        return null;
    }

    private boolean runWin32Browser() {
        if (defaultBrowser != null && !defaultBrowser.equalsIgnoreCase(DEFAULT_BROWSER) && this.executeCommand(String.valueOf(defaultBrowser) + " " + this.url)) {
            return true;
        }
        if (this.runSpecifiedBrowser) {
            try {
                new ResponseThread(this);
                this.suspend();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return false;
            }
            if (!this.findBrowser) {
                return false;
            }
        }
        this.command = "C:\\WINDOWS\\COMMAND\\START.EXE";
        File file = new File(this.command);
        if (!file.canRead()) {
            ErrorMgr.diag("UrlViewer", "Cannot read a command file.");
        } else if (this.executeCommand(String.valueOf(this.command) + " " + this.url)) {
            return true;
        }
        String[] stringArray = new String[]{"c:\\Program Files\\Netscape\\Navigator\\Program\\netscape.exe", "d:\\Program Files\\Netscape\\Navigator\\Program\\netscape.exe", "c:\\Program Files\\Microsoft Internet\\IEXPLORE.EXE", "c:\\Program Files\\Microsoft Internet\\IE20.EXE", "c:\\Program Files\\PLUS!\\Microsoft Internet\\IE20.EXE"};
        int n = 0;
        while (n < stringArray.length) {
            file = new File(stringArray[n]);
            if (file.canRead() && this.executeCommand(String.valueOf(stringArray[n]) + " " + this.url)) {
                return true;
            }
            ++n;
        }
        this.command = this.findPath("c:\\WINDOWS\\WIN.INI", "NETSCAPE.EXE");
        return this.command != null && (file = new File(this.command)).canRead() && this.executeCommand(String.valueOf(this.command) + " " + this.url);
    }

    private final String getPath(String string) {
        String[] stringArray = new String[]{"/bin/" + string, "/usr/bin/" + string, "/usr/ucb/" + string, "/usr/bsd/" + string};
        int n = 0;
        while (n < stringArray.length) {
            File file = new File(stringArray[n]);
            if (file.canRead()) {
                return stringArray[n];
            }
            ++n;
        }
        return null;
    }

    private boolean runUnixBrowser() {
        File file;
        String string;
        boolean bl = false;
        boolean bl2 = false;
        this.command = System.getProperty("user.home");
        if (this.command != null) {
            this.command = this.command.concat("/.netscape/lock");
            string = this.getPath("ls");
            if (string == null) {
                return false;
            }
            this.command = this.executeCommandS(String.valueOf(string) + " " + this.command);
            if (this.command != null && this.command.endsWith("lock")) {
                bl2 = true;
            }
        }
        if (defaultBrowser != null && defaultBrowser.endsWith("netscape") && bl2) {
            this.command = defaultBrowser;
            file = new File(this.command);
            if (file.canRead() && (bl = this.executeCommand(String.valueOf(this.command) + " -remote " + "openURL(" + this.url + ")"))) {
                return true;
            }
        }
        if (this.runSpecifiedBrowser && this.executeCommand(String.valueOf(defaultBrowser) + " " + this.url)) {
            return true;
        }
        if (this.runSpecifiedBrowser) {
            try {
                new ResponseThread(this);
                this.suspend();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return false;
            }
            if (!this.findBrowser) {
                return false;
            }
        }
        if ((string = this.getPath("which")) == null) {
            return false;
        }
        String[] stringArray = new String[]{"netscape", "Mosaic", "lynx"};
        int n = 0;
        while (n < stringArray.length) {
            this.command = this.executeCommandS(String.valueOf(string) + " " + stringArray[n]);
            if (this.command != null && this.command.endsWith(stringArray[n]) && (file = new File(this.command)).canRead()) {
                if (n == 0 && bl2 && (bl = this.executeCommand(String.valueOf(this.command) + " -remote " + "openURL(" + this.url + ")"))) {
                    return true;
                }
                if (this.executeCommand(String.valueOf(this.command) + " " + this.url)) {
                    return true;
                }
            }
            ++n;
        }
        return false;
    }

    private boolean runMacBrowser() {
        return false;
    }

    class ResponseThread
    extends Thread
    implements ChoiceListener {
        UrlViewer ref;

        ResponseThread(UrlViewer urlViewer2) {
            UrlViewer.this = UrlViewer.this;
            this.ref = urlViewer2;
            this.start();
        }

        public void run() {
            ChoiceUI.newChoiceUI(this, 7, null, UrlViewer.BROWSER_KEY, "The browser you have specified, " + defaultBrowser + ", cannot be started. Please check your browser " + "configuration. If you would like " + Oscar.SHORT_NAME + " to try to launch an alternate browser now, choose " + "\"Launch\". Otherwise, choose \"Cancel\".", "Launch", "Cancel", null, null);
        }

        public void choiceMade(int n, int n2, Object object) {
            boolean bl = UrlViewer.this.findBrowser = n2 == 0;
            if (this.ref != null) {
                this.ref.resume();
            }
            this.ref = null;
        }
    }
}

