/*
 * Decompiled with CFR 0.152.
 */
package uiutil;

import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import uiutil.ImageItem;
import uiutil.Item;
import uiutil.RowItem;
import uiutil.ScrollTree;
import uiutil.StringItem;

public class TreeNode {
    boolean collapsed;
    boolean selected;
    boolean visible;
    boolean dimmed;
    int height = 10;
    int width = 100;
    int level;
    int rowNumber;
    String name;
    private Vector rowItemList;
    private ScrollTree sref;
    private int alignPos;
    private ActionListener actionListener;

    public TreeNode(String string, Vector vector, Vector vector2) {
        this.name = string;
        this.setContents(vector, vector2);
        this.initVars();
    }

    public TreeNode(Vector vector, Vector vector2) {
        this.setContents(vector, vector2);
        this.initVars();
    }

    public TreeNode(String string, Vector vector) {
        this.name = string;
        this.setContents(vector, vector);
        this.initVars();
    }

    public TreeNode(String string) {
        this.name = string;
        Vector<String> vector = new Vector<String>(1);
        vector.addElement(string);
        this.setContents(vector, vector);
        this.initVars();
    }

    public TreeNode(Image image) {
        this.name = "image";
        Vector<Image> vector = new Vector<Image>(1);
        vector.addElement(image);
        this.setContents(vector, vector);
        this.initVars();
    }

    public TreeNode(Vector vector) {
        this(vector, vector);
    }

    private final void initVars() {
        this.collapsed = false;
        this.selected = false;
        this.visible = true;
        this.level = 0;
    }

    public void setContents(Vector vector) {
        this.setContents(vector, vector);
    }

    public void setContents(Vector vector, Vector vector2) {
        RowItem rowItem;
        int n;
        int n2;
        if (this.rowItemList != null) {
            n2 = this.rowItemList.size();
            n = 0;
            while (n < n2) {
                rowItem = (RowItem)this.rowItemList.elementAt(n);
                if (rowItem != null) {
                    rowItem.destroy();
                }
                ++n;
            }
            this.rowItemList.removeAllElements();
        }
        n2 = vector.size();
        this.rowItemList = new Vector(n2);
        int n3 = 0;
        while (n3 < n2) {
            Object e = vector.elementAt(n3);
            Object e2 = vector2.elementAt(n3);
            Item item = e instanceof String ? new StringItem((String)e) : new ImageItem((Image)e);
            Item item2 = e2 instanceof String ? new StringItem((String)e2) : new ImageItem((Image)e2);
            rowItem = new RowItem(item, item2);
            this.rowItemList.addElement(rowItem);
            n = rowItem.getHeight();
            ++n3;
        }
    }

    public void addActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, actionListener);
    }

    void hasChosen() {
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(new ActionEvent(this, 1001, this.name));
        }
    }

    void setRef(ScrollTree scrollTree) {
        this.sref = scrollTree;
    }

    ScrollTree getRef() {
        return this.sref;
    }

    public String toString() {
        String string = "\nName = " + this.name + "\nlevel = " + this.level + "\nheight = " + this.height + "\nwidth = " + this.width + "\nrow = " + this.rowNumber + "\ncollapsed = " + this.collapsed + "\nselected = " + this.selected + "\nvisible = " + this.visible;
        return string;
    }

    public Vector getItems() {
        int n = this.rowItemList.size();
        Vector<Object> vector = new Vector<Object>(n);
        int n2 = 0;
        while (n2 < n) {
            RowItem rowItem = (RowItem)this.rowItemList.elementAt(n2);
            Item item = rowItem.getNormal();
            if (item.isString()) {
                vector.addElement(item.getString());
            } else {
                vector.addElement(item.getImage());
            }
            ++n2;
        }
        return vector;
    }

    public Vector getSelectedItems() {
        int n = this.rowItemList.size();
        Vector<Object> vector = new Vector<Object>(n);
        int n2 = 0;
        while (n2 < n) {
            RowItem rowItem = (RowItem)this.rowItemList.elementAt(n2);
            Item item = rowItem.getClicked();
            if (item.isString()) {
                vector.addElement(item.getString());
            } else {
                vector.addElement(item.getImage());
            }
            ++n2;
        }
        return vector;
    }

    public void setDim(boolean bl) {
        this.dimmed = bl;
    }

    public boolean isDim() {
        return this.dimmed;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    int getAlignPos() {
        return this.alignPos;
    }

    public String getFirstString() {
        int n = 0;
        while (n < this.rowItemList.size()) {
            Item item = ((RowItem)this.rowItemList.elementAt(n)).getNormal();
            if (item instanceof StringItem) {
                return item.getString();
            }
            ++n;
        }
        return null;
    }

    public void setCollapsed(boolean bl) {
        this.collapsed = bl;
    }

    public boolean isCollapsed() {
        return this.collapsed;
    }

    void setLevel(int n) {
        this.level = n;
    }

    int getLevel() {
        return this.level;
    }

    void setVisible(boolean bl) {
        this.visible = bl;
    }

    boolean isVisible() {
        return this.visible;
    }

    void setSelected(boolean bl) {
        this.selected = bl;
    }

    public boolean isSelected() {
        return this.selected;
    }

    void setHeight(int n) {
        this.height = n;
    }

    int getHeight() {
        return this.height;
    }

    int getRowNumber() {
        return this.rowNumber;
    }

    int getWidth() {
        return this.width;
    }

    void setWidth(int n) {
        this.width = n;
    }

    void toggle() {
        if (this.selected) {
            this.deselect();
            return;
        }
        this.select();
    }

    void deselect() {
        this.selected = false;
    }

    void select() {
        this.selected = true;
    }

    public void destroy() {
        if (this.rowItemList != null) {
            int n = this.rowItemList.size();
            int n2 = 0;
            while (n2 < n) {
                RowItem rowItem = (RowItem)this.rowItemList.elementAt(n2);
                if (rowItem != null) {
                    rowItem.destroy();
                }
                ++n2;
            }
            this.rowItemList.removeAllElements();
            this.rowItemList = null;
        }
        this.sref = null;
        this.actionListener = null;
    }

    boolean isWithin(int n, int n2) {
        return n2 >= this.rowNumber * this.height && n2 <= (this.rowNumber + 1) * this.height;
    }

    public void paint(Graphics graphics, int n) {
        Object object;
        Color color;
        if (graphics == null || !this.visible) {
            return;
        }
        this.rowNumber = n;
        int n2 = this.level * 7;
        int n3 = n * this.height;
        Color color2 = color = this.dimmed ? ScrollTree.fgDimColor : ScrollTree.foreground;
        if (this.selected) {
            graphics.setColor(color);
        } else {
            graphics.setColor(ScrollTree.background);
        }
        graphics.fillRect(0, n3, this.width, this.height);
        if (this.collapsed) {
            if (this.selected) {
                graphics.setColor(ScrollTree.background);
            } else {
                graphics.setColor(color);
            }
            object = graphics.getFontMetrics();
            graphics.drawString("+", n2, n3 + (this.height + ((FontMetrics)object).getAscent() - ((FontMetrics)object).getDescent()) / 2);
            n2 += ((FontMetrics)object).stringWidth("+");
        }
        Vector vector = this.rowItemList;
        synchronized (vector) {
            int n4 = this.rowItemList.size();
            int n5 = 0;
            while (n5 < n4) {
                int n6 = n2 + 2;
                object = (RowItem)this.rowItemList.elementAt(n5);
                if (n5 == 2 && this.sref != null) {
                    this.alignPos = this.sref.getAlignPos();
                    if (this.alignPos < n6) {
                        this.alignPos = n6;
                        this.sref.setAlignPos(n6);
                    }
                    n2 = ((RowItem)object).drawIt(null, graphics, this.alignPos, n3, this.height, color, ScrollTree.background, this.selected);
                } else {
                    n2 = ((RowItem)object).drawIt(null, graphics, n6, n3, this.height, color, ScrollTree.background, this.selected);
                }
                ++n5;
            }
            return;
        }
    }
}

