/*
 * Decompiled with CFR 0.152.
 */
package uiutil;

import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;

public class PasswordField
extends TextField
implements KeyListener {
    private String password = "";
    private char echoChar = '\u0000';

    public PasswordField() {
        this.addKeyListener(this);
    }

    public PasswordField(int n) {
        super(n);
        this.addKeyListener(this);
    }

    public PasswordField(String string) {
        super(string);
        this.addKeyListener(this);
    }

    public PasswordField(String string, int n) {
        super(string, n);
        this.addKeyListener(this);
    }

    public boolean echoCharIsSet() {
        return false;
    }

    public char getEchoChar() {
        return this.echoChar;
    }

    public String getPassword() {
        return this.password;
    }

    public void keyPressed(KeyEvent keyEvent) {
        int n = this.getSelectionStart();
        int n2 = this.getSelectionEnd();
        int n3 = -1;
        char c = keyEvent.getKeyChar();
        int n4 = keyEvent.getKeyCode();
        switch (n4) {
            case 8: {
                n3 = this.deleteLeft(n, n2);
                break;
            }
            case 9: 
            case 10: 
            case 16: 
            case 17: 
            case 20: 
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                return;
            }
            case 127: {
                n3 = this.deleteRight(n, n2);
                break;
            }
            default: {
                n3 = this.replace(n, n2, c);
            }
        }
        if (n3 != -1) {
            this.setPassword(this.password);
            this.select(n3, n3);
        }
        keyEvent.consume();
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void removeNotify() {
        this.password = null;
        super.removeNotify();
    }

    public void setEchoChar(char c) {
        this.echoChar = c;
    }

    public void setPassword(String string) {
        if (string == null) {
            string = "";
        }
        this.password = string;
        if (this.echoChar == '\u0000') {
            ((TextComponent)this).setText(string);
            return;
        }
        int n = string.length();
        byte[] byArray = new byte[n];
        int n2 = 0;
        while (n2 < n) {
            byArray[n2] = (byte)this.echoChar;
            ++n2;
        }
        ((TextComponent)this).setText(new String(byArray));
    }

    private int deleteLeft(int n, int n2) {
        int n3 = n;
        if (n != n2) {
            this.password = String.valueOf(this.password.substring(0, n)) + this.password.substring(n2);
            n3 = n;
        } else if (n > 0 && n < this.password.length()) {
            this.password = String.valueOf(this.password.substring(0, n - 1)) + this.password.substring(n2);
            n3 = n - 1;
        } else if (n > 0) {
            this.password = this.password.substring(0, n - 1);
            n3 = n - 1;
        }
        return n3;
    }

    private int deleteRight(int n, int n2) {
        int n3 = n;
        int n4 = this.password.length();
        if (n != n2) {
            this.password = String.valueOf(this.password.substring(0, n)) + this.password.substring(n2);
            n3 = n;
        } else if (n2 < n4 && n4 > 0) {
            this.password = String.valueOf(this.password.substring(0, n2)) + this.password.substring(n2 + 1);
            n3 = n2;
        } else if (n2 < n4) {
            this.password = "";
            n3 = 0;
        }
        return n3;
    }

    private int replace(int n, int n2, int n3) {
        this.password = n < this.password.length() ? String.valueOf(this.password.substring(0, n)) + String.valueOf((char)n3) + this.password.substring(n2) : String.valueOf(this.password) + String.valueOf((char)n3);
        return n + 1;
    }
}

