/*
 * Decompiled with CFR 0.152.
 */
package uiutil;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import uiutil.EListListener;
import uiutil.ListItem;
import util.ItemChecker;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class EList
extends Panel
implements MouseListener,
KeyListener,
AdjustmentListener {
    public static final int INSET = 2;
    public static final byte VGAP = 2;
    private Scrollbar vbar = new Scrollbar(1);
    private Vector rowList = new Vector(10);
    private ListItem selectedRow;
    private int selectedIndex = -1;
    private Image image;
    private int topIndex;
    private int visible;
    private int rowsHeight;
    private Color foreground;
    private Color background;
    private int rowHeight;
    private boolean editMode;
    private boolean enabled = true;
    private EListListener listener;
    private ItemChecker itemChecker;
    private Color oforeground;
    private Color obackground;

    public EList() {
        this(10);
    }

    public EList(int n) {
        this.setLayout(new BorderLayout());
        this.add("East", this.vbar);
        this.foreground = Color.black;
        this.background = Color.white;
        this.oforeground = Color.black;
        this.obackground = Color.white;
        this.addKeyListener(this);
        this.addMouseListener(this);
        this.vbar.addAdjustmentListener(this);
    }

    public void registerListener(EListListener eListListener) {
        this.listener = eListListener;
    }

    public void registerItemChecker(ItemChecker itemChecker) {
        this.itemChecker = itemChecker;
    }

    public void addNotify() {
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        if (fontMetrics == null) {
            return;
        }
        this.rowHeight = fontMetrics.getHeight();
        this.rowsHeight = (this.rowHeight + 2) * this.rowList.size();
        super.addNotify();
    }

    public void destroy() {
        this.vbar = null;
        if (this.rowList != null) {
            int n = 0;
            while (n < this.rowList.size()) {
                ListItem listItem = (ListItem)this.rowList.elementAt(n);
                listItem.destroy();
                ++n;
            }
            this.rowList.removeAllElements();
        }
        this.rowList = null;
        this.selectedRow = null;
        this.image = null;
        this.foreground = null;
        this.background = null;
        this.oforeground = null;
        this.obackground = null;
        this.listener = null;
    }

    public void removeNotify() {
        this.destroy();
        super.removeNotify();
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
        if (!bl) {
            this.foreground = Color.gray;
            this.background = Color.lightGray;
        } else {
            this.foreground = this.oforeground;
            this.background = this.obackground;
        }
        int n = 0;
        while (n < this.rowList.size()) {
            ListItem listItem = (ListItem)this.rowList.elementAt(n);
            listItem.setColors(this.foreground, this.background);
            listItem.setEnabled(bl);
            ++n;
        }
        this.vbar.setEnabled(bl);
        this.repaint();
        super.setEnabled(bl);
    }

    public void setColors(Color color, Color color2) {
        this.foreground = color;
        this.background = color2;
        this.oforeground = color;
        this.obackground = color2;
        int n = 0;
        while (n < this.rowList.size()) {
            ((ListItem)this.rowList.elementAt(n)).setColors(color, color2);
            ++n;
        }
    }

    private void adjustValues() {
        Dimension dimension = this.getSize();
        int n = this.rowList.size();
        int n2 = this.vbar.getValue();
        if (n == 0) {
            this.repaint();
            return;
        }
        this.visible = (int)((double)dimension.height / (double)this.rowsHeight * (double)n);
        if (this.visible >= n) {
            this.topIndex = 0;
        }
        int n3 = Math.max(0, n);
        this.vbar.setValues(n2, this.visible, 0, n3);
        this.repaint();
    }

    public boolean validItem(ListItem listItem) {
        boolean bl = true;
        if (listItem != null) {
            bl = this.validItem(listItem.getItem());
        }
        return bl;
    }

    public boolean validItem(String string) {
        boolean bl = true;
        if (this.itemChecker != null && !this.itemChecker.validItem(string, true)) {
            bl = false;
        }
        return bl;
    }

    public Dimension getPreferredSize() {
        Dimension dimension = new Dimension(100, 80);
        dimension.width += this.vbar.getPreferredSize().width;
        return dimension;
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public void addItems(Vector vector) {
        boolean bl = this.vbar.isEnabled();
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            this.addItem((String)vector.elementAt(n2));
            ++n2;
        }
        this.vbar.setEnabled(bl);
    }

    public Vector getItems() {
        int n = this.rowList.size();
        Vector<String> vector = new Vector<String>(n);
        int n2 = 0;
        while (n2 < n) {
            ListItem listItem = (ListItem)this.rowList.elementAt(n2);
            String string = listItem.getItem();
            if (string != null && string.length() > 0) {
                vector.addElement(string);
            }
            ++n2;
        }
        return vector;
    }

    public String getItem(int n) {
        if (n < 0 || n >= this.rowList.size()) {
            return null;
        }
        return ((ListItem)this.rowList.elementAt(n)).getItem();
    }

    public void addItem(String string) {
        this.addItem(string, -1);
    }

    public void addItem(String string, int n) {
        ListItem listItem = new ListItem(string, this.background, this.foreground);
        listItem.setEnabled(this.enabled);
        if (n >= 0 && n < this.rowList.size()) {
            this.rowList.insertElementAt(listItem, n);
        } else {
            this.rowList.addElement(listItem);
        }
        this.rowsHeight += Math.min(this.rowHeight, listItem.height) + 2;
        this.adjustValues();
    }

    public void invalidate() {
        super.invalidate();
        this.image = null;
        this.adjustValues();
    }

    public void clear() {
        this.rowList.removeAllElements();
        this.selectedIndex = -1;
        this.rowsHeight = 0;
        this.adjustValues();
    }

    public int count() {
        return this.rowList.size();
    }

    public void delItem(int n) {
        EList.assert(n >= 0 && n < this.rowList.size());
        ListItem listItem = (ListItem)this.rowList.elementAt(n);
        this.rowList.removeElementAt(n);
        this.rowsHeight -= listItem.height + 2;
        --this.topIndex;
        if (this.topIndex < 0) {
            this.topIndex = 0;
        }
        if (n < this.selectedIndex) {
            --this.selectedIndex;
        } else if (n == this.selectedIndex) {
            this.selectedIndex = -1;
            if (this.selectedRow != null) {
                this.selectedRow.deselect();
            }
        }
        if (listItem != null) {
            listItem.destroy();
            listItem = null;
        }
        this.adjustValues();
    }

    public void delItem() {
        if (!this.rowList.isEmpty()) {
            this.delItem(this.rowList.size() - 1);
        }
    }

    public void deselect(int n) {
        EList.assert(n >= 0 && n < this.rowList.size());
        ((ListItem)this.rowList.elementAt(n)).deselect();
        if (this.selectedIndex == n) {
            this.selectedIndex = -1;
        }
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public String getSelectedItem() {
        if (this.selectedIndex >= 0) {
            return this.selectedRow.getItem();
        }
        return null;
    }

    public void replaceItem(String string, int n) {
        EList.assert(n >= 0 && n < this.rowList.size());
        ((ListItem)this.rowList.elementAt(n)).updateItem(string, this.background, this.foreground);
        this.repaint();
    }

    public void select(int n) {
        EList.assert(n >= 0 && n < this.rowList.size());
        ListItem listItem = (ListItem)this.rowList.elementAt(n);
        if (listItem != null) {
            if (this.selectedRow != null) {
                this.selectedRow.deselect();
            }
            this.selectedRow = listItem;
            this.selectedRow.select();
            this.selectedIndex = n;
        }
        this.requestFocus();
        this.editMode = false;
        this.makeVisible(n);
    }

    public void makeVisible(int n) {
        int n2 = this.rowList.size();
        EList.assert(n >= 0 && n < n2);
        if (n < this.topIndex) {
            this.topIndex = n;
        } else if (n >= this.topIndex + this.visible) {
            this.topIndex = n - this.visible + 1;
            if (this.topIndex >= n2) {
                this.topIndex = 0;
            }
        }
        this.vbar.setValues(this.topIndex, this.visible, 0, n2);
        this.repaint();
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.requestFocus();
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this.rowList == null) {
            return;
        }
        int n = -1;
        int n2 = this.rowList.size();
        int n3 = this.topIndex;
        while (n3 < this.topIndex + this.visible && n3 < n2) {
            if (((ListItem)this.rowList.elementAt(n3)).within(mouseEvent.getX(), mouseEvent.getY())) {
                n = n3;
                break;
            }
            ++n3;
        }
        if (n >= 0 && n < n2 && this.validItem(this.selectedRow)) {
            if (this.editMode) {
                this.listener.entryChanged(this.selectedIndex);
            }
            if (n != this.selectedIndex) {
                if (this.selectedRow != null) {
                    this.selectedRow.deselect();
                }
                this.selectedRow = (ListItem)this.rowList.elementAt(n);
                this.selectedIndex = n;
            }
            this.selectedRow.toggle();
            if (!this.selectedRow.selected) {
                this.selectedIndex = -1;
            }
            this.repaint();
        }
        this.requestFocus();
        this.editMode = false;
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        this.topIndex = this.vbar.getValue();
        this.repaint();
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (this.rowList == null || this.selectedRow == null) {
            return;
        }
        this.rowList.size();
        int n = keyEvent.getKeyCode();
        if (keyEvent.isActionKey()) {
            if (this.selectedIndex < 0) {
                return;
            }
            if (n == 39 || n == 37) {
                if (!this.editMode) {
                    this.listener.entryChanged(this.selectedIndex);
                    this.selectedRow.setEditMode(true);
                    this.editMode = true;
                }
            } else {
                if (n == 38) {
                    if (!this.validItem(this.selectedRow)) {
                        return;
                    }
                    if (this.editMode) {
                        this.listener.entryChanged(this.selectedIndex);
                        this.selectedRow.setEditMode(false);
                    }
                    if (this.selectedIndex - 1 >= 0) {
                        this.select(--this.selectedIndex);
                    }
                    this.editMode = false;
                    return;
                }
                if (n == 40) {
                    if (!this.validItem(this.selectedRow)) {
                        return;
                    }
                    if (this.editMode) {
                        this.listener.entryChanged(this.selectedIndex);
                        this.selectedRow.setEditMode(false);
                    }
                    if (this.selectedIndex + 1 < this.rowList.size()) {
                        this.select(++this.selectedIndex);
                    }
                    this.editMode = false;
                    return;
                }
            }
        }
        if (n == 10 && this.editMode) {
            if (!this.validItem(this.selectedRow)) {
                return;
            }
            this.listener.entryChanged(this.selectedIndex);
            this.selectedRow.deselect();
            this.selectedIndex = -1;
            this.repaint();
            return;
        }
        if (!this.editMode) {
            this.editMode = true;
            this.listener.entryChanged(this.selectedIndex);
            this.selectedRow.clear();
        }
        if (n != 10) {
            this.listener.entryChanged(this.selectedIndex);
            this.selectedRow.processKey(keyEvent);
        }
        this.repaint();
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        if (this.rowList == null) {
            return;
        }
        int n = this.rowList.size();
        if (this.image == null) {
            this.image = this.createImage(dimension.width, dimension.height);
        }
        Graphics graphics2 = this.image.getGraphics();
        graphics2.setColor(this.background);
        graphics2.fillRect(0, 0, dimension.width, dimension.height);
        n = this.rowList.size();
        int n2 = 0;
        int n3 = this.topIndex;
        while (n3 < this.topIndex + this.visible && n3 < n) {
            ((ListItem)this.rowList.elementAt(n3)).paint(graphics2, n2++);
            ++n3;
        }
        graphics.drawImage(this.image, 0, 0, null);
        graphics2.dispose();
    }

    static void assert(boolean bl) throws IllegalArgumentException {
        if (!bl) {
            throw new IllegalArgumentException("Assertion failed ");
        }
    }
}

