/*
 * Decompiled with CFR 0.152.
 */
package snac;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import snac.SnacConstants;
import snac.SnacTlv;
import snac.TLV;

public class SnacNickinfo
implements SnacConstants {
    private static final String MODULE = "SNAC";
    public int currentEvil;
    public int numTlvs;
    public TLV userAttributes;

    public SnacNickinfo(int n, int n2, TLV tLV) {
        this.currentEvil = n;
        this.numTlvs = n2;
        this.userAttributes = tLV;
    }

    SnacNickinfo(DataInputStream dataInputStream) throws IOException {
        this.currentEvil = dataInputStream.readUnsignedShort();
        this.numTlvs = dataInputStream.readUnsignedShort();
        this.userAttributes = new TLV();
        int n = 0;
        while (n < this.numTlvs && dataInputStream.available() > 0) {
            this.userAttributes.addElement(new SnacTlv(dataInputStream));
            ++n;
        }
        if (n < this.numTlvs) {
            throw new IOException("read underflow");
        }
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(this.currentEvil);
        dataOutputStream.writeShort(this.numTlvs);
        int n = 0;
        while (n < this.numTlvs && n < this.userAttributes.size()) {
            ((SnacTlv)this.userAttributes.elementAt(n)).write(dataOutputStream);
            ++n;
        }
    }
}

