/*
 * Decompiled with CFR 0.152.
 */
package snac;

import flap.FLAPSock;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Vector;
import snac.DispatcherListener;
import snac.Listener;
import snac.LocateHostListener;
import snac.SNACHeader;
import snac.SnacHandler;
import snac.SnacNickname;
import snac.SnacNicknameWinfo;
import snac.SnacTlv;
import snac.TLV;
import uiutil.ErrorMgr;
import util.Log;
import util.OutputBuffer;

public class LocateHostHandler
extends SnacHandler {
    private static final String MODULE = "SNAC";

    public LocateHostHandler(DispatcherListener dispatcherListener) {
        this.dispatcher = dispatcherListener;
        dispatcherListener.registerSNACHandler(2, 1, this);
    }

    private void decodeRightsQuery(FLAPSock fLAPSock, SNACHeader sNACHeader, DataInputStream dataInputStream, Listener listener, Object object, Vector vector) throws IOException {
        Log.log(MODULE, Log.DB1, "got locateRightsQuery SNAC");
        LocateHostListener locateHostListener = (LocateHostListener)listener;
        int n = this.initHandledState();
        if (locateHostListener != null) {
            n = this.updateHandledState(n, locateHostListener.locateRightsQuery(fLAPSock, object, sNACHeader.reqID, n));
        }
        int n2 = 0;
        while (vector != null && n2 < vector.size() && this.proceed(n)) {
            LocateHostListener locateHostListener2 = (LocateHostListener)vector.elementAt(n2);
            if (locateHostListener2 != locateHostListener) {
                n = this.updateHandledState(n, locateHostListener2.locateRightsQuery(fLAPSock, object, sNACHeader.reqID, n));
            }
            ++n2;
        }
    }

    public void rightsReply(FLAPSock fLAPSock, LocateHostListener locateHostListener, Object object, TLV tLV) {
        Log.log(MODULE, Log.DB1, "writing locateRightsReply SNAC");
        OutputBuffer outputBuffer = new OutputBuffer(100);
        try {
            int n = 0;
            while (n < tLV.size()) {
                ((SnacTlv)tLV.elementAt(n)).write(outputBuffer);
                ++n;
            }
            this.dispatcher.queueOutput(fLAPSock, locateHostListener, object, 2, 3, null, outputBuffer.bytes());
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("Locate", "got IOException in locateRightsReply " + iOException.getMessage(), iOException);
            fLAPSock.close("problems writing to server", 28);
            return;
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void decodeSetInfo(FLAPSock fLAPSock, SNACHeader sNACHeader, DataInputStream dataInputStream, Listener listener, Object object, Vector vector) throws IOException {
        Log.log(MODULE, Log.DB1, "got locateSetInfo SNAC");
        LocateHostListener locateHostListener = (LocateHostListener)listener;
        try {
            block8: {
                int n;
                int n2;
                TLV tLV;
                block7: {
                    tLV = new TLV();
                    while (dataInputStream.available() > 0) {
                        tLV.addElement(new SnacTlv(dataInputStream));
                    }
                    n2 = this.initHandledState();
                    if (locateHostListener != null) {
                        n2 = this.updateHandledState(n2, locateHostListener.locateSetInfo(fLAPSock, object, sNACHeader.reqID, n2, tLV));
                    }
                    n = 0;
                    if (!true) break block7;
                    if (vector == null) return;
                    if (n >= vector.size()) return;
                    if (!this.proceed(n2)) break block8;
                }
                do {
                    LocateHostListener locateHostListener2;
                    if ((locateHostListener2 = (LocateHostListener)vector.elementAt(n)) != locateHostListener) {
                        n2 = this.updateHandledState(n2, locateHostListener2.locateSetInfo(fLAPSock, object, sNACHeader.reqID, n2, tLV));
                    }
                    ++n;
                    if (vector == null) return;
                    if (n >= vector.size()) return;
                } while (this.proceed(n2));
            }
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("Locate", "got IOException in locateSetInfo " + iOException.getMessage(), iOException);
            fLAPSock.close("problems reading from server", 23);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void decodeUserInfoQuery(FLAPSock fLAPSock, SNACHeader sNACHeader, DataInputStream dataInputStream, Listener listener, Object object, Vector vector) throws IOException {
        Log.log(MODULE, Log.DB1, "got locateUserInfoQuery SNAC");
        LocateHostListener locateHostListener = (LocateHostListener)listener;
        try {
            int n = dataInputStream.readUnsignedShort();
            SnacNickname snacNickname = new SnacNickname(dataInputStream);
            int n2 = this.initHandledState();
            if (locateHostListener != null) {
                n2 = this.updateHandledState(n2, locateHostListener.locateUserInfoQuery(fLAPSock, object, sNACHeader.reqID, n2, n, snacNickname));
            }
            int n3 = 0;
            while (vector != null) {
                if (n3 >= vector.size()) return;
                if (!this.proceed(n2)) {
                    return;
                }
                LocateHostListener locateHostListener2 = (LocateHostListener)vector.elementAt(n3);
                if (locateHostListener2 != locateHostListener) {
                    n2 = this.updateHandledState(n2, locateHostListener2.locateUserInfoQuery(fLAPSock, object, sNACHeader.reqID, n2, n, snacNickname));
                }
                ++n3;
            }
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("Locate", "got IOException in locateUserInfoQuery " + iOException.getMessage(), iOException);
            fLAPSock.close("problems reading from server", 23);
        }
    }

    public void userInfoReply(FLAPSock fLAPSock, LocateHostListener locateHostListener, Object object, SnacNicknameWinfo snacNicknameWinfo, TLV tLV) {
        Log.log(MODULE, Log.DB1, "writing locateUserInfoReply SNAC");
        OutputBuffer outputBuffer = new OutputBuffer(100);
        try {
            snacNicknameWinfo.write(outputBuffer);
            int n = 0;
            while (n < tLV.size()) {
                ((SnacTlv)tLV.elementAt(n)).write(outputBuffer);
                ++n;
            }
            this.dispatcher.queueOutput(fLAPSock, locateHostListener, object, 2, 6, null, outputBuffer.bytes());
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("Locate", "got IOException in locateUserInfoReply " + iOException.getMessage(), iOException);
            fLAPSock.close("problems writing to server", 28);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void decodeWatcherSubRequest(FLAPSock fLAPSock, SNACHeader sNACHeader, DataInputStream dataInputStream, Listener listener, Object object, Vector vector) throws IOException {
        Log.log(MODULE, Log.DB1, "got locateWatcherSubRequest SNAC");
        LocateHostListener locateHostListener = (LocateHostListener)listener;
        try {
            int n = dataInputStream.readUnsignedShort();
            int n2 = this.initHandledState();
            if (locateHostListener != null) {
                n2 = this.updateHandledState(n2, locateHostListener.locateWatcherSubRequest(fLAPSock, object, sNACHeader.reqID, n2, n));
            }
            int n3 = 0;
            while (vector != null) {
                if (n3 >= vector.size()) return;
                if (!this.proceed(n2)) {
                    return;
                }
                LocateHostListener locateHostListener2 = (LocateHostListener)vector.elementAt(n3);
                if (locateHostListener2 != locateHostListener) {
                    n2 = this.updateHandledState(n2, locateHostListener2.locateWatcherSubRequest(fLAPSock, object, sNACHeader.reqID, n2, n));
                }
                ++n3;
            }
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("Locate", "got IOException in locateWatcherSubRequest " + iOException.getMessage(), iOException);
            fLAPSock.close("problems reading from server", 23);
        }
    }

    public void watcherNotification(FLAPSock fLAPSock, LocateHostListener locateHostListener, Object object, Vector vector) {
        Log.log(MODULE, Log.DB1, "writing locateWatcherNotification SNAC");
        OutputBuffer outputBuffer = new OutputBuffer(100);
        try {
            int n = 0;
            while (n < vector.size()) {
                ((SnacNickname)vector.elementAt(n)).write(outputBuffer);
                ++n;
            }
            this.dispatcher.queueOutput(fLAPSock, locateHostListener, object, 2, 8, null, outputBuffer.bytes());
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("Locate", "got IOException in locateWatcherNotification " + iOException.getMessage(), iOException);
            fLAPSock.close("problems writing to server", 28);
            return;
        }
    }

    public void decodeSNAC(FLAPSock fLAPSock, SNACHeader sNACHeader, DataInputStream dataInputStream, Listener listener, Object object, Vector vector) throws IOException {
        if (sNACHeader.subtype == 1) {
            this.decodeSnacError(fLAPSock, sNACHeader, dataInputStream, listener, object, vector);
            return;
        }
        if (sNACHeader.subtype == 2) {
            this.decodeRightsQuery(fLAPSock, sNACHeader, dataInputStream, listener, object, vector);
            return;
        }
        if (sNACHeader.subtype == 4) {
            this.decodeSetInfo(fLAPSock, sNACHeader, dataInputStream, listener, object, vector);
            return;
        }
        if (sNACHeader.subtype == 5) {
            this.decodeUserInfoQuery(fLAPSock, sNACHeader, dataInputStream, listener, object, vector);
            return;
        }
        if (sNACHeader.subtype == 7) {
            this.decodeWatcherSubRequest(fLAPSock, sNACHeader, dataInputStream, listener, object, vector);
            return;
        }
        ErrorMgr.warn("Locate", " got unrecognized SNAC " + sNACHeader + " ignoring");
        fLAPSock.close("server sending bad data", 23);
    }
}

