/*
 * Decompiled with CFR 0.152.
 */
package module;

import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import main.Oscar;
import module.Module;
import uiutil.ErrorMgr;
import uiutil.MediaStore;
import uiutil.UIPack;
import util.JarFile;
import util.KeyBindings;

public class Modules {
    private static final String MODULE = "Modules";
    static Hashtable loadedModules = new Hashtable();
    protected static final int FILENOTFOUND_ERROR = 1;
    protected static final int FILENOTREAD_ERROR = 2;
    protected static final int INTERFACE_ERROR = 3;
    protected static final int FILETYPEUNKNOWN_ERROR = 4;
    protected static final int UNKNOWN_ERROR = 5;

    static void register(Module module) {
        loadedModules.put(module.getModuleName(), module);
    }

    public static Enumeration keys() {
        return loadedModules.keys();
    }

    public static Enumeration elements() {
        return loadedModules.elements();
    }

    public static Module lookup(String string) {
        return (Module)loadedModules.get(string);
    }

    protected static void displayError(int n, String string) {
        String string2 = null;
        switch (n) {
            case 1: {
                string2 = "The module " + string + " could not found.";
                break;
            }
            case 2: {
                string2 = "The module " + string + " was found, however aim doesn't have " + "permission to read it.  Please use chmod to change the file " + "permissions.";
                break;
            }
            case 4: {
                string2 = "The module " + string + " could not be loaded because it " + "is an unknown file type.";
                break;
            }
            case 3: {
                string2 = "The module contained in " + string + " does not implement " + "the correct interface.  It can not be loaded.  You may " + "need to upgrade to a newer version of the modules.";
                break;
            }
            default: {
                string2 = "The module " + string + " could not be fully loaded.   It " + "might not be packaged correctly, or you need to upgrade it " + "to a newer version.";
            }
        }
        ErrorMgr.warn("Module Loader", string2);
    }

    public static Module loadModule(String string, Class clazz) {
        if (string.endsWith(".class")) {
            try {
                String string2 = string.substring(0, string.length() - 6);
                Class<?> clazz2 = Class.forName(string2);
                if (clazz != null && !clazz.isAssignableFrom(clazz2)) {
                    Modules.displayError(3, string);
                    return null;
                }
                Module module = (Module)clazz2.newInstance();
                Modules.register(module);
                return module;
            }
            catch (Throwable throwable) {
                Modules.displayError(5, string);
                throwable.printStackTrace();
            }
        } else {
            if (string.endsWith(".jar")) {
                File file = new File(String.valueOf(Oscar.CONFIG_DIR) + "modules", string);
                if (!file.exists()) {
                    file = new File(String.valueOf(Oscar.ROOT) + "modules", string);
                }
                if (!file.exists()) {
                    Modules.displayError(1, string);
                    return null;
                }
                if (!file.canRead()) {
                    Modules.displayError(2, string);
                    return null;
                }
                try {
                    JarFile jarFile = new JarFile(file.getPath());
                    jarFile.loadEntireJar();
                    Vector vector = jarFile.getBeanNames();
                    if (vector.size() < 1) {
                        return null;
                    }
                    String string3 = (String)vector.elementAt(0);
                    Class clazz3 = jarFile.loadClass(string3);
                    if (clazz != null && !clazz.isAssignableFrom(clazz3)) {
                        Modules.displayError(3, string);
                        return null;
                    }
                    Module module = (Module)clazz3.newInstance();
                    Modules.register(module);
                    if (module instanceof UIPack) {
                        int n = string3.lastIndexOf(46);
                        String string4 = string3.substring(0, n + 1);
                        string4 = string4.replace('.', '/');
                        String string5 = module.getModuleName();
                        MediaStore.loadJarFileUIPack(jarFile, string4, string5, 255);
                    }
                    return module;
                }
                catch (Throwable throwable) {
                    Modules.displayError(5, string);
                    throwable.printStackTrace();
                    return null;
                }
            }
            Modules.displayError(4, string);
        }
        return null;
    }

    public static Vector loadModules(KeyBindings keyBindings, Class clazz) {
        Vector<Module> vector = new Vector<Module>();
        if (keyBindings == null) {
            return vector;
        }
        int n = 0;
        while (n < keyBindings.size()) {
            Module module = Modules.loadModule(keyBindings.getKeyAt(n), clazz);
            if (module != null) {
                vector.addElement(module);
            }
            ++n;
        }
        return vector;
    }
}

