/*
 * Decompiled with CFR 0.152.
 */
package main;

import component.SLCommandHandler;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import main.LoginAPI;
import main.LoginCore;
import main.Oscar;
import uiutil.ChoiceUI;
import uiutil.ErrorMgr;
import uiutil.IUtil;
import uiutil.Icon;
import uiutil.ImagePanel;
import uiutil.MediaStore;
import uiutil.MultiLineLabel;
import uiutil.OFrame;
import uiutil.PasswordField;
import uiutil.SuperLayout;
import util.JUtil;
import util.KeyBindings;

class LoginUI
extends OFrame
implements LoginAPI,
KeyListener,
ActionListener,
WindowListener,
MouseListener,
FocusListener {
    private static int LOGIN_COLUMNS = 33;
    private LoginCore core;
    private ImagePanel main;
    private Component setupButton;
    private Component helpButton;
    private Component loginButton;
    private Component stopButton;
    private Component registerButton;
    private TextField nicknameField;
    private PasswordField passwordField;
    private Icon logo;
    private MultiLineLabel messageArea;
    private boolean connecting = false;
    private Thread loginLoop;
    private Rectangle versionBox;

    public LoginUI(LoginCore loginCore, String string) {
        this.core = loginCore;
        if (string == null) {
            string = " ";
        }
        this.setTitle("Login");
        this.setLayout(new BorderLayout());
        this.setResizable(false);
        this.main = new ImagePanel();
        this.add("Center", this.main);
        SuperLayout superLayout = new SuperLayout(this.main, this.core);
        this.main.setLayout(superLayout);
        this.nicknameField = new TextField(12);
        this.main.add("ScreenName", this.nicknameField);
        this.nicknameField.addKeyListener(this);
        KeyBindings keyBindings = Oscar.config.getKeyBindingsOrAdd(LoginCore.LOGIN_KEY);
        String string2 = keyBindings.getValue(LoginCore.NICKNAME_KEY);
        if (string2 != null) {
            ((TextComponent)this.nicknameField).setText(string2);
        }
        this.passwordField = new PasswordField(12);
        this.main.add("Password", this.passwordField);
        this.passwordField.setEchoChar('*');
        this.passwordField.addKeyListener(this);
        string2 = JUtil.getPassword(keyBindings, LoginCore.PASSWORD_KEY);
        if (string2 != null) {
            this.passwordField.setPassword(string2);
        }
        this.messageArea = new MultiLineLabel(IUtil.format(string, LOGIN_COLUMNS), MultiLineLabel.LEFT);
        this.main.add("MessageArea", this.messageArea);
        superLayout.loadLayout("loginwindow.lay");
        this.registerButton = superLayout.getLayoutComponent("Register");
        this.setupButton = superLayout.getLayoutComponent("Setup");
        SLCommandHandler.addActionListener(this.setupButton, this);
        this.helpButton = superLayout.getLayoutComponent("Help");
        SLCommandHandler.addActionListener(this.helpButton, this);
        this.loginButton = superLayout.getLayoutComponent("Login");
        SLCommandHandler.addActionListener(this.loginButton, this);
        this.stopButton = superLayout.getLayoutComponent("Stop");
        SLCommandHandler.addActionListener(this.stopButton, this);
        Component component = superLayout.getLayoutComponent("Logo");
        if (component != null && component instanceof Icon) {
            this.logo = (Icon)component;
        }
        this.pack();
        Dimension dimension = this.getToolkit().getScreenSize();
        ((Component)this).setLocation((dimension.width - this.getSize().width) / 2, (dimension.height - this.getSize().height) / 2);
        ((Component)this).setVisible(true);
        this.addMouseListener(this);
        this.addWindowListener(this);
        this.addFocusListener(this);
        this.nicknameField.selectAll();
        this.nicknameField.requestFocus();
        this.stopButton.setVisible(false);
        this.loginButton.setVisible(true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.stopButton) {
            this.core.cancel();
            this.stopLogin();
            return;
        }
        if (object == this.loginButton) {
            this.startLogin();
            return;
        }
        if (object == this.helpButton) {
            ChoiceUI.newChoiceUI("Help", "   In order to log in successfully, you'll need a valid screen name and password. If you do not yet have a screen name, you can press the `Signup' button at the bottom left of the login window. This will take you to a Web page whose link you can follow to register a screen name.\n \n   If you encounter errors while attempting either to register or to log on, you can press the `Setup' button. This will take you to a window in which you can change various settings. The setup screen is divided into three distinct areas. On the left side, there is a selectable list of configurable components. Clicking on any item in this list displays a related configuration panel to the right. For example, if you have problems with logging in, click on the `Login' entry. If you have problems with launching a browser, click on the `Browser' entry. \n \n   At the bottom of the setup window, there is a row of buttons that you can use to effect the changes you make in the configuration panel. Use the `OK' or `Apply' button to accept the changes and the `Cancel' button if you not wish to accept the changes. You can also press the `Help' button if you want more information about how to use the configuration panel. \n \n   The configuration panel (the tabbed panel area) occupies most of the setup display window and contains various widgets on which you can click to change the options related to the category on the left. Depending on the category you select, you may see multiple tabs near the top of the setup panel. You can click each tab to see more modifiable options. Note that the `Help' button displays instructions related only to the currently visible configuration panel.", MultiLineLabel.BORDER_SIMPLE);
            return;
        }
        if (object == this.setupButton) {
            Oscar.setup(null, 0);
        }
    }

    public void addNotify() {
        super.addNotify();
        String string = "version " + Oscar.version + Oscar.build;
        if (this.logo == null) {
            this.messageArea.setLabel(string);
            return;
        }
        Insets insets = this.getInsets();
        Insets insets2 = this.main.getInsets();
        Image image = this.logo.getImage();
        Dimension dimension = new Dimension(image.getWidth(this), image.getHeight(this));
        Image image2 = this.createImage(dimension.width, dimension.height);
        Font font = new Font("helvetica", 0, 9);
        FontMetrics fontMetrics = this.getFontMetrics(font);
        Graphics graphics = image2.getGraphics();
        int n = fontMetrics.stringWidth(string);
        int n2 = fontMetrics.getMaxDescent() + fontMetrics.getMaxAscent();
        this.versionBox = new Rectangle((dimension.width - n) / 2, dimension.height - n2 - 1, n, n2);
        graphics.setFont(font);
        graphics.setColor(Color.white);
        graphics.drawImage(image, 0, 0, this);
        graphics.drawString(string, this.versionBox.x, this.versionBox.y + fontMetrics.getMaxAscent());
        this.versionBox.width += 20;
        this.versionBox.height += 20;
        this.versionBox.x += insets.left + insets2.left;
        this.versionBox.y += insets.top + insets2.top;
        this.logo.setImage(image2);
    }

    public void focusLost(FocusEvent focusEvent) {
    }

    public void focusGained(FocusEvent focusEvent) {
        Object object = focusEvent.getSource();
        if (object == this.nicknameField) {
            this.nicknameField.selectAll();
            return;
        }
        if (object == this.passwordField) {
            this.passwordField.selectAll();
        }
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        Oscar.app.shutdown();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this.versionBox != null && this.versionBox.contains(mouseEvent.getX(), mouseEvent.getY())) {
            Oscar.displayVersion();
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        Component component = keyEvent.getComponent();
        int n = keyEvent.getKeyCode();
        if (component == this.nicknameField && (keyEvent.getKeyChar() == '\t' || n == 10)) {
            this.nicknameField.select(0, 0);
            this.passwordField.selectAll();
            this.passwordField.requestFocus();
            return;
        }
        if (component == this.passwordField && !this.connecting && n == 10) {
            this.startLogin();
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void removeNotify() {
        this.removeAll();
        this.core = null;
        this.main = null;
        this.setupButton = null;
        this.helpButton = null;
        this.loginButton = null;
        this.stopButton = null;
        this.registerButton = null;
        this.nicknameField = null;
        this.passwordField = null;
        this.logo = null;
        this.messageArea = null;
        IUtil.stopLoopingSound(this.loginLoop);
        this.loginLoop = null;
        this.versionBox = null;
        this.setLayout(null);
    }

    public void setNameAndPassword(String string, String string2) {
        if (string != null && this.nicknameField != null) {
            ((TextComponent)this.nicknameField).setText(string);
        }
        if (string2 != null && this.passwordField != null) {
            this.passwordField.setPassword(string2);
        }
    }

    public synchronized void shutdown() {
        ((Component)this).setVisible(false);
        this.dispose();
        MediaStore.unloadUIPack("tool.login");
    }

    public void startLogin() {
        if (Oscar.validateNickname(this.nicknameField.getText()) == null) {
            ErrorMgr.warn("Login", "The screen name you entered is not a valid screen name");
            return;
        }
        if (!Oscar.validatePassword(this.passwordField.getPassword())) {
            ErrorMgr.warn("Login", "The password you entered is not a valid password");
            return;
        }
        this.stopButton.setVisible(true);
        this.loginButton.setVisible(false);
        this.connecting = true;
        this.setupButton.setEnabled(false);
        this.helpButton.setEnabled(false);
        if (this.registerButton != null) {
            this.registerButton.setEnabled(false);
        }
        this.nicknameField.setEnabled(false);
        this.passwordField.setEnabled(false);
        this.core.doLogin(this.nicknameField.getText(), this.passwordField.getPassword());
    }

    public void stopLogin() {
        this.stopButton.setVisible(false);
        this.loginButton.setVisible(true);
        this.connecting = false;
        this.setupButton.setEnabled(true);
        this.helpButton.setEnabled(true);
        if (this.registerButton != null) {
            this.registerButton.setEnabled(true);
        }
        this.nicknameField.setEnabled(true);
        this.passwordField.setEnabled(true);
        IUtil.stopLoopingSound(this.loginLoop);
    }

    public void update(int n, String string) {
        if (n == 5) {
            this.stopButton.setEnabled(false);
            this.loginButton.setEnabled(false);
            IUtil.stopLoopingSound(this.loginLoop);
            this.loginLoop = null;
            IUtil.playSound(this.core, "Connect");
        } else if (n == 2) {
            this.loginLoop = IUtil.playLoopingSound(this.core, "LoginLoop");
        }
        switch (n) {
            case -1: {
                this.messageArea.setLabel(IUtil.format(string, LOGIN_COLUMNS));
                this.stopLogin();
                return;
            }
            case -2: {
                this.messageArea.setLabel(IUtil.format(string, LOGIN_COLUMNS));
                return;
            }
            default: {
                this.messageArea.setLabel(IUtil.format(string, LOGIN_COLUMNS));
            }
            case 0: 
        }
    }
}

