/*
 * Decompiled with CFR 0.152.
 */
package main;

import main.ChatRoomDesc;
import main.ChatRoomFullDesc;
import main.ChatRoomID;
import snac.SnacConstants;
import snac.TLV;

public class ChatRoom
implements SnacConstants {
    public static final int SHORT_DESCRIPTION = 1;
    public static final int FULL_DESCRIPTION = 2;
    public static final int DEFAULT_EXCHANGE = -1;
    public static final int DEFAULT_INSTANCE = -1;
    private ChatRoomID id;
    private int detailLevel;
    private ChatRoomDesc description;
    private ChatRoomFullDesc fullDescription;

    public ChatRoom() {
        this.id = null;
        this.detailLevel = 0;
        this.description = null;
        this.fullDescription = null;
    }

    public ChatRoom(ChatRoomID chatRoomID, int n, ChatRoomDesc chatRoomDesc, ChatRoomFullDesc chatRoomFullDesc) {
        this.id = chatRoomID;
        this.detailLevel = n;
        this.description = chatRoomDesc;
        this.fullDescription = chatRoomFullDesc;
    }

    public ChatRoom(snac.ChatRoomDesc chatRoomDesc) {
        if (chatRoomDesc.id != null) {
            int n = chatRoomDesc.id.exchange;
            byte[] byArray = null;
            int n2 = chatRoomDesc.id.instancenum;
            if (chatRoomDesc.id.cookieLength > 0) {
                byArray = chatRoomDesc.id.cookie;
            }
            this.id = new ChatRoomID(n, byArray, n2);
        }
        this.detailLevel = chatRoomDesc.detaillvl;
        if (chatRoomDesc.description != null) {
            TLV tLV = chatRoomDesc.description.tlv;
            this.description = new ChatRoomDesc();
            if (tLV.tlvTypePresent(211)) {
                this.description.setName(tLV.getTlvDataAsString(211));
            }
            if (tLV.tlvTypePresent(106)) {
                this.description.setFullName(tLV.getTlvDataAsString(106));
            }
            tLV.tlvTypePresent(201);
            if (tLV.tlvTypePresent(207)) {
                this.description.setLanguage(tLV.getTlvDataAsString(207));
            }
            if (tLV.tlvTypePresent(209)) {
                this.description.setMaxMessageLength(tLV.getTlvDataAsU16(209));
            }
            if (tLV.tlvTypePresent(210)) {
                this.description.setMaxMessageLength(tLV.getTlvDataAsU16(210));
            }
        }
    }

    public byte[] getCookie() {
        if (this.id != null) {
            return this.id.getCookie();
        }
        return null;
    }

    public int getDetailLevel() {
        return this.detailLevel;
    }

    public int getExchange() {
        if (this.id != null) {
            return this.id.getExchange();
        }
        return -1;
    }

    public int getInstance() {
        if (this.id != null) {
            return this.id.getInstance();
        }
        return -1;
    }

    public String getName() {
        if (this.description != null) {
            return this.description.getName();
        }
        return null;
    }

    public void setCookie(byte[] byArray) {
        if (this.id == null) {
            this.id = new ChatRoomID(-1, byArray, -1);
            return;
        }
        this.id.setCookie(byArray);
    }

    public void setDetailLevel(int n) {
        this.detailLevel = n;
    }

    public void setExchange(int n) {
        if (this.id == null) {
            this.id = new ChatRoomID(n, null, -1);
            return;
        }
        this.id.setExchange(n);
    }

    public void setInstance(int n) {
        if (this.id == null) {
            this.id = new ChatRoomID(-1, null, n);
            return;
        }
        this.id.setInstance(n);
    }

    public void setName(String string) {
        if (this.description == null) {
            this.description = new ChatRoomDesc();
        }
        this.description.setName(string);
    }

    public String toString(String string) {
        String string2 = String.valueOf(string) + "Chat Room ID:\n";
        string2 = this.id != null ? String.valueOf(string2) + this.id.toString(String.valueOf(string) + "  ") : String.valueOf(string2) + string + "  null\n";
        string2 = String.valueOf(string2) + string + "Chat Room Detail Level: " + this.detailLevel + "\n";
        if (this.detailLevel >= 1) {
            string2 = String.valueOf(string2) + string + "Chat Room Description:\n";
            string2 = this.description != null ? String.valueOf(string2) + this.description.toString(String.valueOf(string) + "  ") : String.valueOf(string2) + string + "null\n";
        }
        if (this.detailLevel == 2) {
            string2 = String.valueOf(string2) + "Chat Room Additional Description:\n";
            string2 = this.fullDescription != null ? String.valueOf(string2) + this.fullDescription.toString(String.valueOf(string) + "  ") : String.valueOf(string2) + string + "null\n";
        }
        return string2;
    }
}

