/*
 * Decompiled with CFR 0.152.
 */
package component;

import component.OscarLabelButton;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import main.Oscar;
import uiutil.ImageLabel;
import uiutil.ImagePanel;
import uiutil.LightBar;
import uiutil.OFrame;
import uiutil.TransparentPanel;
import uiutil.UIPack;
import uiutil.UrlViewer;

public class StatusFrame
extends OFrame
implements ActionListener,
UIPack,
WindowListener {
    private static String[] UIPACK_NAMES = new String[]{"tool.statusframe"};
    public static int STATUS_NORMAL;
    public static int STATUS_WAITING;
    public static int STATUS_SUCCESS;
    public static int STATUS_FAILURE;
    private ImagePanel main;
    private ImagePanel statusPanel;
    private OscarLabelButton infoButton;
    private String infoUrl;
    private LightBar waitMeter;
    private int status;
    private ImageLabel statusText;

    public StatusFrame(String string) {
        this.addWindowListener(this);
        this.setResizable(false);
        ((Component)this).setBackground(Oscar.backgroundColor);
        this.setTitle(string);
        this.setLayout(new BorderLayout());
        this.main = new ImagePanel();
        this.add("Center", this.main);
        Image image = Oscar.images.getImage(this, Oscar.BG_TILE, this.main, true);
        this.main.setTile(image);
        this.main.setLayout(new BorderLayout());
        this.statusPanel = new ImagePanel();
        this.add("South", this.statusPanel);
        this.statusPanel.setLayout(new BorderLayout());
        this.statusPanel.setTile(image);
        this.waitMeter = new LightBar(6);
        this.waitMeter.setLightDiameter(6);
        this.waitMeter.setPads(5, 10);
        this.statusPanel.add("West", this.waitMeter);
        this.statusText = new ImageLabel("");
        this.statusPanel.add("Center", this.statusText);
        this.infoButton = new OscarLabelButton("More Info", this, this.statusPanel);
        this.statusPanel.add("East", this.infoButton);
        this.infoButton.addActionListener(this);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object.equals(this.infoButton)) {
            new UrlViewer(this.infoUrl);
        }
    }

    public String[] getUIPackNames() {
        return UIPACK_NAMES;
    }

    public int getStatus() {
        return this.status;
    }

    public void removeNotify() {
        this.removeAll();
        this.main = null;
        this.statusPanel = null;
        this.infoButton = null;
        this.infoUrl = null;
        this.waitMeter = null;
        this.statusText = null;
        this.setLayout(null);
    }

    public void removeStatusPanel() {
        this.remove(this.statusPanel);
    }

    public void setContents(TransparentPanel transparentPanel) {
        this.main.add("Center", transparentPanel);
        this.pack();
        Dimension dimension = this.getToolkit().getScreenSize();
        Dimension dimension2 = this.getSize();
        ((Component)this).setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
        this.infoButton.setVisible(false);
    }

    public void setStatus(int n) {
        this.setStatus(n, null, null);
    }

    public void setStatus(int n, String string) {
        this.setStatus(n, string, null);
    }

    public void setStatus(int n, String string, String string2) {
        this.status = n;
        if (n == STATUS_NORMAL) {
            this.waitMeter.setMode(LightBar.MODE_OFF);
        } else if (n == STATUS_WAITING) {
            this.waitMeter.setColor(Color.yellow);
            this.waitMeter.setMode(LightBar.MODE_BOUNCE);
        } else if (n == STATUS_SUCCESS) {
            this.waitMeter.setColor(Color.green);
            this.waitMeter.setMode(LightBar.MODE_ON);
        } else if (n == STATUS_FAILURE) {
            this.waitMeter.setColor(Color.red);
            this.waitMeter.setMode(LightBar.MODE_FLASH);
        }
        if (string != null) {
            this.statusText.setText(string);
        }
        if (string2 != null) {
            this.infoButton.setVisible(true);
            this.infoUrl = string2;
            return;
        }
        this.infoButton.setVisible(false);
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.dispose();
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    static {
        STATUS_WAITING = 1;
        STATUS_SUCCESS = 2;
        STATUS_FAILURE = 3;
    }
}

