/*
 * Decompiled with CFR 0.152.
 */
package component;

import component.BuddyCore;
import component.User;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import main.Nickname;
import main.Oscar;
import uiutil.ImageTree;
import uiutil.Popup;
import uiutil.TreeNode;
import util.JUtil;

class BuddyDisplay
extends ImageTree
implements ItemListener,
MouseListener {
    private final String displayPrefix = " ";
    private Image[] classIcons;
    private Image[] logIcons;
    private BuddyCore core;
    private String text;
    private Point loc;
    private int nodeHeight = 12;

    public BuddyDisplay(BuddyCore buddyCore, int n, Image[] imageArray, Image[] imageArray2) {
        this.setMinHeight(Oscar.images.MINI_ICON_SIZE);
        this.core = buddyCore;
        this.classIcons = imageArray;
        this.logIcons = imageArray2;
        super.addItemListener(this);
        super.addMouseListener(this);
    }

    public void addBuddyList(String string, int n, int n2) {
        if (this.get(string) == null) {
            String string2 = this.displayNameFromListName(string, n, n2);
            this.add(new TreeNode(string, this.makeItem(string2)));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean addBuddy(String string, User user, int n) {
        String string2 = Nickname.normalize(user.name);
        TreeNode treeNode = this.get(string);
        TreeNode treeNode2 = this.get(treeNode, string2);
        if (treeNode != null) {
            if (treeNode2 != null) return false;
            String string3 = this.displayNameFromNickname(user.name, n);
            TreeNode treeNode3 = new TreeNode(string2, this.makeItem(user, n, string3, this), this.makeItemSelected(user, n, string3, this));
            this.add(treeNode, treeNode3);
            return true;
        } else {
            String string4 = this.displayNameFromListName(string, 1, 1);
            treeNode = new TreeNode(string, this.makeItem(string4));
            this.add(treeNode);
            string4 = this.displayNameFromNickname(user.name, n);
            treeNode2 = new TreeNode(string2, this.makeItem(user, n, string4, this), this.makeItemSelected(user, n, string4, this));
            this.add(treeNode, treeNode2);
        }
        return true;
    }

    public int displayed(int n, String string) {
        String string2 = Nickname.normalize(string);
        TreeNode treeNode = this.get(string2);
        if (treeNode == null) {
            return -1;
        }
        return this.getIndex(treeNode);
    }

    public boolean deleteBuddy(String string, String string2) {
        int n = this.getCount();
        this.delete(string, Nickname.normalize(string2));
        return this.getCount() < n;
    }

    public boolean deleteBuddyList(String string) {
        TreeNode treeNode = this.get(string);
        if (treeNode != null) {
            this.delete(treeNode);
            return true;
        }
        return false;
    }

    private final String displayNameFromListName(String string, int n, int n2) {
        return String.valueOf(string) + " " + n + "/" + n2;
    }

    private String displayNameFromNickname(String string, int n) {
        switch (n) {
            default: 
        }
        String string2 = " " + string;
        return string2;
    }

    private String displayNameToNickname(String string) {
        String string2 = null;
        if (string != null && string.startsWith(" ")) {
            int n = string.length();
            int n2 = " ".length();
            char c = string.charAt(n - 1);
            string2 = c == '*' ? string.substring(n2, n - 1) : (c == ')' ? string.substring(n2 + 1, n - 1) : string.substring(" ".length()));
        }
        return string2;
    }

    public String getSelectedNickname() {
        String string;
        TreeNode treeNode = this.getSelectedNode();
        if (treeNode != null && (string = treeNode.getFirstString()) != null) {
            return this.displayNameToNickname(string);
        }
        return null;
    }

    public boolean buddyNamesMatch(String string, String string2) {
        boolean bl = false;
        String string3 = this.displayNameToNickname(string);
        if (string3 != null && Nickname.normalize(string2).equals(Nickname.normalize(string3))) {
            bl = true;
        }
        return bl;
    }

    public boolean isDim(String string, String string2) {
        String string3 = Nickname.normalize(string2);
        TreeNode treeNode = this.get(string);
        TreeNode treeNode2 = this.get(treeNode, string3);
        if (treeNode2 != null) {
            return treeNode2.isDim();
        }
        return false;
    }

    public boolean listNamesMatch(String string, String string2) {
        int n = string.lastIndexOf(32);
        return string2.equals(string.substring(0, n));
    }

    private final Vector makeItem(String string) {
        Vector<String> vector = new Vector<String>(1);
        vector.addElement(string);
        return vector;
    }

    private Vector makeItem(User user, int n, String string, Component component) {
        Vector<Object> vector = new Vector<Object>(5);
        switch (n) {
            case -1: {
                vector.addElement(this.logIcons[1]);
                break;
            }
            case 1: {
                vector.addElement(this.logIcons[0]);
                break;
            }
            default: {
                if (this.core.getValue(BuddyCore.SHOW_CLASS, true)) {
                    vector.addElement(this.classIcons[user.userClass + 1]);
                    break;
                }
                vector.addElement(this.classIcons[0]);
            }
        }
        vector.addElement(string);
        if (n != -1) {
            if (this.core.getValue(BuddyCore.SHOW_EVIL, false)) {
                vector.addElement(Oscar.images.evilIcon(user.evil, component, true));
            }
            if (this.core.getValue(BuddyCore.SHOW_IDLE_TIME, false)) {
                vector.addElement(Oscar.images.idleIcon((int)user.idle, component, true));
            }
            if (this.core.getValue(BuddyCore.SHOW_SIGNON_TIME, false)) {
                vector.addElement(JUtil.shortDate(user.signon));
            }
        }
        return vector;
    }

    private Vector makeItemSelected(User user, int n, String string, Component component) {
        Vector<Object> vector = new Vector<Object>(5);
        switch (n) {
            case -1: {
                vector.addElement(this.logIcons[3]);
                break;
            }
            default: {
                if (this.core.getValue(BuddyCore.SHOW_CLASS, true)) {
                    vector.addElement(this.classIcons[user.userClass + 1 + 5]);
                    break;
                }
                vector.addElement(this.classIcons[0]);
            }
        }
        vector.addElement(string);
        if (n != -1) {
            if (this.core.getValue(BuddyCore.SHOW_EVIL, false)) {
                vector.addElement(Oscar.images.evilIcon(user.evil, component, false));
            }
            if (this.core.getValue(BuddyCore.SHOW_IDLE_TIME, false)) {
                vector.addElement(Oscar.images.idleIcon((int)user.idle, component, false));
            }
            if (this.core.getValue(BuddyCore.SHOW_SIGNON_TIME, false)) {
                vector.addElement(JUtil.shortDate(user.signon));
            }
        }
        return vector;
    }

    public void removeNotify() {
        this.classIcons = null;
        this.logIcons = null;
        this.core = null;
        this.loc = null;
        super.removeNotify();
    }

    public void renameBuddyList(String string, String string2, int n, int n2) {
        if (string == null || string2 == null) {
            return;
        }
        TreeNode treeNode = this.get(string);
        if (treeNode != null) {
            String string3 = this.displayNameFromListName(string2, n, n2);
            treeNode.setName(string2);
            treeNode.setContents(this.makeItem(string3));
            this.redrawItems();
        }
    }

    public Vector updateBuddy(String string, User user, int n) {
        Vector vector = null;
        String string2 = Nickname.normalize(user.name);
        TreeNode treeNode = this.get(string);
        if (treeNode == null) {
            return null;
        }
        TreeNode treeNode2 = this.get(treeNode, string2);
        if (treeNode2 != null) {
            String string3 = this.displayNameFromNickname(user.name, n);
            treeNode2.setContents(this.makeItem(user, n, string3, this), this.makeItemSelected(user, n, string3, this));
            treeNode2.setDim(n == -1);
            vector = treeNode2.getItems();
        }
        this.redrawItems();
        return vector;
    }

    public void updateBuddyListCount(String string, int n, int n2) {
        TreeNode treeNode = this.get(string);
        String string2 = this.displayNameFromListName(string, n, n2);
        if (treeNode != null) {
            treeNode.setContents(this.makeItem(string2));
            this.redrawItems();
            return;
        }
        this.add(new TreeNode(string, this.makeItem(string2)));
    }

    public void addNotify() {
        super.addNotify();
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        if (fontMetrics != null) {
            this.nodeHeight = Math.max(Oscar.images.MINI_ICON_SIZE, fontMetrics.getHeight());
        }
    }

    private boolean updatedPopup() {
        String string;
        String string2;
        TreeNode treeNode = this.getSelectedNode();
        String string3 = string2 = treeNode != null ? treeNode.getName() : null;
        if (string2 == null) {
            return false;
        }
        User user = this.core.getBuddy(string2);
        if (user == null) {
            return false;
        }
        String string4 = treeNode.getFirstString();
        this.text = string4 != null ? string4.substring(1) : string2;
        this.text = String.valueOf(this.text) + "\n \n";
        if (user.userClass >= 0) {
            this.text = this.text.concat("User class:" + Oscar.images.CLASS_ICON_LABELS[user.userClass + 1] + "\n");
        }
        if (user.evil >= 0) {
            this.text = this.text.concat("Warnings:" + user.evil + "\n");
        }
        if ((string = user.getMemberSinceAsString()) != null) {
            this.text = this.text.concat("Member since:" + string + "\n");
        }
        this.text = user.status == 0 ? String.valueOf(this.text) + "Last login:" : String.valueOf(this.text) + "Online since:";
        this.text = String.valueOf(this.text) + JUtil.shortDate(user.signon);
        if (user.idle >= 0L && user.status != 0) {
            this.text = this.text.concat("\nIdle minutes:" + (int)user.idle);
        }
        return true;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        String string;
        TreeNode treeNode = (TreeNode)itemEvent.getItem();
        if (treeNode != null && (string = treeNode.getFirstString()) != null) {
            if (string.indexOf(47) > -1) {
                this.setGroupCollapsed(treeNode, !treeNode.isCollapsed());
                return;
            }
            Oscar.mainTool.icbmAction(this.displayNameToNickname(string));
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        if (mouseEvent.getModifiers() == 4 && this.contains(n, n2) && this.updatedPopup()) {
            this.loc = this.getLocationOnScreen();
            Popup.showPopup(this.text, this.loc.x + n, this.loc.y + n2, true);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        Popup.hidePopup(this.text);
    }

    public void changeAttribute(Font font, Color color, Color color2, Color color3) {
        this.setFont(font);
        this.setColors(color, color2, color3);
    }
}

