/*
 * Decompiled with CFR 0.152.
 */
package component;

import component.AdminEmailAddressUI;
import component.AdminNicknameUI;
import component.AdminPasswordUI;
import component.AdminUI;
import component.AdminUIListener;
import component.FolderInfo;
import component.SetupUI;
import component.Tools;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.NoSuchElementException;
import java.util.Vector;
import main.AdminAPI;
import main.BOSCore;
import main.LoginCore;
import main.Nickname;
import main.Oscar;
import uiutil.ChoiceListener;
import uiutil.ChoiceUI;
import uiutil.PropertySheet;
import util.JUtil;
import util.KeyBindings;
import util.Log;
import util.Timer;
import util.TimerEvent;
import util.TimerListener;

public class AdminTool
implements AdminAPI,
ChoiceListener,
TimerListener,
WindowListener {
    private static final String MODULE = "AdminTool";
    public static final String MODULE_NAME = "tool.admin";
    private static final String[] UIPACK_NAMES = new String[]{"tool.admin"};
    private static final String DISPLAY_NAME = "Administration";
    public static String REQUESTING_STRING = "(Requesting...)";
    private Tools tools;
    private Vector adminListeners;
    private Timer timer;
    private TimerEvent timeOutEvent;
    private Vector currentRequest;
    private boolean gotResponse;
    private AdminUI nicknameUI;
    private AdminUI passwordUI;
    private AdminUI emailUI;
    private String newPassword;
    private int CHECK_INTERVAL = 1000;
    private int REQUEST_TIMEOUT = 60000;
    private int GET = 1;
    private int SET = 2;
    private int TIMEOUT_ALARM = 1;
    private int REQUEST_ALARM = 2;
    private int EMAIL_UPDATE_ALARM = 3;
    private boolean timeToUpdateEmailAddress = true;
    private int EMAIL_UPDATE_TIMEOUT = 600000;
    private boolean firstTime = true;

    public AdminTool(BOSCore bOSCore, Tools tools) {
        this.tools = tools;
        tools.register(this.getModuleName(), this);
        this.adminListeners = new Vector();
        this.currentRequest = null;
        this.gotResponse = false;
        this.nicknameUI = null;
        this.passwordUI = null;
        this.emailUI = null;
        this.newPassword = null;
        this.timer = new Timer(this.getModuleName(), 250);
    }

    public void setNickname(String string) {
        Oscar.nickname = string;
        int n = 0;
        while (n < this.adminListeners.size()) {
            ((AdminUIListener)this.adminListeners.elementAt(n)).setNickname(string);
            ++n;
        }
        this.gotResponse();
    }

    public void setEmailAddress(String string) {
        if (this.timeToUpdateEmailAddress) {
            this.timeToUpdateEmailAddress = false;
            Timer.createEvent("System", this, this.EMAIL_UPDATE_ALARM, null, this.EMAIL_UPDATE_TIMEOUT);
        }
        Oscar.emailAddress = string;
        int n = 0;
        while (n < this.adminListeners.size()) {
            ((AdminUIListener)this.adminListeners.elementAt(n)).setEmailAddress(string);
            ++n;
        }
        this.gotResponse();
    }

    public void setRegistrationStatus(int n) {
        Oscar.registrationStatus = n;
        int n2 = 0;
        while (n2 < this.adminListeners.size()) {
            ((AdminUIListener)this.adminListeners.elementAt(n2)).setRegistrationStatus(n);
            ++n2;
        }
        this.gotResponse();
    }

    public void adminInfoError(int n, String string, String string2) {
        int n2 = 0;
        while (n2 < this.adminListeners.size()) {
            ((AdminUIListener)this.adminListeners.elementAt(n2)).error(n, string, string2);
            ++n2;
        }
        this.gotResponse();
    }

    public void changeSuccessful(int n) {
        Object object = this.currentRequest.elementAt(2);
        if (n == 0) {
            object = Oscar.nickname;
        }
        if (n == 1) {
            this.newPassword = (String)object;
        } else if (n == 3) {
            Oscar.registrationStatus = (Integer)object;
        }
        this.showUI(n, null);
        int n2 = 0;
        while (n2 < this.adminListeners.size()) {
            ((AdminUIListener)this.adminListeners.elementAt(n2)).changeSuccessful(n, object);
            ++n2;
        }
        this.gotResponse();
    }

    public void changeFailed(int n, String string, String string2) {
        this.showUI(n, null);
        int n2 = 0;
        while (n2 < this.adminListeners.size()) {
            ((AdminUIListener)this.adminListeners.elementAt(n2)).changeFailed(n, string, string2);
            ++n2;
        }
        this.gotResponse();
    }

    public void accountConfirmationSent(boolean bl) {
        if (bl) {
            ChoiceUI.newChoiceUI("Register", "A confirmation e-mail has been sent to the e-mail address you specified when you registered. After you repond to the e-mail, you become a registered user.");
        }
    }

    public void accountDeletionFailed() {
    }

    public void connect() {
    }

    public void disconnect() {
        if (!this.gotResponse && this.currentRequest != null) {
            int n = (Integer)this.currentRequest.elementAt(0);
            this.showUI(n, null);
            int n2 = 0;
            while (n2 < this.adminListeners.size()) {
                ((AdminUIListener)this.adminListeners.elementAt(n2)).error(n, "lost admin connection", null);
                ++n2;
            }
        }
        this.currentRequest = null;
        Timer.removeEvent(this.timeOutEvent);
    }

    public void setEnabled(boolean bl) {
        Log.log(MODULE, Log.DB0, "setEnabled.enabled=" + bl);
        if (bl) {
            this.processRequest(this.currentRequest);
        }
    }

    public void service() {
    }

    public void updateRate() {
    }

    public void updateUserInfo(Nickname nickname) {
    }

    public void updateUserEvil(String string, int n) {
    }

    public int id() {
        return 1;
    }

    public int version() {
        return 1;
    }

    public FolderInfo[] configure(SetupUI setupUI) {
        return null;
    }

    public PropertySheet getPropertySheet(FolderInfo folderInfo, SetupUI setupUI) {
        return null;
    }

    public void exportProperties(KeyBindings keyBindings, KeyBindings keyBindings2) {
    }

    public void importProperties(KeyBindings keyBindings, KeyBindings keyBindings2, KeyBindings keyBindings3, boolean bl) {
    }

    public boolean initiate(Vector vector, KeyBindings keyBindings) {
        return true;
    }

    public void shutdown() {
        Log.log(MODULE, Log.INFO, "AdminTool got shutdown.");
    }

    public String getModuleName() {
        return MODULE_NAME;
    }

    public String getDisplayName() {
        return DISPLAY_NAME;
    }

    public String[] getUIPackNames() {
        return UIPACK_NAMES;
    }

    public void timerEvent(String string, int n, Object object) {
        if (n == this.REQUEST_ALARM) {
            this.makeRequest((Vector)object);
            return;
        }
        if (n == this.TIMEOUT_ALARM && this.currentRequest != null) {
            Oscar.adminCore.shutdown();
            return;
        }
        if (n == this.EMAIL_UPDATE_TIMEOUT) {
            this.timeToUpdateEmailAddress = true;
        }
    }

    public void addAdminUIListener(AdminUIListener adminUIListener) {
        this.adminListeners.insertElementAt(adminUIListener, this.adminListeners.size());
    }

    public void changeNickname(String string) {
        Vector<Object> vector = new Vector<Object>(3);
        vector.addElement(new Integer(0));
        vector.addElement(new Integer(this.SET));
        vector.addElement(string);
        Timer.createEvent(this.getModuleName(), this, this.REQUEST_ALARM, vector, 0);
    }

    public void changePassword(String string, String string2) {
        Vector<Object> vector = new Vector<Object>(4);
        vector.addElement(new Integer(1));
        vector.addElement(new Integer(this.SET));
        vector.addElement(string2);
        vector.addElement(string);
        Timer.createEvent(this.getModuleName(), this, this.REQUEST_ALARM, vector, 0);
    }

    public void changeEmailAddress(String string) {
        Vector<Object> vector = new Vector<Object>(3);
        vector.addElement(new Integer(2));
        vector.addElement(new Integer(this.SET));
        vector.addElement(string);
        Timer.createEvent(this.getModuleName(), this, this.REQUEST_ALARM, vector, 0);
    }

    public void changeRegistrationStatus(int n) {
        Vector<Integer> vector = new Vector<Integer>(3);
        vector.addElement(new Integer(3));
        vector.addElement(new Integer(this.SET));
        vector.addElement(new Integer(n));
        Timer.createEvent(this.getModuleName(), this, this.REQUEST_ALARM, vector, 0);
    }

    public void removeAdminUIListener(AdminUIListener adminUIListener) {
        this.adminListeners.removeElement(adminUIListener);
    }

    public void requestAccountConfirmation() {
        Vector<Integer> vector = new Vector<Integer>(2);
        vector.addElement(new Integer(4));
        vector.addElement(new Integer(this.GET));
        Timer.createEvent(this.getModuleName(), this, this.REQUEST_ALARM, vector, 0);
    }

    public void requestNickname() {
        Vector<Integer> vector = new Vector<Integer>(2);
        vector.addElement(new Integer(0));
        vector.addElement(new Integer(this.GET));
        Timer.createEvent(this.getModuleName(), this, this.REQUEST_ALARM, vector, 0);
    }

    public void requestEmailAddress() {
        Vector<Integer> vector = new Vector<Integer>(2);
        vector.addElement(new Integer(2));
        vector.addElement(new Integer(this.GET));
        Timer.createEvent(this.getModuleName(), this, this.REQUEST_ALARM, vector, 0);
    }

    public void requestRegistrationStatus() {
        Vector<Integer> vector = new Vector<Integer>(2);
        vector.addElement(new Integer(3));
        vector.addElement(new Integer(this.GET));
        Timer.createEvent(this.getModuleName(), this, this.REQUEST_ALARM, vector, 0);
    }

    public void showUI(int n, String string) {
        if (n == 0) {
            if (this.nicknameUI == null) {
                this.nicknameUI = new AdminNicknameUI(this, string);
                this.nicknameUI.addWindowListener(this);
                return;
            }
            this.nicknameUI.toFront();
            return;
        }
        if (n == 1) {
            if (this.passwordUI == null) {
                this.passwordUI = new AdminPasswordUI(this);
                this.passwordUI.addWindowListener(this);
                return;
            }
            this.passwordUI.toFront();
            return;
        }
        if (n == 2) {
            if (this.emailUI == null) {
                this.emailUI = new AdminEmailAddressUI(this, string);
                this.emailUI.addWindowListener(this);
                return;
            }
            this.emailUI.toFront();
        }
    }

    public boolean timeToUpdateEmailAddress() {
        if (this.firstTime) {
            this.firstTime = false;
            if (Oscar.emailAddress != null && Oscar.emailAddress.length() > 0) {
                this.timeToUpdateEmailAddress = false;
            }
        }
        return this.timeToUpdateEmailAddress;
    }

    private synchronized void makeRequest(Vector vector) {
        Log.log(MODULE, Log.DB0, "makeRequest");
        while (this.currentRequest != null) {
            try {
                Thread.sleep(this.CHECK_INTERVAL);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.currentRequest = vector;
        this.gotResponse = false;
        Oscar.bosCore.requestService(this, "admin", null);
        this.timeOutEvent = Timer.createEvent("System", this, this.TIMEOUT_ALARM, this, this.REQUEST_TIMEOUT);
    }

    private void processRequest(Vector vector) {
        int n = 0;
        try {
            Object e = vector.elementAt(n++);
            int n2 = (Integer)e;
            e = vector.elementAt(n++);
            int n3 = (Integer)e;
            if (n2 == 0) {
                if (n3 == this.SET) {
                    Log.log(MODULE, Log.DB0, "processRequest: SET NICKNAME");
                    e = vector.elementAt(n++);
                    Oscar.adminCore.setNickname((String)e);
                    return;
                }
                Log.log(MODULE, Log.DB0, "processRequest: GET NICKNAME");
                Oscar.adminCore.getNickname();
                return;
            }
            if (n2 == 1) {
                if (n3 == this.SET) {
                    Log.log(MODULE, Log.DB0, "processRequest: SET PASSWORD");
                    String string = (String)vector.elementAt(n++);
                    String string2 = (String)vector.elementAt(n++);
                    Log.log(MODULE, Log.DB0, "                new=" + string + " old=" + string2);
                    Oscar.adminCore.setPassword(string, string2);
                    return;
                }
            } else {
                if (n2 == 2) {
                    if (n3 == this.SET) {
                        Log.log(MODULE, Log.DB0, "processRequest: SET EMAIL");
                        e = vector.elementAt(n);
                        Log.log(MODULE, Log.DB0, "                new email address=" + (String)e);
                        Oscar.adminCore.setEmailAddress((String)e);
                        return;
                    }
                    Log.log(MODULE, Log.DB0, "processRequest: GET EMAIL");
                    Oscar.adminCore.getEmailAddress();
                    return;
                }
                if (n2 == 3) {
                    if (n3 == this.SET) {
                        Log.log(MODULE, Log.DB0, "processRequest: SET REG_STATUS");
                        e = vector.elementAt(n++);
                        Oscar.adminCore.setRegistrationStatus((Integer)e);
                        return;
                    }
                    Log.log(MODULE, Log.DB0, "processRequest: GET REG_STATUS");
                    Oscar.adminCore.getRegistrationStatus();
                    return;
                }
                if (n2 == 4) {
                    if (n3 == this.GET) {
                        Log.log(MODULE, Log.DB0, "processRequest: GET ACCOUNT_CONF");
                        Oscar.adminCore.requestAccountConfirmation();
                        return;
                    }
                } else {
                    Log.log(MODULE, Log.ERROR, "processRequest: Error: item=" + e);
                }
            }
            return;
        }
        catch (NoSuchElementException noSuchElementException) {
            Log.log(MODULE, Log.ERROR, "processRequest: Error processing request");
            return;
        }
    }

    private void gotResponse() {
        Log.log(MODULE, Log.DB0, "gotResponse: shutting down adminCore");
        this.gotResponse = true;
        Oscar.adminCore.shutdown();
    }

    public void choiceMade(int n, int n2, Object object) {
        if (n2 == 0) {
            String string = (String)object;
            if (string != null && string.length() > 0) {
                JUtil.putPassword(Oscar.config, string, String.valueOf(LoginCore.LOGIN_KEY) + "." + LoginCore.PASSWORD_KEY);
            }
            Oscar.saveConfiguration();
        }
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
        Object object = windowEvent.getSource();
        if (object.equals(this.nicknameUI)) {
            this.nicknameUI = null;
            return;
        }
        if (object.equals(this.passwordUI)) {
            this.passwordUI = null;
            String string = JUtil.getPassword(Oscar.config, String.valueOf(LoginCore.LOGIN_KEY) + "." + LoginCore.PASSWORD_KEY);
            if (string != null && string.length() > 0 && this.newPassword != null && this.newPassword.length() > 0 && !string.equals(this.newPassword)) {
                ChoiceUI.newChoiceUI(this, 0, this.newPassword, "Change Password", "Because you changed your password, it is now different from the old password you saved for login. Would you like to save your new password for login?", "Save New Password", "Keep Old Password", null, Oscar.WARNING_SOUND);
            }
            this.newPassword = null;
            return;
        }
        if (object.equals(this.emailUI)) {
            this.emailUI = null;
        }
    }

    public void windowClosing(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }
}

