/*
 * Decompiled with CFR 0.152.
 */
package module.rendezvous.fileTransfer;

import java.awt.Button;
import java.awt.Component;
import java.awt.Label;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import module.rendezvous.fileTransfer.CallBackObject;
import module.rendezvous.fileTransfer.FileTransfer;
import module.rendezvous.fileTransfer.FtHeader;
import uiutil.ChoiceUI;
import uiutil.DBFrame;
import uiutil.ErrorMgr;
import uiutil.ProgressBar;

class TransferCore
extends Thread
implements ActionListener {
    static int SIZE = 1024;
    private static int TIMEOUT = 300000;
    String host;
    int port;
    Socket socket;
    boolean listener;
    boolean sender;
    FileTransfer ft;
    CallBackObject cbo;
    ProgressBar pbar;
    DBFrame frame;
    Button cancelButton;

    TransferCore(FileTransfer fileTransfer, CallBackObject callBackObject, String string, int n) {
        this.ft = fileTransfer;
        this.cbo = callBackObject;
        this.host = string;
        this.port = n;
    }

    public void setListener(boolean bl) {
        this.listener = bl;
    }

    public void setSender(boolean bl) {
        this.sender = bl;
    }

    private final void displayConnectionBar(String string) {
        this.frame = new DBFrame("Connecting...");
        this.frame.add("Center", new Label(string));
        this.cancelButton = new Button("Cancel");
        this.frame.add("South", this.cancelButton);
        this.frame.pack();
        this.frame.setVisible(true);
        this.cancelButton.addActionListener(this);
    }

    private final void removeConnectionBar() {
        this.frame.setVisible(false);
        this.frame.dispose();
    }

    private final void displayBar(String string, long l) {
        this.frame = new DBFrame("Progress Bar");
        this.pbar = new ProgressBar(string, l);
        this.frame.add((Component)this.pbar);
        this.cancelButton = new Button("Cancel");
        this.frame.add("South", this.cancelButton);
        this.frame.pack();
        this.frame.setVisible(true);
        this.cancelButton.addActionListener(this);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.cancelButton) {
            this.ft.sendCancel(this.cbo.rCookie, this.cbo.nickname);
            this.cleanup();
        }
    }

    private final void cleanupUIs() {
        this.pbar = null;
        this.cancelButton = null;
        if (this.frame != null) {
            this.frame.removeAll();
            this.frame.setVisible(false);
            this.frame.dispose();
        }
    }

    private final void cleanup() {
        try {
            if (this.socket != null) {
                this.socket.close();
                this.socket = null;
            }
        }
        catch (IOException iOException) {
            System.out.println("Exception closing socket.");
        }
        this.ft.removeThread(new String(this.cbo.rCookie));
        this.cleanupUIs();
        this.stop();
    }

    public void run() {
        if (this.listener) {
            this.runWaitForConnection();
        } else {
            this.runInitiateConnection();
        }
        if (this.sender) {
            this.runSendData();
        } else {
            this.runReceiveData();
        }
        this.cancelButton = null;
        this.frame.dispose();
    }

    private void runInitiateConnection() {
        this.displayConnectionBar("Trying to connect to " + this.host + ":" + this.port);
        System.out.println("Waiting to receive...");
        try {
            this.socket = new Socket(this.host, this.port);
            this.socket.setSoTimeout(TIMEOUT);
        }
        catch (UnknownHostException unknownHostException) {
            System.out.println("Cannot establish connection with " + this.host);
            if (!this.sender) {
                this.ft.sendAccept(this.cbo);
                this.suspend();
            } else {
                this.cleanup();
            }
        }
        catch (IOException iOException) {
            System.out.println("Encountered a problem with file IO");
            if (!this.sender) {
                this.ft.sendAccept(this.cbo);
                this.suspend();
            }
            this.cleanup();
        }
        System.out.println("Connection established with " + this.host);
        this.removeConnectionBar();
    }

    private final void runReceiveData() {
        DataInputStream dataInputStream;
        DataOutputStream dataOutputStream;
        long l = 0L;
        try {
            dataOutputStream = new DataOutputStream(this.socket.getOutputStream());
            dataInputStream = new DataInputStream(this.socket.getInputStream());
        }
        catch (IOException iOException) {
            ErrorMgr.diag((String)"TC.runReceiveData", (String)"Cannot get streams.", (Exception)iOException);
            this.cleanup();
            return;
        }
        FtHeader ftHeader = new FtHeader();
        ftHeader.readFromStream(dataInputStream);
        System.out.println("runReceiveData <<< FILE_TO_SEND " + ftHeader);
        String string = new String(ftHeader.name);
        long l2 = ftHeader.fileSize;
        ftHeader.hdrType = FtHeader.HDR_TYPE_FILE_OK_TO_SEND;
        ftHeader.totalNumParts = 1;
        ftHeader.writeToStream(dataOutputStream);
        System.out.println("runReceiveData >>> OK_TO_SEND " + ftHeader);
        l = this.receiveFile(string, l2, dataInputStream);
        ftHeader.hdrType = FtHeader.HDR_TYPE_FOOTER;
        ftHeader.numRecvd = l;
        ftHeader.recvdChecksum = FileTransfer.calculateChecksum(string);
        ftHeader.writeToStream(dataOutputStream);
        System.out.println("runReceiveData >>> FOOTER " + ftHeader);
        try {
            dataInputStream.close();
            dataOutputStream.close();
        }
        catch (IOException iOException) {
            System.out.println("error closing streams " + iOException);
        }
        this.cleanup();
    }

    private void runWaitForConnection() {
        this.displayConnectionBar("Waiting to connect to " + this.host + ":" + this.port);
        System.out.println("Waiting to send file...");
        ServerSocket serverSocket = null;
        try {
            serverSocket = new ServerSocket(this.port);
            serverSocket.setSoTimeout(TIMEOUT);
        }
        catch (IOException iOException) {
            System.out.println("Cannot open a port to use.");
            this.cleanup();
        }
        try {
            this.socket = serverSocket.accept();
            this.socket.setSoTimeout(TIMEOUT);
        }
        catch (InterruptedIOException interruptedIOException) {
            ChoiceUI.newChoiceUI((String)"File Transfer", (String)"Server socket times out.");
            this.cleanup();
        }
        catch (IOException iOException) {
            System.out.println("Encountered a problem with file IO");
            this.cleanup();
        }
        System.out.println("Connection received...");
        this.removeConnectionBar();
    }

    private final void runSendData() {
        DataInputStream dataInputStream;
        DataOutputStream dataOutputStream;
        String string = this.cbo.ftTLV.name;
        File file = new File(string);
        if (!file.canRead()) {
            ErrorMgr.diag((String)"TC.runSendData", (String)("Cannot read file " + string), null);
            this.cleanup();
            return;
        }
        String string2 = file.getName();
        long l = file.lastModified();
        long l2 = file.length();
        long l3 = FileTransfer.calculateChecksum(string);
        int n = 180 + string2.length();
        try {
            dataOutputStream = new DataOutputStream(this.socket.getOutputStream());
            dataInputStream = new DataInputStream(this.socket.getInputStream());
        }
        catch (IOException iOException) {
            ErrorMgr.diag((String)"TC.runSendData", (String)"Cannot get streams.", (Exception)iOException);
            this.cleanup();
            return;
        }
        try {
            FtHeader ftHeader = new FtHeader();
            ftHeader.setSendAttrib(1, 1, 1, 1, l2, l, l3, string2.getBytes());
            ftHeader.setRecvAttrib(0L, 0L);
            ftHeader.setCommonAttrib(n, FtHeader.HDR_TYPE_FILE_TO_SEND);
            ftHeader.setMacAttrib(1L, l, l3);
            ftHeader.writeToStream(dataOutputStream);
            System.out.println("runSendData >>>> FILE_TO_SEND " + ftHeader);
            ftHeader.readFromStream(dataInputStream);
            System.out.println("runSendData <<< OK_TO_SEND? " + ftHeader);
            if (ftHeader.hdrType == FtHeader.HDR_TYPE_FILE_WANT_TO_RESUME) {
                System.out.println("Recipient wants to resume file transfer.");
            }
            this.sendFile(string, l2, dataOutputStream);
            ftHeader.readFromStream(dataInputStream);
            System.out.println("runSendData <<< FOOTER " + ftHeader);
            dataOutputStream.close();
            dataInputStream.close();
        }
        catch (IOException iOException) {
            ErrorMgr.diag((String)"TC.runSendData", (String)"Got IO exception.", (Exception)iOException);
        }
        this.cleanup();
    }

    private void sendFile(String string, long l, DataOutputStream dataOutputStream) {
        DataInputStream dataInputStream;
        if (string == null || dataOutputStream == null) {
            ErrorMgr.diag((String)"TC.sendFile: ", (String)"bad filePath or output stream.", null);
            return;
        }
        byte[] byArray = new byte[SIZE];
        int n = 0;
        long l2 = 0L;
        try {
            dataInputStream = new DataInputStream(new FileInputStream(string));
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
            return;
        }
        this.displayBar(string, l);
        System.out.println("--- start sending file ---- ");
        block4: while (true) {
            try {
                while (true) {
                    n = dataInputStream.read(byArray, 0, SIZE);
                    l2 += (long)n;
                    if (n < 1) {
                        ChoiceUI.newChoiceUI((String)"File Transfer", (String)("Finished sending " + string));
                        dataInputStream.close();
                        break block4;
                    }
                    dataOutputStream.write(byArray, 0, n);
                    this.pbar.update(l2);
                }
            }
            catch (IOException iOException) {
                ErrorMgr.diag((String)"TC.sendFile", (String)"Got IO exception.", (Exception)iOException);
                continue;
            }
            break;
        }
        System.out.println("--- exiting sendFile file ---- ");
    }

    private long receiveFile(String string, long l, DataInputStream dataInputStream) {
        DataOutputStream dataOutputStream;
        if (string == null || dataInputStream == null) {
            ErrorMgr.diag((String)"TC.sendFile: ", (String)"bad fileName or input stream.", null);
            return 0L;
        }
        this.displayBar(string, l);
        try {
            dataOutputStream = new DataOutputStream(new FileOutputStream(string));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return 0L;
        }
        byte[] byArray = new byte[SIZE];
        long l2 = 0L;
        int n = 0;
        int n2 = (int)Math.min((long)SIZE, l);
        block4: while (true) {
            try {
                do {
                    n = dataInputStream.read(byArray, 0, n2);
                    System.out.println("Read " + n + " bytes from DIS.");
                    if (n < 0) {
                        dataOutputStream.close();
                        break block4;
                    }
                    dataOutputStream.write(byArray, 0, n);
                    n2 = (int)Math.min((long)SIZE, l - (l2 += (long)n));
                    this.pbar.update(l2);
                } while (l2 < l);
                dataOutputStream.close();
                ChoiceUI.newChoiceUI((String)"File Transfer", (String)("Finished receiving " + string));
            }
            catch (IOException iOException) {
                ErrorMgr.diag((String)"TC.receiveFile", (String)"Got IOException while trying to read file", (Exception)iOException);
                continue;
            }
            break;
        }
        return l2;
    }
}

