/*
 * Decompiled with CFR 0.152.
 */
package module.rendezvous.fileTransfer;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import util.JUtil;

public class FtHeader {
    public static int IDSZ = 32;
    public static int FNSZ = 64;
    public static int HDR_TYPE_FILE_TO_SEND = 257;
    public static int HDR_TYPE_FILE_OK_TO_SEND = 514;
    public static int HDR_TYPE_FILE_DATA = 3;
    public static int HDR_TYPE_FOOTER = 516;
    public static int HDR_TYPE_FILE_WANT_TO_RESUME = 517;
    public static int HDR_TYPE_FILE_TO_RESUME = 262;
    public static int HDR_TYPE_FILE_OK_TO_RESUME = 519;
    public static int HDR_TYPE_LIST_TO_SEND = 4360;
    public static int HDR_TYPE_LIST_OK_TO_SEND = 4617;
    public static int HDR_TYPE_LIST_DATA = 4106;
    public static int HDR_TYPE_LIST_FOOTER = 4619;
    byte[] magic = new byte[]{79, 70, 84, 50};
    int hdrLen;
    int hdrType;
    int encryption;
    int compression;
    int totalNumFiles;
    int numFilesLeft;
    int totalNumParts;
    int numPartsLeft;
    long fileSize;
    long fileTime;
    long checksum;
    long resSize;
    long resTime;
    long resChecksum;
    long numRecvd;
    long recvdChecksum;
    byte[] IDstring = new byte[]{74, 97, 118, 97};
    byte[] dummy = new byte[]{0};
    byte[] name;

    public void setSendAttrib(int n, int n2, int n3, int n4, long l, long l2, long l3, byte[] byArray) {
        this.totalNumFiles = n;
        this.numFilesLeft = n2;
        this.totalNumParts = n3;
        this.numPartsLeft = n4;
        this.fileSize = l;
        this.fileTime = l2;
        this.checksum = l3;
        this.name = byArray;
    }

    public void setRecvAttrib(long l, long l2) {
        this.numRecvd = l;
        this.recvdChecksum = l2;
    }

    public void setCommonAttrib(int n, int n2) {
        this.hdrLen = n;
        this.hdrType = n2;
    }

    public void setMacAttrib(long l, long l2, long l3) {
        this.resSize = l;
        this.resTime = l2;
        this.resChecksum = l3;
    }

    public String toString() {
        String string = "\n";
        return " hdrLen = " + this.hdrLen + string + " hdrType = " + this.hdrType + string + " totalNumFiles = " + this.totalNumFiles + string + " numFilesLeft = " + this.numFilesLeft + string + " fileSize = " + this.fileSize + string + " fileTime = " + this.fileTime + string + " checksum = " + this.checksum + string + " numRecvd = " + this.numRecvd + string + " recvdChecksum = " + this.recvdChecksum + string + " IDstring = " + new String(this.IDstring) + string + " name = " + new String(this.name) + string;
    }

    public void writeToStream(DataOutputStream dataOutputStream) {
        if (dataOutputStream == null) {
            return;
        }
        try {
            dataOutputStream.write(this.magic, 0, this.magic.length);
            dataOutputStream.writeShort(this.hdrLen);
            dataOutputStream.writeShort(this.hdrType);
            dataOutputStream.writeShort(this.encryption);
            dataOutputStream.writeShort(this.compression);
            dataOutputStream.writeShort(this.totalNumFiles);
            dataOutputStream.writeShort(this.numFilesLeft);
            dataOutputStream.writeShort(this.totalNumParts);
            dataOutputStream.writeShort(this.numPartsLeft);
            dataOutputStream.writeInt((int)this.fileSize);
            dataOutputStream.writeInt((int)this.fileTime);
            dataOutputStream.writeInt((int)this.checksum);
            dataOutputStream.writeInt((int)this.resSize);
            dataOutputStream.writeInt((int)this.resTime);
            dataOutputStream.writeInt((int)this.resChecksum);
            dataOutputStream.writeInt((int)this.numRecvd);
            dataOutputStream.writeInt((int)this.recvdChecksum);
            dataOutputStream.write(this.IDstring, 0, this.IDstring.length);
            dataOutputStream.writeByte(0);
            dataOutputStream.write(this.dummy, 0, this.dummy.length);
            dataOutputStream.write(this.name, 0, this.name.length);
            dataOutputStream.writeByte(0);
            return;
        }
        catch (IOException iOException) {
            System.out.println("writeToStream error.." + iOException);
            return;
        }
    }

    public void readFromStream(DataInputStream dataInputStream) {
        if (dataInputStream == null) {
            return;
        }
        try {
            this.magic = new byte[4];
            dataInputStream.read(this.magic, 0, 4);
            this.hdrLen = dataInputStream.readUnsignedShort();
            this.hdrType = dataInputStream.readUnsignedShort();
            this.encryption = dataInputStream.readUnsignedShort();
            this.compression = dataInputStream.readUnsignedShort();
            this.totalNumFiles = dataInputStream.readUnsignedShort();
            this.numFilesLeft = dataInputStream.readUnsignedShort();
            this.totalNumParts = dataInputStream.readUnsignedShort();
            this.numPartsLeft = dataInputStream.readUnsignedShort();
            this.fileSize = JUtil.readU32((DataInputStream)dataInputStream);
            this.fileTime = JUtil.readU32((DataInputStream)dataInputStream);
            this.checksum = JUtil.readU32((DataInputStream)dataInputStream);
            this.resSize = JUtil.readU32((DataInputStream)dataInputStream);
            this.resTime = JUtil.readU32((DataInputStream)dataInputStream);
            this.resChecksum = JUtil.readU32((DataInputStream)dataInputStream);
            this.numRecvd = JUtil.readU32((DataInputStream)dataInputStream);
            this.recvdChecksum = JUtil.readU32((DataInputStream)dataInputStream);
            this.IDstring = new byte[IDSZ];
            this.readUntilNullByte(this.IDstring, dataInputStream);
            this.dummy = new byte[1];
            dataInputStream.read(this.dummy, 0, 1);
            this.name = new byte[FNSZ];
            this.readUntilNullByte(this.name, dataInputStream);
            return;
        }
        catch (IOException iOException) {
            System.out.println("readFromStream error..");
            return;
        }
    }

    private final void readUntilNullByte(byte[] byArray, DataInputStream dataInputStream) {
        int n = 0;
        try {
            byte by = dataInputStream.readByte();
            while (by > 0) {
                byArray[n++] = by;
                by = dataInputStream.readByte();
            }
            return;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
    }
}

